/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.settings;

import com.intellij.openapi.application.PathMacroFilter;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.project.ProjectKt;
import com.intellij.project.ProjectStoreOwner;
import com.intellij.util.PathUtilRt;
import com.intellij.util.PlatformUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@State(name="QueryFileSettings", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u0000 &2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002&'B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0012\u001a\u0004\u0018\u00010\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R(\u0010\u0019\u001a\u0004\u0018\u00010\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u00138F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u0015\"\u0004\b\u001b\u0010\u001cR$\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u001d8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006("}, d2={"Lcom/intellij/database/settings/QueryFileSettings;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/database/settings/QueryFileSettings$Companion$QueryFileSettingsState;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "_state", "getState", "loadState", "", "state", "defaultScriptPath", "Ljava/nio/file/Path;", "getDefaultScriptPath", "()Ljava/nio/file/Path;", "defaultScriptPath$delegate", "Lkotlin/Lazy;", "value", "queriesDirectory", "getQueriesDirectory", "setQueriesDirectory", "(Ljava/nio/file/Path;)V", "", "fileNameTemplate", "getFileNameTemplate", "()Ljava/lang/String;", "setFileNameTemplate", "(Ljava/lang/String;)V", "isAskedToAttachDirectory", "", "setAskedToAttachProjectDirectory", "Companion", "QueryFilesPathMacroFilter", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nQueryFileSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueryFileSettings.kt\ncom/intellij/database/settings/QueryFileSettings\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,153:1\n1#2:154\n*E\n"})
public final class QueryFileSettings
implements PersistentStateComponent<Companion.QueryFileSettingsState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final Companion.QueryFileSettingsState _state;
    @NotNull
    private final Lazy defaultScriptPath$delegate;
    @ApiStatus.Internal
    @NotNull
    public static final String DATASOURCE_VARIABLE = "$DATA_SOURCE$";
    @NotNull
    private static final String STORAGE_NAME = "QueryFileSettings";
    @NotNull
    private static final String DEFAULT_TEMPLATE_NAME = "Query";
    @NotNull
    private static final String DEFAULT_DIRECTORY_NAME = "queries";

    public QueryFileSettings(@NotNull Project project, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.project = project;
        this.scope = scope;
        this._state = new Companion.QueryFileSettingsState(null, false, null, 7, null);
        this.defaultScriptPath$delegate = LazyKt.lazy(() -> QueryFileSettings.defaultScriptPath_delegate$lambda$0(this));
        Path path = this.getQueriesDirectory();
        if (path == null) {
            path = this.getDefaultScriptPath();
        }
        this.setQueriesDirectory(path);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final CoroutineScope getScope() {
        return this.scope;
    }

    @NotNull
    public Companion.QueryFileSettingsState getState() {
        return this._state;
    }

    public void loadState(@NotNull Companion.QueryFileSettingsState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this._state.setFileNameTemplate(state.getFileNameTemplate());
        this._state.setProjectQueriesDirectory(state.getProjectQueriesDirectory());
        this._state.setAskedToAttachProjectDirectory(state.getAskedToAttachProjectDirectory());
    }

    private final Path getDefaultScriptPath() {
        Lazy lazy = this.defaultScriptPath$delegate;
        return (Path)lazy.getValue();
    }

    @Nullable
    public final Path getQueriesDirectory() {
        Object object;
        block3: {
            block2: {
                object = this._state.getProjectQueriesDirectory();
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                Path path = Paths.get(it, new String[0]);
                object = path;
                if (path != null) break block3;
            }
            object = this.getDefaultScriptPath();
        }
        return object;
    }

    public final void setQueriesDirectory(@Nullable Path value) {
        Object object = Companion.getValidPathOrNull(value);
        if (object == null || (object = object.toString()) == null) {
            Path path = this.getDefaultScriptPath();
            object = path != null ? ((Object)path).toString() : null;
        }
        this._state.setProjectQueriesDirectory((String)object);
        this._state.setAskedToAttachProjectDirectory(false);
    }

    @NotNull
    public final String getFileNameTemplate() {
        String string = this._state.getFileNameTemplate();
        if (string == null) {
            string = Companion.getDefaultQueriesNameTemplate();
        }
        return string;
    }

    public final void setFileNameTemplate(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = Companion.getValidFileNameOrNull(value);
        if (string == null) {
            string = Companion.getDefaultQueriesNameTemplate();
        }
        this._state.setFileNameTemplate(string);
    }

    public final boolean isAskedToAttachDirectory() {
        return this._state.getAskedToAttachProjectDirectory();
    }

    public final void setAskedToAttachProjectDirectory() {
        this._state.setAskedToAttachProjectDirectory(true);
    }

    private static final Path defaultScriptPath_delegate$lambda$0(QueryFileSettings this$0) {
        return Companion.getDefaultQueriesPath(this$0.project);
    }

    @JvmStatic
    @NotNull
    public static final QueryFileSettings getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    @ApiStatus.Internal
    @Nullable
    public static final Path getValidPathOrNull(@Nullable Path path) {
        return Companion.getValidPathOrNull(path);
    }

    @JvmStatic
    @ApiStatus.Internal
    @Nullable
    public static final String getValidFileNameOrNull(@Nullable String fileName) {
        return Companion.getValidFileNameOrNull(fileName);
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final String getDefaultNameForQueryFile(@NotNull Project project, @NotNull String dataSourceName) {
        return Companion.getDefaultNameForQueryFile(project, dataSourceName);
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final String getNameForQueryFile(@NotNull String $this$getNameForQueryFile, @NotNull String dataSourceName) {
        return Companion.getNameForQueryFile($this$getNameForQueryFile, dataSourceName);
    }

    @JvmStatic
    @ApiStatus.Internal
    @Nullable
    public static final Path getDefaultQueriesPath(@Nullable Project project) {
        return Companion.getDefaultQueriesPath(project);
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final String getDefaultQueriesNameTemplate() {
        return Companion.getDefaultQueriesNameTemplate();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u001aB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0007J\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0007J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0005H\u0007J\u0014\u0010\u0014\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0007J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\u0018\u001a\u00020\u0005H\u0007J\f\u0010\u0019\u001a\u00020\u0005*\u00020\u0005H\u0002R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/settings/QueryFileSettings$Companion;", "", "<init>", "()V", "DATASOURCE_VARIABLE", "", "STORAGE_NAME", "DEFAULT_TEMPLATE_NAME", "DEFAULT_DIRECTORY_NAME", "getInstance", "Lcom/intellij/database/settings/QueryFileSettings;", "project", "Lcom/intellij/openapi/project/Project;", "getValidPathOrNull", "Ljava/nio/file/Path;", "path", "getValidFileNameOrNull", "fileName", "getDefaultNameForQueryFile", "dataSourceName", "getNameForQueryFile", "getDefaultQueriesPath", "isDotIdeaExists", "", "getDefaultQueriesNameTemplate", "prepareForUseInFileName", "QueryFileSettingsState", "intellij.database.core.impl"})
    @SourceDebugExtension(value={"SMAP\nQueryFileSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueryFileSettings.kt\ncom/intellij/database/settings/QueryFileSettings$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,153:1\n1#2:154\n11641#3:155\n11976#3,3:156\n*S KotlinDebug\n*F\n+ 1 QueryFileSettings.kt\ncom/intellij/database/settings/QueryFileSettings$Companion\n*L\n124#1:155\n124#1:156,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final QueryFileSettings getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(QueryFileSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (QueryFileSettings)object;
        }

        @JvmStatic
        @ApiStatus.Internal
        @Nullable
        public final Path getValidPathOrNull(@Nullable Path path) {
            if (path == null) {
                return null;
            }
            Companion companion = this;
            try {
                Companion $this$getValidPathOrNull_u24lambda_u240 = companion;
                boolean bl = false;
                return path.normalize().toAbsolutePath();
            }
            catch (Throwable throwable) {
                Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                return null;
            }
        }

        @JvmStatic
        @ApiStatus.Internal
        @Nullable
        public final String getValidFileNameOrNull(@Nullable String fileName) {
            String string = fileName;
            String trimmed = string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null;
            CharSequence charSequence = trimmed;
            if (charSequence == null || charSequence.length() == 0) {
                return null;
            }
            String trimmedAndReplaced = StringsKt.replace$default((String)trimmed, (String)QueryFileSettings.DATASOURCE_VARIABLE, (String)"data_source_name", (boolean)false, (int)4, null);
            return PathUtilRt.isValidFileName((String)(trimmedAndReplaced + ".sql"), (boolean)true) ? trimmed : null;
        }

        @JvmStatic
        @ApiStatus.Internal
        @NotNull
        public final String getDefaultNameForQueryFile(@NotNull Project project, @NotNull String dataSourceName) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataSourceName, (String)"dataSourceName");
            return this.getNameForQueryFile(this.getInstance(project).getFileNameTemplate(), dataSourceName);
        }

        @JvmStatic
        @ApiStatus.Internal
        @NotNull
        public final String getNameForQueryFile(@NotNull String $this$getNameForQueryFile, @NotNull String dataSourceName) {
            Intrinsics.checkNotNullParameter((Object)$this$getNameForQueryFile, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)dataSourceName, (String)"dataSourceName");
            return StringsKt.replace$default((String)$this$getNameForQueryFile, (String)QueryFileSettings.DATASOURCE_VARIABLE, (String)this.prepareForUseInFileName(dataSourceName), (boolean)false, (int)4, null);
        }

        @JvmStatic
        @ApiStatus.Internal
        @Nullable
        public final Path getDefaultQueriesPath(@Nullable Project project) {
            Path platformDependentPath;
            Path path;
            if (project == null) {
                return null;
            }
            if (PlatformUtils.isDataGrip() || !this.isDotIdeaExists(project)) {
                String string = project.getBasePath();
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    path = Paths.get(it, new String[0]);
                } else {
                    path = null;
                }
            } else {
                path = ProjectKt.getStateStore((Project)project).getDirectoryStorePath();
            }
            Path path2 = platformDependentPath = path;
            return path2 != null ? path2.resolve(QueryFileSettings.DEFAULT_DIRECTORY_NAME) : null;
        }

        private final boolean isDotIdeaExists(Project project) {
            return project instanceof ProjectStoreOwner && ProjectKt.getStateStore((Project)project).getDirectoryStorePath() != null;
        }

        @JvmStatic
        @ApiStatus.Internal
        @NotNull
        public final String getDefaultQueriesNameTemplate() {
            return QueryFileSettings.DEFAULT_TEMPLATE_NAME;
        }

        /*
         * WARNING - void declaration
         */
        private final String prepareForUseInFileName(String $this$prepareForUseInFileName) {
            void $this$mapTo$iv$iv;
            char[] cArray = new char[]{' ', '.'};
            char[] cArray2 = StringsKt.trim((String)$this$prepareForUseInFileName, (char[])cArray).toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"toCharArray(...)");
            char[] $this$map$iv = cArray2;
            boolean $i$f$map = false;
            char[] cArray3 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                void char_;
                void item$iv$iv;
                void var10_10 = item$iv$iv = $this$mapTo$iv$iv[j];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Character.isLetterOrDigit((char)char_) ? Character.valueOf((char)char_) : (char_ == 32 ? Character.valueOf('_') : (StringsKt.contains$default((CharSequence)"-_()[].", (char)char_, (boolean)false, (int)2, null) ? Character.valueOf((char)char_) : null)));
            }
            return CollectionsKt.joinToString$default((Iterable)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J+\u0010\u0016\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\n\"\u0004\b\u0012\u0010\f\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/settings/QueryFileSettings$Companion$QueryFileSettingsState;", "", "projectQueriesDirectory", "", "askedToAttachProjectDirectory", "", "fileNameTemplate", "<init>", "(Ljava/lang/String;ZLjava/lang/String;)V", "getProjectQueriesDirectory", "()Ljava/lang/String;", "setProjectQueriesDirectory", "(Ljava/lang/String;)V", "getAskedToAttachProjectDirectory", "()Z", "setAskedToAttachProjectDirectory", "(Z)V", "getFileNameTemplate", "setFileNameTemplate", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "intellij.database.core.impl"})
        public static final class QueryFileSettingsState {
            @Nullable
            private String projectQueriesDirectory;
            private boolean askedToAttachProjectDirectory;
            @Nullable
            private String fileNameTemplate;

            public QueryFileSettingsState(@Nullable String projectQueriesDirectory, boolean askedToAttachProjectDirectory, @Nullable String fileNameTemplate) {
                this.projectQueriesDirectory = projectQueriesDirectory;
                this.askedToAttachProjectDirectory = askedToAttachProjectDirectory;
                this.fileNameTemplate = fileNameTemplate;
            }

            public /* synthetic */ QueryFileSettingsState(String string, boolean bl, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    string = null;
                }
                if ((n & 2) != 0) {
                    bl = false;
                }
                if ((n & 4) != 0) {
                    string2 = null;
                }
                this(string, bl, string2);
            }

            @Nullable
            public final String getProjectQueriesDirectory() {
                return this.projectQueriesDirectory;
            }

            public final void setProjectQueriesDirectory(@Nullable String string) {
                this.projectQueriesDirectory = string;
            }

            public final boolean getAskedToAttachProjectDirectory() {
                return this.askedToAttachProjectDirectory;
            }

            public final void setAskedToAttachProjectDirectory(boolean bl) {
                this.askedToAttachProjectDirectory = bl;
            }

            @Nullable
            public final String getFileNameTemplate() {
                return this.fileNameTemplate;
            }

            public final void setFileNameTemplate(@Nullable String string) {
                this.fileNameTemplate = string;
            }

            @Nullable
            public final String component1() {
                return this.projectQueriesDirectory;
            }

            public final boolean component2() {
                return this.askedToAttachProjectDirectory;
            }

            @Nullable
            public final String component3() {
                return this.fileNameTemplate;
            }

            @NotNull
            public final QueryFileSettingsState copy(@Nullable String projectQueriesDirectory, boolean askedToAttachProjectDirectory, @Nullable String fileNameTemplate) {
                return new QueryFileSettingsState(projectQueriesDirectory, askedToAttachProjectDirectory, fileNameTemplate);
            }

            public static /* synthetic */ QueryFileSettingsState copy$default(QueryFileSettingsState queryFileSettingsState, String string, boolean bl, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = queryFileSettingsState.projectQueriesDirectory;
                }
                if ((n & 2) != 0) {
                    bl = queryFileSettingsState.askedToAttachProjectDirectory;
                }
                if ((n & 4) != 0) {
                    string2 = queryFileSettingsState.fileNameTemplate;
                }
                return queryFileSettingsState.copy(string, bl, string2);
            }

            @NotNull
            public String toString() {
                return "QueryFileSettingsState(projectQueriesDirectory=" + this.projectQueriesDirectory + ", askedToAttachProjectDirectory=" + this.askedToAttachProjectDirectory + ", fileNameTemplate=" + this.fileNameTemplate + ")";
            }

            public int hashCode() {
                int result = this.projectQueriesDirectory == null ? 0 : this.projectQueriesDirectory.hashCode();
                result = result * 31 + Boolean.hashCode(this.askedToAttachProjectDirectory);
                result = result * 31 + (this.fileNameTemplate == null ? 0 : this.fileNameTemplate.hashCode());
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof QueryFileSettingsState)) {
                    return false;
                }
                QueryFileSettingsState queryFileSettingsState = (QueryFileSettingsState)other;
                if (!Intrinsics.areEqual((Object)this.projectQueriesDirectory, (Object)queryFileSettingsState.projectQueriesDirectory)) {
                    return false;
                }
                if (this.askedToAttachProjectDirectory != queryFileSettingsState.askedToAttachProjectDirectory) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.fileNameTemplate, (Object)queryFileSettingsState.fileNameTemplate);
            }

            public QueryFileSettingsState() {
                this(null, false, null, 7, null);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/settings/QueryFileSettings$QueryFilesPathMacroFilter;", "Lcom/intellij/openapi/application/PathMacroFilter;", "<init>", "()V", "skipPathMacros", "", "attribute", "Lorg/jdom/Attribute;", "intellij.database.core.impl"})
    public static final class QueryFilesPathMacroFilter
    extends PathMacroFilter {
        public boolean skipPathMacros(@NotNull Attribute attribute) {
            Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
            Element element = attribute.getParent();
            if (element == null) {
                return false;
            }
            Element parent = element;
            if (!Intrinsics.areEqual((Object)parent.getName(), (Object)"option")) {
                return false;
            }
            Element option = parent;
            Parent parent2 = option.getParent();
            Element element2 = parent2 instanceof Element ? (Element)parent2 : null;
            if (element2 == null) {
                return false;
            }
            Element component = element2;
            return Intrinsics.areEqual((Object)component.getAttributeValue("name"), (Object)QueryFileSettings.STORAGE_NAME) && Intrinsics.areEqual((Object)option.getAttributeValue("name"), (Object)"fileNameTemplate");
        }
    }
}

