/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.documentation;

import com.google.common.collect.Iterables;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.navigation.UtilKt;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DatabaseObjectFormatterConfig;
import com.intellij.database.extractors.DbObjectFormatter;
import com.intellij.database.extractors.DisplayHtmlValuesExtractor;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.ExtractionConfigKt;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.GridExtractorsUtilCore;
import com.intellij.database.extractors.HtmlValuesExtractor;
import com.intellij.database.extractors.ImageInfo;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterConfig;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ModelRelationManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.DataGridDocumentationCommand;
import com.intellij.database.run.ui.DbDocumentationHelper;
import com.intellij.database.run.ui.grid.documentation.DataGridDocumentationLinkHandlerKt;
import com.intellij.database.run.ui.grid.documentation.DataGridDocumentationUtil;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.Out;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.model.Pointer;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.backend.documentation.DocumentationResult;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.util.ObjectUtils;
import java.awt.Color;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataGridDocumentationTarget
implements DocumentationTarget {
    public static final String GRID_SECTION = "grid";
    public static final String LOAD_RELATED_DATA = "load-related-data";
    public static final String VIEW_MODE_PROPERTY = "DataGrid.QuickDoc.View";
    private final PsiElement myElement;
    private final DataGrid myGrid;

    public DataGridDocumentationTarget(@NotNull PsiElement element, @NotNull DataGrid grid) {
        if (element == null) {
            DataGridDocumentationTarget.$$$reportNull$$$0(0);
        }
        if (grid == null) {
            DataGridDocumentationTarget.$$$reportNull$$$0(1);
        }
        this.myElement = element;
        this.myGrid = grid;
    }

    @NotNull
    public Pointer<? extends DocumentationTarget> createPointer() {
        Function<PsiElement, DataGridDocumentationTarget> restoration = element -> new DataGridDocumentationTarget((PsiElement)element, Objects.requireNonNull(DataGridPomTarget.unwrapDataGrid((PsiElement)element)));
        Pointer pointer = Pointer.delegatingPointer((Pointer)SmartPointersKt.createSmartPointer((PsiElement)this.myElement), this.getClass(), restoration);
        if (pointer == null) {
            DataGridDocumentationTarget.$$$reportNull$$$0(2);
        }
        return pointer;
    }

    @NotNull
    public DataGrid getGrid() {
        DataGrid dataGrid = this.myGrid;
        if (dataGrid == null) {
            DataGridDocumentationTarget.$$$reportNull$$$0(3);
        }
        return dataGrid;
    }

    @NotNull
    public TargetPresentation computePresentation() {
        TargetPresentation targetPresentation = UtilKt.targetPresentation((PsiElement)this.myElement);
        if (targetPresentation == null) {
            DataGridDocumentationTarget.$$$reportNull$$$0(4);
        }
        return targetPresentation;
    }

    @Nullable
    public DocumentationResult computeDocumentation() {
        DataGridPomTarget.Cell cell = DataGridPomTarget.unwrapCell((PsiElement)this.myElement);
        if (cell != null) {
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myElement.getProject());
            DataGridDocumentationCommand command = DataGridDocumentationCommand.getCommand((String)propertiesComponent.getValue(VIEW_MODE_PROPERTY), (DataGridDocumentationCommand)DataGridDocumentationCommand.REGULAR);
            String doc = DataGridDocumentationTarget.getCellDocumentation(cell.dataGrid, command);
            DocumentationResult.Documentation documentation = DocumentationResult.documentation((String)doc);
            return Registry.is((String)"database.automatically.load.related.data.in.cell.quick.doc") ? documentation.updates(DataGridDocumentationLinkHandlerKt.asDocumentationContent(DataGridDocumentationLinkHandlerKt.loadData(doc, LOAD_RELATED_DATA, this))) : documentation;
        }
        if (DataGridUtil.getQueryText(this.myGrid) != null) {
            String documentation = DataGridDocumentationTarget.getGridDocumentation(this.myElement.getProject(), this.myGrid);
            return documentation == null ? null : DocumentationResult.documentation((String)documentation);
        }
        return null;
    }

    @NlsSafe
    @Nullable
    public String loadRelatedData() throws ExecutionException, InterruptedException {
        boolean noRelationships;
        DasObject databaseTable = DataGridUtilCore.getDatabaseTable((CoreGrid)this.myGrid);
        DbDataSource dataSource = DataGridUtilCore.getDatabaseSystem((CoreGrid)this.myGrid);
        if (dataSource == null || databaseTable == null) {
            return null;
        }
        ModelIndexSet selectedRows = this.myGrid.getSelectionModel().getSelectedRows();
        boolean badSelection = this.myGrid.getSelectionModel().getSelectedRowCount() <= 0;
        for (ModelIndex selectedRow : selectedRows.asIterable()) {
            badSelection |= !selectedRow.isValid((CoreGrid)this.myGrid);
        }
        boolean bl = noRelationships = !(databaseTable instanceof DasTable) || !DataGridDocumentationTarget.hasNavigatableKeys(dataSource, (DasTable)databaseTable);
        if (badSelection || noRelationships) {
            return null;
        }
        List<DataGridDocumentationUtil.QueryInfo> newQueries = DataGridDocumentationUtil.buildQueries((DasDataSource)dataSource, this.myGrid, (ModelIndexSet<GridRow>)selectedRows, EnumSet.of(DataGridDocumentationUtil.KeyType.FOREIGN, DataGridDocumentationUtil.KeyType.EXPORTED));
        CompletableFuture<@Nls String> future = DataGridDocumentationTarget.runQueries(this.myGrid, newQueries);
        if (future == null) {
            return null;
        }
        return future.get();
    }

    private static @Nullable CompletableFuture<@Nls String> runQueries(@NotNull DataGrid dataGrid, final @NotNull List<DataGridDocumentationUtil.QueryInfo> newQueries) {
        PsiElement element;
        if (dataGrid == null) {
            DataGridDocumentationTarget.$$$reportNull$$$0(5);
        }
        if (newQueries == null) {
            DataGridDocumentationTarget.$$$reportNull$$$0(6);
        }
        if (DataGridPomTarget.unwrapCell((PsiElement)(element = DataGridUtil.getPsiElementForSelection((DataGrid)dataGrid))) == null) {
            return null;
        }
        DatabaseGridDataHookUp ownerEx = DataGridUtil.getDatabaseHookUp((CoreGrid<GridRow, GridColumn>)dataGrid);
        if (ownerEx == null) {
            return null;
        }
        final CompletableFuture<@Nls String> future = new CompletableFuture<String>();
        ownerEx.getMessageBus().getDataProducer().processRequest((GridDataRequest)new DataRequest.RawRequest((DataRequest.OwnerEx)ownerEx){

            public void processRaw(DataRequest.Context context, DatabaseConnectionCore connection) {
                future.complete(DataGridDocumentationTarget.doLoadRelatedData(newQueries, (DatabaseConnection)connection));
            }
        });
        return future;
    }

    @Nls
    @Nullable
    public static String doLoadRelatedData(@NotNull List<DataGridDocumentationUtil.QueryInfo> newQueries, @NotNull DatabaseConnection connection) {
        if (newQueries == null) {
            DataGridDocumentationTarget.$$$reportNull$$$0(7);
        }
        if (connection == null) {
            DataGridDocumentationTarget.$$$reportNull$$$0(8);
        }
        @Nls StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (DataGridDocumentationUtil.QueryInfo info2 : newQueries) {
            int length = sb.length();
            DataSourceUtil.tryLoadFirstNRows((DatabaseConnection)connection, (String)info2.query, (StringBuilder)sb, (int)info2.values.size());
            if (sb.length() == length) continue;
            @Nls String title = DatabaseBundle.message((String)"documentation.referenced.1.first.referencing.1", (Object[])new Object[]{!info2.exported ? 0 : 1, info2.table.getName()});
            sb.insert(length, (first ? "" : "<br>") + "<b>" + title + ":</b><br>" + info2.keysAndColumns);
            first = false;
        }
        if (sb.isEmpty()) {
            return null;
        }
        return sb.toString();
    }

    @NlsSafe
    @NotNull
    public static String getCellDocumentation(@NotNull DataGrid dataGrid, DataGridDocumentationCommand mode) {
        if (dataGrid == null) {
            DataGridDocumentationTarget.$$$reportNull$$$0(9);
        }
        StringBuilder sb = new StringBuilder(DisplayHtmlValuesExtractor.getHeader());
        sb.append(DataGridDocumentationTarget.extractValues(dataGrid, mode));
        DasTable databaseTable = (DasTable)ObjectUtils.tryCast((Object)DataGridUtilCore.getDatabaseTable((CoreGrid)dataGrid), DasTable.class);
        DbDataSource dataSource = DataGridUtilCore.getDatabaseSystem((CoreGrid)dataGrid);
        if (DataGridDocumentationTarget.hasNavigatableKeys(dataSource, databaseTable)) {
            sb.append("<br><br>").append(DbDocumentationHelper.sectionStart((String)LOAD_RELATED_DATA)).append(HtmlChunk.link((String)DbDocumentationHelper.dbSubstituteUrl((String)LOAD_RELATED_DATA), (String)DatabaseBundle.message((String)"DataGrid.documentation.load.related.data", (Object[])new Object[0]))).append(DbDocumentationHelper.sectionEnd((String)LOAD_RELATED_DATA)).append("<br><br>");
        }
        String string = sb.toString();
        if (string == null) {
            DataGridDocumentationTarget.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    static String extractValues(@NotNull DataGrid dataGrid, @NotNull DataGridDocumentationCommand mode) {
        if (dataGrid == null) {
            DataGridDocumentationTarget.$$$reportNull$$$0(11);
        }
        if (mode == null) {
            DataGridDocumentationTarget.$$$reportNull$$$0(12);
        }
        StringBuilder sb = new StringBuilder(DbDocumentationHelper.sectionStart((String)GRID_SECTION));
        SelectionModel selectionModel = dataGrid.getSelectionModel();
        boolean singleValue = selectionModel.getSelectedColumnCount() + selectionModel.getSelectedRowCount() == 2;
        boolean plainMode = singleValue && mode != DataGridDocumentationCommand.TRANSPOSED;
        Out.Readable readableOut = new Out.Readable();
        DataGridDocumentationCharOut out = new DataGridDocumentationCharOut((Out)readableOut, mode, plainMode);
        Dbms dbms = DataGridUtil.getDbms(dataGrid);
        if (singleValue) {
            DataGridDocumentationObjectFormatter converter = new DataGridDocumentationObjectFormatter(dataGrid.getObjectFormatter(), dbms);
            GridUtil.extractSelectedValues((DataGrid)dataGrid, (DataExtractor)GridExtractorsUtilCore.getSingleValueExtractor((ObjectFormatter)converter, (Function)DataGridUtil.getConfigProvider((DataGrid)dataGrid)), (Out)out);
        } else {
            int[] columns = (mode == DataGridDocumentationCommand.TRANSPOSED ? dataGrid.getVisibleColumns() : selectionModel.getSelectedColumns()).asArray();
            Color color = Objects.requireNonNull(EditorColorsUtil.getGlobalOrDefaultColor((ColorKey)DocumentationComponent.COLOR_KEY));
            DataGridDocumentationObjectFormatter converter = new DataGridDocumentationObjectFormatter(dataGrid.getObjectFormatter(), dbms);
            DisplayHtmlValuesExtractor extractor = new DisplayHtmlValuesExtractor(color, (ObjectFormatter)converter);
            DataGridDocumentationCommand command = mode == DataGridDocumentationCommand.TRANSPOSED ? DataGridDocumentationCommand.REGULAR : DataGridDocumentationCommand.TRANSPOSED;
            String text = mode == DataGridDocumentationCommand.TRANSPOSED ? DatabaseBundle.message((String)"cells.view.mode.regular", (Object[])new Object[0]) : DatabaseBundle.message((String)"cells.view.mode.transposed", (Object[])new Object[0]);
            out.getDelegate().appendText((CharSequence)HtmlChunk.link((String)DbDocumentationHelper.dbSubstituteUrl((String)command.code()), (String)text).toString()).appendText((CharSequence)"<br><br>");
            List allColumns = dataGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getAllColumnsForExtraction(columns);
            List selectedRows = GridUtil.getSelectedGridRows((DataGrid)dataGrid);
            GridExtractorsUtilCore.extract((Out)out, (ExtractionConfig)ExtractionConfigKt.builder().setTransposed(mode == DataGridDocumentationCommand.TRANSPOSED).build(), (List)allColumns, (DataExtractor)extractor, (List)selectedRows, (int[])columns);
        }
        sb.append(readableOut.getString());
        String string = sb.append(DbDocumentationHelper.sectionEnd((String)GRID_SECTION)).toString();
        if (string == null) {
            DataGridDocumentationTarget.$$$reportNull$$$0(13);
        }
        return string;
    }

    public static boolean hasNavigatableKeys(@Nullable DbDataSource dataSource, @Nullable DasTable databaseTable) {
        return dataSource != null && databaseTable != null && (!Iterables.isEmpty((Iterable)ModelRelationManager.getExportedKeys((Project)dataSource.getProject(), (DasTable)databaseTable)) || !Iterables.isEmpty((Iterable)ModelRelationManager.getForeignKeys((Project)dataSource.getProject(), (DasTable)databaseTable)));
    }

    @NlsSafe
    @Nullable
    public static String getGridDocumentation(Project project, @NotNull DataGrid dataGrid) {
        String queryText;
        if (dataGrid == null) {
            DataGridDocumentationTarget.$$$reportNull$$$0(14);
        }
        if ((queryText = DataGridUtil.getQueryText(dataGrid)) == null) {
            return null;
        }
        GridPagingModel pageModel = dataGrid.getDataHookup().getPageModel();
        String curCount = pageModel.getTotalRowCount() + (!pageModel.isTotalRowCountPrecise() ? "+" : "");
        return DbDocumentationHelper.getRowCountSection((Object)curCount, (boolean)pageModel.isTotalRowCountPrecise()) + "<br><br><pre><code>" + DbSqlUtil.sql2Html((Project)project, (Language)DataGridUtil.getSqlDialect(dataGrid), (CharSequence)queryText) + "</code></pre>";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 10, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = GRID_SECTION;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/documentation/DataGridDocumentationTarget";
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataGrid";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newQueries";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/documentation/DataGridDocumentationTarget";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGrid";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computePresentation";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCellDocumentation";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "extractValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 13: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runQueries";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doLoadRelatedData";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCellDocumentation";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "extractValues";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getGridDocumentation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 10, 13 -> new IllegalStateException(string);
        };
    }

    public static class DataGridDocumentationCharOut
    extends Out.Wrapper {
        private final DataGridDocumentationCommand myMode;
        private final boolean myPlainMode;
        static final int max = 10240;

        public DataGridDocumentationCharOut(@NotNull Out sink, @NotNull DataGridDocumentationCommand mode, boolean plainMode) {
            if (sink == null) {
                DataGridDocumentationCharOut.$$$reportNull$$$0(0);
            }
            if (mode == null) {
                DataGridDocumentationCharOut.$$$reportNull$$$0(1);
            }
            super(sink);
            this.myMode = mode;
            this.myPlainMode = plainMode;
        }

        @NotNull
        public Out appendText(@NotNull CharSequence seq) {
            CharSequence trimmedSeq;
            if (seq == null) {
                DataGridDocumentationCharOut.$$$reportNull$$$0(2);
            }
            if (seq.isEmpty()) {
                DataGridDocumentationCharOut dataGridDocumentationCharOut = this;
                if (dataGridDocumentationCharOut == null) {
                    DataGridDocumentationCharOut.$$$reportNull$$$0(3);
                }
                return dataGridDocumentationCharOut;
            }
            boolean truncate = this.myMode != DataGridDocumentationCommand.FULL_VALUE && (double)seq.length() > 11264.0;
            CharSequence charSequence = trimmedSeq = truncate ? seq.subSequence(0, 10240) : seq;
            if (this.myPlainMode) {
                this.getDelegate().appendText((CharSequence)HtmlChunk.link((String)DbDocumentationHelper.dbSubstituteUrl((String)DataGridDocumentationCommand.TRANSPOSED.code()), (String)DatabaseBundle.message((String)"cells.view.mode.transposed", (Object[])new Object[0])).toString());
                if (truncate) {
                    this.getDelegate().appendText((CharSequence)"&nbsp;&nbsp;&nbsp;").appendText((CharSequence)HtmlChunk.link((String)DbDocumentationHelper.dbSubstituteUrl((String)DataGridDocumentationCommand.FULL_VALUE.code()), (String)DatabaseBundle.message((String)"cells.show.all.N.byte", (Object[])new Object[]{ExtractorsUtil.getPresentableSize((long)seq.length())})).toString());
                }
                super.appendText((CharSequence)"<br><br><pre><code>");
                this.appendInner(trimmedSeq);
                super.appendText((CharSequence)"</code>");
                if (truncate) {
                    this.getDelegate().appendText((CharSequence)"&nbsp;").appendText((CharSequence)HtmlChunk.link((String)DbDocumentationHelper.dbSubstituteUrl((String)DataGridDocumentationCommand.FULL_VALUE.code()), (String)DatabaseBundle.message((String)"cells.show.N.byte.more", (Object[])new Object[]{ExtractorsUtil.getPresentableSize((long)(seq.length() - 10240))})).toString());
                }
                super.appendText((CharSequence)"</pre>");
            } else if (truncate) {
                this.appendInner(trimmedSeq);
                super.appendText((CharSequence)(" " + ExtractorsUtil.getPresentableSize((long)(seq.length() - 10240)) + " more..."));
            } else {
                this.appendInner(seq);
            }
            DataGridDocumentationCharOut dataGridDocumentationCharOut = this;
            if (dataGridDocumentationCharOut == null) {
                DataGridDocumentationCharOut.$$$reportNull$$$0(4);
            }
            return dataGridDocumentationCharOut;
        }

        void appendInner(CharSequence trimmedSeq) {
            int cur = 0;
            int len = trimmedSeq.length();
            while (cur < len) {
                int next = StringUtil.indexOf((CharSequence)trimmedSeq, (char)'\n', (int)cur);
                next = next < 0 ? len : next;
                super.appendText(trimmedSeq.subSequence(cur, next));
                if (next != len) {
                    super.appendText((CharSequence)" \n");
                }
                cur = next + 1;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "seq";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/documentation/DataGridDocumentationTarget$DataGridDocumentationCharOut";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/documentation/DataGridDocumentationTarget$DataGridDocumentationCharOut";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "appendText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "appendText";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    private static class DataGridDocumentationObjectFormatter
    extends DbObjectFormatter {
        final ObjectFormatter myDelegate;

        DataGridDocumentationObjectFormatter(@NotNull ObjectFormatter delegate, @NotNull Dbms dbms) {
            if (delegate == null) {
                DataGridDocumentationObjectFormatter.$$$reportNull$$$0(0);
            }
            if (dbms == null) {
                DataGridDocumentationObjectFormatter.$$$reportNull$$$0(1);
            }
            super(dbms);
            this.myDelegate = delegate;
        }

        @Nullable
        public String objectToString(@Nullable Object o, GridColumn column, @NotNull ObjectFormatterConfig config) {
            if (config == null) {
                DataGridDocumentationObjectFormatter.$$$reportNull$$$0(2);
            }
            ObjectFormatterConfig newConfig = DatabaseObjectFormatterConfig.toDisplayConfig((ObjectFormatterConfig)config);
            if (o instanceof ImageInfo) {
                ImageInfo oo = (ImageInfo)o;
                String s = this.myDelegate.objectToString((Object)oo.stripBytes(), column, newConfig);
                return DbDocumentationHelper.createImageRefTag((ImageInfo)oo, (String)s);
            }
            String s = this.myDelegate.objectToString(o, column, newConfig);
            return HtmlValuesExtractor.escapeChars((String)s);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ui/grid/documentation/DataGridDocumentationTarget$DataGridDocumentationObjectFormatter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "objectToString";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

