/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.endpoints;

import com.intellij.microservices.url.HttpUrlResolver;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlResolveRequest;
import com.intellij.microservices.url.UrlResolverFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.python.endpoints.ModuleWebStructure;
import com.intellij.python.endpoints.ProjectWebStructureKt;
import com.intellij.python.endpoints.RenderedEndpoint;
import com.intellij.python.endpoints.WebApplication;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/python/endpoints/WebApplicationUrlResolver;", "Lcom/intellij/microservices/url/HttpUrlResolver;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getApplications", "", "Lcom/intellij/python/endpoints/WebApplication;", "resolve", "Lcom/intellij/python/endpoints/RenderedEndpoint;", "request", "Lcom/intellij/microservices/url/UrlResolveRequest;", "getVariants", "Factory", "intellij.python.endpoints"})
@SourceDebugExtension(value={"SMAP\nWebApplicationUrlResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebApplicationUrlResolver.kt\ncom/intellij/python/endpoints/WebApplicationUrlResolver\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,38:1\n10468#2:39\n10890#2,5:40\n1374#3:45\n1460#3,2:46\n774#3:48\n865#3:49\n866#3:53\n1462#3,3:54\n1374#3:57\n1460#3,5:58\n1#4:50\n1255#5,2:51\n*S KotlinDebug\n*F\n+ 1 WebApplicationUrlResolver.kt\ncom/intellij/python/endpoints/WebApplicationUrlResolver\n*L\n21#1:39\n21#1:40,5\n26#1:45\n26#1:46,2\n27#1:48\n27#1:49\n27#1:53\n26#1:54,3\n36#1:57\n36#1:58,5\n29#1:51,2\n*E\n"})
public final class WebApplicationUrlResolver
extends HttpUrlResolver {
    @NotNull
    private final Project project;

    public WebApplicationUrlResolver(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    /*
     * WARNING - void declaration
     */
    private final Iterable<WebApplication> getApplications() {
        void $this$flatMapTo$iv$iv;
        Module[] $this$flatMap$iv = ProjectUtil.getModules((Project)this.project);
        boolean $i$f$flatMap = false;
        Module[] moduleArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        int n = ((void)$this$flatMapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$flatMapTo$iv$iv[i];
            boolean bl = false;
            Object object = ProjectWebStructureKt.getModuleWebStructure((Module)it);
            if (object == null || (object = ((ModuleWebStructure)object).getWebApplications()) == null) {
                object = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = (Iterable)object;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Iterable<RenderedEndpoint> resolve(@NotNull UrlResolveRequest request) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Sequence combinations = UrlPath.Companion.combinations(request.getPath());
        Iterable<WebApplication> $this$flatMap$iv = this.getApplications();
        boolean $i$f$flatMap = false;
        Iterable<WebApplication> iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$filterTo$iv$iv;
            WebApplication application = (WebApplication)element$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv = application.getEndpoints();
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                boolean isPathCompatible;
                boolean hasRequestedMethod;
                block5: {
                    boolean bl2;
                    boolean bl3;
                    RenderedEndpoint endpoint = (RenderedEndpoint)element$iv$iv2;
                    boolean bl4 = false;
                    if (request.getMethod() != null) {
                        String it;
                        boolean bl5 = false;
                        bl3 = endpoint.getMethods().contains(it);
                    } else {
                        bl3 = true;
                    }
                    hasRequestedMethod = bl3;
                    Sequence $this$any$iv = combinations;
                    boolean $i$f$any = false;
                    for (Object element$iv : $this$any$iv) {
                        UrlPath it = (UrlPath)element$iv;
                        boolean bl6 = false;
                        if (!endpoint.getPath().isCompatibleWith(it)) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = isPathCompatible = false;
                }
                if (!(hasRequestedMethod && isPathCompatible)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Iterable<RenderedEndpoint> getVariants() {
        void $this$flatMapTo$iv$iv;
        Iterable<WebApplication> $this$flatMap$iv = this.getApplications();
        boolean $i$f$flatMap = false;
        Iterable<WebApplication> iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            WebApplication it = (WebApplication)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getEndpoints();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/python/endpoints/WebApplicationUrlResolver$Factory;", "Lcom/intellij/microservices/url/UrlResolverFactory;", "<init>", "()V", "forProject", "Lcom/intellij/python/endpoints/WebApplicationUrlResolver;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.python.endpoints"})
    @SourceDebugExtension(value={"SMAP\nWebApplicationUrlResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebApplicationUrlResolver.kt\ncom/intellij/python/endpoints/WebApplicationUrlResolver$Factory\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,38:1\n12970#2,2:39\n*S KotlinDebug\n*F\n+ 1 WebApplicationUrlResolver.kt\ncom/intellij/python/endpoints/WebApplicationUrlResolver$Factory\n*L\n15#1:39,2\n*E\n"})
    public static final class Factory
    implements UrlResolverFactory {
        @Nullable
        public WebApplicationUrlResolver forProject(@NotNull Project project) {
            boolean bl;
            block1: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Module[] $this$any$iv = ProjectUtil.getModules((Project)project);
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    Module element$iv;
                    Module it = element$iv = $this$any$iv[i];
                    boolean bl2 = false;
                    if (!ProjectWebStructureKt.hasWebStructure(it)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            boolean hasModuleWithWebStructure = bl;
            return hasModuleWithWebStructure ? new WebApplicationUrlResolver(project) : null;
        }
    }
}

