/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.lsp.core;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspServer;
import com.intellij.platform.lsp.api.LspServerDescriptor;
import com.intellij.platform.lsp.api.LspServerManager;
import com.intellij.platform.lsp.api.LspServerSupportProvider;
import com.intellij.platform.lsp.api.lsWidget.LspServerWidgetItem;
import com.intellij.python.lsp.core.PyLspToolDescriptor;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.packaging.common.PythonPackage;
import com.jetbrains.python.packaging.common.PythonPackageManagementListener;
import com.jetbrains.python.packaging.management.PythonPackageManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 !2\u00020\u0001:\u0002 !B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\rH&J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0015H&J\u0015\u0010\u001b\u001a\u00070\u001c\u00a2\u0006\u0002\b\u001d2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\rH\u0014R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\""}, d2={"Lcom/intellij/python/lsp/core/PyLspToolSupportProvider;", "Lcom/intellij/platform/lsp/api/LspServerSupportProvider;", "<init>", "()V", "listenerConnected", "", "getListenerConnected", "()Z", "setListenerConnected", "(Z)V", "fileOpened", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "serverStarter", "Lcom/intellij/platform/lsp/api/LspServerSupportProvider$LspServerStarter;", "createLspServerWidgetItem", "Lcom/intellij/platform/lsp/api/lsWidget/LspServerWidgetItem;", "lspServer", "Lcom/intellij/platform/lsp/api/LspServer;", "currentFile", "getDescriptor", "Lcom/intellij/python/lsp/core/PyLspToolDescriptor;", "getIcon", "Ljavax/swing/Icon;", "presentableName", "", "Lcom/intellij/openapi/util/NlsSafe;", "subscribeOnChanges", "name", "LspPackageListener", "Companion", "intellij.python.lsp.core"})
public abstract class PyLspToolSupportProvider
implements LspServerSupportProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean listenerConnected;

    public final boolean getListenerConnected() {
        return this.listenerConnected;
    }

    public final void setListenerConnected(boolean bl) {
        this.listenerConnected = bl;
    }

    public void fileOpened(@NotNull Project project, @NotNull VirtualFile file, @NotNull LspServerSupportProvider.LspServerStarter serverStarter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)serverStarter, (String)"serverStarter");
        if (!Companion.getPythonLspToolsEnabled()) {
            return;
        }
        if (!(file.getFileType() instanceof PythonFileType)) {
            return;
        }
        PyLspToolDescriptor descriptor = this.getDescriptor(project);
        if (!this.listenerConnected) {
            this.subscribeOnChanges(descriptor.getToolNames().getPackageName(), project);
            this.listenerConnected = true;
        }
        if (descriptor.findExecutable() == null) {
            return;
        }
        if (!descriptor.getToolConfig().getEnabled()) {
            return;
        }
        serverStarter.ensureServerStarted((LspServerDescriptor)descriptor);
    }

    @Nullable
    public LspServerWidgetItem createLspServerWidgetItem(@NotNull LspServer lspServer, @Nullable VirtualFile currentFile) {
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        Icon icon = this.getIcon(lspServer);
        LspServerDescriptor lspServerDescriptor = lspServer.getDescriptor();
        Intrinsics.checkNotNull((Object)lspServerDescriptor, (String)"null cannot be cast to non-null type com.intellij.python.lsp.core.PyLspToolDescriptor");
        Class<? extends Configurable> clazz = ((PyLspToolDescriptor)lspServerDescriptor).getConfigurableClass();
        return new LspServerWidgetItem(lspServer, currentFile, this, icon, clazz){
            final /* synthetic */ LspServer $lspServer;
            final /* synthetic */ PyLspToolSupportProvider this$0;
            {
                this.$lspServer = $lspServer;
                this.this$0 = $receiver;
                super($lspServer, $currentFile, $super_call_param$1, $super_call_param$2);
            }

            protected String getServerLabel() {
                return this.this$0.presentableName(this.$lspServer) + this.getVersionPostfix() + this.getRootPostfix();
            }
        };
    }

    @NotNull
    public abstract PyLspToolDescriptor getDescriptor(@NotNull Project var1);

    @NotNull
    public abstract Icon getIcon(@NotNull LspServer var1);

    @NotNull
    public String presentableName(@NotNull LspServer lspServer) {
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        Object object = lspServer.getInitializeResult();
        if (object == null || (object = object.getServerInfo()) == null || (object = object.getName()) == null) {
            object = lspServer.getDescriptor().getPresentableName();
        }
        return object;
    }

    protected void subscribeOnChanges(@NotNull String name, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        project.getMessageBus().connect().subscribe(PythonPackageManager.Companion.getPACKAGE_MANAGEMENT_TOPIC(), (Object)new LspPackageListener(name, project));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058G\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/python/lsp/core/PyLspToolSupportProvider$Companion;", "", "<init>", "()V", "pythonLspToolsEnabled", "", "getPythonLspToolsEnabled", "()Z", "intellij.python.lsp.core"})
    public static final class Companion {
        private Companion() {
        }

        @ApiStatus.Internal
        public final boolean getPythonLspToolsEnabled() {
            return Registry.Companion.is("python.lsp.tools.enabled");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0012\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lcom/intellij/python/lsp/core/PyLspToolSupportProvider$LspPackageListener;", "Lcom/jetbrains/python/packaging/common/PythonPackageManagementListener;", "name", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/python/lsp/core/PyLspToolSupportProvider;Ljava/lang/String;Lcom/intellij/openapi/project/Project;)V", "getName", "()Ljava/lang/String;", "getProject", "()Lcom/intellij/openapi/project/Project;", "wasThisToolInstalled", "", "getWasThisToolInstalled", "()Ljava/lang/Boolean;", "setWasThisToolInstalled", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "packagesChanged", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "intellij.python.lsp.core"})
    @SourceDebugExtension(value={"SMAP\nPyLspToolSupportProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyLspToolSupportProvider.kt\ncom/intellij/python/lsp/core/PyLspToolSupportProvider$LspPackageListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,388:1\n1563#2:389\n1634#2,3:390\n*S KotlinDebug\n*F\n+ 1 PyLspToolSupportProvider.kt\ncom/intellij/python/lsp/core/PyLspToolSupportProvider$LspPackageListener\n*L\n114#1:389\n114#1:390,3\n*E\n"})
    public final class LspPackageListener
    implements PythonPackageManagementListener {
        @NotNull
        private final String name;
        @NotNull
        private final Project project;
        @Nullable
        private Boolean wasThisToolInstalled;

        public LspPackageListener(@NotNull String name, Project project) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.name = name;
            this.project = project;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @Nullable
        public final Boolean getWasThisToolInstalled() {
            return this.wasThisToolInstalled;
        }

        public final void setWasThisToolInstalled(@Nullable Boolean bl) {
            this.wasThisToolInstalled = bl;
        }

        /*
         * WARNING - void declaration
         */
        public void packagesChanged(@NotNull Sdk sdk) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
            LspServerManager lspServerManager = LspServerManager.Companion.getInstance(this.project);
            Iterable $this$map$iv = PythonPackageManager.Companion.forSdk(this.project, sdk).listInstalledPackagesSnapshot();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PythonPackage pythonPackage = (PythonPackage)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            boolean isInstalled = ((List)destination$iv$iv).contains(this.name);
            if (!Intrinsics.areEqual((Object)isInstalled, (Object)this.wasThisToolInstalled)) {
                Class<?> providerClass = PyLspToolSupportProvider.this.getClass();
                if (isInstalled) {
                    lspServerManager.startServersIfNeeded(providerClass);
                } else {
                    lspServerManager.stopServers(providerClass);
                }
            }
            this.wasThisToolInstalled = isInstalled;
        }
    }
}

