/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.profiler.callgraph;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.profiler.ui.MainCallTreeDataComponentKt;
import com.intellij.python.profiler.FunctionStat;
import com.intellij.python.profiler.ProfilerViewKt;
import com.intellij.python.profiler.PythonProfilerBundle;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lcom/intellij/python/profiler/callgraph/NavigateFromNodeToSourceAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "project", "Lcom/intellij/openapi/project/Project;", "functionStat", "Lcom/intellij/python/profiler/FunctionStat;", "localPathFunction", "Lkotlin/Function1;", "Ljava/nio/file/Path;", "Lcom/intellij/python/profiler/LocalPathFunction;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/python/profiler/FunctionStat;Lkotlin/jvm/functions/Function1;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getFunctionStat", "()Lcom/intellij/python/profiler/FunctionStat;", "getLocalPathFunction", "()Lkotlin/jvm/functions/Function1;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.python.profiler"})
final class NavigateFromNodeToSourceAction
extends AnAction {
    @NotNull
    private final Project project;
    @NotNull
    private final FunctionStat functionStat;
    @NotNull
    private final Function1<Path, Path> localPathFunction;

    public NavigateFromNodeToSourceAction(@NotNull Project project, @NotNull FunctionStat functionStat, @NotNull Function1<? super Path, ? extends Path> localPathFunction) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)functionStat, (String)"functionStat");
        Intrinsics.checkNotNullParameter(localPathFunction, (String)"localPathFunction");
        super(PythonProfilerBundle.message("navigate.to.source", new Object[0]));
        this.project = project;
        this.functionStat = functionStat;
        this.localPathFunction = localPathFunction;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final FunctionStat getFunctionStat() {
        return this.functionStat;
    }

    @NotNull
    public final Function1<Path, Path> getLocalPathFunction() {
        return this.localPathFunction;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Navigatable[] navigatables = ProfilerViewKt.findNavigatables(this.project, this.functionStat, this.localPathFunction);
            Project project = e.getProject();
            if (project == null || (project = MainCallTreeDataComponentKt.profilerUiScope((Project)project)) == null) break block1;
            Project scope = project;
            boolean bl = false;
            if (!(navigatables.length == 0)) {
                ProfilerViewKt.navigate(navigatables, (CoroutineScope)scope);
            }
        }
    }
}

