/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleNavigatable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageChecker.ProjectLibraryNavigatable;
import com.intellij.packageChecker.model.Dependency;
import com.intellij.packageChecker.model.Package;
import com.intellij.packageChecker.toolwindow.DependencyContext;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\nJ\u001c\u0010\u0014\u001a\u0004\u0018\u00010\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007RB\u0010\b\u001a6\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\u0006\u0012\u0004\u0018\u00010\f \u000b*\u001a\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u000e\u001a6\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u000f0\u000f\u0012\u0006\u0012\u0004\u0018\u00010\f \u000b*\u001a\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u000f0\u000f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u0010\u001a6\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00110\u0011\u0012\u0006\u0012\u0004\u0018\u00010\f \u000b*\u001a\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00110\u0011\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/packageChecker/DependencySourceService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "navigatablesByDependency", "", "Lcom/intellij/packageChecker/model/Dependency;", "kotlin.jvm.PlatformType", "Lcom/intellij/pom/Navigatable;", "", "navigatablesByModule", "Lcom/intellij/openapi/module/Module;", "navigatablesByVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getOrCreateDependencySource", "dependency", "getOrCreateModuleSource", "file", "module", "Companion", "intellij.packageChecker"})
public final class DependencySourceService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private final Map<Dependency, Navigatable> navigatablesByDependency;
    private final Map<Module, Navigatable> navigatablesByModule;
    private final Map<VirtualFile, Navigatable> navigatablesByVirtualFile;

    public DependencySourceService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.navigatablesByDependency = Collections.synchronizedMap(new HashMap());
        this.navigatablesByModule = Collections.synchronizedMap(new HashMap());
        this.navigatablesByVirtualFile = Collections.synchronizedMap(new HashMap());
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final Navigatable getOrCreateDependencySource(@NotNull Dependency dependency) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        DependencyContext dependencyContext = dependency.getContext();
        if (dependencyContext == null) {
            return null;
        }
        DependencyContext context = dependencyContext;
        return this.navigatablesByDependency.computeIfAbsent(dependency, arg_0 -> DependencySourceService.getOrCreateDependencySource$lambda$1(arg_0 -> DependencySourceService.getOrCreateDependencySource$lambda$0(context, dependency, this, arg_0), arg_0));
    }

    @Nullable
    public final Navigatable getOrCreateModuleSource(@Nullable VirtualFile file, @Nullable Module module) {
        return file != null ? this.navigatablesByVirtualFile.computeIfAbsent(file, arg_0 -> DependencySourceService.getOrCreateModuleSource$lambda$1(arg_0 -> DependencySourceService.getOrCreateModuleSource$lambda$0(this, file, arg_0), arg_0)) : (module != null ? this.navigatablesByModule.computeIfAbsent(module, arg_0 -> DependencySourceService.getOrCreateModuleSource$lambda$3(arg_0 -> DependencySourceService.getOrCreateModuleSource$lambda$2(module, arg_0), arg_0)) : null);
    }

    private static final Navigatable getOrCreateDependencySource$lambda$0(DependencyContext $context, Dependency $dependency, DependencySourceService this$0, Dependency it) {
        VirtualFile file = $context.getVirtualFile();
        Module module = $context.getModule();
        Package pkg = $dependency.getPkg();
        if (module != null && file != null) {
            Function3<VirtualFile, Module, Package, PsiElement> findPackageDeclaration = $context.getFindPackageDeclaration();
            if (findPackageDeclaration == null) {
                return (Navigatable)new OpenFileDescriptor(this$0.project, file);
            }
            PsiElement psiElement = (PsiElement)findPackageDeclaration.invoke((Object)file, (Object)module, (Object)pkg);
            if (psiElement != null && psiElement instanceof Navigatable) {
                return (Navigatable)psiElement;
            }
            return (Navigatable)new OpenFileDescriptor(this$0.project, file);
        }
        if ($context.getLibrary() != null) {
            return new ProjectLibraryNavigatable($context.getLibrary(), this$0.project);
        }
        if (file != null) {
            return (Navigatable)new OpenFileDescriptor(this$0.project, file);
        }
        if (module != null) {
            return (Navigatable)new ModuleNavigatable(module);
        }
        return null;
    }

    private static final Navigatable getOrCreateDependencySource$lambda$1(Function1 $tmp0, Object p0) {
        return (Navigatable)$tmp0.invoke(p0);
    }

    private static final Navigatable getOrCreateModuleSource$lambda$0(DependencySourceService this$0, VirtualFile $file, VirtualFile it) {
        return (Navigatable)new OpenFileDescriptor(this$0.project, $file);
    }

    private static final Navigatable getOrCreateModuleSource$lambda$1(Function1 $tmp0, Object p0) {
        return (Navigatable)$tmp0.invoke(p0);
    }

    private static final Navigatable getOrCreateModuleSource$lambda$2(Module $module, Module it) {
        return (Navigatable)new ModuleNavigatable($module);
    }

    private static final Navigatable getOrCreateModuleSource$lambda$3(Function1 $tmp0, Object p0) {
        return (Navigatable)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/packageChecker/DependencySourceService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/packageChecker/DependencySourceService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.packageChecker"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DependencySourceService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(DependencySourceService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (DependencySourceService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

