/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download;

import com.intellij.indexing.shared.download.SharedIndexAuthParams;
import com.intellij.indexing.shared.download.SharedIndexDownloadAuthExtension;
import com.intellij.indexing.shared.download.SharedIndexDownloadAuthExtensionKt;
import com.intellij.indexing.shared.download.SharedIndexDownloadLoggerKt;
import com.intellij.indexing.shared.download.SharedIndexLookupRequest;
import com.intellij.indexing.shared.download.SharedIndexSuggestion;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorForCollections;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001aV\u0010\u0000\u001a\u00020\u00012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2$\u0010\u000b\u001a \u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u0012\u0004\u0012\u00020\u00010\f\u00a8\u0006\r"}, d2={"initiateAuthIfNeeded", "", "requests", "", "Lkotlin/Pair;", "Lcom/intellij/indexing/shared/download/SharedIndexSuggestion;", "Lcom/intellij/indexing/shared/download/SharedIndexLookupRequest;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "disposable", "Lcom/intellij/openapi/Disposable;", "onAuthCompleted", "Lkotlin/Function1;", "intellij.indexing.shared"})
@SourceDebugExtension(value={"SMAP\nSharedIndexAuth.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndexAuth.kt\ncom/intellij/indexing/shared/download/SharedIndexAuthKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 ProgressIndicatorEx.kt\ncom/intellij/openapi/progress/ProgressIndicatorForCollections\n*L\n1#1,151:1\n1869#2:152\n1870#2:160\n1563#2:161\n1634#2,3:162\n1563#2:184\n1634#2,3:185\n382#3,7:153\n28#4:165\n13#4,4:166\n29#4,14:170\n44#4,5:188\n19#4,2:193\n49#4:195\n*S KotlinDebug\n*F\n+ 1 SharedIndexAuth.kt\ncom/intellij/indexing/shared/download/SharedIndexAuthKt\n*L\n27#1:152\n27#1:160\n44#1:161\n44#1:162,3\n61#1:184\n61#1:185,3\n38#1:153,7\n54#1:165\n54#1:166,4\n54#1:170,14\n54#1:188,5\n54#1:193,2\n54#1:195\n*E\n"})
public final class SharedIndexAuthKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void initiateAuthIfNeeded(@NotNull List<? extends Pair<? extends SharedIndexSuggestion, ? extends SharedIndexLookupRequest>> requests, @NotNull ProgressIndicator indicator, @NotNull Disposable disposable, @NotNull Function1<? super List<? extends Pair<? extends SharedIndexSuggestion, ? extends SharedIndexLookupRequest>>, Unit> onAuthCompleted) {
        Collection $this$map$iv;
        Object auth;
        Intrinsics.checkNotNullParameter(requests, (String)"requests");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(onAuthCompleted, (String)"onAuthCompleted");
        indicator.checkCanceled();
        List noAuth = new ArrayList();
        List canNotAuth = new ArrayList();
        Map auths = new LinkedHashMap();
        Iterable $this$forEach$iv = requests;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            void $this$getOrPut$iv;
            boolean bl;
            Pair it = (Pair)element$iv;
            boolean bl2 = false;
            SharedIndexAuthParams authId = ((SharedIndexLookupRequest)it.getSecond()).getAuthId();
            if (authId == null) {
                bl = noAuth.add(it);
                continue;
            }
            auth = SharedIndexDownloadAuthExtensionKt.resolveIndexDownloadAuthExtension(authId);
            if (auth == null) {
                bl = canNotAuth.add(authId);
                continue;
            }
            Map map = auths;
            SharedIndexDownloadAuthExtension key$iv = auth;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl3 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            bl = ((List)object).add(it);
        }
        if (!((Collection)canNotAuth).isEmpty()) {
            void $this$mapTo$iv$iv;
            $this$forEach$iv = canNotAuth;
            Logger logger = SharedIndexDownloadLoggerKt.getDownloadLogger();
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                auth = (SharedIndexAuthParams)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getAuthId());
            }
            logger.warn("Can not find authentication extensions: " + (List)destination$iv$iv);
        }
        if (!((Collection)noAuth).isEmpty() && auths.isEmpty()) {
            onAuthCompleted.invoke((Object)noAuth);
        }
        if (!auths.isEmpty()) {
            indicator.setText(SharedIndexesBundle.message("progress.text.auth", new Object[0]));
            $this$map$iv = auths.entrySet();
            ProgressIndicator indicator$iv = indicator;
            boolean $i$f$forEachWithProgress = false;
            ProgressIndicator $this$withPushPop$iv$iv = indicator$iv;
            boolean $i$f$withPushPop = false;
            boolean wasIndeterminate$iv$iv = $this$withPushPop$iv$iv.isIndeterminate();
            $this$withPushPop$iv$iv.pushState();
            try {
                void $this$forEachWithProgress$iv;
                boolean bl = false;
                indicator$iv.setIndeterminate(false);
                indicator$iv.checkCanceled();
                double size$iv = $this$forEachWithProgress$iv.size();
                Iterator iterator = ((Iterable)$this$forEachWithProgress$iv).iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    int i$iv = n++;
                    Object y$iv = iterator.next();
                    indicator$iv.checkCanceled();
                    double lowerBound$iv = (double)i$iv / size$iv;
                    double upperBound$iv = (double)(i$iv + 1) / size$iv;
                    indicator$iv.setFraction(lowerBound$iv);
                    String prevText$iv = indicator$iv.getText();
                    String prevText2$iv = indicator$iv.getText2();
                    ProgressIndicator progressIndicator = ProgressIndicatorForCollections.scaleFraction((ProgressIndicator)indicator$iv, (double)lowerBound$iv, (double)upperBound$iv);
                    Map.Entry entry = (Map.Entry)y$iv;
                    boolean bl4 = false;
                    SharedIndexDownloadAuthExtension auth2 = (SharedIndexDownloadAuthExtension)entry.getKey();
                    List requests2 = (List)entry.getValue();
                    try {
                        String string;
                        Collection<SharedIndexSuggestion> collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv2;
                        void subProgress;
                        subProgress.setText2(auth2.getPresentableName());
                        SharedIndexDownloadLoggerKt.getDownloadLogger().info("Starting authentication: " + auth2.getType());
                        Intrinsics.checkNotNullExpressionValue((Object)SharedIndexesBundle.message("auth.presentable.text", new Object[0]), (String)"message(...)");
                        Iterable iterable = requests2;
                        SharedIndexDownloadAuthExtension sharedIndexDownloadAuthExtension = auth2;
                        boolean $i$f$map = false;
                        void var35_48 = $this$map$iv2;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            Pair pair = (Pair)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl5 = false;
                            collection.add((SharedIndexSuggestion)it.getFirst());
                        }
                        collection = (List)destination$iv$iv;
                        sharedIndexDownloadAuthExtension.checkAuthenticated(string, (List<? extends SharedIndexSuggestion>)collection, (ProgressIndicator)subProgress, disposable, (Function0<Unit>)((Function0)() -> SharedIndexAuthKt.initiateAuthIfNeeded$lambda$2$1(auth2, onAuthCompleted, requests2)));
                    }
                    catch (Throwable t) {
                        if (t instanceof ControlFlowException) {
                            throw t;
                        }
                        SharedIndexDownloadLoggerKt.getDownloadLogger().warn("Failed to check for authentication with " + auth2.getType() + ". " + t.getMessage(), t);
                    }
                    indicator$iv.setText(prevText$iv);
                    indicator$iv.setText2(prevText2$iv);
                }
                indicator$iv.setFraction(1.0);
            }
            finally {
                $this$withPushPop$iv$iv.setIndeterminate(wasIndeterminate$iv$iv);
                $this$withPushPop$iv$iv.popState();
            }
        }
    }

    private static final Unit initiateAuthIfNeeded$lambda$2$1(SharedIndexDownloadAuthExtension $auth, Function1 $onAuthCompleted, List $requests) {
        SharedIndexDownloadLoggerKt.getDownloadLogger().info("Authentication completed: " + $auth.getType() + " ");
        $onAuthCompleted.invoke((Object)$requests);
        return Unit.INSTANCE;
    }
}

