/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.util.JSFunctionsRefactoringUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAnonymousToNamedFunctionIntention
extends JavaScriptIntention {
    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            JSAnonymousToNamedFunctionIntention.$$$reportNull$$$0(0);
        }
        return currentFile;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element2) {
        if (project == null) {
            JSAnonymousToNamedFunctionIntention.$$$reportNull$$$0(1);
        }
        if (element2 == null) {
            JSAnonymousToNamedFunctionIntention.$$$reportNull$$$0(2);
        }
        if (!super.isAvailable(project, editor, element2)) {
            return false;
        }
        JSFunctionExpression functionExpression = JSAnonymousToNamedFunctionIntention.findFunctionExpression(element2);
        if (functionExpression == null) {
            return false;
        }
        this.setText(JSUtils.isMember((PsiElement)functionExpression.getElementAssignedTo()) && JSClassUtils.isES6ClassImplementation((PsiElement)functionExpression) ? JavaScriptBundle.message((String)"js.convert.to.named.function.to.class.method", (Object[])new Object[0]) : JavaScriptBundle.message((String)"js.convert.to.named.function", (Object[])new Object[0]));
        return true;
    }

    @Nullable
    static JSFunctionExpression findFunctionExpression(@NotNull PsiElement element2) {
        JSField field;
        JSFunctionExpression functionExpression;
        PsiElement psiElement;
        JSFunctionExpression wrappingAnonymousFunction;
        if (element2 == null) {
            JSAnonymousToNamedFunctionIntention.$$$reportNull$$$0(3);
        }
        if ((wrappingAnonymousFunction = JSAnonymousToNamedFunctionIntention.getWrappingAnonymousFunction(element2)) != null) {
            return wrappingAnonymousFunction;
        }
        if (PsiUtilCore.getElementType((PsiElement)element2) == JSTokenTypes.IDENTIFIER && (psiElement = element2.getParent()) instanceof JSField && (functionExpression = (JSFunctionExpression)ObjectUtils.tryCast((Object)JSPsiImplUtils.getPossibleFunction((PsiElement)(field = (JSField)psiElement)), JSFunctionExpression.class)) != null && functionExpression.isArrowFunction()) {
            return functionExpression;
        }
        return null;
    }

    @Nullable
    public static JSFunctionExpression getWrappingAnonymousFunction(@NotNull PsiElement element2) {
        JSFunctionExpression functionExpression;
        if (element2 == null) {
            JSAnonymousToNamedFunctionIntention.$$$reportNull$$$0(4);
        }
        if ((functionExpression = JSAnonymousToNamedFunctionIntention.getParentFunctionExpression(element2)) == null) {
            return null;
        }
        ASTNode nameNode = JSPsiImplUtils.findNameIdentifierOfFunction((ASTNode)functionExpression.getNode(), (boolean)true);
        return nameNode == null ? functionExpression : null;
    }

    static JSFunctionExpression getParentFunctionExpression(@NotNull PsiElement element2) {
        PsiElement parent;
        if (element2 == null) {
            JSAnonymousToNamedFunctionIntention.$$$reportNull$$$0(5);
        }
        if ((parent = element2.getParent()) instanceof JSParameter) {
            parent = parent.getParent();
        }
        if (parent instanceof JSParameterList) {
            parent = parent.getParent();
        }
        if (parent instanceof JSFunctionExpression) {
            return (JSFunctionExpression)parent;
        }
        return null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element2) throws IncorrectOperationException {
        boolean isEs6ClassMember;
        JSFunctionExpression functionExpression;
        if (project == null) {
            JSAnonymousToNamedFunctionIntention.$$$reportNull$$$0(6);
        }
        if (element2 == null) {
            JSAnonymousToNamedFunctionIntention.$$$reportNull$$$0(7);
        }
        if ((functionExpression = JSAnonymousToNamedFunctionIntention.findFunctionExpression(element2)) == null) {
            return;
        }
        String functionName = null;
        JSQualifiedNamedElement parentNamedElement = functionExpression.getElementAssignedTo();
        boolean bl = isEs6ClassMember = JSUtils.isMember((PsiElement)parentNamedElement) && JSClassUtils.isES6ClassImplementation((PsiElement)functionExpression);
        if (parentNamedElement instanceof JSVariable && (isEs6ClassMember || ((JSVariable)parentNamedElement).isConst())) {
            functionName = functionExpression.getName();
        }
        if (StringUtil.isEmpty(functionName)) {
            GetFunctionNameDialog dialog;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                functionName = "foo";
            } else if (StringUtil.isEmpty((String)functionName) && (dialog = new GetFunctionNameDialog(this, (PsiElement)functionExpression, functionExpression.getName())).showAndGet()) {
                functionName = dialog.getFunctionName();
            }
        }
        List<JSReferenceExpression> usagesToUpdate = ContainerUtil.emptyList();
        if (isEs6ClassMember && functionExpression.isArrowFunction() && (usagesToUpdate = JSAnonymousToNamedFunctionIntention.findNonCallUsages(parentNamedElement)) == null) {
            return;
        }
        if (functionName != null) {
            String finalFunctionName = functionName;
            List<JSReferenceExpression> finalUsagesToUpdate = usagesToUpdate;
            ApplicationManager.getApplication().runWriteAction(() -> JSAnonymousToNamedFunctionIntention.performRefactoring(functionExpression, parentNamedElement, finalFunctionName, isEs6ClassMember, finalUsagesToUpdate));
        }
    }

    private static void performRefactoring(@NotNull JSFunctionExpression functionExpression, @Nullable JSQualifiedNamedElement parentNamedElement, @NotNull String functionName, boolean isES6ClassMember, @NotNull List<JSReferenceExpression> usagesToReplaceWithBind) {
        JSFunction newFunction;
        if (functionExpression == null) {
            JSAnonymousToNamedFunctionIntention.$$$reportNull$$$0(8);
        }
        if (functionName == null) {
            JSAnonymousToNamedFunctionIntention.$$$reportNull$$$0(9);
        }
        if (usagesToReplaceWithBind == null) {
            JSAnonymousToNamedFunctionIntention.$$$reportNull$$$0(10);
        }
        PsiComment docComment = JSDocumentationUtils.findDocComment((PsiElement)functionExpression);
        if (isES6ClassMember) {
            JSVarStatement fieldStatement = (JSVarStatement)PsiTreeUtil.getParentOfType((PsiElement)parentNamedElement, JSVarStatement.class);
            assert (fieldStatement != null);
            newFunction = JSFunctionsRefactoringUtil.createClassMember((JSFunction)functionExpression, functionName);
            JSRefactoringUtil.copyDecorators((JSAttributeListOwner)parentNamedElement, (JSAttributeListOwner)newFunction);
            newFunction = (JSFunction)fieldStatement.getParent().addBefore((PsiElement)newFunction, (PsiElement)fieldStatement);
            fieldStatement.delete();
            for (JSReferenceExpression referenceExpression : usagesToReplaceWithBind) {
                JSExpression qualifier = referenceExpression.getQualifier();
                assert (qualifier != null);
                String replacementText = referenceExpression.getText() + ".bind(" + qualifier.getText() + ")";
                referenceExpression.replace(JSPsiElementFactory.createJSExpression((String)replacementText, (PsiElement)referenceExpression));
            }
        } else {
            newFunction = JSFunctionsRefactoringUtil.createFunctionDeclaration(functionExpression, functionName);
            newFunction = JSAnonymousToNamedFunctionIntention.addNewFunctionAndReplaceExpression(functionExpression, newFunction, parentNamedElement, functionName);
        }
        if (docComment != null) {
            JSDocumentationUtils.moveJSDoc((PsiComment)docComment, (PsiElement)newFunction);
        }
        FormatFixer.create((PsiElement)newFunction, (FormatFixer.Mode)FormatFixer.Mode.Reformat).fixFormat();
    }

    private static JSFunction addNewFunctionAndReplaceExpression(@NotNull JSFunctionExpression functionExpression, @NotNull JSFunction newPsiElementFunction, @Nullable JSQualifiedNamedElement parentNamedElement, @NotNull String name) {
        if (functionExpression == null) {
            JSAnonymousToNamedFunctionIntention.$$$reportNull$$$0(11);
        }
        if (newPsiElementFunction == null) {
            JSAnonymousToNamedFunctionIntention.$$$reportNull$$$0(12);
        }
        if (name == null) {
            JSAnonymousToNamedFunctionIntention.$$$reportNull$$$0(13);
        }
        JSSourceElement anchor = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)functionExpression, (Class[])new Class[]{JSFunction.class, JSStatement.class});
        assert (anchor != null);
        if (parentNamedElement instanceof JSVariable && name.equals(parentNamedElement.getName())) {
            newPsiElementFunction = (JSFunction)anchor.getParent().addAfter((PsiElement)newPsiElementFunction, (PsiElement)anchor);
            parentNamedElement.delete();
        } else {
            newPsiElementFunction = (JSFunction)anchor.getParent().addAfter((PsiElement)newPsiElementFunction, (PsiElement)anchor);
            JSAnonymousToNamedFunctionIntention.replaceFunctionExpressionWithReference(functionExpression, newPsiElementFunction);
        }
        return newPsiElementFunction;
    }

    private static void replaceFunctionExpressionWithReference(@NotNull JSFunctionExpression functionExpression, @NotNull JSFunction newFunction) {
        if (functionExpression == null) {
            JSAnonymousToNamedFunctionIntention.$$$reportNull$$$0(14);
        }
        if (newFunction == null) {
            JSAnonymousToNamedFunctionIntention.$$$reportNull$$$0(15);
        }
        JSChangeUtil.addWs((ASTNode)newFunction.getParent().getNode(), (ASTNode)newFunction.getNode(), (String)"\n");
        JSExpression referenceExpression = JSPsiElementFactory.createJSExpression((String)newFunction.getName(), (PsiElement)functionExpression, JSReferenceExpression.class);
        JSChangeUtil.replaceExpression((JSExpression)functionExpression, (JSExpression)referenceExpression);
    }

    @Nullable
    private static List<JSReferenceExpression> findNonCallUsages(@NotNull JSQualifiedNamedElement element2) {
        if (element2 == null) {
            JSAnonymousToNamedFunctionIntention.$$$reportNull$$$0(16);
        }
        ArrayList<JSReferenceExpression> result2 = new ArrayList<JSReferenceExpression>();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> ReferencesSearch.search((PsiElement)element2, (SearchScope)element2.getUseScope()).asIterable().forEach(reference -> {
            if (reference instanceof JSReferenceExpression && !(JSUtils.getParentSkipParentheses((PsiElement)((PsiElement)reference)) instanceof JSCallExpression)) {
                result2.add((JSReferenceExpression)reference);
            }
        })), JavaScriptBundle.message((String)"javascript.refactoring.searching.usages", (Object[])new Object[0]), true, element2.getProject())) {
            return null;
        }
        return result2;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"js.anonymous.to.named.function", (Object[])new Object[0]);
        if (string == null) {
            JSAnonymousToNamedFunctionIntention.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionExpression";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usagesToReplaceWithBind";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPsiElementFunction";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFunction";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSAnonymousToNamedFunctionIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSAnonymousToNamedFunctionIntention";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findFunctionExpression";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getWrappingAnonymousFunction";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getParentFunctionExpression";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addNewFunctionAndReplaceExpression";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "replaceFunctionExpressionWithReference";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findNonCallUsages";
                break;
            }
            case 17: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 17 -> new IllegalStateException(string);
        };
    }

    private class GetFunctionNameDialog
    extends DialogWrapper {
        private final JTextField myTextField = new JTextField();
        private final PsiElement myContext;
        private final String myDefaultName;

        protected GetFunctionNameDialog(JSAnonymousToNamedFunctionIntention jSAnonymousToNamedFunctionIntention, PsiElement context2, String defaultName) {
            super(context2.getProject());
            this.myContext = context2;
            this.myDefaultName = defaultName;
            this.setTitle(StringUtil.capitalizeWords((String)jSAnonymousToNamedFunctionIntention.getText(), (boolean)true));
            this.updateOkAction();
            this.init();
        }

        protected JComponent createCenterPanel() {
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(7, 2, 5, 2));
            JLabel label = new JLabel(JavaScriptBundle.message((String)"anonymous.to.named.intention.function.name", (Object[])new Object[0]));
            label.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
            panel.add((Component)label, "First");
            label.setLabelFor(this.myTextField);
            panel.add((Component)this.myTextField, "Last");
            this.myTextField.setPreferredSize(new Dimension(200, this.myTextField.getPreferredSize().height));
            if (this.myDefaultName != null) {
                this.myTextField.setText(this.myDefaultName);
                this.updateOkAction();
            }
            this.myTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    GetFunctionNameDialog.this.updateOkAction();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/intentions/JSAnonymousToNamedFunctionIntention$GetFunctionNameDialog$1", "textChanged"));
                }
            });
            return panel;
        }

        private void updateOkAction() {
            String text = this.myTextField.getText();
            this.getOKAction().setEnabled(!text.isEmpty() && this.isNameValid(text));
        }

        private boolean isNameValid(String text) {
            return LanguageNamesValidation.isIdentifier((Language)this.myContext.getLanguage(), (String)text, (Project)this.myContext.getProject());
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myTextField;
        }

        public String getFunctionName() {
            return this.myTextField.getText();
        }
    }
}

