/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint.service;

import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSNpmLinterState;
import com.intellij.lang.javascript.linter.ServiceInactivityTracker;
import com.intellij.lang.javascript.linter.eslint.EslintConfiguration;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.linter.eslint.service.ESLintBasedLanguageService;
import com.intellij.lang.javascript.linter.eslint.service.EslintLanguageServiceManager;
import com.intellij.lang.javascript.linter.eslint.service.protocol.ESLintLanguageServiceInitialState;
import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0014J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0002H\u0014J/\u0010\u001b\u001a\u0002H\u001c\"\u0004\b\u0000\u0010\u001c\"\b\b\u0001\u0010\u001d*\u00020\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u0002H\u001c\u0012\u0004\u0012\u0002H\u001d0 \u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020\u0017H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006#"}, d2={"Lcom/intellij/lang/javascript/linter/eslint/service/ESLintLanguageService;", "Lcom/intellij/lang/javascript/linter/eslint/service/ESLintBasedLanguageService;", "Lcom/intellij/lang/javascript/linter/eslint/EslintState;", "project", "Lcom/intellij/openapi/project/Project;", "nodePackage", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "workingDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/javascript/nodejs/util/NodePackage;Lcom/intellij/openapi/vfs/VirtualFile;)V", "inactivityTracker", "Lcom/intellij/lang/javascript/linter/ServiceInactivityTracker;", "fileLevelAnnotation", "Lcom/intellij/lang/javascript/linter/JSLinterFileLevelAnnotation;", "getFileLevelAnnotation", "()Lcom/intellij/lang/javascript/linter/JSLinterFileLevelAnnotation;", "setFileLevelAnnotation", "(Lcom/intellij/lang/javascript/linter/JSLinterFileLevelAnnotation;)V", "getConfigurationClass", "Ljava/lang/Class;", "Lcom/intellij/lang/javascript/linter/eslint/EslintConfiguration;", "fillInitialProtocolState", "", "protocolState", "Lcom/intellij/lang/javascript/linter/eslint/service/protocol/ESLintLanguageServiceInitialState;", "storedState", "useService", "T", "E", "", "computable", "Lcom/intellij/openapi/util/ThrowableComputable;", "(Lcom/intellij/openapi/util/ThrowableComputable;)Ljava/lang/Object;", "dispose", "intellij.javascript.backend"})
public final class ESLintLanguageService
extends ESLintBasedLanguageService<EslintState> {
    @NotNull
    private final ServiceInactivityTracker inactivityTracker;
    @Nullable
    private JSLinterFileLevelAnnotation fileLevelAnnotation;

    public ESLintLanguageService(@NotNull Project project, @NotNull NodePackage nodePackage, @NotNull VirtualFile workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)nodePackage, (String)"nodePackage");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        super(project, nodePackage, workingDirectory);
        EslintLanguageServiceManager eslintLanguageServiceManager = EslintLanguageServiceManager.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)eslintLanguageServiceManager, (String)"getInstance(...)");
        EslintLanguageServiceManager manager = eslintLanguageServiceManager;
        CoroutineScope coroutineScope = manager.getCoroutineScope();
        Intrinsics.checkNotNullExpressionValue((Object)coroutineScope, (String)"getCoroutineScope(...)");
        this.inactivityTracker = ServiceInactivityTracker.Companion.startTracking(coroutineScope, manager.getInactivityTimeoutMs(), (Function0<Unit>)((Function0)() -> ESLintLanguageService._init_$lambda$0(project, this)));
    }

    @Nullable
    public final JSLinterFileLevelAnnotation getFileLevelAnnotation() {
        return this.fileLevelAnnotation;
    }

    public final void setFileLevelAnnotation(@Nullable JSLinterFileLevelAnnotation jSLinterFileLevelAnnotation) {
        this.fileLevelAnnotation = jSLinterFileLevelAnnotation;
    }

    @Override
    @NotNull
    protected Class<EslintConfiguration> getConfigurationClass() {
        return EslintConfiguration.class;
    }

    @Override
    protected void fillInitialProtocolState(@NotNull ESLintLanguageServiceInitialState protocolState, @NotNull EslintState storedState) {
        Intrinsics.checkNotNullParameter((Object)protocolState, (String)"protocolState");
        Intrinsics.checkNotNullParameter((Object)storedState, (String)"storedState");
        super.fillInitialProtocolState(protocolState, (JSNpmLinterState)storedState);
        String string = storedState.getAdditionalRulesDirPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAdditionalRulesDirPath(...)");
        protocolState.additionalRootDirectory = LocalFilePath.Companion.createNotNull(string);
        protocolState.includeSourceText = Registry.Companion.is("eslint.language.service.full.log", false);
    }

    public final <T, E extends Throwable> T useService(@NotNull ThrowableComputable<T, E> computable) {
        Intrinsics.checkNotNullParameter(computable, (String)"computable");
        return (T)this.inactivityTracker.useService(() -> ESLintLanguageService.useService$lambda$0(computable));
    }

    @Override
    public void dispose() {
        this.inactivityTracker.stopTracking();
        super.dispose();
    }

    private static final Unit _init_$lambda$0(Project $project, ESLintLanguageService this$0) {
        EslintLanguageServiceManager.getInstance($project).terminateInactiveService((JSLanguageServiceBase)this$0);
        return Unit.INSTANCE;
    }

    private static final Object useService$lambda$0(ThrowableComputable $computable) {
        return $computable.compute();
    }
}

