/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.bitwise;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.util.ExpressionUtil;
import com.intellij.lang.javascript.psi.util.JSParenthesesUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.utils.ComparisonUtils;
import org.jetbrains.annotations.NotNull;

public final class IncompatibleMaskJSInspection
extends JavaScriptInspection {
    @Override
    @NotNull
    @InspectionMessage
    public String buildErrorString(Object ... args) {
        if (((JSBinaryExpression)args[0]).getOperationSign() == JSTokenTypes.EQEQ) {
            String string = InspectionJSBundle.message("incompatible.mask.operation.problem.descriptor.always.false", new Object[0]);
            if (string == null) {
                IncompatibleMaskJSInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionJSBundle.message("incompatible.mask.operation.problem.descriptor.always.true", new Object[0]);
        if (string == null) {
            IncompatibleMaskJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IncompatibleMaskVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/bitwise/IncompatibleMaskJSInspection", "buildErrorString"));
    }

    private static class IncompatibleMaskVisitor
    extends BaseInspectionVisitor {
        private IncompatibleMaskVisitor() {
        }

        public void visitJSBinaryExpression(@NotNull JSBinaryExpression expression) {
            if (expression == null) {
                IncompatibleMaskVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSBinaryExpression(expression);
            JSExpression rhs = expression.getROperand();
            if (!ComparisonUtils.isEqualityComparison(expression)) {
                return;
            }
            JSExpression strippedRhs = JSParenthesesUtils.stripParentheses((JSExpression)rhs);
            if (strippedRhs == null) {
                return;
            }
            JSExpression lhs = expression.getLOperand();
            JSExpression strippedLhs = JSParenthesesUtils.stripParentheses((JSExpression)lhs);
            if (strippedLhs == null) {
                return;
            }
            if (IncompatibleMaskVisitor.isConstantMask(strippedLhs) && ExpressionUtil.isConstantExpression((JSExpression)strippedRhs, (boolean)false)) {
                if (IncompatibleMaskVisitor.isIncompatibleMask((JSBinaryExpression)strippedLhs, strippedRhs)) {
                    this.registerError((PsiElement)expression, expression);
                }
            } else if (IncompatibleMaskVisitor.isConstantMask(strippedRhs) && ExpressionUtil.isConstantExpression((JSExpression)strippedLhs, (boolean)false) && IncompatibleMaskVisitor.isIncompatibleMask((JSBinaryExpression)strippedRhs, strippedLhs)) {
                this.registerError((PsiElement)expression, expression);
            }
        }

        private static boolean isIncompatibleMask(JSBinaryExpression maskExpression, JSExpression constantExpression) {
            int constantMaskValue;
            IElementType tokenType = maskExpression.getOperationSign();
            Object constantValue = ExpressionUtil.computeConstantExpression((JSExpression)constantExpression);
            if (!(constantValue instanceof Integer)) {
                return false;
            }
            int constantLongValue = (Integer)constantValue;
            JSExpression maskRhs = maskExpression.getROperand();
            JSExpression maskLhs = maskExpression.getLOperand();
            if (ExpressionUtil.isConstantExpression((JSExpression)maskRhs, (boolean)false)) {
                Object rhsValue = ExpressionUtil.computeConstantExpression((JSExpression)maskRhs);
                if (!(rhsValue instanceof Integer)) {
                    return false;
                }
                constantMaskValue = (Integer)rhsValue;
            } else {
                Object lhsValue = ExpressionUtil.computeConstantExpression((JSExpression)maskLhs);
                if (!(lhsValue instanceof Integer)) {
                    return false;
                }
                constantMaskValue = (Integer)lhsValue;
            }
            if (tokenType == JSTokenTypes.OR) {
                return (constantMaskValue | constantLongValue) != constantLongValue;
            }
            if (tokenType == JSTokenTypes.AND) {
                return (constantMaskValue | constantLongValue) != constantMaskValue;
            }
            return false;
        }

        private static boolean isConstantMask(JSExpression expression) {
            if (expression == null) {
                return false;
            }
            if (!(expression instanceof JSBinaryExpression)) {
                return false;
            }
            JSBinaryExpression binaryExpression = (JSBinaryExpression)expression;
            IElementType tokenType = binaryExpression.getOperationSign();
            if (tokenType != JSTokenTypes.OR && tokenType != JSTokenTypes.AND) {
                return false;
            }
            JSExpression rhs = binaryExpression.getROperand();
            if (ExpressionUtil.isConstantExpression((JSExpression)rhs, (boolean)false)) {
                return true;
            }
            JSExpression lhs = binaryExpression.getLOperand();
            return ExpressionUtil.isConstantExpression((JSExpression)lhs, (boolean)false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/sixrr/inspectjs/bitwise/IncompatibleMaskJSInspection$IncompatibleMaskVisitor", "visitJSBinaryExpression"));
        }
    }
}

