/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.ide.highlighter.EmbeddedTokenHighlighter;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.TypeScriptLanguageDialect;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.highlighting.TypeScriptHighlightDescriptor;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.MultiMap;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 \u00112\u00020\u0001:\u0003\u0010\u0011\u0012B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/lang/javascript/highlighting/TypeScriptHighlighter;", "Lcom/intellij/lang/javascript/highlighting/JSHighlighter;", "dialectOptionsHolder", "Lcom/intellij/lang/javascript/DialectOptionHolder;", "<init>", "(Lcom/intellij/lang/javascript/DialectOptionHolder;)V", "getTokenHighlights", "", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "(Lcom/intellij/psi/tree/IElementType;)[Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "getKeywords", "Lcom/intellij/psi/tree/TokenSet;", "getMappedKey", "original", "XmlTokenHighlighter", "Companion", "Keys", "intellij.javascript.psi.impl"})
public class TypeScriptHighlighter
extends JSHighlighter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_KEYWORD;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_STRING;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_NUMBER;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_REGEXP;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_LINE_COMMENT;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_BLOCK_COMMENT;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_DOC_COMMENT;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_OPERATION_SIGN;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_PARENTHS;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_BRACKETS;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_BRACES;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_COMMA;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_DOT;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_SEMICOLON;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_BAD_CHARACTER;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_DOC_TAG;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_DOC_TAG_NAMEPATH;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_DOC_TYPE;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_VALID_STRING_ESCAPE;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_INVALID_STRING_ESCAPE;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_LOCAL_VARIABLE;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_PARAMETER;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_TYPE_PARAMETER;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_INSTANCE_MEMBER_VARIABLE;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_STATIC_MEMBER_VARIABLE;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_ENUM_MEMBER;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_GLOBAL_VARIABLE;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_GLOBAL_FUNCTION;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_LOCAL_FUNCTION;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_DECORATOR;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_STATIC_MEMBER_FUNCTION;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_INSTANCE_MEMBER_FUNCTION;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_CLASS;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_INTERFACE;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_ENUM;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_TYPE_ALIAS;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_PRIMITIVE_TYPES;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_MODULE_NAME;
    @JvmField
    @NotNull
    public static final TextAttributesKey FUNCTION_ARROW;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_EXPORTED_VARIABLE;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_EXPORTED_FUNCTION;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_EXPORTED_CLASS;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_LABEL;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_TEMPLATE_LITERAL_PLACEHOLDER_DELIMITERS;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_INJECTED_LANGUAGE_FRAGMENT;
    @JvmField
    @NotNull
    public static final TextAttributesKey TS_TYPE_GUARD;

    public TypeScriptHighlighter(@NotNull DialectOptionHolder dialectOptionsHolder) {
        Intrinsics.checkNotNullParameter((Object)dialectOptionsHolder, (String)"dialectOptionsHolder");
        super(dialectOptionsHolder);
    }

    public /* synthetic */ TypeScriptHighlighter(DialectOptionHolder dialectOptionHolder, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            dialectOptionHolder = TypeScriptLanguageDialect.INSTANCE.getOptionHolder();
        }
        this(dialectOptionHolder);
    }

    @Override
    @NotNull
    public TextAttributesKey[] getTokenHighlights(@NotNull IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray;
        TextAttributesKey key;
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        if (tokenType == JSDocTokenTypes.DOC_TAG_NAME) {
            TextAttributesKey[] textAttributesKeyArray2 = SyntaxHighlighterBase.pack((TextAttributesKey)TS_DOC_COMMENT, (TextAttributesKey)TS_DOC_TAG);
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKeyArray2, (String)"pack(...)");
            return textAttributesKeyArray2;
        }
        TextAttributesKey textAttributesKey = key = Keys.INSTANCE.getTsKeys().get(tokenType);
        if (textAttributesKey == null) {
            textAttributesKeyArray = super.getTokenHighlights(tokenType);
        } else {
            TextAttributesKey[] textAttributesKeyArray3 = SyntaxHighlighterBase.pack((TextAttributesKey)textAttributesKey);
            textAttributesKeyArray = textAttributesKeyArray3;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKeyArray3, (String)"pack(...)");
        }
        return textAttributesKeyArray;
    }

    @Override
    @NotNull
    public TokenSet getKeywords() {
        TokenSet[] tokenSetArray = new TokenSet[]{super.getKeywords(), JSKeywordSets.TYPESCRIPT_RESERVED_WORDS};
        TokenSet tokenSet = TokenSet.orSet((TokenSet[])tokenSetArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"orSet(...)");
        return tokenSet;
    }

    @Override
    @NotNull
    public TextAttributesKey getMappedKey(@NotNull TextAttributesKey original) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        return Keys.INSTANCE.getOurJsToTSKeyMap().getOrDefault(original, original);
    }

    public TypeScriptHighlighter() {
        this(null, 1, null);
    }

    static {
        TextAttributesKey textAttributesKey = TextAttributesKey.createTextAttributesKey((String)"TS.KEYWORD", (TextAttributesKey)JSHighlighter.JS_KEYWORD);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"createTextAttributesKey(...)");
        TS_KEYWORD = textAttributesKey;
        TextAttributesKey textAttributesKey2 = TextAttributesKey.createTextAttributesKey((String)"TS.STRING", (TextAttributesKey)JSHighlighter.JS_STRING);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey2, (String)"createTextAttributesKey(...)");
        TS_STRING = textAttributesKey2;
        TextAttributesKey textAttributesKey3 = TextAttributesKey.createTextAttributesKey((String)"TS.NUMBER", (TextAttributesKey)JSHighlighter.JS_NUMBER);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey3, (String)"createTextAttributesKey(...)");
        TS_NUMBER = textAttributesKey3;
        TextAttributesKey textAttributesKey4 = TextAttributesKey.createTextAttributesKey((String)"TS.REGEXP", (TextAttributesKey)JSHighlighter.JS_REGEXP);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey4, (String)"createTextAttributesKey(...)");
        TS_REGEXP = textAttributesKey4;
        TextAttributesKey textAttributesKey5 = TextAttributesKey.createTextAttributesKey((String)"TS.LINE_COMMENT", (TextAttributesKey)JSHighlighter.JS_LINE_COMMENT);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey5, (String)"createTextAttributesKey(...)");
        TS_LINE_COMMENT = textAttributesKey5;
        TextAttributesKey textAttributesKey6 = TextAttributesKey.createTextAttributesKey((String)"TS.BLOCK_COMMENT", (TextAttributesKey)JSHighlighter.JS_BLOCK_COMMENT);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey6, (String)"createTextAttributesKey(...)");
        TS_BLOCK_COMMENT = textAttributesKey6;
        TextAttributesKey textAttributesKey7 = TextAttributesKey.createTextAttributesKey((String)"TS.DOC_COMMENT", (TextAttributesKey)JSHighlighter.JS_DOC_COMMENT);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey7, (String)"createTextAttributesKey(...)");
        TS_DOC_COMMENT = textAttributesKey7;
        TextAttributesKey textAttributesKey8 = TextAttributesKey.createTextAttributesKey((String)"TS.OPERATION_SIGN", (TextAttributesKey)JSHighlighter.JS_OPERATION_SIGN);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey8, (String)"createTextAttributesKey(...)");
        TS_OPERATION_SIGN = textAttributesKey8;
        TextAttributesKey textAttributesKey9 = TextAttributesKey.createTextAttributesKey((String)"TS.PARENTHS", (TextAttributesKey)JSHighlighter.JS_PARENTHS);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey9, (String)"createTextAttributesKey(...)");
        TS_PARENTHS = textAttributesKey9;
        TextAttributesKey textAttributesKey10 = TextAttributesKey.createTextAttributesKey((String)"TS.BRACKETS", (TextAttributesKey)JSHighlighter.JS_BRACKETS);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey10, (String)"createTextAttributesKey(...)");
        TS_BRACKETS = textAttributesKey10;
        TextAttributesKey textAttributesKey11 = TextAttributesKey.createTextAttributesKey((String)"TS.BRACES", (TextAttributesKey)JSHighlighter.JS_BRACES);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey11, (String)"createTextAttributesKey(...)");
        TS_BRACES = textAttributesKey11;
        TextAttributesKey textAttributesKey12 = TextAttributesKey.createTextAttributesKey((String)"TS.COMMA", (TextAttributesKey)JSHighlighter.JS_COMMA);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey12, (String)"createTextAttributesKey(...)");
        TS_COMMA = textAttributesKey12;
        TextAttributesKey textAttributesKey13 = TextAttributesKey.createTextAttributesKey((String)"TS.DOT", (TextAttributesKey)JSHighlighter.JS_DOT);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey13, (String)"createTextAttributesKey(...)");
        TS_DOT = textAttributesKey13;
        TextAttributesKey textAttributesKey14 = TextAttributesKey.createTextAttributesKey((String)"TS.SEMICOLON", (TextAttributesKey)JSHighlighter.JS_SEMICOLON);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey14, (String)"createTextAttributesKey(...)");
        TS_SEMICOLON = textAttributesKey14;
        TextAttributesKey textAttributesKey15 = TextAttributesKey.createTextAttributesKey((String)"TS.BADCHARACTER", (TextAttributesKey)JSHighlighter.JS_BAD_CHARACTER);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey15, (String)"createTextAttributesKey(...)");
        TS_BAD_CHARACTER = textAttributesKey15;
        TextAttributesKey textAttributesKey16 = TextAttributesKey.createTextAttributesKey((String)"TS.DOC_TAG", (TextAttributesKey)JSHighlighter.JS_DOC_TAG);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey16, (String)"createTextAttributesKey(...)");
        TS_DOC_TAG = textAttributesKey16;
        TextAttributesKey textAttributesKey17 = TextAttributesKey.createTextAttributesKey((String)"TS.DOC_TAG_NAMEPATH", (TextAttributesKey)JSHighlighter.JS_DOC_TAG_NAMEPATH);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey17, (String)"createTextAttributesKey(...)");
        TS_DOC_TAG_NAMEPATH = textAttributesKey17;
        TextAttributesKey textAttributesKey18 = TextAttributesKey.createTextAttributesKey((String)"TS.DOC_TYPE", (TextAttributesKey)TS_DOC_TAG_NAMEPATH);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey18, (String)"createTextAttributesKey(...)");
        TS_DOC_TYPE = textAttributesKey18;
        TextAttributesKey textAttributesKey19 = TextAttributesKey.createTextAttributesKey((String)"TS.VALID_STRING_ESCAPE", (TextAttributesKey)JSHighlighter.JS_VALID_STRING_ESCAPE);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey19, (String)"createTextAttributesKey(...)");
        TS_VALID_STRING_ESCAPE = textAttributesKey19;
        TextAttributesKey textAttributesKey20 = TextAttributesKey.createTextAttributesKey((String)"TS.INVALID_STRING_ESCAPE", (TextAttributesKey)JSHighlighter.JS_INVALID_STRING_ESCAPE);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey20, (String)"createTextAttributesKey(...)");
        TS_INVALID_STRING_ESCAPE = textAttributesKey20;
        TextAttributesKey textAttributesKey21 = TextAttributesKey.createTextAttributesKey((String)"TS.LOCAL_VARIABLE", (TextAttributesKey)JSHighlighter.JS_LOCAL_VARIABLE);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey21, (String)"createTextAttributesKey(...)");
        TS_LOCAL_VARIABLE = textAttributesKey21;
        TextAttributesKey textAttributesKey22 = TextAttributesKey.createTextAttributesKey((String)"TS.PARAMETER", (TextAttributesKey)JSHighlighter.JS_PARAMETER);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey22, (String)"createTextAttributesKey(...)");
        TS_PARAMETER = textAttributesKey22;
        TS_TYPE_PARAMETER = TypeScriptHighlightDescriptor.TYPE_PARAMETER.getOrCreateTextAttributesKey();
        TextAttributesKey textAttributesKey23 = TextAttributesKey.createTextAttributesKey((String)"TS.INSTANCE_MEMBER_VARIABLE", (TextAttributesKey)JSHighlighter.JS_INSTANCE_MEMBER_VARIABLE);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey23, (String)"createTextAttributesKey(...)");
        TS_INSTANCE_MEMBER_VARIABLE = textAttributesKey23;
        TextAttributesKey textAttributesKey24 = TextAttributesKey.createTextAttributesKey((String)"TS.STATIC_MEMBER_VARIABLE", (TextAttributesKey)JSHighlighter.JS_STATIC_MEMBER_VARIABLE);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey24, (String)"createTextAttributesKey(...)");
        TS_STATIC_MEMBER_VARIABLE = textAttributesKey24;
        TS_ENUM_MEMBER = TypeScriptHighlightDescriptor.ENUM_MEMBER.getOrCreateTextAttributesKey();
        TextAttributesKey textAttributesKey25 = TextAttributesKey.createTextAttributesKey((String)"TS.GLOBAL_VARIABLE", (TextAttributesKey)JSHighlighter.JS_GLOBAL_VARIABLE);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey25, (String)"createTextAttributesKey(...)");
        TS_GLOBAL_VARIABLE = textAttributesKey25;
        TextAttributesKey textAttributesKey26 = TextAttributesKey.createTextAttributesKey((String)"TS.GLOBAL_FUNCTION", (TextAttributesKey)JSHighlighter.JS_GLOBAL_FUNCTION);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey26, (String)"createTextAttributesKey(...)");
        TS_GLOBAL_FUNCTION = textAttributesKey26;
        TextAttributesKey textAttributesKey27 = TextAttributesKey.createTextAttributesKey((String)"TS.LOCAL_FUNCTION", (TextAttributesKey)JSHighlighter.JS_LOCAL_FUNCTION);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey27, (String)"createTextAttributesKey(...)");
        TS_LOCAL_FUNCTION = textAttributesKey27;
        TextAttributesKey textAttributesKey28 = TextAttributesKey.createTextAttributesKey((String)"TS.DECORATOR", (TextAttributesKey)JSHighlighter.ES6_DECORATOR);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey28, (String)"createTextAttributesKey(...)");
        TS_DECORATOR = textAttributesKey28;
        TextAttributesKey textAttributesKey29 = TextAttributesKey.createTextAttributesKey((String)"TS.STATIC_MEMBER_FUNCTION", (TextAttributesKey)JSHighlighter.JS_STATIC_MEMBER_FUNCTION);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey29, (String)"createTextAttributesKey(...)");
        TS_STATIC_MEMBER_FUNCTION = textAttributesKey29;
        TextAttributesKey textAttributesKey30 = TextAttributesKey.createTextAttributesKey((String)"TS.INSTANCE_MEMBER_FUNCTION", (TextAttributesKey)JSHighlighter.JS_INSTANCE_MEMBER_FUNCTION);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey30, (String)"createTextAttributesKey(...)");
        TS_INSTANCE_MEMBER_FUNCTION = textAttributesKey30;
        TextAttributesKey textAttributesKey31 = TextAttributesKey.createTextAttributesKey((String)"TS.CLASS", (TextAttributesKey)JSHighlighter.JS_CLASS);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey31, (String)"createTextAttributesKey(...)");
        TS_CLASS = textAttributesKey31;
        TextAttributesKey textAttributesKey32 = TextAttributesKey.createTextAttributesKey((String)"TS.INTERFACE", (TextAttributesKey)DefaultLanguageHighlighterColors.INTERFACE_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey32, (String)"createTextAttributesKey(...)");
        TS_INTERFACE = textAttributesKey32;
        TS_ENUM = TypeScriptHighlightDescriptor.ENUM.getOrCreateTextAttributesKey();
        TextAttributesKey textAttributesKey33 = TextAttributesKey.createTextAttributesKey((String)"TS.TYPE.ALIAS", (TextAttributesKey)TS_INTERFACE);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey33, (String)"createTextAttributesKey(...)");
        TS_TYPE_ALIAS = textAttributesKey33;
        TextAttributesKey textAttributesKey34 = TextAttributesKey.createTextAttributesKey((String)"TS.PRIMITIVE.TYPES", (TextAttributesKey)TS_KEYWORD);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey34, (String)"createTextAttributesKey(...)");
        TS_PRIMITIVE_TYPES = textAttributesKey34;
        TS_MODULE_NAME = TypeScriptHighlightDescriptor.MODULE_NAME.getOrCreateTextAttributesKey();
        TextAttributesKey textAttributesKey35 = TextAttributesKey.createTextAttributesKey((String)"TS.FUNCTION_ARROW", (TextAttributesKey)JSHighlighter.FUNCTION_ARROW);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey35, (String)"createTextAttributesKey(...)");
        FUNCTION_ARROW = textAttributesKey35;
        TextAttributesKey textAttributesKey36 = TextAttributesKey.createTextAttributesKey((String)"TS.EXPORTED_VARIABLE", (TextAttributesKey)TS_GLOBAL_VARIABLE);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey36, (String)"createTextAttributesKey(...)");
        TS_EXPORTED_VARIABLE = textAttributesKey36;
        TextAttributesKey textAttributesKey37 = TextAttributesKey.createTextAttributesKey((String)"TS.EXPORTED_FUNCTION", (TextAttributesKey)TS_GLOBAL_FUNCTION);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey37, (String)"createTextAttributesKey(...)");
        TS_EXPORTED_FUNCTION = textAttributesKey37;
        TextAttributesKey textAttributesKey38 = TextAttributesKey.createTextAttributesKey((String)"TS.EXPORTED_CLASS", (TextAttributesKey)TS_CLASS);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey38, (String)"createTextAttributesKey(...)");
        TS_EXPORTED_CLASS = textAttributesKey38;
        TextAttributesKey textAttributesKey39 = TextAttributesKey.createTextAttributesKey((String)"TS.LABEL", (TextAttributesKey)JSHighlighter.JS_LABEL);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey39, (String)"createTextAttributesKey(...)");
        TS_LABEL = textAttributesKey39;
        TextAttributesKey textAttributesKey40 = TextAttributesKey.createTextAttributesKey((String)"TS.TEMPLATE_LITERAL_PLACEHOLDER_DELIMITERS", (TextAttributesKey)JSHighlighter.JS_TEMPLATE_LITERAL_PLACEHOLDER_DELIMITERS);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey40, (String)"createTextAttributesKey(...)");
        TS_TEMPLATE_LITERAL_PLACEHOLDER_DELIMITERS = textAttributesKey40;
        TextAttributesKey textAttributesKey41 = EditorColors.createInjectedLanguageFragmentKey((Language)JavaScriptSupportLoader.TYPESCRIPT);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey41, (String)"createInjectedLanguageFragmentKey(...)");
        TS_INJECTED_LANGUAGE_FRAGMENT = textAttributesKey41;
        TextAttributesKey textAttributesKey42 = TextAttributesKey.createTextAttributesKey((String)"TS.TYPE_GUARD");
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey42, (String)"createTextAttributesKey(...)");
        TS_TYPE_GUARD = textAttributesKey42;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b.\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00102\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/lang/javascript/highlighting/TypeScriptHighlighter$Companion;", "", "<init>", "()V", "TS_KEYWORD", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "TS_STRING", "TS_NUMBER", "TS_REGEXP", "TS_LINE_COMMENT", "TS_BLOCK_COMMENT", "TS_DOC_COMMENT", "TS_OPERATION_SIGN", "TS_PARENTHS", "TS_BRACKETS", "TS_BRACES", "TS_COMMA", "TS_DOT", "TS_SEMICOLON", "TS_BAD_CHARACTER", "TS_DOC_TAG", "TS_DOC_TAG_NAMEPATH", "TS_DOC_TYPE", "TS_VALID_STRING_ESCAPE", "TS_INVALID_STRING_ESCAPE", "TS_LOCAL_VARIABLE", "TS_PARAMETER", "TS_TYPE_PARAMETER", "TS_INSTANCE_MEMBER_VARIABLE", "TS_STATIC_MEMBER_VARIABLE", "TS_ENUM_MEMBER", "TS_GLOBAL_VARIABLE", "TS_GLOBAL_FUNCTION", "TS_LOCAL_FUNCTION", "TS_DECORATOR", "TS_STATIC_MEMBER_FUNCTION", "TS_INSTANCE_MEMBER_FUNCTION", "TS_CLASS", "TS_INTERFACE", "TS_ENUM", "TS_TYPE_ALIAS", "TS_PRIMITIVE_TYPES", "TS_MODULE_NAME", "FUNCTION_ARROW", "TS_EXPORTED_VARIABLE", "TS_EXPORTED_FUNCTION", "TS_EXPORTED_CLASS", "TS_LABEL", "TS_TEMPLATE_LITERAL_PLACEHOLDER_DELIMITERS", "TS_INJECTED_LANGUAGE_FRAGMENT", "TS_TYPE_GUARD", "intellij.javascript.psi.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/intellij/lang/javascript/highlighting/TypeScriptHighlighter$Keys;", "", "<init>", "()V", "tsKeys", "", "Lcom/intellij/psi/tree/IElementType;", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "getTsKeys", "()Ljava/util/Map;", "ourJsToTSKeyMap", "getOurJsToTSKeyMap", "intellij.javascript.psi.impl"})
    private static final class Keys {
        @NotNull
        public static final Keys INSTANCE = new Keys();
        @NotNull
        private static final Map<IElementType, TextAttributesKey> tsKeys = new HashMap();
        @NotNull
        private static final Map<TextAttributesKey, TextAttributesKey> ourJsToTSKeyMap = new HashMap();

        private Keys() {
        }

        @NotNull
        public final Map<IElementType, TextAttributesKey> getTsKeys() {
            return tsKeys;
        }

        @NotNull
        public final Map<TextAttributesKey, TextAttributesKey> getOurJsToTSKeyMap() {
            return ourJsToTSKeyMap;
        }

        static {
            SyntaxHighlighterBase.fillMap(tsKeys, (TokenSet)JSHighlighter.getOPERATORS_LIKE(), (TextAttributesKey)TS_OPERATION_SIGN);
            SyntaxHighlighterBase.fillMap(tsKeys, (TokenSet)JSKeywordSets.TYPESCRIPT_RESERVED_WORDS, (TextAttributesKey)TS_KEYWORD);
            tsKeys.put(StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN, TS_VALID_STRING_ESCAPE);
            tsKeys.put(StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN, TS_INVALID_STRING_ESCAPE);
            tsKeys.put(StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN, TS_INVALID_STRING_ESCAPE);
            tsKeys.put(JSTokenTypes.NUMERIC_LITERAL, TS_NUMBER);
            tsKeys.put(JSTokenTypes.STRING_LITERAL, TS_STRING);
            tsKeys.put(JSTokenTypes.SINGLE_QUOTE_STRING_LITERAL, TS_STRING);
            tsKeys.put(JSTokenTypes.STRING_TEMPLATE_PART, TS_STRING);
            tsKeys.put(JSTokenTypes.BACKQUOTE, TS_STRING);
            tsKeys.put(JSTokenTypes.REGEXP_LITERAL, TS_REGEXP);
            tsKeys.put(JSTokenTypes.LPAR, TS_PARENTHS);
            tsKeys.put(JSTokenTypes.RPAR, TS_PARENTHS);
            tsKeys.put(JSTokenTypes.LBRACE, TS_BRACES);
            tsKeys.put(JSTokenTypes.RBRACE, TS_BRACES);
            tsKeys.put(JSTokenTypes.XML_LBRACE, TS_BRACES);
            tsKeys.put(JSTokenTypes.XML_RBRACE, TS_BRACES);
            tsKeys.put(JSTokenTypes.LBRACKET, TS_BRACKETS);
            tsKeys.put(JSTokenTypes.RBRACKET, TS_BRACKETS);
            tsKeys.put(JSTokenTypes.COMMA, TS_COMMA);
            tsKeys.put(JSTokenTypes.DOT, TS_DOT);
            tsKeys.put(JSTokenTypes.SEMICOLON, TS_SEMICOLON);
            tsKeys.put(JSTokenTypes.C_STYLE_COMMENT, TS_BLOCK_COMMENT);
            tsKeys.put(JSTokenTypes.XML_STYLE_COMMENT, TS_BLOCK_COMMENT);
            tsKeys.put(JSElementTypes.DOC_COMMENT, TS_DOC_COMMENT);
            tsKeys.put(JSTokenTypes.END_OF_LINE_COMMENT, TS_LINE_COMMENT);
            tsKeys.put(JSTokenTypes.BAD_CHARACTER, TS_BAD_CHARACTER);
            tsKeys.put(JSTokenTypes.EQGT, FUNCTION_ARROW);
            for (IElementType type : JSDocTokenTypes.INSTANCE.enumerateJSDocElementTypes()) {
                tsKeys.put(type, TS_DOC_COMMENT);
            }
            tsKeys.put(JSDocTokenTypes.DOC_DESCRIPTION, TS_DOC_COMMENT);
            tsKeys.put(JSDocTokenTypes.DOC_TAG_TYPE, TS_DOC_COMMENT);
            tsKeys.put(JSDocTokenTypes.DOC_TAG_NAMEPATH, TS_DOC_COMMENT);
            ourJsToTSKeyMap.put(JSHighlighter.JS_PARAMETER, TS_PARAMETER);
            ourJsToTSKeyMap.put(JSHighlighter.JS_INSTANCE_MEMBER_VARIABLE, TS_INSTANCE_MEMBER_VARIABLE);
            ourJsToTSKeyMap.put(JSHighlighter.JS_LOCAL_VARIABLE, TS_LOCAL_VARIABLE);
            ourJsToTSKeyMap.put(JSHighlighter.JS_GLOBAL_VARIABLE, TS_GLOBAL_VARIABLE);
            ourJsToTSKeyMap.put(JSHighlighter.JS_GLOBAL_FUNCTION, TS_GLOBAL_FUNCTION);
            ourJsToTSKeyMap.put(JSHighlighter.JS_LOCAL_FUNCTION, TS_LOCAL_FUNCTION);
            ourJsToTSKeyMap.put(JSHighlighter.ES6_DECORATOR, TS_DECORATOR);
            ourJsToTSKeyMap.put(JSHighlighter.JS_INSTANCE_MEMBER_FUNCTION, TS_INSTANCE_MEMBER_FUNCTION);
            ourJsToTSKeyMap.put(JSHighlighter.JS_STATIC_MEMBER_FUNCTION, TS_STATIC_MEMBER_FUNCTION);
            ourJsToTSKeyMap.put(JSHighlighter.JS_STATIC_MEMBER_VARIABLE, TS_STATIC_MEMBER_VARIABLE);
            ourJsToTSKeyMap.put(JSHighlighter.JS_CLASS, TS_CLASS);
            ourJsToTSKeyMap.put(JSHighlighter.JS_INTERFACE, TS_INTERFACE);
            ourJsToTSKeyMap.put(JSHighlighter.JS_TYPE_ALIAS, TS_TYPE_ALIAS);
            ourJsToTSKeyMap.put(JSHighlighter.JS_DOC_COMMENT, TS_DOC_COMMENT);
            ourJsToTSKeyMap.put(JSHighlighter.JS_TEMPLATE_LITERAL_PLACEHOLDER_DELIMITERS, TS_TEMPLATE_LITERAL_PLACEHOLDER_DELIMITERS);
            ourJsToTSKeyMap.put(JSHighlighter.JS_EXPORTED_VARIABLE, TS_EXPORTED_VARIABLE);
            ourJsToTSKeyMap.put(JSHighlighter.JS_EXPORTED_FUNCTION, TS_EXPORTED_FUNCTION);
            ourJsToTSKeyMap.put(JSHighlighter.JS_EXPORTED_CLASS, TS_EXPORTED_CLASS);
            ourJsToTSKeyMap.put(JSHighlighter.JS_LABEL, TS_LABEL);
            ourJsToTSKeyMap.put(JSHighlighter.JS_KEYWORD, TS_KEYWORD);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/lang/javascript/highlighting/TypeScriptHighlighter$XmlTokenHighlighter;", "Lcom/intellij/ide/highlighter/EmbeddedTokenHighlighter;", "<init>", "()V", "getEmbeddedTokenAttributes", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/psi/tree/IElementType;", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "intellij.javascript.psi.impl"})
    public static final class XmlTokenHighlighter
    implements EmbeddedTokenHighlighter {
        @NotNull
        public MultiMap<IElementType, TextAttributesKey> getEmbeddedTokenAttributes() {
            MultiMap multiMap = MultiMap.create();
            Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"create(...)");
            MultiMap map = multiMap;
            map.putAllValues(Keys.INSTANCE.getTsKeys());
            return map;
        }
    }
}

