/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.execution;

import com.google.common.collect.ImmutableList;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.javascript.karma.scope.KarmaScopeKind;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ComparatorUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaRunSettings {
    private final String myConfigPath;
    private final NodePackage myKarmaPackage;
    private final String myKarmaOptions;
    private final NodeJsInterpreterRef myInterpreterRef;
    private final String myNodeOptions;
    private final String myWorkingDirectory;
    private final EnvironmentVariablesData myEnvData;
    private final KarmaScopeKind myScopeKind;
    private final String myTestFilePath;
    private final List<String> myTestNames;

    public KarmaRunSettings(@NotNull Builder builder) {
        if (builder == null) {
            KarmaRunSettings.$$$reportNull$$$0(0);
        }
        this.myConfigPath = FileUtil.toSystemDependentName((String)builder.myConfigPath);
        this.myKarmaPackage = builder.myKarmaPackage;
        this.myKarmaOptions = builder.myKarmaOptions;
        this.myInterpreterRef = builder.myInterpreterRef;
        this.myNodeOptions = builder.myNodeOptions;
        this.myWorkingDirectory = FileUtil.toSystemDependentName((String)builder.myWorkingDirectory);
        this.myEnvData = builder.myEnvData;
        this.myScopeKind = builder.myScopeKind;
        this.myTestFilePath = FileUtil.toSystemDependentName((String)builder.myTestFilePath);
        this.myTestNames = ImmutableList.copyOf(builder.myTestNames);
    }

    @NotNull
    public String getConfigPathSystemDependent() {
        String string = this.myConfigPath;
        if (string == null) {
            KarmaRunSettings.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getConfigPathSystemIndependent() {
        String string = FileUtil.toSystemIndependentName((String)this.myConfigPath);
        if (string == null) {
            KarmaRunSettings.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public NodePackage getKarmaPackage() {
        return this.myKarmaPackage;
    }

    @NotNull
    public String getKarmaOptions() {
        String string = this.myKarmaOptions;
        if (string == null) {
            KarmaRunSettings.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public NodeJsInterpreterRef getInterpreterRef() {
        NodeJsInterpreterRef nodeJsInterpreterRef = this.myInterpreterRef;
        if (nodeJsInterpreterRef == null) {
            KarmaRunSettings.$$$reportNull$$$0(4);
        }
        return nodeJsInterpreterRef;
    }

    @NotNull
    public String getNodeOptions() {
        String string = this.myNodeOptions;
        if (string == null) {
            KarmaRunSettings.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getWorkingDirectorySystemDependent() {
        String string = this.myWorkingDirectory;
        if (string == null) {
            KarmaRunSettings.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getWorkingDirectorySystemIndependent() {
        String string = FileUtil.toSystemIndependentName((String)this.myWorkingDirectory);
        if (string == null) {
            KarmaRunSettings.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public EnvironmentVariablesData getEnvData() {
        EnvironmentVariablesData environmentVariablesData = this.myEnvData;
        if (environmentVariablesData == null) {
            KarmaRunSettings.$$$reportNull$$$0(8);
        }
        return environmentVariablesData;
    }

    @NotNull
    public KarmaScopeKind getScopeKind() {
        KarmaScopeKind karmaScopeKind = this.myScopeKind;
        if (karmaScopeKind == null) {
            KarmaRunSettings.$$$reportNull$$$0(9);
        }
        return karmaScopeKind;
    }

    @NotNull
    public String getTestFileSystemDependentPath() {
        String string = this.myTestFilePath;
        if (string == null) {
            KarmaRunSettings.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public String getTestFileSystemIndependentPath() {
        String string = FileUtil.toSystemIndependentName((String)this.myTestFilePath);
        if (string == null) {
            KarmaRunSettings.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public List<String> getTestNames() {
        List<String> list = this.myTestNames;
        if (list == null) {
            KarmaRunSettings.$$$reportNull$$$0(12);
        }
        return list;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KarmaRunSettings that = (KarmaRunSettings)o;
        return this.myConfigPath.equals(that.myConfigPath) && ComparatorUtil.equalsNullable((Object)this.myKarmaPackage, (Object)that.myKarmaPackage) && this.myKarmaOptions.equals(that.myKarmaOptions) && this.myInterpreterRef.getReferenceName().equals(that.myInterpreterRef.getReferenceName()) && this.myNodeOptions.equals(that.myNodeOptions) && this.myWorkingDirectory.equals(that.myWorkingDirectory) && this.myEnvData.equals((Object)that.myEnvData) && this.myScopeKind.equals((Object)that.myScopeKind) && this.myTestFilePath.equals(that.myTestFilePath) && this.myTestNames.equals(that.myTestNames);
    }

    public int hashCode() {
        int result = this.myConfigPath.hashCode();
        result = 31 * result + (this.myKarmaPackage != null ? this.myKarmaPackage.hashCode() : 0);
        result = 31 * result + this.myKarmaOptions.hashCode();
        result = 31 * result + this.myInterpreterRef.getReferenceName().hashCode();
        result = 31 * result + this.myNodeOptions.hashCode();
        result = 31 * result + this.myWorkingDirectory.hashCode();
        result = 31 * result + this.myEnvData.hashCode();
        result = 31 * result + this.myScopeKind.hashCode();
        result = 31 * result + this.myTestFilePath.hashCode();
        result = 31 * result + this.myTestNames.hashCode();
        return result;
    }

    @NotNull
    public Builder toBuilder() {
        return new Builder(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/karma/execution/KarmaRunSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/karma/execution/KarmaRunSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigPathSystemDependent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigPathSystemIndependent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKarmaOptions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterRef";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeOptions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectorySystemDependent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectorySystemIndependent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvData";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeKind";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestFileSystemDependentPath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestFileSystemIndependentPath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }

    public static class Builder {
        private String myConfigPath;
        private NodePackage myKarmaPackage;
        private String myKarmaOptions;
        private NodeJsInterpreterRef myInterpreterRef;
        private String myNodeOptions;
        private EnvironmentVariablesData myEnvData;
        private KarmaScopeKind myScopeKind;
        private String myTestFilePath;
        private List<String> myTestNames;
        private String myWorkingDirectory;

        public Builder() {
            this.myConfigPath = "";
            this.myKarmaPackage = null;
            this.myKarmaOptions = "";
            this.myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            this.myNodeOptions = "";
            this.myEnvData = EnvironmentVariablesData.DEFAULT;
            this.myScopeKind = KarmaScopeKind.ALL;
            this.myTestFilePath = "";
            this.myTestNames = Collections.emptyList();
            this.myWorkingDirectory = "";
        }

        public Builder(@NotNull KarmaRunSettings settings) {
            if (settings == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myConfigPath = "";
            this.myKarmaPackage = null;
            this.myKarmaOptions = "";
            this.myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            this.myNodeOptions = "";
            this.myEnvData = EnvironmentVariablesData.DEFAULT;
            this.myScopeKind = KarmaScopeKind.ALL;
            this.myTestFilePath = "";
            this.myTestNames = Collections.emptyList();
            this.myWorkingDirectory = "";
            this.myConfigPath = settings.getConfigPathSystemDependent();
            this.myKarmaPackage = settings.myKarmaPackage;
            this.myKarmaOptions = settings.myKarmaOptions;
            this.myInterpreterRef = settings.getInterpreterRef();
            this.myNodeOptions = settings.myNodeOptions;
            this.myWorkingDirectory = settings.myWorkingDirectory;
            this.myEnvData = settings.myEnvData;
            this.myScopeKind = settings.myScopeKind;
            this.myTestFilePath = settings.myTestFilePath;
            this.myTestNames = settings.myTestNames;
        }

        @NotNull
        public Builder setConfigPath(@Nullable String configPath) {
            this.myConfigPath = StringUtil.notNullize((String)configPath);
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder;
        }

        @NotNull
        public Builder setKarmaPackage(@Nullable NodePackage karmaPackage) {
            this.myKarmaPackage = karmaPackage;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder;
        }

        @NotNull
        public Builder setKarmaOptions(@Nullable String karmaOptions) {
            this.myKarmaOptions = StringUtil.notNullize((String)karmaOptions);
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder;
        }

        @NotNull
        public Builder setInterpreterRef(@NotNull NodeJsInterpreterRef interpreterRef) {
            if (interpreterRef == null) {
                Builder.$$$reportNull$$$0(4);
            }
            this.myInterpreterRef = interpreterRef;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return builder;
        }

        @NotNull
        public Builder setNodeOptions(@NotNull String nodeOptions) {
            if (nodeOptions == null) {
                Builder.$$$reportNull$$$0(6);
            }
            this.myNodeOptions = nodeOptions;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return builder;
        }

        @NotNull
        public Builder setWorkingDirectory(@Nullable String workingDirectory) {
            this.myWorkingDirectory = StringUtil.notNullize((String)workingDirectory);
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(8);
            }
            return builder;
        }

        @NotNull
        public Builder setEnvData(@NotNull EnvironmentVariablesData envData) {
            if (envData == null) {
                Builder.$$$reportNull$$$0(9);
            }
            this.myEnvData = envData;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(10);
            }
            return builder;
        }

        @NotNull
        public Builder setScopeKind(@NotNull KarmaScopeKind scopeKind) {
            if (scopeKind == null) {
                Builder.$$$reportNull$$$0(11);
            }
            this.myScopeKind = scopeKind;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(12);
            }
            return builder;
        }

        @NotNull
        public Builder setTestFilePath(@Nullable String testFilePath) {
            this.myTestFilePath = StringUtil.notNullize((String)testFilePath);
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(13);
            }
            return builder;
        }

        @NotNull
        public Builder setTestNames(@NotNull List<String> testNames) {
            if (testNames == null) {
                Builder.$$$reportNull$$$0(14);
            }
            this.myTestNames = testNames;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(15);
            }
            return builder;
        }

        @NotNull
        public KarmaRunSettings build() {
            return new KarmaRunSettings(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 5, 7, 8, 10, 12, 13, 15 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 10: 
                case 12: 
                case 13: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/karma/execution/KarmaRunSettings$Builder";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interpreterRef";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodeOptions";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "envData";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scopeKind";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "testNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/karma/execution/KarmaRunSettings$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setConfigPath";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setKarmaPackage";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setKarmaOptions";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setInterpreterRef";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setNodeOptions";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setWorkingDirectory";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setEnvData";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setScopeKind";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setTestFilePath";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setTestNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 10: 
                case 12: 
                case 13: 
                case 15: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setInterpreterRef";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setNodeOptions";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "setEnvData";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "setScopeKind";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "setTestNames";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 5, 7, 8, 10, 12, 13, 15 -> new IllegalStateException(string);
            };
        }
    }
}

