/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.dialects.BaseDatabaseErrorHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThreeState;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OraErrorHandler
extends BaseDatabaseErrorHandler {
    @RegExp
    private static final String LINE_COLUMN_PATTERN = "(ORA-\\d+: line|Line:) (\\d+), column:? (\\d+)";
    @RegExp
    private static final String OFFSET_PATTERN = "(Error : \\d+, Position :|Position:) (\\d+)";
    private static final String DATABASE_EXCEPTION = "oracle.jdbc.OracleDatabaseException";

    @NotNull
    protected ErrorInfo getErrorInfo(@NotNull Project project, @Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
        if (project == null) {
            OraErrorHandler.$$$reportNull$$$0(0);
        }
        if (original == null) {
            OraErrorHandler.$$$reportNull$$$0(1);
        }
        if (cause == null) {
            OraErrorHandler.$$$reportNull$$$0(2);
        }
        if (this.isPasswordExpired(cause)) {
            return new BaseDatabaseErrorHandler.PasswordExpiredErrorInfo(dataSource, original, cause);
        }
        if (OraErrorHandler.getErrorCode((Throwable)cause) == 28002) {
            return new BaseDatabaseErrorHandler.PasswordIsAboutExpireErrorInfo(dataSource, original, cause);
        }
        if (OraErrorHandler.isMissingOci(cause)) {
            return new OraMissingOCIErrorInfo(dataSource, original, cause);
        }
        if (OraErrorHandler.isNlsProblem(cause)) {
            return new OraNlsProblemErrorInfo(this, dataSource, original, cause, project);
        }
        @Nullable String originalMsg = original.getMessage();
        Pattern lineColumnPattern = Pattern.compile(LINE_COLUMN_PATTERN);
        Pattern offsetPattern = Pattern.compile(OFFSET_PATTERN);
        if (originalMsg != null && (lineColumnPattern.matcher(originalMsg).find() || offsetPattern.matcher(originalMsg).find())) {
            return new OraNativeErrorInfo(dataSource, original, cause, project);
        }
        if (OraErrorHandler.findByClassName((Throwable)original, (String)DATABASE_EXCEPTION) != null) {
            return new OraWrappedDatabaseErrorInfo(dataSource, original, cause, lineColumnPattern, offsetPattern);
        }
        ErrorInfo errorInfo = super.getErrorInfo(project, dataSource, original, cause);
        if (errorInfo == null) {
            OraErrorHandler.$$$reportNull$$$0(3);
        }
        return errorInfo;
    }

    private static boolean isMissingOci(@NotNull Throwable cause) {
        if (cause == null) {
            OraErrorHandler.$$$reportNull$$$0(4);
        }
        return cause instanceof UnsatisfiedLinkError && cause.getMessage().contains("ocijdbc");
    }

    private static boolean isNlsProblem(@NotNull Throwable cause) {
        if (cause == null) {
            OraErrorHandler.$$$reportNull$$$0(5);
        }
        return OraErrorHandler.getErrorCode((Throwable)cause) == 12705;
    }

    public int getErrorOffset(@NotNull Project project, @NotNull ErrorInfo errorInfo, @NotNull String queryText) {
        String errorMessage;
        int offset;
        if (project == null) {
            OraErrorHandler.$$$reportNull$$$0(6);
        }
        if (errorInfo == null) {
            OraErrorHandler.$$$reportNull$$$0(7);
        }
        if (queryText == null) {
            OraErrorHandler.$$$reportNull$$$0(8);
        }
        if ((offset = OraErrorHandler.getOffset(errorMessage = errorInfo.getMessage())) != 1) {
            return offset;
        }
        BaseDatabaseErrorHandler.OffsetInfo offsetInfo = new BaseDatabaseErrorHandler.OffsetInfoBuilder(errorMessage, LINE_COLUMN_PATTERN).groupLine(2).groupColumn(3).build();
        return OraErrorHandler.getOffsetImpl((BaseDatabaseErrorHandler.OffsetInfo)offsetInfo, (String)queryText, null);
    }

    private static int getOffset(@NotNull String text) {
        Matcher matcher;
        if (text == null) {
            OraErrorHandler.$$$reportNull$$$0(9);
        }
        return (matcher = Pattern.compile(OFFSET_PATTERN).matcher(text)).find() ? StringUtil.parseInt((String)matcher.group(2), (int)-1) : -1;
    }

    public boolean isPasswordExpired(@NotNull Throwable e) {
        if (e == null) {
            OraErrorHandler.$$$reportNull$$$0(10);
        }
        return OraErrorHandler.getErrorCode((Throwable)e) == 28001;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/OraErrorHandler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorInfo";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/OraErrorHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getErrorInfo";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isMissingOci";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isNlsProblem";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getErrorOffset";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getOffset";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isPasswordExpired";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static class OraMissingOCIErrorInfo
    extends BaseDatabaseErrorHandler.MissingNativeLibraryErrorInfo {
        OraMissingOCIErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                OraMissingOCIErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                OraMissingOCIErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                OraMissingOCIErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                OraMissingOCIErrorInfo.$$$reportNull$$$0(3);
            }
            super.fillInfoData(sb, fixes);
            this.addMissingOciFix(fixes);
        }

        private void addMissingOciFix(@NotNull List<ErrorInfo.Fix> fixes) {
            DatabaseDriver driver;
            if (fixes == null) {
                OraMissingOCIErrorInfo.$$$reportNull$$$0(4);
            }
            DatabaseDriver databaseDriver = driver = this.getDataSource() == null ? null : this.getDataSource().getDatabaseDriver();
            if (driver != null) {
                OraMissingOCIErrorInfo.addFix(fixes, f -> f.addLibraryPath(DatabaseBundle.message((String)"add.dependency.on.oci.libraries", (Object[])new Object[0]), driver, true));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/oracle/OraErrorHandler$OraMissingOCIErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addMissingOciFix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class OraNlsProblemErrorInfo
    extends BaseDatabaseErrorHandler.SQLErrorInfo {
        OraNlsProblemErrorInfo(@Nullable OraErrorHandler oraErrorHandler, @NotNull LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause, Project project) {
            if (original == null) {
                OraNlsProblemErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                OraNlsProblemErrorInfo.$$$reportNull$$$0(1);
            }
            if (project == null) {
                OraNlsProblemErrorInfo.$$$reportNull$$$0(2);
            }
            super((BaseDatabaseErrorHandler)oraErrorHandler, project, dataSource, original, cause);
        }

        @Nullable
        public ThreeState isCredentialsProblem() {
            return ThreeState.NO;
        }

        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                OraNlsProblemErrorInfo.$$$reportNull$$$0(3);
            }
            if (fixes == null) {
                OraNlsProblemErrorInfo.$$$reportNull$$$0(4);
            }
            super.fillInfoData(sb, fixes);
            sb.append("\n").append(DatabaseBundle.message((String)"error.message.ora.nls", (Object[])new Object[]{this.getDataSource() == null ? "" : this.getDataSource().getName()}));
            this.addNlsFix(fixes);
        }

        private void addNlsFix(@NotNull List<ErrorInfo.Fix> fixes) {
            if (fixes == null) {
                OraNlsProblemErrorInfo.$$$reportNull$$$0(5);
            }
            String example = "-Duser.language=en -Duser.region=US -Duser.country=en";
            String options = this.getDataSource() == null ? null : this.getDataSource().getVmOptions();
            OraNlsProblemErrorInfo.addFix(fixes, f -> f.setVmOptions(AnalysisBundle.message((String)"OraErrorHandler.set.locale", (Object[])new Object[0]), this.getDataSource(), (String)(StringUtil.isEmpty((String)options) ? example : options + " " + example)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/oracle/OraErrorHandler$OraNlsProblemErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addNlsFix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class OraNativeErrorInfo
    extends BaseDatabaseErrorHandler.DatabaseErrorInfo {
        OraNativeErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause, @NotNull Project project) {
            if (original == null) {
                OraNativeErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                OraNativeErrorInfo.$$$reportNull$$$0(1);
            }
            if (project == null) {
                OraNativeErrorInfo.$$$reportNull$$$0(2);
            }
            super(dataSource, original, cause);
        }

        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                OraNativeErrorInfo.$$$reportNull$$$0(3);
            }
            if (fixes == null) {
                OraNativeErrorInfo.$$$reportNull$$$0(4);
            }
            OraNativeErrorInfo.appendGenericMessage((Throwable)this.myOriginal, (StringBuilder)sb);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/oracle/OraErrorHandler$OraNativeErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class OraWrappedDatabaseErrorInfo
    extends BaseDatabaseErrorHandler.DatabaseErrorInfo {
        private final Pattern myLineColumnPattern;
        private final Pattern myOffsetPattern;

        OraWrappedDatabaseErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause, @NotNull Pattern lineColumnPattern, @NotNull Pattern offsetPattern) {
            if (original == null) {
                OraWrappedDatabaseErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                OraWrappedDatabaseErrorInfo.$$$reportNull$$$0(1);
            }
            if (lineColumnPattern == null) {
                OraWrappedDatabaseErrorInfo.$$$reportNull$$$0(2);
            }
            if (offsetPattern == null) {
                OraWrappedDatabaseErrorInfo.$$$reportNull$$$0(3);
            }
            super(dataSource, original, cause);
            this.myLineColumnPattern = lineColumnPattern;
            this.myOffsetPattern = offsetPattern;
        }

        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            String causeMessage;
            Matcher lcMatcher;
            if (sb == null) {
                OraWrappedDatabaseErrorInfo.$$$reportNull$$$0(4);
            }
            if (fixes == null) {
                OraWrappedDatabaseErrorInfo.$$$reportNull$$$0(5);
            }
            if ((lcMatcher = this.myLineColumnPattern.matcher(causeMessage = GridUtilCore.getMessage((Throwable)this.myCause))).find()) {
                OraWrappedDatabaseErrorInfo.appendGenericMessage((Throwable)this.myOriginal, (StringBuilder)sb);
                String line = lcMatcher.group(2);
                String column = lcMatcher.group(3);
                sb.append(String.format("Line: %s, column: %s", line, column));
                return;
            }
            Matcher oMatcher = this.myOffsetPattern.matcher(causeMessage);
            if (oMatcher.find()) {
                OraWrappedDatabaseErrorInfo.appendGenericMessage((Throwable)this.myOriginal, (StringBuilder)sb);
                String offset = oMatcher.group(2);
                sb.append(String.format("Position: %s", offset));
                return;
            }
            sb.append(GridUtilCore.getMessage((Throwable)this.myCause));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lineColumnPattern";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "offsetPattern";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/oracle/OraErrorHandler$OraWrappedDatabaseErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

