/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ls.requests;

import com.jetbrains.ls.requests.AbstractObtainTicketRequest;
import com.jetbrains.ls.responses.ObtainPermanentTicketGroupResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;

public class ObtainPermanentTicketGroupRequest
extends AbstractObtainTicketRequest<ObtainPermanentTicketGroupResponse> {
    public static final String ACTION_NAME = "obtainPermanentTicketGroup.action";
    private String email;
    private String activationCode;
    private Collection<ProductSelector> productSelectors;

    public ObtainPermanentTicketGroupRequest() {
    }

    public ObtainPermanentTicketGroupRequest(long salt, Collection<ProductSelector> productSelectors, String machineId, String hostName, String userName, String ideProductCode, String email, String activationCode) {
        super(salt, ObtainPermanentTicketGroupRequest.h(productSelectors), machineId, hostName, userName, ideProductCode, 0, 0, false);
        this.email = email;
        this.activationCode = activationCode;
        this.productSelectors = productSelectors;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getActivationCode() {
        return this.activationCode;
    }

    public void setActivationCode(String activationCode) {
        this.activationCode = activationCode;
    }

    public String getProductSelectors() {
        if (this.productSelectors == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (ProductSelector productSelector : this.productSelectors) {
            if (!stringBuilder.isEmpty()) {
                stringBuilder.append(",");
            }
            stringBuilder.append(productSelector.toString());
        }
        return stringBuilder.toString();
    }

    public void setProductSelectors(String selectors) {
        ArrayList<ProductSelector> arrayList = new ArrayList<ProductSelector>();
        if (selectors != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(selectors, ",", false);
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken().trim();
                ProductSelector productSelector = ProductSelector.fromString(string, 0);
                if (productSelector == null) continue;
                arrayList.add(productSelector);
            }
        }
        this.productSelectors = arrayList.isEmpty() ? null : arrayList;
    }

    @NotNull
    public Collection<ProductSelector> getAllProductSelectors() {
        return this.productSelectors == null ? Collections.emptyList() : this.productSelectors;
    }

    @Override
    public String getActionName() {
        return ACTION_NAME;
    }

    private static String h(Collection<ProductSelector> collection) {
        if (collection.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (ProductSelector productSelector : collection) {
            if (!stringBuilder.isEmpty()) {
                stringBuilder.append(",");
            }
            stringBuilder.append(productSelector.getProductFamilyId());
        }
        return stringBuilder.toString();
    }

    public static final class ProductSelector {
        public final String productFamilyId;
        public final int version;
        public final int buildDate;
        public final String edition;

        public ProductSelector(String productFamilyId, int version, int buildDate, String edition) {
            this.productFamilyId = productFamilyId;
            this.version = version;
            this.buildDate = buildDate;
            this.edition = edition == null || edition.isEmpty() || "null".equalsIgnoreCase(edition) ? null : edition;
        }

        public String getProductFamilyId() {
            return this.productFamilyId;
        }

        public int getVersion() {
            return this.version;
        }

        public int getBuildDate() {
            return this.buildDate;
        }

        public String getEdition() {
            return this.edition;
        }

        public String toString() {
            return "{" + this.productFamilyId + "|" + this.version + "|" + this.buildDate + "|" + this.edition + "}";
        }

        public static ProductSelector fromString(String str, int start) {
            int n2;
            if (start >= str.length()) {
                return null;
            }
            if (str.charAt(start) != '{') {
                return null;
            }
            if ((n2 = str.indexOf(124, ++start)) < 0) {
                return null;
            }
            String string = str.substring(start, n2).trim();
            start = n2 + 1;
            if ((n2 = str.indexOf(124, start)) < 0) {
                return null;
            }
            String string2 = str.substring(start, n2).trim();
            start = n2 + 1;
            if ((n2 = str.indexOf(124, start)) < 0) {
                return null;
            }
            String string3 = str.substring(start, n2).trim();
            start = n2 + 1;
            if ((n2 = str.indexOf(125, start)) < 0) {
                return null;
            }
            String string4 = str.substring(start, n2).trim();
            try {
                return new ProductSelector(string, Integer.parseInt(string2), Integer.parseInt(string3), string4);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }
}

