"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.equalOwnPropertiesDeep = exports.throwIdeError = void 0;
function throwIdeError(kind) {
    let error = new Error(kind);
    error.ideKind = kind;
    throw error;
}
exports.throwIdeError = throwIdeError;
function equalOwnPropertiesDeep(left, right, compared = new Set()) {
    if (left === right)
        return true;
    if (!left || !right)
        return false;
    for (const key in left) {
        if (left.hasOwnProperty(key)) {
            if (!right.hasOwnProperty(key))
                return false;
            if (!equalsDeep(left[key], right[key], compared))
                return false;
        }
    }
    for (const key in right) {
        if (right.hasOwnProperty(key)) {
            if (!left.hasOwnProperty(key))
                return false;
        }
    }
    return true;
}
exports.equalOwnPropertiesDeep = equalOwnPropertiesDeep;
function equalsDeep(left, right, compared) {
    if (typeof left === "object" && typeof right === "object") {
        if (compared.has(left) || compared.has(right))
            return false;
        compared.add(left);
        compared.add(right);
        try {
            return equalOwnPropertiesDeep(left, right, compared);
        }
        finally {
            compared.delete(left);
            compared.delete(right);
        }
    }
    return left === right;
}
//# sourceMappingURL=utils.js.map