/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.BasicAction;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.dialogs.SetPropertyDialog;
import org.jetbrains.idea.svn.properties.PropertyClient;
import org.jetbrains.idea.svn.properties.PropertyValue;

public class SetPropertyAction
extends BasicAction {
    @Override
    @NotNull
    protected String getActionName() {
        String string = SvnBundle.message("action.name.set.property", new Object[0]);
        if (string == null) {
            SetPropertyAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected boolean isEnabled(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        FileStatus status;
        if (vcs == null) {
            SetPropertyAction.$$$reportNull$$$0(1);
        }
        if (file == null) {
            SetPropertyAction.$$$reportNull$$$0(2);
        }
        return !FileStatus.IGNORED.equals((Object)(status = FileStatusManager.getInstance((Project)vcs.getProject()).getStatus(file))) && !FileStatus.UNKNOWN.equals((Object)status);
    }

    @Override
    protected void perform(@NotNull SvnVcs vcs, @NotNull VirtualFile file, @NotNull DataContext context) throws VcsException {
        if (vcs == null) {
            SetPropertyAction.$$$reportNull$$$0(3);
        }
        if (file == null) {
            SetPropertyAction.$$$reportNull$$$0(4);
        }
        if (context == null) {
            SetPropertyAction.$$$reportNull$$$0(5);
        }
        this.batchPerform(vcs, (VirtualFile[])ContainerUtil.ar((Object[])new VirtualFile[]{file}), context);
    }

    @Override
    protected void batchPerform(@NotNull SvnVcs vcs, VirtualFile @NotNull [] files, @NotNull DataContext context) throws VcsException {
        if (vcs == null) {
            SetPropertyAction.$$$reportNull$$$0(6);
        }
        if (context == null) {
            SetPropertyAction.$$$reportNull$$$0(7);
        }
        if (files == null) {
            SetPropertyAction.$$$reportNull$$$0(8);
        }
        File[] ioFiles = SvnUtil.toIoFiles(files);
        SetPropertyDialog dialog = new SetPropertyDialog(vcs.getProject(), ioFiles, null, true);
        if (dialog.showAndGet()) {
            String name = dialog.getPropertyName();
            String value = dialog.getPropertyValue();
            boolean recursive = dialog.isRecursive();
            for (File file : ioFiles) {
                PropertyClient client = vcs.getFactory(file).createPropertyClient();
                client.setProperty(file, name, PropertyValue.create(value), Depth.allOrFiles(recursive), false);
            }
            for (File file : files) {
                if (recursive && file.isDirectory()) {
                    VcsDirtyScopeManager.getInstance((Project)vcs.getProject()).dirDirtyRecursively((VirtualFile)file);
                    continue;
                }
                VcsDirtyScopeManager.getInstance((Project)vcs.getProject()).fileDirty((VirtualFile)file);
            }
        }
    }

    @Override
    protected boolean isBatchAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/actions/SetPropertyAction";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/actions/SetPropertyAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "batchPerform";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

