/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.awt.canvas;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.awt.canvas.AwtContext2d;
import org.jetbrains.letsPlot.commons.geometry.Vector;
import org.jetbrains.letsPlot.commons.values.Bitmap;
import org.jetbrains.letsPlot.commons.values.awt.BitmapUtil;
import org.jetbrains.letsPlot.core.canvas.Canvas;
import org.jetbrains.letsPlot.core.canvas.Context2d;
import org.jetbrains.letsPlot.core.canvas.ScaledContext2d;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0002\u0013\u0014B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/letsPlot/awt/canvas/AwtCanvas;", "Lorg/jetbrains/letsPlot/core/canvas/Canvas;", "image", "Ljava/awt/image/BufferedImage;", "size", "Lorg/jetbrains/letsPlot/commons/geometry/Vector;", "pixelDensity", "", "(Ljava/awt/image/BufferedImage;Lorg/jetbrains/letsPlot/commons/geometry/Vector;D)V", "context2d", "Lorg/jetbrains/letsPlot/core/canvas/Context2d;", "getContext2d", "()Lorg/jetbrains/letsPlot/core/canvas/Context2d;", "getImage", "()Ljava/awt/image/BufferedImage;", "getSize", "()Lorg/jetbrains/letsPlot/commons/geometry/Vector;", "takeSnapshot", "Lorg/jetbrains/letsPlot/core/canvas/Canvas$Snapshot;", "AwtSnapshot", "Companion", "platf-awt"})
public final class AwtCanvas
implements Canvas {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BufferedImage image;
    @NotNull
    private final Vector size;
    @NotNull
    private final Context2d context2d;

    private AwtCanvas(BufferedImage image, Vector size2, double pixelDensity) {
        this.image = image;
        this.size = size2;
        Graphics2D graphics2D = this.image.createGraphics();
        Intrinsics.checkNotNull((Object)graphics2D, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        this.context2d = ScaledContext2d.Companion.wrap(new AwtContext2d(graphics2D), pixelDensity);
    }

    @NotNull
    public final BufferedImage getImage() {
        return this.image;
    }

    @Override
    @NotNull
    public Vector getSize() {
        return this.size;
    }

    @Override
    @NotNull
    public Context2d getContext2d() {
        return this.context2d;
    }

    @Override
    @NotNull
    public Canvas.Snapshot takeSnapshot() {
        return new AwtSnapshot(this.image);
    }

    public /* synthetic */ AwtCanvas(BufferedImage image, Vector size2, double pixelDensity, DefaultConstructorMarker $constructor_marker) {
        this(image, size2, pixelDensity);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\b\u0010\u0012\u001a\u00020\u0000H\u0016J\u0013\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u001b\u0010\u0005\u001a\u00020\u00068VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/awt/canvas/AwtCanvas$AwtSnapshot;", "Lorg/jetbrains/letsPlot/core/canvas/Canvas$Snapshot;", "image", "Ljava/awt/image/BufferedImage;", "(Ljava/awt/image/BufferedImage;)V", "bitmap", "Lorg/jetbrains/letsPlot/commons/values/Bitmap;", "getBitmap", "()Lorg/jetbrains/letsPlot/commons/values/Bitmap;", "bitmap$delegate", "Lkotlin/Lazy;", "getImage", "()Ljava/awt/image/BufferedImage;", "size", "Lorg/jetbrains/letsPlot/commons/geometry/Vector;", "getSize", "()Lorg/jetbrains/letsPlot/commons/geometry/Vector;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Companion", "platf-awt"})
    public static final class AwtSnapshot
    implements Canvas.Snapshot {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final BufferedImage image;
        @NotNull
        private final Vector size;
        @NotNull
        private final Lazy bitmap$delegate;

        public AwtSnapshot(@NotNull BufferedImage image) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            this.image = image;
            this.size = new Vector(this.image.getWidth(), this.image.getHeight());
            this.bitmap$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Bitmap>(this){
                final /* synthetic */ AwtSnapshot this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Bitmap invoke() {
                    return BitmapUtil.INSTANCE.fromBufferedImage(this.this$0.getImage());
                }
            }));
        }

        @NotNull
        public final BufferedImage getImage() {
            return this.image;
        }

        @Override
        @NotNull
        public Vector getSize() {
            return this.size;
        }

        @Override
        @NotNull
        public Bitmap getBitmap() {
            Lazy lazy = this.bitmap$delegate;
            return (Bitmap)lazy.getValue();
        }

        @Override
        @NotNull
        public AwtSnapshot copy() {
            BufferedImage b2 = new BufferedImage(this.image.getWidth(), this.image.getHeight(), this.image.getType());
            Graphics2D graphics2D = b2.createGraphics();
            Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"createGraphics(...)");
            Graphics2D g = graphics2D;
            g.drawImage((Image)this.image, 0, 0, null);
            g.dispose();
            return new AwtSnapshot(b2);
        }

        @NotNull
        public final BufferedImage component1() {
            return this.image;
        }

        @NotNull
        public final AwtSnapshot copy(@NotNull BufferedImage image) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            return new AwtSnapshot(image);
        }

        public static /* synthetic */ AwtSnapshot copy$default(AwtSnapshot awtSnapshot, BufferedImage bufferedImage, int n, Object object) {
            if ((n & 1) != 0) {
                bufferedImage = awtSnapshot.image;
            }
            return awtSnapshot.copy(bufferedImage);
        }

        @NotNull
        public String toString() {
            return "AwtSnapshot(image=" + this.image + ')';
        }

        public int hashCode() {
            return this.image.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AwtSnapshot)) {
                return false;
            }
            AwtSnapshot awtSnapshot = (AwtSnapshot)other;
            return Intrinsics.areEqual((Object)this.image, (Object)awtSnapshot.image);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/awt/canvas/AwtCanvas$AwtSnapshot$Companion;", "", "()V", "fromBitmap", "Lorg/jetbrains/letsPlot/awt/canvas/AwtCanvas$AwtSnapshot;", "bitmap", "Lorg/jetbrains/letsPlot/commons/values/Bitmap;", "platf-awt"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final AwtSnapshot fromBitmap(@NotNull Bitmap bitmap2) {
                Intrinsics.checkNotNullParameter((Object)bitmap2, (String)"bitmap");
                BufferedImage image = BitmapUtil.INSTANCE.toBufferedImage(bitmap2);
                return new AwtSnapshot(image);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/awt/canvas/AwtCanvas$Companion;", "", "()V", "create", "Lorg/jetbrains/letsPlot/awt/canvas/AwtCanvas;", "size", "Lorg/jetbrains/letsPlot/commons/geometry/Vector;", "pixelDensity", "", "platf-awt"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AwtCanvas create(@NotNull Vector size2, double pixelDensity) {
            Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
            Vector s = Intrinsics.areEqual((Object)size2, (Object)Vector.Companion.getZERO()) ? new Vector(1, 1) : size2;
            return new AwtCanvas(new BufferedImage(MathKt.roundToInt((double)((double)s.getX() * pixelDensity)), MathKt.roundToInt((double)((double)s.getY() * pixelDensity)), 6), s, pixelDensity, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

