/*
 * Decompiled with CFR 0.152.
 */
package git4idea.conflicts;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffEditorTitleCustomizer;
import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.merge.MergeCallback;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeRequestProducer;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.impl.BackgroundableActionLock;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vcs.merge.MergeUtils;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.util.ApplicationKt;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.conflicts.GitConflictsUtil;
import git4idea.conflicts.GitMergeHandler;
import git4idea.conflicts.MergeConflictResolveUtilKt;
import git4idea.i18n.GitBundle;
import git4idea.index.ui.GitStagePanelKt;
import git4idea.repo.GitConflict;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.status.GitStagingAreaHolder;
import java.awt.Window;
import java.util.List;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\u001b\u001c\u001d\u001eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0007J\"\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0015\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0019J\u0012\u0010\u001a\u001a\u00020\u00182\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lgit4idea/conflicts/MergeConflictResolveUtil;", "", "<init>", "()V", "ACTIVE_MERGE_WINDOW", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/ui/WindowWrapper;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "showMergeWindow", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "lock", "Lcom/intellij/openapi/vcs/impl/BackgroundableActionLock;", "resolverComputer", "Lkotlin/Function0;", "Lgit4idea/conflicts/GitMergeHandler$Resolver;", "putActiveWindowKey", "wrapper", "getActiveMergeWindow", "hasActiveMergeWindow", "", "hasActiveMergeWindow$intellij_vcs_git", "focusActiveMergeWindow", "MyProducer", "MyMergeCallback", "NotificationProvider", "MyStagingAreaListener", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nMergeConflictResolveUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MergeConflictResolveUtil.kt\ngit4idea/conflicts/MergeConflictResolveUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,220:1\n1#2:221\n*E\n"})
public final class MergeConflictResolveUtil {
    @NotNull
    public static final MergeConflictResolveUtil INSTANCE = new MergeConflictResolveUtil();
    @NotNull
    private static final Key<WindowWrapper> ACTIVE_MERGE_WINDOW;

    private MergeConflictResolveUtil() {
    }

    @RequiresEdt
    public final void showMergeWindow(@NotNull Project project, @Nullable VirtualFile file, @NotNull BackgroundableActionLock lock, @NotNull Function0<GitMergeHandler.Resolver> resolverComputer) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        Intrinsics.checkNotNullParameter(resolverComputer, (String)"resolverComputer");
        if (this.focusActiveMergeWindow(file)) {
            return;
        }
        if (lock.isLocked()) {
            return;
        }
        lock.lock();
        if (file != null) {
            string = new MergeDialogCustomizer().getMergeWindowTitle(file);
        } else {
            String string2 = DiffBundle.message((String)"merge.files.dialog.title", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        }
        String title = string;
        Consumer windowHandler = arg_0 -> MergeConflictResolveUtil.showMergeWindow$lambda$0(project, file, lock, arg_0);
        DiffDialogHints hints = new DiffDialogHints(WindowWrapper.Mode.FRAME, null, windowHandler);
        MyProducer producer = new MyProducer(project, title, resolverComputer);
        DiffManagerEx.getInstance().showMergeBuiltin(project, (MergeRequestProducer)producer, hints);
    }

    private final void putActiveWindowKey(Project project, WindowWrapper wrapper, VirtualFile file) {
        if (file == null) {
            return;
        }
        Window window = wrapper.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"getWindow(...)");
        Window window2 = window;
        if (!(window2 instanceof JFrame)) {
            return;
        }
        file.putUserData(ACTIVE_MERGE_WINDOW, (Object)wrapper);
        MergeConflictResolveUtilKt.updateMergeConflictEditorNotifications(project);
        UIUtil.runWhenWindowClosed((Window)window2, () -> MergeConflictResolveUtil.putActiveWindowKey$lambda$0(file, project));
    }

    private final WindowWrapper getActiveMergeWindow(VirtualFile file) {
        Object object;
        WindowWrapper windowWrapper = (WindowWrapper)file.getUserData(ACTIVE_MERGE_WINDOW);
        if (windowWrapper != null) {
            WindowWrapper windowWrapper2;
            WindowWrapper it = windowWrapper2 = windowWrapper;
            boolean bl = false;
            object = !it.isDisposed() ? windowWrapper2 : null;
        } else {
            object = null;
        }
        return object;
    }

    public final boolean hasActiveMergeWindow$intellij_vcs_git(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.getActiveMergeWindow(file) != null;
    }

    private final boolean focusActiveMergeWindow(VirtualFile file) {
        if (file == null) {
            return false;
        }
        WindowWrapper windowWrapper = this.getActiveMergeWindow(file);
        if (windowWrapper == null) {
            return false;
        }
        WindowWrapper wrapper = windowWrapper;
        UIUtil.toFront((Window)wrapper.getWindow());
        return true;
    }

    private static final void showMergeWindow$lambda$0(Project $project, VirtualFile $file, BackgroundableActionLock $lock, WindowWrapper wrapper) {
        UIUtil.runWhenWindowClosed((Window)wrapper.getWindow(), () -> MergeConflictResolveUtil.showMergeWindow$lambda$0$0($lock));
        Intrinsics.checkNotNull((Object)wrapper);
        INSTANCE.putActiveWindowKey($project, wrapper, $file);
    }

    private static final void showMergeWindow$lambda$0$0(BackgroundableActionLock $lock) {
        $lock.unlock();
    }

    private static final void putActiveWindowKey$lambda$0(VirtualFile $file, Project $project) {
        $file.putUserData(ACTIVE_MERGE_WINDOW, null);
        MergeConflictResolveUtilKt.updateMergeConflictEditorNotifications($project);
    }

    static {
        Key key = Key.create((String)"ResolveConflictsWindow");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        ACTIVE_MERGE_WINDOW = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lgit4idea/conflicts/MergeConflictResolveUtil$MyMergeCallback;", "Lcom/intellij/diff/merge/MergeCallback;", "resolver", "Lgit4idea/conflicts/GitMergeHandler$Resolver;", "<init>", "(Lgit4idea/conflicts/GitMergeHandler$Resolver;)V", "applyResult", "", "result", "Lcom/intellij/diff/merge/MergeResult;", "checkIsValid", "", "addListener", "listener", "Lcom/intellij/diff/merge/MergeCallback$Listener;", "disposable", "Lcom/intellij/openapi/Disposable;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nMergeConflictResolveUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MergeConflictResolveUtil.kt\ngit4idea/conflicts/MergeConflictResolveUtil$MyMergeCallback\n+ 2 progress.kt\ncom/intellij/openapi/progress/ProgressKt\n*L\n1#1,220:1\n46#2,6:221\n*S KotlinDebug\n*F\n+ 1 MergeConflictResolveUtil.kt\ngit4idea/conflicts/MergeConflictResolveUtil$MyMergeCallback\n*L\n140#1:221,6\n*E\n"})
    private static final class MyMergeCallback
    extends MergeCallback {
        @NotNull
        private final GitMergeHandler.Resolver resolver;

        public MyMergeCallback(@NotNull GitMergeHandler.Resolver resolver) {
            Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
            this.resolver = resolver;
        }

        /*
         * WARNING - void declaration
         */
        public void applyResult(@NotNull MergeResult result2) {
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            Project project = this.resolver.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            VirtualFile virtualFile = this.resolver.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            VirtualFile file = virtualFile;
            Document document = FileDocumentManager.getInstance().getCachedDocument(file);
            if (document != null) {
                ApplicationKt.getApplication().runWriteAction(() -> MyMergeCallback.applyResult$lambda$0(document));
            }
            MergeUtil.reportProjectFileChangeIfNeeded((Project)project2, (VirtualFile)file);
            if (result2 != MergeResult.CANCEL) {
                void title$iv;
                void project$iv;
                String string = GitBundle.message((String)"progress.finishing.conflict.resolve", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String string2 = string;
                Project project3 = project2;
                boolean cancellable$iv = false;
                boolean $i$f$runBackgroundableTask = false;
                ProgressManager.getInstance().run((Task)new Task.Backgroundable((Project)project$iv, (String)title$iv, cancellable$iv, this, result2){
                    final /* synthetic */ MyMergeCallback this$0;
                    final /* synthetic */ MergeResult $result$inlined;
                    {
                        this.this$0 = myMergeCallback;
                        this.$result$inlined = mergeResult;
                        super($project, $title, $cancellable);
                    }

                    public void run(ProgressIndicator indicator) {
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        ProgressIndicator it = indicator;
                        boolean bl = false;
                        MyMergeCallback.access$getResolver$p(this.this$0).onConflictResolved(this.$result$inlined);
                    }
                });
            }
        }

        public boolean checkIsValid() {
            return this.resolver.checkIsValid();
        }

        public void addListener(@NotNull MergeCallback.Listener listener2, @NotNull Disposable disposable) {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            this.resolver.addListener(listener2, disposable);
        }

        private static final void applyResult$lambda$0(Document $document) {
            FileDocumentManager.getInstance().saveDocument($document);
        }

        public static final /* synthetic */ GitMergeHandler.Resolver access$getResolver$p(MyMergeCallback $this) {
            return $this.resolver;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0011\u001a\u00020\u0005H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lgit4idea/conflicts/MergeConflictResolveUtil$MyProducer;", "Lcom/intellij/diff/merge/MergeRequestProducer;", "project", "Lcom/intellij/openapi/project/Project;", "title", "", "resolverComputer", "Lkotlin/Function0;", "Lgit4idea/conflicts/GitMergeHandler$Resolver;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getTitle", "()Ljava/lang/String;", "getResolverComputer", "()Lkotlin/jvm/functions/Function0;", "getName", "process", "Lcom/intellij/diff/merge/MergeRequest;", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.vcs.git"})
    private static final class MyProducer
    implements MergeRequestProducer {
        @NotNull
        private final Project project;
        @NotNull
        private final String title;
        @NotNull
        private final Function0<GitMergeHandler.Resolver> resolverComputer;

        public MyProducer(@NotNull Project project, @NotNull String title, @NotNull Function0<GitMergeHandler.Resolver> resolverComputer) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(resolverComputer, (String)"resolverComputer");
            this.project = project;
            this.title = title;
            this.resolverComputer = resolverComputer;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final String getTitle() {
            return this.title;
        }

        @NotNull
        public final Function0<GitMergeHandler.Resolver> getResolverComputer() {
            return this.resolverComputer;
        }

        @NotNull
        public String getName() {
            return this.title;
        }

        @NotNull
        public MergeRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            try {
                GitMergeHandler.Resolver resolver = (GitMergeHandler.Resolver)this.resolverComputer.invoke();
                MergeData mergeData = resolver.getMergeData();
                Intrinsics.checkNotNullExpressionValue((Object)mergeData, (String)"getMergeData(...)");
                MergeData mergeData2 = mergeData;
                byte[][] byArrayArray = new byte[][]{mergeData2.CURRENT, mergeData2.ORIGINAL, mergeData2.LAST};
                List byteContents = CollectionsKt.listOf((Object[])((Object[])byArrayArray));
                MergeRequest mergeRequest = DiffRequestFactory.getInstance().createMergeRequest(this.project, resolver.getVirtualFile(), byteContents, mergeData2.CONFLICT_TYPE, resolver.getWindowTitle(), resolver.getContentTitles());
                Intrinsics.checkNotNullExpressionValue((Object)mergeRequest, (String)"createMergeRequest(...)");
                MergeRequest request = mergeRequest;
                MergeDialogCustomizer.DiffEditorTitleCustomizerList $this$process_u24lambda_u240 = resolver.getTitleCustomizerList();
                boolean bl = false;
                Object[] objectArray = new DiffEditorTitleCustomizer[]{$this$process_u24lambda_u240.getLeftTitleCustomizer(), $this$process_u24lambda_u240.getCenterTitleCustomizer(), $this$process_u24lambda_u240.getRightTitleCustomizer()};
                DiffUtil.addTitleCustomizers((MergeRequest)request, (List)CollectionsKt.listOf((Object[])objectArray));
                MergeUtils.putRevisionInfos((MergeRequest)request, (MergeData)mergeData2);
                MergeCallback.register((MergeRequest)request, (MergeCallback)new MyMergeCallback(resolver));
                return request;
            }
            catch (Throwable e) {
                throw new DiffRequestProducerException(e);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lgit4idea/conflicts/MergeConflictResolveUtil$MyStagingAreaListener;", "Lgit4idea/status/GitStagingAreaHolder$StagingAreaListener;", "<init>", "()V", "stagingAreaChanged", "", "repository", "Lgit4idea/repo/GitRepository;", "intellij.vcs.git"})
    public static final class MyStagingAreaListener
    implements GitStagingAreaHolder.StagingAreaListener {
        @Override
        public void stagingAreaChanged(@NotNull GitRepository repository2) {
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            Project project = repository2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            ActionsKt.runInEdt((ModalityState)ModalityState.nonModal(), () -> MyStagingAreaListener.stagingAreaChanged$lambda$0(project2));
        }

        private static final Unit stagingAreaChanged$lambda$0(Project $project) {
            MergeConflictResolveUtilKt.updateMergeConflictEditorNotifications($project);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J,\u0010\u0005\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u0007\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0010\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0015"}, d2={"Lgit4idea/conflicts/MergeConflictResolveUtil$NotificationProvider;", "Lcom/intellij/ui/EditorNotificationProvider;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createPanelForOngoingResolve", "Lcom/intellij/ui/EditorNotificationPanel;", "fileEditor", "createPanelForFileWithConflict", "showMergeWindow", "", "findConflictFor", "Lgit4idea/repo/GitConflict;", "intellij.vcs.git"})
    public static final class NotificationProvider
    implements EditorNotificationProvider,
    DumbAware {
        @Nullable
        public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (INSTANCE.hasActiveMergeWindow$intellij_vcs_git(file)) {
                return arg_0 -> NotificationProvider.collectNotificationData$lambda$0(this, file, arg_0);
            }
            GitConflict conflict = this.findConflictFor(project, file);
            if (conflict != null && GitConflictsUtil.INSTANCE.canShowMergeWindow$intellij_vcs_git(project, GitStagePanelKt.createMergeHandler(project), conflict)) {
                return arg_0 -> NotificationProvider.collectNotificationData$lambda$1(this, project, file, arg_0);
            }
            return null;
        }

        private final EditorNotificationPanel createPanelForOngoingResolve(FileEditor fileEditor, VirtualFile file) {
            if (!INSTANCE.hasActiveMergeWindow$intellij_vcs_git(file)) {
                return null;
            }
            EditorNotificationPanel panel2 = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Info);
            panel2.setText(GitBundle.message((String)"link.label.editor.notification.merge.conflicts.resolve.in.progress", (Object[])new Object[0]));
            panel2.createActionLabel(GitBundle.message((String)"link.label.merge.conflicts.resolve.in.progress.focus.window", (Object[])new Object[0]), () -> NotificationProvider.createPanelForOngoingResolve$lambda$0(file));
            panel2.createActionLabel(GitBundle.message((String)"link.label.merge.conflicts.resolve.in.progress.cancel.resolve", (Object[])new Object[0]), () -> NotificationProvider.createPanelForOngoingResolve$lambda$1(file));
            return panel2;
        }

        private final EditorNotificationPanel createPanelForFileWithConflict(Project project, FileEditor fileEditor, VirtualFile file) {
            EditorNotificationPanel panel2 = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Warning);
            panel2.setText(GitBundle.message((String)"link.label.editor.notification.merge.conflicts.suggest.resolve", (Object[])new Object[0]));
            panel2.createActionLabel(GitBundle.message((String)"link.label.merge.conflicts.suggest.resolve.show.window", (Object[])new Object[0]), () -> NotificationProvider.createPanelForFileWithConflict$lambda$0(this, project, file));
            return panel2;
        }

        private final void showMergeWindow(Project project, VirtualFile file) {
            GitConflict gitConflict = this.findConflictFor(project, file);
            if (gitConflict == null) {
                return;
            }
            GitConflict conflict = gitConflict;
            GitConflictsUtil.INSTANCE.showMergeWindow$intellij_vcs_git(project, GitStagePanelKt.createMergeHandler(project), CollectionsKt.listOf((Object)conflict));
        }

        private final GitConflict findConflictFor(Project project, VirtualFile file) {
            GitRepository gitRepository = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForFileQuick(file);
            if (gitRepository == null) {
                return null;
            }
            GitRepository repo = gitRepository;
            return repo.getStagingAreaHolder().findConflict(VcsUtil.getFilePath((VirtualFile)file));
        }

        private static final EditorNotificationPanel collectNotificationData$lambda$0(NotificationProvider this$0, VirtualFile $file, FileEditor fileEditor) {
            Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
            return this$0.createPanelForOngoingResolve(fileEditor, $file);
        }

        private static final EditorNotificationPanel collectNotificationData$lambda$1(NotificationProvider this$0, Project $project, VirtualFile $file, FileEditor fileEditor) {
            Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
            return this$0.createPanelForFileWithConflict($project, fileEditor, $file);
        }

        private static final void createPanelForOngoingResolve$lambda$0(VirtualFile $file) {
            WindowWrapper windowWrapper = INSTANCE.getActiveMergeWindow($file);
            UIUtil.toFront((Window)(windowWrapper != null ? windowWrapper.getWindow() : null));
        }

        private static final void createPanelForOngoingResolve$lambda$1(VirtualFile $file) {
            block0: {
                WindowWrapper windowWrapper = INSTANCE.getActiveMergeWindow($file);
                if (windowWrapper == null) break block0;
                windowWrapper.close();
            }
        }

        private static final void createPanelForFileWithConflict$lambda$0(NotificationProvider this$0, Project $project, VirtualFile $file) {
            this$0.showMergeWindow($project, $file);
        }
    }
}

