/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css;

import com.intellij.lang.LanguagePerFileMappings;
import com.intellij.lang.css.CssDialect;
import com.intellij.lang.css.CssDialectPusher;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.FilePropertyKey;
import com.intellij.psi.FilePropertyKeyImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@State(name="CssDialectMappings", storages={@Storage(value="cssdialects.xml")})
public class CssDialectMappings
extends LanguagePerFileMappings<String> {
    public static final FilePropertyKey<String> CSS_DIALECT_NAME_KEY = FilePropertyKeyImpl.createPersistentStringKey((String)"CSS_LANGUAGE_DIALECT", (FileAttribute)new FileAttribute("css_dialect_persistence", 4, true));
    private final CssDialectPusher myPusherInstance = new CssDialectPusher();

    public static CssDialectMappings getInstance(Project project) {
        return (CssDialectMappings)((Object)project.getService(CssDialectMappings.class));
    }

    protected FilePropertyPusher<String> getFilePropertyPusher() {
        return this.myPusherInstance;
    }

    public CssDialectMappings(Project project) {
        super(project);
    }

    protected String serialize(@NotNull String dialectName) {
        if (dialectName == null) {
            CssDialectMappings.$$$reportNull$$$0(0);
        }
        return dialectName;
    }

    public @Unmodifiable @NotNull List<String> getAvailableValues() {
        List list = ContainerUtil.map((Collection)CssDialect.getAvailableDialects(), dialect -> dialect.getName());
        if (list == null) {
            CssDialectMappings.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Contract(value="null -> false")
    public boolean hasCustomDialect(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        String mapping = (String)this.getMapping(file);
        return mapping != null && !CssDialect.CLASSIC.getName().equals(mapping);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialectName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/css/CssDialectMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/css/CssDialectMappings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

