/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl.io;

import java.awt.image.BufferedImage;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.impl.io.BytesUtilsKt;
import org.jetbrains.kotlinx.dataframe.impl.io.CompressionKt;
import org.jetbrains.kotlinx.dataframe.impl.io.ImageKt;
import org.jetbrains.kotlinx.dataframe.io.Base64ImageEncodingOptions;
import org.jetbrains.kotlinx.dataframe.io.CustomEncoder;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlinx/dataframe/impl/io/BufferedImageEncoder;", "Lorg/jetbrains/kotlinx/dataframe/io/CustomEncoder;", "options", "Lorg/jetbrains/kotlinx/dataframe/io/Base64ImageEncodingOptions;", "<init>", "(Lorg/jetbrains/kotlinx/dataframe/io/Base64ImageEncodingOptions;)V", "canEncode", "", "input", "", "encode", "Lkotlinx/serialization/json/JsonElement;", "encodeBufferedImageAsBase64", "", "image", "Ljava/awt/image/BufferedImage;", "imageEncodingOptions", "core"})
@SourceDebugExtension(value={"SMAP\nwriteJson.kt\nKotlin\n*S Kotlin\n*F\n+ 1 writeJson.kt\norg/jetbrains/kotlinx/dataframe/impl/io/BufferedImageEncoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,404:1\n1#2:405\n*E\n"})
public final class BufferedImageEncoder
implements CustomEncoder {
    @NotNull
    private final Base64ImageEncodingOptions options;

    public BufferedImageEncoder(@NotNull Base64ImageEncodingOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.options = options;
    }

    @Override
    public boolean canEncode(@Nullable Object input) {
        return input instanceof BufferedImage;
    }

    @Override
    @NotNull
    public JsonElement encode(@Nullable Object input) {
        Object object;
        block3: {
            block2: {
                object = input;
                if (object == null) break block2;
                Object image = object;
                boolean bl = false;
                String string = this.encodeBufferedImageAsBase64((BufferedImage)image, this.options);
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        return (JsonElement)JsonElementKt.JsonPrimitive((String)object);
    }

    private final String encodeBufferedImageAsBase64(BufferedImage image, Base64ImageEncodingOptions imageEncodingOptions) {
        String string;
        try {
            BufferedImage preparedImage = imageEncodingOptions.isLimitSizeOn() ? ImageKt.resizeKeepingAspectRatio$default(image, imageEncodingOptions.getImageSizeLimit(), 0, null, null, null, null, 62, null) : image;
            byte[] bytes = imageEncodingOptions.isGzipOn() ? CompressionKt.encodeGzip(ImageKt.toByteArray$default(preparedImage, null, 1, null)) : ImageKt.toByteArray$default(preparedImage, null, 1, null);
            string = BytesUtilsKt.toBase64(bytes);
        }
        catch (IOException iOException) {
            string = "";
        }
        return string;
    }

    static /* synthetic */ String encodeBufferedImageAsBase64$default(BufferedImageEncoder bufferedImageEncoder, BufferedImage bufferedImage, Base64ImageEncodingOptions base64ImageEncodingOptions, int n, Object object) {
        if ((n & 2) != 0) {
            base64ImageEncodingOptions = new Base64ImageEncodingOptions(0, 0, 3, null);
        }
        return bufferedImageEncoder.encodeBufferedImageAsBase64(bufferedImage, base64ImageEncodingOptions);
    }
}

