/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ExtendedNotificationBrowserTask;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.WebDeploymentDataKeys;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTree;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeNode;
import java.awt.Component;
import java.util.Collections;
import javax.swing.Icon;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.NameScope;
import org.jetbrains.annotations.NotNull;

public class RemoteRenameAction
extends DumbAwareAction {
    public RemoteRenameAction() {
        this.setEnabledInModalContext(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RemoteRenameAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RemoteRenameAction.$$$reportNull$$$0(1);
        }
        boolean b = RemoteRenameAction.isEnabled(e.getDataContext());
        e.getPresentation().setEnabled(b);
        if (e.isFromContextMenu()) {
            e.getPresentation().setVisible(b);
        }
    }

    private static boolean isEnabled(DataContext context) {
        ServerTreeNode[] serverNodes = (ServerTreeNode[])WebDeploymentDataKeys.SERVER_NODES.getData(context);
        if (serverNodes == null || serverNodes.length != 1) {
            return false;
        }
        ServerTreeNode fileToRename = serverNodes[0];
        return !fileToRename.isRoot();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        String nameToRename;
        if (e == null) {
            RemoteRenameAction.$$$reportNull$$$0(2);
        }
        final RemoteConnection connection = (RemoteConnection)e.getData(WebDeploymentDataKeys.REMOTE_CONNECTION);
        FileObject[] serverObjects = (FileObject[])e.getData(WebDeploymentDataKeys.REMOTE_ITEMS);
        if (serverObjects == null || serverObjects.length != 1) {
            return;
        }
        final FileObject fileToRenameObject = serverObjects[0];
        String oldName = fileToRenameObject.getName().getBaseName();
        final ServerTree tree = (ServerTree)((Object)e.getData(WebDeploymentDataKeys.SERVER_TREE));
        if (tree == null) {
            return;
        }
        final Deployable server = (Deployable)e.getData(WebDeploymentDataKeys.DEPLOYABLE);
        if (server == null) {
            return;
        }
        Project project = e.getProject();
        Boolean isModalContext = (Boolean)e.getData(PlatformCoreDataKeys.IS_MODAL_CONTEXT);
        if (isModalContext == null) {
            return;
        }
        String newName = Messages.showInputDialog((Component)((Object)tree), (String)WDBundle.message("enter.new.name.for.0", oldName), (String)WDBundle.message("rename.dialog.title", new Object[0]), (Icon)Messages.getQuestionIcon(), (String)oldName, (InputValidator)new InputValidator(this){

            public boolean checkInput(String inputString) {
                if (StringUtil.isEmpty((String)inputString)) {
                    return false;
                }
                return !inputString.contains("\\") && !inputString.contains("/");
            }

            public boolean canClose(String inputString) {
                return true;
            }
        });
        if (newName != null && !oldName.equals(nameToRename = newName.trim())) {
            PublishConfig publishConfig2 = project != null ? PublishConfig.getInstance(project) : new PublishConfig(null);
            new ExtendedNotificationBrowserTask(this, project, ConnectionOwnerFactory.createConnectionOwner(project, (Component)((Object)tree)), publishConfig2, server, WDBundle.message("rename.server.node", oldName, newName), isModalContext, (Component)((Object)tree), WDBundle.message("rename.task.title", new Object[0]), DeploymentRevisionTracker.DEAF, true){

                @Override
                @NotNull
                protected TransferTask.ListBased.ResultWithErrors buildOperationsList(ExecutionContext context) {
                    TransferOperation.RemoteMoveOrCopy operation;
                    context.getProgressIndicator().checkCanceled();
                    context.getProgressIndicator().setText(WDBundle.message("processing.0", server.getPresentablePath(fileToRenameObject)));
                    try {
                        FileObject parent = fileToRenameObject.getParent();
                        final FileObject newFile = parent.resolveFile(nameToRename + (fileToRenameObject.getType() == FileType.FOLDER && server.getAccessType().equals((Object)AccessType.WEBDAV) ? "/" : ""), NameScope.CHILD);
                        operation = new TransferOperation.RemoteMoveOrCopy(fileToRenameObject, newFile, fileToRenameObject.getType() == FileType.FOLDER, false, true){

                            @Override
                            public void execute(ExecutionContext context) throws FileSystemException {
                                super.execute(context);
                                context.scheduleForSelection(server.getRemotePath(newFile), (Object)tree);
                            }
                        };
                    }
                    catch (FileSystemException ex) {
                        return new TransferTask.ListBased.ResultWithErrors(Collections.emptyList(), new DeploymentPathUtils.ErrorsAndExclusions());
                    }
                    return new TransferTask.ListBased.ResultWithErrors(Collections.singletonList(operation), new DeploymentPathUtils.ErrorsAndExclusions());
                }

                @Override
                protected RemoteConnection getExistingConnection() {
                    return connection;
                }
            }.queue();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/actions/RemoteRenameAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/actions/RemoteRenameAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

