/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 101198587726841L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(568319520 + 4761, -568319520 - -11300, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(568319520 + 4760, -568319520 - -12930, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 109524815928067L;
                thread = Thread.currentThread();
                boolean bl2 = SshAgentIpcService.y();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (bl2) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl3 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-1145158590 - -((char)-9217), 1145027520 + (char)-14702, (int)l2) + string + WindowsNamedPipeAgentIpc.b(-1145158590 - -((char)-9218), -1145158590 - -((char)-14299), (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-1145158590 - -((char)-9211), 1145158590 - (char)-6186, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        block17: {
            boolean bl;
            block19: {
                block18: {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
                    boolean bl2;
                    long l2;
                    block15: {
                        block16: {
                            l2 = 103366945814939L;
                            Object object = this.lock;
                            synchronized (object) {
                                boolean bl3;
                                bl2 = SshAgentIpcService.b();
                                boolean bl4 = false;
                                try {
                                    bl3 = this.connectionThread == null;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                if (!bl3) {
                                    boolean bl5 = false;
                                    String string = WindowsNamedPipeAgentIpc.b(-32112150 - -16628, 32112150 - 25031, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-32112150 - -16627, -32112150 - -14556, (int)l2) + this.state;
                                    throw new IllegalArgumentException(string.toString());
                                }
                                this.connectionThread = Thread.currentThread();
                                Unit unit = Unit.INSTANCE;
                            }
                            try {
                                try {
                                    WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                                    Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-32112150 - -16626, -32112150 - -22672, (int)l2));
                                    this.hPipe = hANDLE;
                                    windowsNamedPipeAgentIpc = this;
                                    if (!bl2) break block15;
                                    if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                                    }
                                    break block16;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-32112150 - -16617, 32112150 - 27365, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-32112150 - -16616, -32112150 - -27931, (int)l2) + ErrorToolsKt.kernel32LastError());
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        this.state = NamedPipeState.Open;
                        windowsNamedPipeAgentIpc = this;
                    }
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
                    boolean bl6 = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-32112150 - -16615, 32112150 - 31799, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-32112150 - -16617, 32112150 - 27365, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-32112150 - -16614, 32112150 - 15333, (int)l2));
                            if (ActionTimestamp.y() != null) break block17;
                            if (!bl2) break block18;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = false;
                        break block19;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = true;
            }
            SshAgentIpcService.y(bl);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                boolean bl;
                block6: {
                    long l2 = 120825208618860L;
                    bl = SshAgentIpcService.y();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (bl) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (bl) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        boolean bl;
        long l2;
        block27: {
            block28: {
                l2 = 119512889631108L;
                boolean bl2 = SshAgentIpcService.y();
                this.assertConnectionThread();
                Object object3 = this.lock;
                bl = bl2;
                synchronized (object3) {
                    boolean bl3;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl4 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (bl) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl5 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1129692330 - 25058, 1129692330 - (char)-21479, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1129692330 - 25054, -1129692330 - -18392, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1129692330 - 25057, -1129692330 - -16757, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl3 = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl3) {
                        boolean bl6 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1129692330 - 25054, -1129692330 - -18392, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1129692330 - 25056, -1129692330 - -((char)-25676), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl7 = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1129692330 - 25058, 1129692330 - (char)-21479, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1129692330 - 25054, -1129692330 - -18392, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1129692330 - 25055, 1129692330 - (char)-28280, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (bl) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl8 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1129692330 - 25058, 1129692330 - (char)-21479, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1129692330 - 25054, -1129692330 - -18392, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1129692330 - 25046, 1129692330 - 21427, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(1129692330 - 25054, -1129692330 - -18392, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1129692330 - 25045, 1129692330 - 24704, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl9;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl10 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (bl) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl9 = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl9) {
                boolean bl11 = false;
                String string = WindowsNamedPipeAgentIpc.b(1129692330 - 25054, -1129692330 - -18392, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1129692330 - 25056, -1129692330 - -((char)-25676), (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl12 = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1129692330 - 25058, 1129692330 - (char)-21479, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1129692330 - 25054, -1129692330 - -18392, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1129692330 - 25044, -1129692330 - -19145, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 120301461261928L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(572644830 + (char)-12612, 572775900 - (char)-2555, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 44100664303943L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(59898990 - 14522, 59898990 - 21507, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u0005_\u00cf\u00f3\u009f\u000e\u00d2\u0001@\u0015\u00db\u00acF\u00c6g\u00a4T\u00c9\u00d9\u0014z\u00e7 \u00e2y\u00ees\u0098\u00f6 \u00c8\u00de\u00e6q\u00b2\u00d9\u0003\u00a04\u00b6";
                        var4_3 = "\u0005_\u00cf\u00f3\u009f\u000e\u00d2\u0001@\u0015\u00db\u00acF\u00c6g\u00a4T\u00c9\u00d9\u0014z\u00e7 \u00e2y\u00ees\u0098\u00f6 \u00c8\u00de\u00e6q\u00b2\u00d9\u0003\u00a04\u00b6".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 41;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 7;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 60;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 87;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 19;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 119;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 14;
                                        break;
                                    }
                                    default: {
                                        v11 = 21;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0xFFFFE2F2) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 134;
                            case 1 -> 107;
                            case 2 -> 188;
                            case 3 -> 223;
                            case 4 -> 40;
                            case 5 -> 45;
                            case 6 -> 114;
                            case 7 -> 155;
                            case 8 -> 174;
                            case 9 -> 203;
                            case 10 -> 41;
                            case 11 -> 121;
                            case 12 -> 58;
                            case 13 -> 77;
                            case 14 -> 31;
                            case 15 -> 3;
                            case 16 -> 7;
                            case 17 -> 236;
                            case 18 -> 71;
                            case 19 -> 101;
                            case 20 -> 72;
                            case 21 -> 172;
                            case 22 -> 23;
                            case 23 -> 247;
                            case 24 -> 207;
                            case 25 -> 170;
                            case 26 -> 150;
                            case 27 -> 80;
                            case 28 -> 37;
                            case 29 -> 214;
                            case 30 -> 147;
                            case 31 -> 148;
                            case 32 -> 99;
                            case 33 -> 56;
                            case 34 -> 25;
                            case 35 -> 229;
                            case 36 -> 198;
                            case 37 -> 46;
                            case 38 -> 255;
                            case 39 -> 97;
                            case 40 -> 199;
                            case 41 -> 84;
                            case 42 -> 44;
                            case 43 -> 122;
                            case 44 -> 171;
                            case 45 -> 8;
                            case 46 -> 154;
                            case 47 -> 234;
                            case 48 -> 213;
                            case 49 -> 182;
                            case 50 -> 196;
                            case 51 -> 55;
                            case 52 -> 66;
                            case 53 -> 241;
                            case 54 -> 194;
                            case 55 -> 191;
                            case 56 -> 68;
                            case 57 -> 16;
                            case 58 -> 81;
                            case 59 -> 233;
                            case 60 -> 4;
                            case 61 -> 216;
                            case 62 -> 113;
                            case 63 -> 54;
                            case 64 -> 0;
                            case 65 -> 62;
                            case 66 -> 187;
                            case 67 -> 117;
                            case 68 -> 43;
                            case 69 -> 76;
                            case 70 -> 20;
                            case 71 -> 13;
                            case 72 -> 119;
                            case 73 -> 125;
                            case 74 -> 219;
                            case 75 -> 105;
                            case 76 -> 87;
                            case 77 -> 166;
                            case 78 -> 161;
                            case 79 -> 248;
                            case 80 -> 185;
                            case 81 -> 140;
                            case 82 -> 120;
                            case 83 -> 96;
                            case 84 -> 242;
                            case 85 -> 18;
                            case 86 -> 180;
                            case 87 -> 24;
                            case 88 -> 104;
                            case 89 -> 164;
                            case 90 -> 27;
                            case 91 -> 240;
                            case 92 -> 159;
                            case 93 -> 103;
                            case 94 -> 126;
                            case 95 -> 51;
                            case 96 -> 135;
                            case 97 -> 173;
                            case 98 -> 232;
                            case 99 -> 130;
                            case 100 -> 246;
                            case 101 -> 190;
                            case 102 -> 129;
                            case 103 -> 162;
                            case 104 -> 243;
                            case 105 -> 228;
                            case 106 -> 59;
                            case 107 -> 53;
                            case 108 -> 116;
                            case 109 -> 235;
                            case 110 -> 19;
                            case 111 -> 39;
                            case 112 -> 132;
                            case 113 -> 109;
                            case 114 -> 225;
                            case 115 -> 138;
                            case 116 -> 197;
                            case 117 -> 239;
                            case 118 -> 124;
                            case 119 -> 136;
                            case 120 -> 12;
                            case 121 -> 90;
                            case 122 -> 210;
                            case 123 -> 156;
                            case 124 -> 224;
                            case 125 -> 131;
                            case 126 -> 175;
                            case 127 -> 9;
                            case 128 -> 6;
                            case 129 -> 111;
                            case 130 -> 93;
                            case 131 -> 42;
                            case 132 -> 146;
                            case 133 -> 35;
                            case 134 -> 205;
                            case 135 -> 106;
                            case 136 -> 230;
                            case 137 -> 245;
                            case 138 -> 179;
                            case 139 -> 153;
                            case 140 -> 110;
                            case 141 -> 149;
                            case 142 -> 22;
                            case 143 -> 202;
                            case 144 -> 252;
                            case 145 -> 192;
                            case 146 -> 178;
                            case 147 -> 52;
                            case 148 -> 211;
                            case 149 -> 142;
                            case 150 -> 102;
                            case 151 -> 32;
                            case 152 -> 206;
                            case 153 -> 1;
                            case 154 -> 189;
                            case 155 -> 184;
                            case 156 -> 204;
                            case 157 -> 26;
                            case 158 -> 94;
                            case 159 -> 50;
                            case 160 -> 221;
                            case 161 -> 158;
                            case 162 -> 92;
                            case 163 -> 226;
                            case 164 -> 217;
                            case 165 -> 57;
                            case 166 -> 151;
                            case 167 -> 28;
                            case 168 -> 83;
                            case 169 -> 251;
                            case 170 -> 168;
                            case 171 -> 29;
                            case 172 -> 128;
                            case 173 -> 98;
                            case 174 -> 70;
                            case 175 -> 137;
                            case 176 -> 169;
                            case 177 -> 144;
                            case 178 -> 167;
                            case 179 -> 139;
                            case 180 -> 133;
                            case 181 -> 108;
                            case 182 -> 127;
                            case 183 -> 176;
                            case 184 -> 237;
                            case 185 -> 100;
                            case 186 -> 89;
                            case 187 -> 63;
                            case 188 -> 227;
                            case 189 -> 200;
                            case 190 -> 10;
                            case 191 -> 78;
                            case 192 -> 183;
                            case 193 -> 15;
                            case 194 -> 88;
                            case 195 -> 250;
                            case 196 -> 212;
                            case 197 -> 38;
                            case 198 -> 193;
                            case 199 -> 249;
                            case 200 -> 195;
                            case 201 -> 75;
                            case 202 -> 208;
                            case 203 -> 143;
                            case 204 -> 220;
                            case 205 -> 222;
                            case 206 -> 67;
                            case 207 -> 33;
                            case 208 -> 5;
                            case 209 -> 17;
                            case 210 -> 14;
                            case 211 -> 181;
                            case 212 -> 65;
                            case 213 -> 64;
                            case 214 -> 69;
                            case 215 -> 30;
                            case 216 -> 152;
                            case 217 -> 48;
                            case 218 -> 244;
                            case 219 -> 60;
                            case 220 -> 115;
                            case 221 -> 91;
                            case 222 -> 49;
                            case 223 -> 163;
                            case 224 -> 118;
                            case 225 -> 85;
                            case 226 -> 218;
                            case 227 -> 74;
                            case 228 -> 47;
                            case 229 -> 123;
                            case 230 -> 73;
                            case 231 -> 2;
                            case 232 -> 254;
                            case 233 -> 11;
                            case 234 -> 201;
                            case 235 -> 82;
                            case 236 -> 186;
                            case 237 -> 21;
                            case 238 -> 141;
                            case 239 -> 215;
                            case 240 -> 253;
                            case 241 -> 112;
                            case 242 -> 145;
                            case 243 -> 165;
                            case 244 -> 157;
                            case 245 -> 209;
                            case 246 -> 231;
                            case 247 -> 61;
                            case 248 -> 177;
                            case 249 -> 238;
                            case 250 -> 34;
                            case 251 -> 160;
                            case 252 -> 36;
                            case 253 -> 95;
                            case 254 -> 86;
                            default -> 79;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (bl) {
                ActionTimestamp.y("L3MCp");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 29046206334427L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    boolean bl2 = SshAgentIpcService.b();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (!bl2) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-657447120 + -10393, -657447120 + -29282, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-657447120 + -10397, 657447120 + 22177, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-657447120 + -10408, -657447120 + -28244, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-657447120 + -10393, -657447120 + -29282, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-657447120 + -10397, 657447120 + 22177, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-657447120 + -10401, 657447120 + 21387, (int)l3) + ErrorToolsKt.prettyHRESULT((int)n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    boolean bl2;
                    block13: {
                        long l2 = 50686058915205L;
                        boolean bl3 = SshAgentIpcService.y();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(1149877110 - (char)-25434, -1149877110 - -((char)-30479), (int)l2));
                        bl2 = bl3;
                        try {
                            try {
                                try {
                                    try {
                                        if (bl2 || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (bl2) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(1149877110 - (char)-25437, 1149877110 - (char)-25582, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (bl2) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        boolean bl;
        long l2;
        block25: {
            block26: {
                l2 = 113272287290909L;
                boolean bl2 = SshAgentIpcService.b();
                this.assertConnectionThread();
                bl = bl2;
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl3;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl4 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (!bl) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (!bl) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl5 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1114750350 + 24515, 1114750350 + (char)-26246, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1114750350 + 24519, -1114750350 + -30139, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1114750350 + 24508, -1114750350 + -((char)-20250), (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl3 = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl3) {
                        boolean bl6 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1114750350 + 24519, -1114750350 + -30139, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1114750350 + 24517, -1114750350 + -((char)-22049), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl7 = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1114750350 + 24515, 1114750350 + (char)-26246, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1114750350 + 24519, -1114750350 + -30139, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1114750350 + 24503, -1114750350 + -31565, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (!bl) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl7 = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1114750350 + 24515, 1114750350 + (char)-26246, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1114750350 + 24519, -1114750350 + -30139, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1114750350 + 24502, 1114750350 + (char)-28590, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl8 = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (!bl) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl9 = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1114750350 + 24515, 1114750350 + (char)-26246, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1114750350 + 24519, -1114750350 + -30139, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1114750350 + 24505, -1114750350 + -((char)-21906), (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                boolean bl2;
                block16: {
                    l2 = 53014235854621L;
                    Object object = this.lock;
                    bl2 = SshAgentIpcService.b();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl3 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (!bl2) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl4 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1454483790 + (char)-23805, 1454483790 + 23738, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(1454483790 + (char)-23801, -1454483790 + -((char)-18181), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1454483790 + (char)-23816, -1454483790 + -26164, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(1454483790 + (char)-23821, -1454483790 + -32713, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1454483790 + (char)-23805, 1454483790 + 23738, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1454483790 + (char)-23801, -1454483790 + -((char)-18181), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1454483790 + (char)-23822, -1454483790 + -32598, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (!bl2) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (!bl2) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl5 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1454483790 + (char)-23805, 1454483790 + 23738, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(1454483790 + (char)-23801, -1454483790 + -((char)-18181), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1454483790 + (char)-23819, 1454483790 + 25600, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1454483790 + (char)-23805, 1454483790 + 23738, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1454483790 + (char)-23801, -1454483790 + -((char)-18181), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1454483790 + (char)-23820, -1454483790 + -31587, (int)l2));
                    if (!bl2) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1454483790 + (char)-23805, 1454483790 + 23738, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1454483790 + (char)-23801, -1454483790 + -((char)-18181), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1454483790 + (char)-23761, 1454483790 + (char)-14310, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1454483790 + (char)-23762, 1454483790 + (char)-28100, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "G\u00bb\u0017\u0005j\u0012\u00deH\u0014\u00adCr\u00fd8\u0085;\u00a0l\u0010\u00d1\u0089\u00eb\u0005\u00c8\u0094\u001d\u00119\u00b8\u0006\u0081=\u00cf\u00d5\u001bI\u0018r\u0015\u00e9\u0007\u00c9\u001f\u00073#\u001f7\u0018Q\u00c8\u00cd\u00af\u0014\u001f6\u00e4\u00c6\u00d9\u00c9>\t\u00fb\u00a7F\u00e0W|\u00cc\u0017f\u0005T\u00b3u\u0004V\b\u0012\u009b\u00bdpm\u009a8\u00bb\u0014\u00a3=\u00cb\u00a9b\u0007Eg\u00cd5N\u0099R\u00a4DM\u009e\u00f9\u00b0\u00e7\u0005\u009a\u00ae\u00ac\u00a7m\u001ei\u0006\u00c7\u00d6\u009d\u00e1/\u0096\u0083\u00bfh\u008b\u00f6\u009a\u009b\u0081?K\u0081\u009a\u009c9\u008e\u00ef\u00da\u00d3\u00de\u0094\u00ba\u00a2\u0010n\u00cd\u00c3jJD#\u00db\u007f\u00a4z\u0015\u00b2\u001c\u00bc\u00ce\tX\u00b0\u00e4\u0013P%\n\u00a3P\u0010;\u00f8i\u00cc\u001f\u0090\u0089A*\u00f7\u00d0\u007f\u00e7Q\u0016g?\u007f\u009e\r\u00c5\u00c9\u008a \u0097\u0013N?N\u00a3\u00d4\fq\b0\u001a0a>JiR\u00eb\u00c2'\u000e\u0082\u00b7U\u00f2\u00ef\u00ab\u00b2hL-\f0\u0097\u00e38\u00ecw\u00f7#\u00e1\u00d0\u00f4\u00c5\u00a7aS\u00c1\u009f/R\u00cabk6\b\u0001\u00a6\u00df\u00d7!n\u00b1%\fO\u009c\u0006\u008b\u0007\u0087\u009b\u001fAt\u00ef\u000bF\u00c3\u009a\u0097K5\u009f\u00dd\u001c\u0089\u0018\u00fcBM]\u00cef\u00ac\u00b5\u008e/\u00e1\u008fYm\u0006@\u00bbY\u009ed\u009f\u00b5\u00cbEN\u00c6\u000e\u008fJ\u00b0O\u0015\u0087\u0093\u00be\u0087\u00e9@\u00c5D\u0016\u00fd\u0014\u00f03\u00e8\f~\u00b6\\\u00cd\u00d0\u009f\u00dfT\u00ae@\u00f28\u00c2\u001f\u00bb[\u009d}\u00d6\u0094F8\u00aej\u00cd1B\u00d0\u0006y\u00f7\u00bc\u00e5\u00ae\u00db?\u00b1\u0084\\n\u0019\u00ef_<\u00a5\u000b\u00b4\u0097y\u00ea\u00e8\u00abf\u009a\u00fe\u00c8\u0012\u00151L\u00c9\u0092\u00f9\u00cc\u00a8\u000b\u0019\u001a&\u00f4\u0081\u00c4c\u00ad\u00a0\u00b2\u00d2\u0016\u000b)\u00eb5\u0097\u00b0\u0097-n\u000f\u00ab\u008cm\u00edRA\u009aN;\u00d2\u00a7\u00c4c\n`:\t\u00f0dD\u00df\u00bd7\u00b0 @U\u00ebs7n\u000eh\u0007%`D\u0000\u00c9f>\u0007*n\u00c1\u00ad\u009e<\u00c2(\u00dd_\u001d\u00dcv\u00ca\u00a4\u00d4\u0082 bN\u0090\u00b4\u0080s\u007f\u00d8\u0081\u00c6\u00c6t\u00bb>\u00e2\u00cc\u00af\u00b8\u0091B%V\u0099\u00f7\u00fc\u00b0\u00fc!\f?\u000f\u00eav\u00b5\u00d0\u008b'\u00be\u00aa\u00b4b\u0005W\u00dc\u00c3\u0097\"\u0002c\u00aaz0t\u009a$5\u00e9\u00beA+\u00d8\u00d1\u00b3\u00b9D}T\u00d2\u0018\u00f6(H\u00e6\u0081XG\f\u0086\u00818\u0095\u000e\u00f8\u00e4\u00f7\u0082\u00c3m\u00b7\u00e3\u0095K!rTm\u001b\u00df\f\u0014\u009aD\u00db\u00d2in\u009d\u00d3\u00a9Z \u00d9\u00ba\u0010\u00cf\u00f5\u00b9\u00f8\u0091\u00c0\u00bf\u00c5ye\n\u0089E\u001a\u00b4\u0091\u00fa\u00bbg\u00e8>\u0018\u00d3C\u0095~u\u00fb\u00d53\u0090\u001f\u00cef@\u008af\u00ce\u0090@21x\u00cb\u008b\u00a7)\u00c5\u00e9R+/^yaIA1T\u00dd\u007f\u00f4\u00f2\u00880\u000e]l)\u00c8Rio\u00f5[\u00be\u0002\u00a0\u00d6\u00f7Rz=H\u00c9\t\u00d1\u0084\t\u001b\u00b6\u008c\u00cdW1\u00bcz;";
                var4_3 = "G\u00bb\u0017\u0005j\u0012\u00deH\u0014\u00adCr\u00fd8\u0085;\u00a0l\u0010\u00d1\u0089\u00eb\u0005\u00c8\u0094\u001d\u00119\u00b8\u0006\u0081=\u00cf\u00d5\u001bI\u0018r\u0015\u00e9\u0007\u00c9\u001f\u00073#\u001f7\u0018Q\u00c8\u00cd\u00af\u0014\u001f6\u00e4\u00c6\u00d9\u00c9>\t\u00fb\u00a7F\u00e0W|\u00cc\u0017f\u0005T\u00b3u\u0004V\b\u0012\u009b\u00bdpm\u009a8\u00bb\u0014\u00a3=\u00cb\u00a9b\u0007Eg\u00cd5N\u0099R\u00a4DM\u009e\u00f9\u00b0\u00e7\u0005\u009a\u00ae\u00ac\u00a7m\u001ei\u0006\u00c7\u00d6\u009d\u00e1/\u0096\u0083\u00bfh\u008b\u00f6\u009a\u009b\u0081?K\u0081\u009a\u009c9\u008e\u00ef\u00da\u00d3\u00de\u0094\u00ba\u00a2\u0010n\u00cd\u00c3jJD#\u00db\u007f\u00a4z\u0015\u00b2\u001c\u00bc\u00ce\tX\u00b0\u00e4\u0013P%\n\u00a3P\u0010;\u00f8i\u00cc\u001f\u0090\u0089A*\u00f7\u00d0\u007f\u00e7Q\u0016g?\u007f\u009e\r\u00c5\u00c9\u008a \u0097\u0013N?N\u00a3\u00d4\fq\b0\u001a0a>JiR\u00eb\u00c2'\u000e\u0082\u00b7U\u00f2\u00ef\u00ab\u00b2hL-\f0\u0097\u00e38\u00ecw\u00f7#\u00e1\u00d0\u00f4\u00c5\u00a7aS\u00c1\u009f/R\u00cabk6\b\u0001\u00a6\u00df\u00d7!n\u00b1%\fO\u009c\u0006\u008b\u0007\u0087\u009b\u001fAt\u00ef\u000bF\u00c3\u009a\u0097K5\u009f\u00dd\u001c\u0089\u0018\u00fcBM]\u00cef\u00ac\u00b5\u008e/\u00e1\u008fYm\u0006@\u00bbY\u009ed\u009f\u00b5\u00cbEN\u00c6\u000e\u008fJ\u00b0O\u0015\u0087\u0093\u00be\u0087\u00e9@\u00c5D\u0016\u00fd\u0014\u00f03\u00e8\f~\u00b6\\\u00cd\u00d0\u009f\u00dfT\u00ae@\u00f28\u00c2\u001f\u00bb[\u009d}\u00d6\u0094F8\u00aej\u00cd1B\u00d0\u0006y\u00f7\u00bc\u00e5\u00ae\u00db?\u00b1\u0084\\n\u0019\u00ef_<\u00a5\u000b\u00b4\u0097y\u00ea\u00e8\u00abf\u009a\u00fe\u00c8\u0012\u00151L\u00c9\u0092\u00f9\u00cc\u00a8\u000b\u0019\u001a&\u00f4\u0081\u00c4c\u00ad\u00a0\u00b2\u00d2\u0016\u000b)\u00eb5\u0097\u00b0\u0097-n\u000f\u00ab\u008cm\u00edRA\u009aN;\u00d2\u00a7\u00c4c\n`:\t\u00f0dD\u00df\u00bd7\u00b0 @U\u00ebs7n\u000eh\u0007%`D\u0000\u00c9f>\u0007*n\u00c1\u00ad\u009e<\u00c2(\u00dd_\u001d\u00dcv\u00ca\u00a4\u00d4\u0082 bN\u0090\u00b4\u0080s\u007f\u00d8\u0081\u00c6\u00c6t\u00bb>\u00e2\u00cc\u00af\u00b8\u0091B%V\u0099\u00f7\u00fc\u00b0\u00fc!\f?\u000f\u00eav\u00b5\u00d0\u008b'\u00be\u00aa\u00b4b\u0005W\u00dc\u00c3\u0097\"\u0002c\u00aaz0t\u009a$5\u00e9\u00beA+\u00d8\u00d1\u00b3\u00b9D}T\u00d2\u0018\u00f6(H\u00e6\u0081XG\f\u0086\u00818\u0095\u000e\u00f8\u00e4\u00f7\u0082\u00c3m\u00b7\u00e3\u0095K!rTm\u001b\u00df\f\u0014\u009aD\u00db\u00d2in\u009d\u00d3\u00a9Z \u00d9\u00ba\u0010\u00cf\u00f5\u00b9\u00f8\u0091\u00c0\u00bf\u00c5ye\n\u0089E\u001a\u00b4\u0091\u00fa\u00bbg\u00e8>\u0018\u00d3C\u0095~u\u00fb\u00d53\u0090\u001f\u00cef@\u008af\u00ce\u0090@21x\u00cb\u008b\u00a7)\u00c5\u00e9R+/^yaIA1T\u00dd\u007f\u00f4\u00f2\u00880\u000e]l)\u00c8Rio\u00f5[\u00be\u0002\u00a0\u00d6\u00f7Rz=H\u00c9\t\u00d1\u0084\t\u001b\u00b6\u008c\u00cdW1\u00bcz;".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 96;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00f5\u0013\u00bc\u009c\u001a@7Jh\u00cc\u00fd\r\u00ac\u00bc2b\u00b8\u00c6\u00b0\u00ef\u0006\u00a8\u009eT\u00e0[\u00bdp\u00cf\u0014z\u00c5`\u00c5\u0092j\u0086\u00b53Z\u00d2(c\u00d91\u00e7\u00ca\u0097+\u0080";
                    var4_3 = "\u00f5\u0013\u00bc\u009c\u001a@7Jh\u00cc\u00fd\r\u00ac\u00bc2b\u00b8\u00c6\u00b0\u00ef\u0006\u00a8\u009eT\u00e0[\u00bdp\u00cf\u0014z\u00c5`\u00c5\u0092j\u0086\u00b53Z\u00d2(c\u00d91\u00e7\u00ca\u0097+\u0080".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 4;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 69;
                            break;
                        }
                        case 1: {
                            v15 = 104;
                            break;
                        }
                        case 2: {
                            v15 = 53;
                            break;
                        }
                        case 3: {
                            v15 = 50;
                            break;
                        }
                        case 4: {
                            v15 = 108;
                            break;
                        }
                        case 5: {
                            v15 = 48;
                            break;
                        }
                        default: {
                            v15 = 92;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x7B40) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 142;
                case 1 -> 213;
                case 2 -> 215;
                case 3 -> 139;
                case 4 -> 4;
                case 5 -> 146;
                case 6 -> 165;
                case 7 -> 158;
                case 8 -> 134;
                case 9 -> 222;
                case 10 -> 254;
                case 11 -> 135;
                case 12 -> 19;
                case 13 -> 241;
                case 14 -> 252;
                case 15 -> 101;
                case 16 -> 97;
                case 17 -> 89;
                case 18 -> 44;
                case 19 -> 147;
                case 20 -> 217;
                case 21 -> 246;
                case 22 -> 77;
                case 23 -> 208;
                case 24 -> 7;
                case 25 -> 75;
                case 26 -> 39;
                case 27 -> 36;
                case 28 -> 192;
                case 29 -> 47;
                case 30 -> 156;
                case 31 -> 43;
                case 32 -> 27;
                case 33 -> 138;
                case 34 -> 247;
                case 35 -> 145;
                case 36 -> 112;
                case 37 -> 106;
                case 38 -> 0;
                case 39 -> 224;
                case 40 -> 15;
                case 41 -> 6;
                case 42 -> 144;
                case 43 -> 118;
                case 44 -> 251;
                case 45 -> 214;
                case 46 -> 9;
                case 47 -> 191;
                case 48 -> 51;
                case 49 -> 195;
                case 50 -> 238;
                case 51 -> 181;
                case 52 -> 104;
                case 53 -> 54;
                case 54 -> 152;
                case 55 -> 80;
                case 56 -> 216;
                case 57 -> 137;
                case 58 -> 23;
                case 59 -> 37;
                case 60 -> 109;
                case 61 -> 25;
                case 62 -> 78;
                case 63 -> 52;
                case 64 -> 177;
                case 65 -> 182;
                case 66 -> 31;
                case 67 -> 53;
                case 68 -> 42;
                case 69 -> 221;
                case 70 -> 233;
                case 71 -> 113;
                case 72 -> 18;
                case 73 -> 160;
                case 74 -> 202;
                case 75 -> 24;
                case 76 -> 40;
                case 77 -> 206;
                case 78 -> 187;
                case 79 -> 225;
                case 80 -> 62;
                case 81 -> 84;
                case 82 -> 220;
                case 83 -> 115;
                case 84 -> 244;
                case 85 -> 189;
                case 86 -> 148;
                case 87 -> 237;
                case 88 -> 126;
                case 89 -> 21;
                case 90 -> 239;
                case 91 -> 81;
                case 92 -> 98;
                case 93 -> 183;
                case 94 -> 255;
                case 95 -> 58;
                case 96 -> 230;
                case 97 -> 91;
                case 98 -> 235;
                case 99 -> 188;
                case 100 -> 2;
                case 101 -> 186;
                case 102 -> 204;
                case 103 -> 79;
                case 104 -> 180;
                case 105 -> 122;
                case 106 -> 86;
                case 107 -> 120;
                case 108 -> 198;
                case 109 -> 20;
                case 110 -> 157;
                case 111 -> 234;
                case 112 -> 197;
                case 113 -> 211;
                case 114 -> 162;
                case 115 -> 88;
                case 116 -> 82;
                case 117 -> 200;
                case 118 -> 178;
                case 119 -> 41;
                case 120 -> 143;
                case 121 -> 57;
                case 122 -> 63;
                case 123 -> 242;
                case 124 -> 166;
                case 125 -> 99;
                case 126 -> 90;
                case 127 -> 176;
                case 128 -> 248;
                case 129 -> 174;
                case 130 -> 124;
                case 131 -> 16;
                case 132 -> 102;
                case 133 -> 253;
                case 134 -> 28;
                case 135 -> 111;
                case 136 -> 218;
                case 137 -> 207;
                case 138 -> 71;
                case 139 -> 205;
                case 140 -> 73;
                case 141 -> 203;
                case 142 -> 150;
                case 143 -> 161;
                case 144 -> 159;
                case 145 -> 240;
                case 146 -> 179;
                case 147 -> 96;
                case 148 -> 22;
                case 149 -> 173;
                case 150 -> 92;
                case 151 -> 87;
                case 152 -> 141;
                case 153 -> 130;
                case 154 -> 209;
                case 155 -> 132;
                case 156 -> 11;
                case 157 -> 60;
                case 158 -> 10;
                case 159 -> 212;
                case 160 -> 210;
                case 161 -> 226;
                case 162 -> 100;
                case 163 -> 72;
                case 164 -> 125;
                case 165 -> 228;
                case 166 -> 190;
                case 167 -> 123;
                case 168 -> 35;
                case 169 -> 127;
                case 170 -> 26;
                case 171 -> 103;
                case 172 -> 116;
                case 173 -> 153;
                case 174 -> 107;
                case 175 -> 30;
                case 176 -> 74;
                case 177 -> 201;
                case 178 -> 223;
                case 179 -> 3;
                case 180 -> 231;
                case 181 -> 114;
                case 182 -> 193;
                case 183 -> 64;
                case 184 -> 17;
                case 185 -> 65;
                case 186 -> 128;
                case 187 -> 184;
                case 188 -> 76;
                case 189 -> 5;
                case 190 -> 69;
                case 191 -> 219;
                case 192 -> 194;
                case 193 -> 34;
                case 194 -> 61;
                case 195 -> 164;
                case 196 -> 175;
                case 197 -> 93;
                case 198 -> 8;
                case 199 -> 70;
                case 200 -> 29;
                case 201 -> 154;
                case 202 -> 243;
                case 203 -> 56;
                case 204 -> 129;
                case 205 -> 33;
                case 206 -> 140;
                case 207 -> 67;
                case 208 -> 229;
                case 209 -> 245;
                case 210 -> 119;
                case 211 -> 196;
                case 212 -> 169;
                case 213 -> 149;
                case 214 -> 199;
                case 215 -> 14;
                case 216 -> 83;
                case 217 -> 155;
                case 218 -> 49;
                case 219 -> 227;
                case 220 -> 13;
                case 221 -> 50;
                case 222 -> 249;
                case 223 -> 136;
                case 224 -> 121;
                case 225 -> 250;
                case 226 -> 95;
                case 227 -> 105;
                case 228 -> 133;
                case 229 -> 68;
                case 230 -> 151;
                case 231 -> 94;
                case 232 -> 236;
                case 233 -> 168;
                case 234 -> 12;
                case 235 -> 32;
                case 236 -> 48;
                case 237 -> 108;
                case 238 -> 232;
                case 239 -> 170;
                case 240 -> 172;
                case 241 -> 59;
                case 242 -> 110;
                case 243 -> 131;
                case 244 -> 1;
                case 245 -> 66;
                case 246 -> 117;
                case 247 -> 45;
                case 248 -> 185;
                case 249 -> 171;
                case 250 -> 163;
                case 251 -> 55;
                case 252 -> 46;
                case 253 -> 85;
                case 254 -> 167;
                default -> 38;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 53480425903445L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(506847690 + (char)-30014, 506847690 + (char)-29629, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        boolean bl2;
                        block4: {
                            l2 = 47634572582203L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            bl2 = SshAgentIpcService.y();
                            try {
                                hANDLE2 = hANDLE;
                                if (bl2) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (bl2) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl3 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(909625800 + (char)-9445, -909756870 - -((char)-1260), (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(909625800 + (char)-9448, 909625800 + (char)-14509, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(909625800 + (char)-9447, 909625800 + (char)-2989, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00b0fR\u0013\u00ba|\u00d1\u0081\u0010\u00e6qiPg\u00af\u0093\u00a2\u00e30D\u00ff\u00d9T\u00d5M";
                    var4_3 = "\u00b0fR\u0013\u00ba|\u00d1\u0081\u0010\u00e6qiPg\u00af\u0093\u00a2\u00e30D\u00ff\u00d9T\u00d5M".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 14;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u008b\u0002'\u008dv5Y\u00aaj\u00f4\r\u0010\u00d4\u00ecnPu!\u001aw\u00ba\u00b1i^\u00cb\u00d2@\u00f1Zm\u008e\u00ae\u00f8\u00a2\u00cf\u009a\u00f7\u00ael\u0092{J/\u00d0>\u009e\\\u00ed\u00ef\u0007\u0091\u00c4\u00c0y\u00b4{\u00d5<y";
                        var4_3 = "\u008b\u0002'\u008dv5Y\u00aaj\u00f4\r\u0010\u00d4\u00ecnPu!\u001aw\u00ba\u00b1i^\u00cb\u00d2@\u00f1Zm\u008e\u00ae\u00f8\u00a2\u00cf\u009a\u00f7\u00ael\u0092{J/\u00d0>\u009e\\\u00ed\u00ef\u0007\u0091\u00c4\u00c0y\u00b4{\u00d5<y".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 30;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 46;
                                break;
                            }
                            case 1: {
                                v15 = 66;
                                break;
                            }
                            case 2: {
                                v15 = 64;
                                break;
                            }
                            case 3: {
                                v15 = 121;
                                break;
                            }
                            case 4: {
                                v15 = 25;
                                break;
                            }
                            case 5: {
                                v15 = 86;
                                break;
                            }
                            default: {
                                v15 = 68;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFB9D9) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 78;
                    case 1 -> 183;
                    case 2 -> 175;
                    case 3 -> 68;
                    case 4 -> 54;
                    case 5 -> 222;
                    case 6 -> 43;
                    case 7 -> 244;
                    case 8 -> 122;
                    case 9 -> 178;
                    case 10 -> 239;
                    case 11 -> 87;
                    case 12 -> 89;
                    case 13 -> 194;
                    case 14 -> 88;
                    case 15 -> 132;
                    case 16 -> 245;
                    case 17 -> 162;
                    case 18 -> 8;
                    case 19 -> 185;
                    case 20 -> 242;
                    case 21 -> 48;
                    case 22 -> 99;
                    case 23 -> 208;
                    case 24 -> 189;
                    case 25 -> 180;
                    case 26 -> 20;
                    case 27 -> 24;
                    case 28 -> 235;
                    case 29 -> 109;
                    case 30 -> 221;
                    case 31 -> 153;
                    case 32 -> 104;
                    case 33 -> 15;
                    case 34 -> 102;
                    case 35 -> 72;
                    case 36 -> 96;
                    case 37 -> 227;
                    case 38 -> 207;
                    case 39 -> 172;
                    case 40 -> 151;
                    case 41 -> 170;
                    case 42 -> 141;
                    case 43 -> 161;
                    case 44 -> 123;
                    case 45 -> 177;
                    case 46 -> 94;
                    case 47 -> 56;
                    case 48 -> 60;
                    case 49 -> 41;
                    case 50 -> 223;
                    case 51 -> 127;
                    case 52 -> 50;
                    case 53 -> 176;
                    case 54 -> 199;
                    case 55 -> 152;
                    case 56 -> 34;
                    case 57 -> 164;
                    case 58 -> 233;
                    case 59 -> 63;
                    case 60 -> 79;
                    case 61 -> 65;
                    case 62 -> 118;
                    case 63 -> 148;
                    case 64 -> 216;
                    case 65 -> 42;
                    case 66 -> 252;
                    case 67 -> 53;
                    case 68 -> 74;
                    case 69 -> 155;
                    case 70 -> 70;
                    case 71 -> 93;
                    case 72 -> 86;
                    case 73 -> 3;
                    case 74 -> 19;
                    case 75 -> 181;
                    case 76 -> 119;
                    case 77 -> 28;
                    case 78 -> 100;
                    case 79 -> 117;
                    case 80 -> 114;
                    case 81 -> 247;
                    case 82 -> 66;
                    case 83 -> 166;
                    case 84 -> 95;
                    case 85 -> 112;
                    case 86 -> 35;
                    case 87 -> 37;
                    case 88 -> 224;
                    case 89 -> 131;
                    case 90 -> 139;
                    case 91 -> 147;
                    case 92 -> 134;
                    case 93 -> 32;
                    case 94 -> 111;
                    case 95 -> 187;
                    case 96 -> 138;
                    case 97 -> 7;
                    case 98 -> 12;
                    case 99 -> 203;
                    case 100 -> 69;
                    case 101 -> 97;
                    case 102 -> 136;
                    case 103 -> 217;
                    case 104 -> 21;
                    case 105 -> 205;
                    case 106 -> 210;
                    case 107 -> 129;
                    case 108 -> 232;
                    case 109 -> 215;
                    case 110 -> 254;
                    case 111 -> 29;
                    case 112 -> 169;
                    case 113 -> 13;
                    case 114 -> 26;
                    case 115 -> 246;
                    case 116 -> 220;
                    case 117 -> 92;
                    case 118 -> 62;
                    case 119 -> 154;
                    case 120 -> 18;
                    case 121 -> 49;
                    case 122 -> 25;
                    case 123 -> 248;
                    case 124 -> 105;
                    case 125 -> 159;
                    case 126 -> 55;
                    case 127 -> 58;
                    case 128 -> 201;
                    case 129 -> 219;
                    case 130 -> 168;
                    case 131 -> 81;
                    case 132 -> 149;
                    case 133 -> 193;
                    case 134 -> 150;
                    case 135 -> 121;
                    case 136 -> 45;
                    case 137 -> 218;
                    case 138 -> 198;
                    case 139 -> 250;
                    case 140 -> 76;
                    case 141 -> 39;
                    case 142 -> 91;
                    case 143 -> 57;
                    case 144 -> 120;
                    case 145 -> 206;
                    case 146 -> 124;
                    case 147 -> 255;
                    case 148 -> 23;
                    case 149 -> 90;
                    case 150 -> 226;
                    case 151 -> 196;
                    case 152 -> 0;
                    case 153 -> 1;
                    case 154 -> 126;
                    case 155 -> 197;
                    case 156 -> 36;
                    case 157 -> 142;
                    case 158 -> 186;
                    case 159 -> 38;
                    case 160 -> 165;
                    case 161 -> 64;
                    case 162 -> 52;
                    case 163 -> 179;
                    case 164 -> 209;
                    case 165 -> 184;
                    case 166 -> 2;
                    case 167 -> 133;
                    case 168 -> 163;
                    case 169 -> 31;
                    case 170 -> 33;
                    case 171 -> 40;
                    case 172 -> 144;
                    case 173 -> 107;
                    case 174 -> 195;
                    case 175 -> 75;
                    case 176 -> 30;
                    case 177 -> 135;
                    case 178 -> 84;
                    case 179 -> 213;
                    case 180 -> 10;
                    case 181 -> 202;
                    case 182 -> 253;
                    case 183 -> 238;
                    case 184 -> 44;
                    case 185 -> 236;
                    case 186 -> 27;
                    case 187 -> 85;
                    case 188 -> 71;
                    case 189 -> 174;
                    case 190 -> 241;
                    case 191 -> 101;
                    case 192 -> 191;
                    case 193 -> 225;
                    case 194 -> 14;
                    case 195 -> 6;
                    case 196 -> 80;
                    case 197 -> 116;
                    case 198 -> 212;
                    case 199 -> 171;
                    case 200 -> 214;
                    case 201 -> 128;
                    case 202 -> 17;
                    case 203 -> 61;
                    case 204 -> 125;
                    case 205 -> 137;
                    case 206 -> 115;
                    case 207 -> 110;
                    case 208 -> 11;
                    case 209 -> 113;
                    case 210 -> 192;
                    case 211 -> 146;
                    case 212 -> 140;
                    case 213 -> 82;
                    case 214 -> 204;
                    case 215 -> 249;
                    case 216 -> 200;
                    case 217 -> 145;
                    case 218 -> 234;
                    case 219 -> 251;
                    case 220 -> 228;
                    case 221 -> 77;
                    case 222 -> 51;
                    case 223 -> 98;
                    case 224 -> 83;
                    case 225 -> 160;
                    case 226 -> 157;
                    case 227 -> 9;
                    case 228 -> 211;
                    case 229 -> 130;
                    case 230 -> 73;
                    case 231 -> 237;
                    case 232 -> 108;
                    case 233 -> 229;
                    case 234 -> 182;
                    case 235 -> 240;
                    case 236 -> 243;
                    case 237 -> 103;
                    case 238 -> 5;
                    case 239 -> 190;
                    case 240 -> 47;
                    case 241 -> 46;
                    case 242 -> 16;
                    case 243 -> 230;
                    case 244 -> 231;
                    case 245 -> 106;
                    case 246 -> 156;
                    case 247 -> 188;
                    case 248 -> 173;
                    case 249 -> 67;
                    case 250 -> 4;
                    case 251 -> 22;
                    case 252 -> 167;
                    case 253 -> 158;
                    case 254 -> 59;
                    default -> 143;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 40246832417714L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "6*[\u0005\u0015Z\u0018o\t1 H\u000fX\u0018\u0005sf";
                    var5_4 = "6*[\u0005\u0015Z\u0018o\t1 H\u000fX\u0018\u0005sf".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 8;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 85;
                                    break;
                                }
                                case 1: {
                                    v11 = 71;
                                    break;
                                }
                                case 2: {
                                    v11 = 33;
                                    break;
                                }
                                case 3: {
                                    v11 = 99;
                                    break;
                                }
                                case 4: {
                                    v11 = 120;
                                    break;
                                }
                                case 5: {
                                    v11 = 62;
                                    break;
                                }
                                default: {
                                    v11 = 35;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 67940154511780L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "*I\u0000V\r'd\u0004,W\fL\n H\u0007L\u0001%|\nI\u000e\t H\u0007L\u0001%|\u0006C\r'N\u001aA\u000b(f\u0006D\u001dK\n!";
                    var5_4 = "*I\u0000V\r'd\u0004,W\fL\n H\u0007L\u0001%|\nI\u000e\t H\u0007L\u0001%|\u0006C\r'N\u001aA\u000b(f\u0006D\u001dK\n!".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 50;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "\u001cw:m1\u0014S\u0006\u001cw:m=\u001e";
                        var5_4 = "\u001cw:m1\u0014S\u0006\u001cw:m=\u001e".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 14;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 81;
                                break;
                            }
                            case 1: {
                                v15 = 21;
                                break;
                            }
                            case 2: {
                                v15 = 91;
                                break;
                            }
                            case 3: {
                                v15 = 16;
                                break;
                            }
                            case 4: {
                                v15 = 86;
                                break;
                            }
                            case 5: {
                                v15 = 116;
                                break;
                            }
                            default: {
                                v15 = 58;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 88717035933876L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-191493270 - -22179, -191493270 - -18221, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 136384390860116L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00ac\u001c\u0083\u00e4\u0085\u0003\u00b6\u009at\u0005\u00f1\u00cd\u000e\u001a\u00d7\r\u008aiW\u00c4\t\u00ffjh\u00da\u0099\u00fc\u0011\u007f\u00106\u00ee\u0007\u00df<\t\u00e7\u008b\u00a2a\u0010C\u0004\u00dc\u0093\u0093\u0005\u0090!\"\u0087R3\u007f\u0085\u00ced\u00d0:J\u00f9j\u00d2\u0082\u001c\u0090f-\u00db\u00cdf\u00ac\u0090\u0006P)\u00b7E\u00ee-\u00f1$\u0099\u00d3\u00fd\u00ad\u001b\u00ae\u00ff\u00b2BSB)!\u00bfq\u008c\u0016\u0089L\u0019\u0002M";
                    var4_3 = "\u00ac\u001c\u0083\u00e4\u0085\u0003\u00b6\u009at\u0005\u00f1\u00cd\u000e\u001a\u00d7\r\u008aiW\u00c4\t\u00ffjh\u00da\u0099\u00fc\u0011\u007f\u00106\u00ee\u0007\u00df<\t\u00e7\u008b\u00a2a\u0010C\u0004\u00dc\u0093\u0093\u0005\u0090!\"\u0087R3\u007f\u0085\u00ced\u00d0:J\u00f9j\u00d2\u0082\u001c\u0090f-\u00db\u00cdf\u00ac\u0090\u0006P)\u00b7E\u00ee-\u00f1$\u0099\u00d3\u00fd\u00ad\u001b\u00ae\u00ff\u00b2BSB)!\u00bfq\u008c\u0016\u0089L\u0019\u0002M".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 9;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u0098\u0095\u00ac\u00ce7U\u00f8~?\u00a1\u00dd%\u00c3n\u0015\u00bbL_\u0092\u00a3\u00e4\u00fc\u00d8\u00ef\u00a1T\u00c9\u001c\u0091\u00f5v@\u00c1\u001b\u008a\u00f7\u0085{\u00e8\u00d2|g\u00022\u00d4C\n\u00ae\u009el\u00e7\u0099\u0002\u0018]B\u00b9C\u00ddC\u00edx%\u00a2l\u00f0L\u00e6VeZq X\u00fc\u00d4&\u0016\u000bdVe.3\u0013z\u00dd\u00e7d\u0000\u0001\u0099c";
                        var4_3 = "\u0098\u0095\u00ac\u00ce7U\u00f8~?\u00a1\u00dd%\u00c3n\u0015\u00bbL_\u0092\u00a3\u00e4\u00fc\u00d8\u00ef\u00a1T\u00c9\u001c\u0091\u00f5v@\u00c1\u001b\u008a\u00f7\u0085{\u00e8\u00d2|g\u00022\u00d4C\n\u00ae\u009el\u00e7\u0099\u0002\u0018]B\u00b9C\u00ddC\u00edx%\u00a2l\u00f0L\u00e6VeZq X\u00fc\u00d4&\u0016\u000bdVe.3\u0013z\u00dd\u00e7d\u0000\u0001\u0099c".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 121;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 123;
                                break;
                            }
                            case 1: {
                                v15 = 44;
                                break;
                            }
                            case 2: {
                                v15 = 121;
                                break;
                            }
                            case 3: {
                                v15 = 47;
                                break;
                            }
                            case 4: {
                                v15 = 79;
                                break;
                            }
                            case 5: {
                                v15 = 44;
                                break;
                            }
                            default: {
                                v15 = 118;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFF2B9) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 37;
                    case 1 -> 128;
                    case 2 -> 47;
                    case 3 -> 120;
                    case 4 -> 154;
                    case 5 -> 188;
                    case 6 -> 119;
                    case 7 -> 141;
                    case 8 -> 230;
                    case 9 -> 240;
                    case 10 -> 137;
                    case 11 -> 11;
                    case 12 -> 72;
                    case 13 -> 197;
                    case 14 -> 173;
                    case 15 -> 85;
                    case 16 -> 67;
                    case 17 -> 90;
                    case 18 -> 18;
                    case 19 -> 20;
                    case 20 -> 107;
                    case 21 -> 48;
                    case 22 -> 25;
                    case 23 -> 70;
                    case 24 -> 238;
                    case 25 -> 26;
                    case 26 -> 239;
                    case 27 -> 30;
                    case 28 -> 116;
                    case 29 -> 69;
                    case 30 -> 153;
                    case 31 -> 31;
                    case 32 -> 224;
                    case 33 -> 168;
                    case 34 -> 211;
                    case 35 -> 227;
                    case 36 -> 95;
                    case 37 -> 252;
                    case 38 -> 220;
                    case 39 -> 175;
                    case 40 -> 112;
                    case 41 -> 60;
                    case 42 -> 215;
                    case 43 -> 228;
                    case 44 -> 38;
                    case 45 -> 208;
                    case 46 -> 149;
                    case 47 -> 3;
                    case 48 -> 218;
                    case 49 -> 125;
                    case 50 -> 19;
                    case 51 -> 35;
                    case 52 -> 237;
                    case 53 -> 146;
                    case 54 -> 17;
                    case 55 -> 41;
                    case 56 -> 87;
                    case 57 -> 21;
                    case 58 -> 101;
                    case 59 -> 0;
                    case 60 -> 73;
                    case 61 -> 161;
                    case 62 -> 33;
                    case 63 -> 99;
                    case 64 -> 45;
                    case 65 -> 140;
                    case 66 -> 195;
                    case 67 -> 210;
                    case 68 -> 183;
                    case 69 -> 29;
                    case 70 -> 202;
                    case 71 -> 42;
                    case 72 -> 148;
                    case 73 -> 222;
                    case 74 -> 61;
                    case 75 -> 113;
                    case 76 -> 53;
                    case 77 -> 166;
                    case 78 -> 43;
                    case 79 -> 189;
                    case 80 -> 133;
                    case 81 -> 234;
                    case 82 -> 243;
                    case 83 -> 194;
                    case 84 -> 86;
                    case 85 -> 247;
                    case 86 -> 198;
                    case 87 -> 196;
                    case 88 -> 51;
                    case 89 -> 231;
                    case 90 -> 190;
                    case 91 -> 111;
                    case 92 -> 162;
                    case 93 -> 205;
                    case 94 -> 24;
                    case 95 -> 46;
                    case 96 -> 55;
                    case 97 -> 66;
                    case 98 -> 244;
                    case 99 -> 217;
                    case 100 -> 143;
                    case 101 -> 255;
                    case 102 -> 206;
                    case 103 -> 1;
                    case 104 -> 109;
                    case 105 -> 50;
                    case 106 -> 134;
                    case 107 -> 159;
                    case 108 -> 225;
                    case 109 -> 131;
                    case 110 -> 219;
                    case 111 -> 178;
                    case 112 -> 184;
                    case 113 -> 56;
                    case 114 -> 144;
                    case 115 -> 199;
                    case 116 -> 49;
                    case 117 -> 207;
                    case 118 -> 4;
                    case 119 -> 93;
                    case 120 -> 138;
                    case 121 -> 213;
                    case 122 -> 63;
                    case 123 -> 251;
                    case 124 -> 34;
                    case 125 -> 32;
                    case 126 -> 80;
                    case 127 -> 233;
                    case 128 -> 180;
                    case 129 -> 170;
                    case 130 -> 108;
                    case 131 -> 94;
                    case 132 -> 54;
                    case 133 -> 214;
                    case 134 -> 122;
                    case 135 -> 64;
                    case 136 -> 254;
                    case 137 -> 118;
                    case 138 -> 121;
                    case 139 -> 156;
                    case 140 -> 155;
                    case 141 -> 84;
                    case 142 -> 236;
                    case 143 -> 105;
                    case 144 -> 209;
                    case 145 -> 167;
                    case 146 -> 174;
                    case 147 -> 110;
                    case 148 -> 129;
                    case 149 -> 145;
                    case 150 -> 81;
                    case 151 -> 103;
                    case 152 -> 76;
                    case 153 -> 235;
                    case 154 -> 172;
                    case 155 -> 13;
                    case 156 -> 44;
                    case 157 -> 59;
                    case 158 -> 253;
                    case 159 -> 248;
                    case 160 -> 165;
                    case 161 -> 52;
                    case 162 -> 106;
                    case 163 -> 12;
                    case 164 -> 204;
                    case 165 -> 126;
                    case 166 -> 91;
                    case 167 -> 139;
                    case 168 -> 65;
                    case 169 -> 88;
                    case 170 -> 16;
                    case 171 -> 98;
                    case 172 -> 185;
                    case 173 -> 203;
                    case 174 -> 169;
                    case 175 -> 39;
                    case 176 -> 62;
                    case 177 -> 8;
                    case 178 -> 79;
                    case 179 -> 193;
                    case 180 -> 92;
                    case 181 -> 96;
                    case 182 -> 201;
                    case 183 -> 186;
                    case 184 -> 97;
                    case 185 -> 115;
                    case 186 -> 171;
                    case 187 -> 177;
                    case 188 -> 124;
                    case 189 -> 130;
                    case 190 -> 5;
                    case 191 -> 176;
                    case 192 -> 7;
                    case 193 -> 71;
                    case 194 -> 68;
                    case 195 -> 83;
                    case 196 -> 242;
                    case 197 -> 74;
                    case 198 -> 246;
                    case 199 -> 249;
                    case 200 -> 232;
                    case 201 -> 164;
                    case 202 -> 241;
                    case 203 -> 127;
                    case 204 -> 181;
                    case 205 -> 221;
                    case 206 -> 212;
                    case 207 -> 132;
                    case 208 -> 223;
                    case 209 -> 135;
                    case 210 -> 147;
                    case 211 -> 78;
                    case 212 -> 160;
                    case 213 -> 216;
                    case 214 -> 152;
                    case 215 -> 158;
                    case 216 -> 157;
                    case 217 -> 57;
                    case 218 -> 163;
                    case 219 -> 151;
                    case 220 -> 104;
                    case 221 -> 40;
                    case 222 -> 100;
                    case 223 -> 187;
                    case 224 -> 114;
                    case 225 -> 27;
                    case 226 -> 2;
                    case 227 -> 191;
                    case 228 -> 22;
                    case 229 -> 6;
                    case 230 -> 102;
                    case 231 -> 15;
                    case 232 -> 10;
                    case 233 -> 36;
                    case 234 -> 9;
                    case 235 -> 245;
                    case 236 -> 150;
                    case 237 -> 136;
                    case 238 -> 14;
                    case 239 -> 77;
                    case 240 -> 28;
                    case 241 -> 58;
                    case 242 -> 200;
                    case 243 -> 117;
                    case 244 -> 182;
                    case 245 -> 89;
                    case 246 -> 123;
                    case 247 -> 226;
                    case 248 -> 82;
                    case 249 -> 23;
                    case 250 -> 75;
                    case 251 -> 179;
                    case 252 -> 250;
                    case 253 -> 142;
                    case 254 -> 192;
                    default -> 229;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 69976261741942L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(1640472120 - (char)-15552, -1640472120 - -((char)-19964), (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 112692985337533L;
                    boolean bl = SshAgentIpcService.b();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-1633394340 + -((char)-8150), -1633394340 + -((char)-20574), (int)l2));
                    boolean bl2 = bl;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (!bl2) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 90262032417751L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00a6=\u00f9\u0018\u0005\u0003'\u00b7\u009f";
                var4_3 = "\u00a6=\u00f9\u0018\u0005\u0003'\u00b7\u009f".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 26;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 9;
                                break;
                            }
                            case 1: {
                                v11 = 56;
                                break;
                            }
                            case 2: {
                                v11 = 125;
                                break;
                            }
                            case 3: {
                                v11 = 4;
                                break;
                            }
                            case 4: {
                                v11 = 113;
                                break;
                            }
                            case 5: {
                                v11 = 104;
                                break;
                            }
                            default: {
                                v11 = 32;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFF978E) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 89;
                    case 1 -> 180;
                    case 2 -> 251;
                    case 3 -> 130;
                    case 4 -> 222;
                    case 5 -> 213;
                    case 6 -> 27;
                    case 7 -> 244;
                    case 8 -> 75;
                    case 9 -> 126;
                    case 10 -> 55;
                    case 11 -> 216;
                    case 12 -> 163;
                    case 13 -> 127;
                    case 14 -> 71;
                    case 15 -> 12;
                    case 16 -> 243;
                    case 17 -> 253;
                    case 18 -> 0;
                    case 19 -> 211;
                    case 20 -> 53;
                    case 21 -> 188;
                    case 22 -> 141;
                    case 23 -> 152;
                    case 24 -> 195;
                    case 25 -> 16;
                    case 26 -> 193;
                    case 27 -> 64;
                    case 28 -> 110;
                    case 29 -> 104;
                    case 30 -> 156;
                    case 31 -> 153;
                    case 32 -> 248;
                    case 33 -> 138;
                    case 34 -> 94;
                    case 35 -> 247;
                    case 36 -> 171;
                    case 37 -> 143;
                    case 38 -> 185;
                    case 39 -> 47;
                    case 40 -> 4;
                    case 41 -> 25;
                    case 42 -> 133;
                    case 43 -> 43;
                    case 44 -> 184;
                    case 45 -> 139;
                    case 46 -> 234;
                    case 47 -> 169;
                    case 48 -> 179;
                    case 49 -> 255;
                    case 50 -> 220;
                    case 51 -> 175;
                    case 52 -> 192;
                    case 53 -> 22;
                    case 54 -> 159;
                    case 55 -> 74;
                    case 56 -> 232;
                    case 57 -> 221;
                    case 58 -> 48;
                    case 59 -> 93;
                    case 60 -> 33;
                    case 61 -> 225;
                    case 62 -> 241;
                    case 63 -> 20;
                    case 64 -> 57;
                    case 65 -> 109;
                    case 66 -> 90;
                    case 67 -> 81;
                    case 68 -> 100;
                    case 69 -> 115;
                    case 70 -> 190;
                    case 71 -> 210;
                    case 72 -> 59;
                    case 73 -> 196;
                    case 74 -> 176;
                    case 75 -> 41;
                    case 76 -> 250;
                    case 77 -> 129;
                    case 78 -> 201;
                    case 79 -> 30;
                    case 80 -> 114;
                    case 81 -> 252;
                    case 82 -> 137;
                    case 83 -> 242;
                    case 84 -> 72;
                    case 85 -> 154;
                    case 86 -> 118;
                    case 87 -> 70;
                    case 88 -> 194;
                    case 89 -> 246;
                    case 90 -> 24;
                    case 91 -> 124;
                    case 92 -> 203;
                    case 93 -> 6;
                    case 94 -> 240;
                    case 95 -> 92;
                    case 96 -> 178;
                    case 97 -> 160;
                    case 98 -> 174;
                    case 99 -> 37;
                    case 100 -> 229;
                    case 101 -> 237;
                    case 102 -> 236;
                    case 103 -> 84;
                    case 104 -> 186;
                    case 105 -> 235;
                    case 106 -> 151;
                    case 107 -> 166;
                    case 108 -> 121;
                    case 109 -> 99;
                    case 110 -> 120;
                    case 111 -> 183;
                    case 112 -> 224;
                    case 113 -> 135;
                    case 114 -> 149;
                    case 115 -> 56;
                    case 116 -> 108;
                    case 117 -> 63;
                    case 118 -> 146;
                    case 119 -> 125;
                    case 120 -> 3;
                    case 121 -> 200;
                    case 122 -> 170;
                    case 123 -> 238;
                    case 124 -> 5;
                    case 125 -> 35;
                    case 126 -> 182;
                    case 127 -> 80;
                    case 128 -> 39;
                    case 129 -> 79;
                    case 130 -> 145;
                    case 131 -> 18;
                    case 132 -> 218;
                    case 133 -> 98;
                    case 134 -> 68;
                    case 135 -> 83;
                    case 136 -> 85;
                    case 137 -> 65;
                    case 138 -> 28;
                    case 139 -> 187;
                    case 140 -> 123;
                    case 141 -> 8;
                    case 142 -> 189;
                    case 143 -> 106;
                    case 144 -> 9;
                    case 145 -> 54;
                    case 146 -> 10;
                    case 147 -> 69;
                    case 148 -> 165;
                    case 149 -> 142;
                    case 150 -> 144;
                    case 151 -> 45;
                    case 152 -> 128;
                    case 153 -> 227;
                    case 154 -> 61;
                    case 155 -> 66;
                    case 156 -> 105;
                    case 157 -> 2;
                    case 158 -> 102;
                    case 159 -> 46;
                    case 160 -> 208;
                    case 161 -> 209;
                    case 162 -> 1;
                    case 163 -> 91;
                    case 164 -> 147;
                    case 165 -> 15;
                    case 166 -> 204;
                    case 167 -> 119;
                    case 168 -> 7;
                    case 169 -> 23;
                    case 170 -> 82;
                    case 171 -> 164;
                    case 172 -> 136;
                    case 173 -> 173;
                    case 174 -> 150;
                    case 175 -> 134;
                    case 176 -> 206;
                    case 177 -> 26;
                    case 178 -> 214;
                    case 179 -> 101;
                    case 180 -> 254;
                    case 181 -> 230;
                    case 182 -> 167;
                    case 183 -> 49;
                    case 184 -> 245;
                    case 185 -> 215;
                    case 186 -> 161;
                    case 187 -> 32;
                    case 188 -> 219;
                    case 189 -> 36;
                    case 190 -> 217;
                    case 191 -> 34;
                    case 192 -> 191;
                    case 193 -> 181;
                    case 194 -> 21;
                    case 195 -> 112;
                    case 196 -> 168;
                    case 197 -> 29;
                    case 198 -> 228;
                    case 199 -> 42;
                    case 200 -> 77;
                    case 201 -> 197;
                    case 202 -> 76;
                    case 203 -> 88;
                    case 204 -> 95;
                    case 205 -> 122;
                    case 206 -> 132;
                    case 207 -> 17;
                    case 208 -> 62;
                    case 209 -> 19;
                    case 210 -> 11;
                    case 211 -> 131;
                    case 212 -> 103;
                    case 213 -> 212;
                    case 214 -> 226;
                    case 215 -> 107;
                    case 216 -> 113;
                    case 217 -> 38;
                    case 218 -> 52;
                    case 219 -> 60;
                    case 220 -> 67;
                    case 221 -> 87;
                    case 222 -> 177;
                    case 223 -> 249;
                    case 224 -> 239;
                    case 225 -> 96;
                    case 226 -> 199;
                    case 227 -> 73;
                    case 228 -> 172;
                    case 229 -> 13;
                    case 230 -> 205;
                    case 231 -> 50;
                    case 232 -> 51;
                    case 233 -> 78;
                    case 234 -> 58;
                    case 235 -> 231;
                    case 236 -> 207;
                    case 237 -> 157;
                    case 238 -> 202;
                    case 239 -> 198;
                    case 240 -> 223;
                    case 241 -> 97;
                    case 242 -> 116;
                    case 243 -> 155;
                    case 244 -> 44;
                    case 245 -> 86;
                    case 246 -> 31;
                    case 247 -> 158;
                    case 248 -> 111;
                    case 249 -> 162;
                    case 250 -> 14;
                    case 251 -> 117;
                    case 252 -> 233;
                    case 253 -> 148;
                    case 254 -> 140;
                    default -> 40;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

