/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.manage;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.python.django.console.DjangoConsoleOptions;
import com.intellij.python.django.util.DjangoUtil;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.facet.DjangoFacetConfiguration;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.remote.PyRemoteSdkWithoutSudo;
import com.jetbrains.python.run.PythonExecution;
import com.jetbrains.python.run.PythonScripts;
import com.jetbrains.python.run.PythonTask;
import com.jetbrains.python.run.target.HelpersAwareTargetEnvironmentRequest;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class DjangoManageTask
extends PythonTask {
    private static final String PYCHARM_TRACK_FILES_PATTERN = "PYCHARM_TRACK_FILES_PATTERN";

    public DjangoManageTask(@NotNull Module module, @NlsContexts.TabTitle String runTabTitle) throws ExecutionException {
        if (module == null) {
            DjangoManageTask.$$$reportNull$$$0(0);
        }
        super(module, runTabTitle, (Sdk)new PyRemoteSdkWithoutSudo(PythonTask.requirePythonSdk((Module)module)));
    }

    protected void setupPythonPath(@NotNull TargetEnvironmentRequest request, @NotNull PythonExecution pythonExecution) {
        if (request == null) {
            DjangoManageTask.$$$reportNull$$$0(1);
        }
        if (pythonExecution == null) {
            DjangoManageTask.$$$reportNull$$$0(2);
        }
        PyConsoleOptions.PyConsoleSettings settingsProvider = DjangoConsoleOptions.getInstance(this.myModule.getProject()).getState();
        DjangoManageTask.setupPythonPath((Module)this.myModule, (Sdk)this.mySdk, (TargetEnvironmentRequest)request, (PythonExecution)pythonExecution, (boolean)settingsProvider.shouldAddContentRoots(), (boolean)settingsProvider.shouldAddSourceRoots());
        DjangoFacet facet = DjangoFacet.getInstance((Module)this.myModule);
        if (facet != null) {
            String djangoPath = ((DjangoFacetConfiguration)facet.getConfiguration()).getProjectRootPath();
            this.setWorkingDirectory(djangoPath);
            if (!StringUtil.isEmptyOrSpaces((String)djangoPath)) {
                PythonScripts.appendToPythonPath((Map)pythonExecution.getEnvs(), (Function)TargetEnvironmentFunctions.targetPath((Path)Path.of(djangoPath, new String[0])), (TargetPlatform)request.getTargetPlatform());
            }
        }
    }

    protected List<String> setupPythonPath() {
        PyConsoleOptions.PyConsoleSettings settingsProvider = DjangoConsoleOptions.getInstance(this.myModule.getProject()).getState();
        List strings = this.setupPythonPath(settingsProvider.shouldAddContentRoots(), settingsProvider.shouldAddSourceRoots());
        DjangoFacet facet = DjangoFacet.getInstance((Module)this.myModule);
        if (facet != null) {
            String djangoPath = ((DjangoFacetConfiguration)facet.getConfiguration()).getProjectRootPath();
            this.setWorkingDirectory(djangoPath);
            strings.add(djangoPath);
        }
        return strings;
    }

    @NotNull
    public final ProcessHandler createProcess() throws ExecutionException {
        Map environment = this.createCommandLine().getEnvironment();
        ProcessHandler processHandler = this.createProcess(environment);
        if (processHandler == null) {
            DjangoManageTask.$$$reportNull$$$0(3);
        }
        return processHandler;
    }

    public final GeneralCommandLine createCommandLine() {
        GeneralCommandLine cmd = super.createCommandLine();
        DjangoFacet djangoFacet = DjangoFacet.getInstance((Module)this.myModule);
        if (djangoFacet != null) {
            DjangoFacetConfiguration configuration = (DjangoFacetConfiguration)djangoFacet.getConfiguration();
            cmd.getEnvironment().putAll(configuration.getEnvVariables());
            String filePattern = configuration.getTrackFilePattern();
            cmd.getEnvironment().put(PYCHARM_TRACK_FILES_PATTERN, filePattern);
        }
        ApplicationManager.getApplication().runReadAction(() -> DjangoUtil.addDjangoSettingsToEnv(this.myModule, cmd.getEnvironment()));
        return cmd;
    }

    protected void customizePythonExecution(@NotNull HelpersAwareTargetEnvironmentRequest request, @NotNull PythonExecution pythonExecution, @NotNull Module module) {
        if (request == null) {
            DjangoManageTask.$$$reportNull$$$0(4);
        }
        if (pythonExecution == null) {
            DjangoManageTask.$$$reportNull$$$0(5);
        }
        if (module == null) {
            DjangoManageTask.$$$reportNull$$$0(6);
        }
        LinkedHashMap<String, Function> envs = new LinkedHashMap<String, Function>();
        DjangoFacet djangoFacet = DjangoFacet.getInstance((Module)this.myModule);
        if (djangoFacet != null) {
            DjangoFacetConfiguration configuration = (DjangoFacetConfiguration)djangoFacet.getConfiguration();
            configuration.getEnvVariables().forEach((key, value) -> envs.put((String)key, TargetEnvironmentFunctions.constant((Object)value)));
            String filePattern = configuration.getTrackFilePattern();
            envs.put(PYCHARM_TRACK_FILES_PATTERN, TargetEnvironmentFunctions.constant((Object)filePattern));
        }
        ApplicationManager.getApplication().runReadAction(() -> DjangoUtil.addDjangoSettingsToEnv(request, this.myModule, envs));
        envs.forEach((key, value) -> pythonExecution.addEnvironmentVariable(key, value));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonExecution";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/django/manage/DjangoManageTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/django/manage/DjangoManageTask";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setupPythonPath";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "customizePythonExecution";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

