/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.core;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Map;
import org.ec4j.core.Resource;
import org.ec4j.core.model.Ec4jPath;

public interface ResourcePath {
    public ResourcePath getParent();

    public Ec4jPath getPath();

    public boolean hasParent();

    public Resource relativize(Resource var1);

    public Resource resolve(String var1);

    public static class ResourcePaths {
        public static ResourcePath ofPath(Path path, Charset encoding) {
            return new PathResourcePath(path, encoding);
        }

        private ResourcePaths() {
        }

        static class StringResourcePath
        implements ResourcePath {
            private final Ec4jPath path;
            private final Map<Ec4jPath, Resource> resources;

            StringResourcePath(Ec4jPath path, Map<Ec4jPath, Resource> resources) {
                this.path = path;
                this.resources = resources;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                StringResourcePath other = (StringResourcePath)obj;
                return this.path.equals(other.path);
            }

            @Override
            public ResourcePath getParent() {
                Ec4jPath parentPath = this.path.getParentPath();
                return parentPath == null ? null : new StringResourcePath(parentPath, this.resources);
            }

            @Override
            public Ec4jPath getPath() {
                return this.path;
            }

            public int hashCode() {
                return this.path.hashCode();
            }

            @Override
            public boolean hasParent() {
                return this.path.getParentPath() != null;
            }

            @Override
            public Resource relativize(Resource resource) {
                if (resource instanceof Resource.Resources.StringResource) {
                    Resource.Resources.StringResource strResource = (Resource.Resources.StringResource)resource;
                    return new Resource.Resources.StringResource(strResource.resources, this.path.relativize(strResource.path), strResource.content);
                }
                throw new IllegalArgumentException(this.getClass().getName() + ".relativize(Resource resource) can handle only instances of " + Resource.Resources.StringResource.class.getName());
            }

            @Override
            public Resource resolve(String name) {
                Ec4jPath newPath = this.path.resolve(name);
                Resource result2 = this.resources.get(newPath);
                if (result2 == null) {
                    result2 = new Resource.Resources.StringResource(this.resources, newPath, null);
                }
                return result2;
            }

            public String toString() {
                return "string:" + this.getPath();
            }
        }

        static class PathResourcePath
        implements ResourcePath {
            private final Charset encoding;
            private final Path path;

            PathResourcePath(Path path, Charset encoding) {
                this.path = path;
                this.encoding = encoding;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                PathResourcePath other = (PathResourcePath)obj;
                return this.path.equals(other.path);
            }

            @Override
            public ResourcePath getParent() {
                Path parent = this.path.getParent();
                return parent == null ? null : new PathResourcePath(parent, this.encoding);
            }

            @Override
            public Ec4jPath getPath() {
                return Ec4jPath.Ec4jPaths.of(this.path);
            }

            public int hashCode() {
                return this.path.hashCode();
            }

            @Override
            public boolean hasParent() {
                return this.path.getParent() != null;
            }

            @Override
            public Resource relativize(Resource resource) {
                if (resource instanceof Resource.Resources.PathResource) {
                    Resource.Resources.PathResource pathResource = (Resource.Resources.PathResource)resource;
                    return new Resource.Resources.PathResource(this.path.relativize(pathResource.path), pathResource.encoding);
                }
                throw new IllegalArgumentException(this.getClass().getName() + ".relativize(Resource resource) can handle only instances of " + Resource.Resources.PathResource.class.getName());
            }

            @Override
            public Resource resolve(String name) {
                return new Resource.Resources.PathResource(this.path.resolve(name), this.encoding);
            }

            public String toString() {
                return "path:" + this.getPath();
            }
        }

        static class ClassPathResourcePath
        implements ResourcePath {
            final Charset encoding;
            final ClassLoader loader;
            final Ec4jPath path;

            ClassPathResourcePath(ClassLoader loader, Ec4jPath path, Charset encoding) {
                this.path = path;
                this.loader = loader;
                this.encoding = encoding;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                ClassPathResourcePath other = (ClassPathResourcePath)obj;
                if (this.loader == null ? other.loader != null : !this.loader.equals(other.loader)) {
                    return false;
                }
                return !(this.path == null ? other.path != null : !this.path.equals(other.path));
            }

            @Override
            public ResourcePath getParent() {
                Ec4jPath parentPath = this.path.getParentPath();
                return parentPath == null ? null : new ClassPathResourcePath(this.loader, parentPath, this.encoding);
            }

            @Override
            public Ec4jPath getPath() {
                return this.path;
            }

            public int hashCode() {
                int prime = 31;
                int result2 = 1;
                result2 = 31 * result2 + (this.loader == null ? 0 : this.loader.hashCode());
                result2 = 31 * result2 + (this.path == null ? 0 : this.path.hashCode());
                return result2;
            }

            @Override
            public boolean hasParent() {
                return this.path.getParentPath() != null;
            }

            @Override
            public Resource relativize(Resource resource) {
                if (resource instanceof Resource.Resources.ClassPathResource) {
                    Resource.Resources.ClassPathResource cpResource = (Resource.Resources.ClassPathResource)resource;
                    return new Resource.Resources.ClassPathResource(cpResource.loader, this.path.relativize(cpResource.path), cpResource.encoding);
                }
                throw new IllegalArgumentException(this.getClass().getName() + ".relativize(Resource resource) can handle only instances of " + Resource.Resources.ClassPathResource.class.getName());
            }

            @Override
            public Resource resolve(String name) {
                return new Resource.Resources.ClassPathResource(this.loader, this.path.resolve(name), this.encoding);
            }

            public String toString() {
                return "classpath:" + this.getPath();
            }
        }
    }
}

