/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.editor;

import com.intellij.notebooks.jupyter.core.jupyter.CellType;
import com.intellij.notebooks.ui.visualization.NotebookUtil;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LineNumberConverter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\b\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/jupyter/core/editor/JupyterLineNumberConverterSetter;", "", "<init>", "()V", "setConverterToEditor", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "getLineNumberConverter", "Lcom/intellij/openapi/editor/LineNumberConverter;", "Companion", "intellij.jupyter.core"})
public final class JupyterLineNumberConverterSetter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final JupyterLineNumberConverterSetter instance = new JupyterLineNumberConverterSetter();

    private JupyterLineNumberConverterSetter() {
    }

    public final void setConverterToEditor(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        editor.getGutter().setLineNumberConverter(this.getLineNumberConverter());
    }

    private final LineNumberConverter getLineNumberConverter() {
        return new LineNumberConverter(){

            public Integer convert(Editor editor, int lineNumber) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                int trueLineNumber = lineNumber - 1;
                NotebookCellLines notebookCellLines = NotebookCellLines.Companion.get(editor);
                NotebookCellLines.Interval interval = (NotebookCellLines.Interval)notebookCellLines.intervalsIterator(trueLineNumber).next();
                if (interval.getType() != CellType.CODE && !NotebookUtil.INSTANCE.isDiffKind(editor)) {
                    return null;
                }
                int adjustedLineNumber = lineNumber - interval.getLines().getFirst() - 1;
                return adjustedLineNumber < 1 ? null : Integer.valueOf(adjustedLineNumber);
            }

            public Integer getMaxLineNumber(Editor editor) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                return editor.getDocument().getLineCount();
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/core/editor/JupyterLineNumberConverterSetter$Companion;", "", "<init>", "()V", "instance", "Lcom/intellij/jupyter/core/editor/JupyterLineNumberConverterSetter;", "getInstance", "()Lcom/intellij/jupyter/core/editor/JupyterLineNumberConverterSetter;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JupyterLineNumberConverterSetter getInstance() {
            return instance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

