/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.kernel.executor;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterExecutionStatusKt;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterClearOutputMessage;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessage;
import com.intellij.jupyter.core.jupyter.helper.JupyterCellLinesExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterListenersKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutputs;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutputsBase;
import com.intellij.jupyter.core.jupyter.nbformat.schema.v4.V4JupyterOutputSchema;
import com.intellij.jupyter.core.kernel.executor.JupyterTaskBaseCallback;
import com.intellij.jupyter.core.kernel.executor.JupyterTaskCellOutputUpdater;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001e"}, d2={"Lcom/intellij/jupyter/core/kernel/executor/JupyterTaskCellOutputUpdater;", "Lcom/intellij/jupyter/core/kernel/executor/JupyterTaskBaseCallback;", "project", "Lcom/intellij/openapi/project/Project;", "notebookFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "intervalPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getNotebookFile", "()Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "getIntervalPointer", "()Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "waitClearOutput", "", "jupyterCell", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;", "getJupyterCell", "()Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;", "onUpdateOutput", "", "message", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessage;", "onDisplayData", "onClearOutput", "onExecuteReply", "updateCellOutput", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterTaskCellOutputUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterTaskCellOutputUpdater.kt\ncom/intellij/jupyter/core/kernel/executor/JupyterTaskCellOutputUpdater\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n23#2:92\n23#2:93\n23#2:94\n1#3:95\n*S KotlinDebug\n*F\n+ 1 JupyterTaskCellOutputUpdater.kt\ncom/intellij/jupyter/core/kernel/executor/JupyterTaskCellOutputUpdater\n*L\n37#1:92\n64#1:93\n68#1:94\n*E\n"})
public final class JupyterTaskCellOutputUpdater
extends JupyterTaskBaseCallback {
    @NotNull
    private final Project project;
    @NotNull
    private final BackedNotebookVirtualFile notebookFile;
    @NotNull
    private final NotebookIntervalPointer intervalPointer;
    private boolean waitClearOutput;

    public JupyterTaskCellOutputUpdater(@NotNull Project project, @NotNull BackedNotebookVirtualFile notebookFile, @NotNull NotebookIntervalPointer intervalPointer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
        Intrinsics.checkNotNullParameter((Object)intervalPointer, (String)"intervalPointer");
        this.project = project;
        this.notebookFile = notebookFile;
        this.intervalPointer = intervalPointer;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final BackedNotebookVirtualFile getNotebookFile() {
        return this.notebookFile;
    }

    @NotNull
    public final NotebookIntervalPointer getIntervalPointer() {
        return this.intervalPointer;
    }

    private final JupyterCell getJupyterCell() {
        NotebookCellLines.Interval interval = this.intervalPointer.get();
        return interval != null ? JupyterCellLinesExtensionsKt.toJupyterCell(interval, this.notebookFile) : null;
    }

    @Override
    public void onUpdateOutput(@NotNull JupyterMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.updateCellOutput(message);
    }

    @Override
    public void onDisplayData(@NotNull JupyterMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.updateCellOutput(message);
    }

    @Override
    public void onClearOutput(@NotNull JupyterMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        JupyterTaskCellOutputUpdater $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(JupyterTaskCellOutputUpdater.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("Clear output received");
        boolean wait = new JupyterClearOutputMessage(message).getWait();
        if (wait) {
            this.waitClearOutput = true;
            return;
        }
        com.intellij.openapi.progress.CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ JupyterTaskCellOutputUpdater this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = CoroutinesKt.edtWriteAction(() -> onClearOutput.1.invokeSuspend$lambda$0(this.this$0), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(JupyterTaskCellOutputUpdater this$0) {
                block0: {
                    JupyterCell jupyterCell = JupyterTaskCellOutputUpdater.access$getJupyterCell(this$0);
                    if (jupyterCell == null) break block0;
                    jupyterCell.setOutputs(null);
                }
                return Unit.INSTANCE;
            }
        }));
    }

    @Override
    public void onExecuteReply(@NotNull JupyterMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Integer n = JupyterExecutionStatusKt.getExecutionCount(message);
        if (n == null) {
            return;
        }
        int executionCount = n;
        com.intellij.openapi.progress.CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, executionCount, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ JupyterTaskCellOutputUpdater this$0;
            final /* synthetic */ int $executionCount;
            {
                this.this$0 = $receiver;
                this.$executionCount = $executionCount;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$runBlockingMaybeCancellable;
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$runBlockingMaybeCancellable);
                        this.label = 1;
                        Object object2 = CoroutinesKt.edtWriteAction(() -> onExecuteReply.1.invokeSuspend$lambda$0(this.this$0, (CoroutineScope)$this$runBlockingMaybeCancellable, this.$executionCount), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(JupyterTaskCellOutputUpdater this$0, CoroutineScope $$this$runBlockingMaybeCancellable, int $executionCount) {
                block1: {
                    JupyterCell jupyterCell = JupyterTaskCellOutputUpdater.access$getJupyterCell(this$0);
                    if (jupyterCell == null) {
                        return Unit.INSTANCE;
                    }
                    JupyterCell jupyterCell2 = jupyterCell;
                    CoroutineScope $this$thisLogger$iv = $$this$runBlockingMaybeCancellable;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(CoroutineScope.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.debug("Execution reply received. execution count: " + $executionCount);
                    jupyterCell2.setExecutionCount($executionCount);
                    JupyterNotebook jupyterNotebook = this$0.getNotebookFile().getNotebookOrNull();
                    if (jupyterNotebook == null) break block1;
                    JupyterListenersKt.executionInfoUpdated(jupyterNotebook, this$0.getIntervalPointer());
                }
                return Unit.INSTANCE;
            }
        }));
    }

    private final void updateCellOutput(JupyterMessage message) {
        JupyterTaskCellOutputUpdater $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(JupyterTaskCellOutputUpdater.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("Receive update cell output: " + message.getMessageContent());
        if (this.waitClearOutput) {
            this.waitClearOutput = false;
            $this$thisLogger$iv = this;
            $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(JupyterTaskCellOutputUpdater.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.debug("Clear output");
            com.intellij.openapi.progress.CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ JupyterTaskCellOutputUpdater this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = CoroutinesKt.edtWriteAction(() -> updateCellOutput.1.invokeSuspend$lambda$0(this.this$0), (Continuation)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final Unit invokeSuspend$lambda$0(JupyterTaskCellOutputUpdater this$0) {
                    block0: {
                        JupyterCell jupyterCell = JupyterTaskCellOutputUpdater.access$getJupyterCell(this$0);
                        if (jupyterCell == null) break block0;
                        jupyterCell.setOutputs(null);
                    }
                    return Unit.INSTANCE;
                }
            }));
        }
        JupyterCell jupyterCell = this.getJupyterCell();
        if (jupyterCell == null) {
            return;
        }
        JupyterCell jupyterCell2 = jupyterCell;
        JupyterNotebook notebook = this.notebookFile.getNotebook();
        JupyterOutputs jupyterOutputs = jupyterCell2.getOutputs();
        if (jupyterOutputs == null) {
            JupyterOutputsBase jupyterOutputsBase;
            JupyterOutputsBase it = jupyterOutputsBase = new JupyterOutputsBase(null, V4JupyterOutputSchema.INSTANCE, 1, null);
            boolean bl = false;
            jupyterCell2.setOutputs(it);
            jupyterOutputs = jupyterOutputsBase;
        }
        JupyterOutputs outputs = jupyterOutputs;
        com.intellij.openapi.progress.CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(outputs, message, notebook, this, jupyterCell2, null){
            int label;
            final /* synthetic */ JupyterOutputs $outputs;
            final /* synthetic */ JupyterMessage $message;
            final /* synthetic */ JupyterNotebook $notebook;
            final /* synthetic */ JupyterTaskCellOutputUpdater this$0;
            final /* synthetic */ JupyterCell $jupyterCell;
            {
                this.$outputs = $outputs;
                this.$message = $message;
                this.$notebook = $notebook;
                this.this$0 = $receiver;
                this.$jupyterCell = $jupyterCell;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = CoroutinesKt.edtWriteAction(() -> updateCellOutput.2.invokeSuspend$lambda$0(this.$outputs, this.$message, this.$notebook, this.this$0, this.$jupyterCell), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(JupyterOutputs $outputs, JupyterMessage $message, JupyterNotebook $notebook, JupyterTaskCellOutputUpdater this$0, JupyterCell $jupyterCell) {
                $outputs.update($message);
                Integer executionCount = JupyterExecutionStatusKt.getExecutionCount($message);
                JupyterListenersKt.outputUpdated($notebook, this$0.getIntervalPointer());
                if (executionCount != null) {
                    $jupyterCell.setExecutionCount(executionCount);
                    JupyterListenersKt.executionInfoUpdated($notebook, this$0.getIntervalPointer());
                }
                return Unit.INSTANCE;
            }
        }));
    }

    public static final /* synthetic */ JupyterCell access$getJupyterCell(JupyterTaskCellOutputUpdater $this) {
        return $this.getJupyterCell();
    }
}

