/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow.lsp;

import com.intellij.lang.javascript.flow.FlowJSServerManager;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfig;
import com.intellij.lang.javascript.flow.lsp.FlowJSLspServerDescriptor;
import com.intellij.lang.javascript.flow.lsp.FlowJSLspSupportProviderKt;
import com.intellij.lang.javascript.flow.widget.FlowServiceWidgetItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspServer;
import com.intellij.platform.lsp.api.LspServerDescriptor;
import com.intellij.platform.lsp.api.LspServerSupportProvider;
import com.intellij.platform.lsp.api.lsWidget.LspServerWidgetItem;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/lang/javascript/flow/lsp/FlowJSLspSupportProvider;", "Lcom/intellij/platform/lsp/api/LspServerSupportProvider;", "<init>", "()V", "fileOpened", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "serverStarter", "Lcom/intellij/platform/lsp/api/LspServerSupportProvider$LspServerStarter;", "createLspServerWidgetItem", "Lcom/intellij/platform/lsp/api/lsWidget/LspServerWidgetItem;", "lspServer", "Lcom/intellij/platform/lsp/api/LspServer;", "currentFile", "intellij.javascript.backend"})
public final class FlowJSLspSupportProvider
implements LspServerSupportProvider {
    public void fileOpened(@NotNull Project project, @NotNull VirtualFile file, @NotNull LspServerSupportProvider.LspServerStarter serverStarter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)serverStarter, (String)"serverStarter");
        if (FlowJSLspSupportProviderKt.isFlowLanguageServiceFileType(file)) {
            FlowJSConfig flowJSConfig = FlowJSServerManager.getInstance(project).getConfigForService(file);
            if (flowJSConfig == null) {
                return;
            }
            FlowJSConfig config = flowJSConfig;
            serverStarter.ensureServerStarted((LspServerDescriptor)new FlowJSLspServerDescriptor(project, config));
        }
    }

    @NotNull
    public LspServerWidgetItem createLspServerWidgetItem(@NotNull LspServer lspServer, @Nullable VirtualFile currentFile) {
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        return new FlowServiceWidgetItem(lspServer, currentFile);
    }
}

