/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommentsMover {
    private final List<PsiElement> myBeforeComments;
    private final List<PsiElement> myAfterComments;
    private final boolean myAllowNonStatements;

    public CommentsMover(@NotNull JSSourceElement statement) {
        if (statement == null) {
            CommentsMover.$$$reportNull$$$0(0);
        }
        this(statement, false);
    }

    CommentsMover(@NotNull JSSourceElement statement, boolean allowNonStatements) {
        if (statement == null) {
            CommentsMover.$$$reportNull$$$0(1);
        }
        this.myBeforeComments = CommentsMover.collectBeforeComments(statement);
        this.myAfterComments = CommentsMover.collectAfterComments(statement);
        this.myAllowNonStatements = allowNonStatements;
    }

    @Nullable
    private static PsiElement fixMinToStatement(PsiElement min) {
        return !(min instanceof JSSourceElement) ? PsiTreeUtil.getParentOfType((PsiElement)min, JSSourceElement.class) : min;
    }

    public void move(@NotNull Set<? extends PsiElement> created, @NotNull Collection<? extends PsiElement> touched) {
        if (created == null) {
            CommentsMover.$$$reportNull$$$0(2);
        }
        if (touched == null) {
            CommentsMover.$$$reportNull$$$0(3);
        }
        if (this.myBeforeComments.isEmpty() && this.myAfterComments.isEmpty()) {
            return;
        }
        PsiElement min = Collections.min(created, Comparator.comparingInt(o -> o.getTextRange().getStartOffset()));
        if (min == null) {
            return;
        }
        if (!this.myAllowNonStatements && (min = CommentsMover.fixMinToStatement(min)) == null) {
            return;
        }
        if (!this.myBeforeComments.isEmpty() && this.myBeforeComments.get(0) instanceof JSDocComment) {
            JSDocumentationUtils.moveJSDoc((PsiComment)((PsiComment)this.myBeforeComments.get(0)), (PsiElement)min);
        } else {
            if (this.myAllowNonStatements && (min = CommentsMover.fixMinToStatement(min)) == null) {
                return;
            }
            Collections.reverse(this.myBeforeComments);
            CommentsMover.moveCommentsList(min, this.myBeforeComments, touched);
        }
        if (!this.myAfterComments.isEmpty()) {
            if (this.myAllowNonStatements && (min = CommentsMover.fixMinToStatement(min)) == null) {
                return;
            }
            CommentsMover.moveCommentsList(min.getNextSibling(), this.myAfterComments, touched);
        }
    }

    boolean hasAfterComments() {
        return !this.myAfterComments.isEmpty();
    }

    @NotNull
    private static List<PsiElement> collectBeforeComments(JSSourceElement statement) {
        SmartList comments = new SmartList();
        PsiComment comment = JSDocumentationUtils.findDocComment((PsiElement)statement);
        if (!(comment instanceof JSDocComment)) {
            PsiElement current = statement.getPrevSibling();
            boolean commentsFound = false;
            while (current instanceof PsiComment || current instanceof PsiWhiteSpace) {
                comments.add(current);
                if (commentsFound && current instanceof PsiWhiteSpace && StringUtil.countNewLines((CharSequence)current.getText()) > 1) break;
                commentsFound |= current instanceof PsiComment;
                current = current.getPrevSibling();
            }
            if (!commentsFound) {
                List<PsiElement> list = Collections.emptyList();
                if (list == null) {
                    CommentsMover.$$$reportNull$$$0(4);
                }
                return list;
            }
        } else {
            comments.add(comment);
        }
        SmartList smartList = comments;
        if (smartList == null) {
            CommentsMover.$$$reportNull$$$0(5);
        }
        return smartList;
    }

    @NotNull
    private static List<PsiElement> collectAfterComments(JSSourceElement statement) {
        boolean fallThrough;
        SmartList comments = new SmartList();
        boolean commentsFound = false;
        PsiElement current = statement.getNextSibling();
        boolean bl = fallThrough = statement.getParent() instanceof JSBlockStatement && PsiUtilCore.getElementType((PsiElement)PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)statement)) == JSTokenTypes.RBRACE;
        while (current instanceof PsiComment || current instanceof PsiWhiteSpace) {
            comments.add(current);
            if (commentsFound && !fallThrough && current instanceof PsiWhiteSpace) break;
            commentsFound |= current instanceof PsiComment;
            if (!fallThrough && current.getText().contains("\n")) break;
            current = current.getNextSibling();
        }
        if (!commentsFound) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                CommentsMover.$$$reportNull$$$0(6);
            }
            return list;
        }
        SmartList smartList = comments;
        if (smartList == null) {
            CommentsMover.$$$reportNull$$$0(7);
        }
        return smartList;
    }

    private static void moveCommentsList(@NotNull PsiElement target, @NotNull List<? extends PsiElement> comments, @NotNull Collection<? extends PsiElement> touched) {
        int n;
        if (target == null) {
            CommentsMover.$$$reportNull$$$0(8);
        }
        if (comments == null) {
            CommentsMover.$$$reportNull$$$0(9);
        }
        if (touched == null) {
            CommentsMover.$$$reportNull$$$0(10);
        }
        if (comments.isEmpty()) {
            return;
        }
        for (PsiElement psiElement : comments) {
            PsiElement comment;
            if (!psiElement.isValid()) {
                return;
            }
            if (!(psiElement instanceof PsiComment) || (comment = CommentsMover.findAssociatedElementForComment((PsiComment)psiElement)) == null || !touched.contains(comment)) continue;
            return;
        }
        JSChangeUtil.addComments(comments, (PsiElement)target);
        PsiElement before = comments.get(0).getPrevSibling();
        PsiElement psiElement = comments.get(comments.size() - 1);
        PsiElement after = psiElement.getNextSibling();
        for (PsiElement psiElement2 : comments) {
            psiElement2.getParent().getNode().removeChild(psiElement2.getNode());
        }
        int lastSpaceNewLines = Math.max(1, CommentsMover.countNewLinesIfSpace(psiElement));
        if (before != null && after != null && (n = CommentsMover.countNewLinesIfSpace(before) + CommentsMover.countNewLinesIfSpace(after)) < lastSpaceNewLines) {
            String str = StringUtil.repeat((String)"\n", (int)(lastSpaceNewLines - n));
            JSChangeUtil.addWs((ASTNode)after.getParent().getNode(), (ASTNode)after.getNode(), (String)str);
        }
    }

    private static int countNewLinesIfSpace(@NotNull PsiElement element2) {
        if (element2 == null) {
            CommentsMover.$$$reportNull$$$0(11);
        }
        return element2 instanceof PsiWhiteSpace ? StringUtil.countNewLines((CharSequence)element2.getText()) : 0;
    }

    private static PsiElement findAssociatedSameLineElementForComment(@NotNull PsiComment current) {
        Document document;
        if (current == null) {
            CommentsMover.$$$reportNull$$$0(12);
        }
        if ((document = current.getContainingFile().getViewProvider().getDocument()) == null) {
            return null;
        }
        int startLine = document.getLineNumber(current.getTextRange().getStartOffset());
        for (PsiElement currentOnLine = current.getPrevSibling(); currentOnLine != null && startLine == document.getLineNumber(currentOnLine.getTextRange().getStartOffset()); currentOnLine = currentOnLine.getPrevSibling()) {
            if (!(currentOnLine instanceof JSElement) || currentOnLine instanceof PsiComment) continue;
            return currentOnLine;
        }
        return null;
    }

    static PsiElement findAssociatedElementForComment(PsiComment current) {
        PsiElement sameLineElementForComment = CommentsMover.findAssociatedSameLineElementForComment(current);
        if (sameLineElementForComment != null) {
            return sameLineElementForComment;
        }
        return JSDocumentationUtils.findAttachedElementFromComment((PsiComment)current);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "created";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "touched";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/CommentsMover";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comments";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/CommentsMover";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectBeforeComments";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAfterComments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "move";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "moveCommentsList";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "countNewLinesIfSpace";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findAssociatedSameLineElementForComment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

