/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.intentions.JSQuoteUnquotePropertiesIntentionBase;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSUnquoteLiteralPropertiesIntention
extends JSQuoteUnquotePropertiesIntentionBase {
    @Override
    protected String getActionName() {
        return JavaScriptBundle.message((String)"js.quote.unquote.intention.unquote", (Object[])new Object[0]);
    }

    @Override
    protected boolean canPerformAction(Collection<? extends JSProperty> properties2, Project project) {
        if (properties2.isEmpty()) {
            return false;
        }
        for (JSProperty jSProperty : properties2) {
            String name;
            if (PsiUtilCore.getElementType((PsiElement)jSProperty.getNameIdentifier()) != JSTokenTypes.STRING_LITERAL || (name = jSProperty.getName()) == null || !JSRefactoringUtil.isValidIdentifier(name, project)) continue;
            return true;
        }
        return false;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"js.quote.unquote.intention.unquote.family", (Object[])new Object[0]);
        if (string == null) {
            JSUnquoteLiteralPropertiesIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element2) throws IncorrectOperationException {
        if (project == null) {
            JSUnquoteLiteralPropertiesIntention.$$$reportNull$$$0(1);
        }
        if (element2 == null) {
            JSUnquoteLiteralPropertiesIntention.$$$reportNull$$$0(2);
        }
        for (JSProperty property : JSUnquoteLiteralPropertiesIntention.collectProperties(element2, editor)) {
            String name;
            PsiElement identifier = property.getNameIdentifier();
            if (PsiUtilCore.getElementType((PsiElement)identifier) != JSTokenTypes.STRING_LITERAL || (name = property.getName()) == null || !JSRefactoringUtil.isValidIdentifier(name, project)) continue;
            identifier.replace(JSChangeUtil.createTokenElement((PsiElement)property, (IElementType)JSTokenTypes.IDENTIFIER, (CharSequence)name));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSUnquoteLiteralPropertiesIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSUnquoteLiteralPropertiesIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

