/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.linter.JSLinterSuppressionUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ESLintSuppressionUtil
extends JSLinterSuppressionUtil {
    public static final ESLintSuppressionUtil INSTANCE = new ESLintSuppressionUtil();
    private static final String FILE_COMMENT_PREFIX = "eslint-disable";
    public static final String LINE_COMMENT_PREFIX = "eslint-disable-next-line";
    private static final Pattern LINE_SUPPRESSION_PATTERN = Pattern.compile("(?://|/\\*)\\s*eslint-disable-next-line\\s*(.*?)(?:\\*/)?");
    private static final Pattern FILE_SUPPRESSION_PATTERN = Pattern.compile("/\\*\\s*eslint-disable\\s*(.*?)\\s*\\*/");

    private ESLintSuppressionUtil() {
    }

    @Override
    @NotNull
    protected String getToolName() {
        String string = JavaScriptBundle.message((String)"settings.javascript.linters.eslint.configurable.name", (Object[])new Object[0]);
        if (string == null) {
            ESLintSuppressionUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected String getRulesFromFileLevelComment(@NotNull PsiComment element2) {
        Matcher matcher;
        if (element2 == null) {
            ESLintSuppressionUtil.$$$reportNull$$$0(1);
        }
        if (element2.getNode().getElementType() != JSTokenTypes.C_STYLE_COMMENT) {
            return null;
        }
        String text = element2.getText();
        if (text.contains(FILE_COMMENT_PREFIX) && (matcher = FILE_SUPPRESSION_PATTERN.matcher(text)).matches()) {
            return matcher.group(1).trim();
        }
        return null;
    }

    @Override
    @Nullable
    protected String getRulesFromLineSuppressionComment(@NotNull PsiComment comment) {
        Matcher matcher;
        String text;
        if (comment == null) {
            ESLintSuppressionUtil.$$$reportNull$$$0(2);
        }
        if ((text = comment.getText()).contains(LINE_COMMENT_PREFIX) && (matcher = LINE_SUPPRESSION_PATTERN.matcher(text)).matches()) {
            return matcher.group(1).trim();
        }
        return null;
    }

    @Override
    @NotNull
    protected String buildFileCommentText(@Nullable String existing, @Nullable String toAdd) {
        return ESLintSuppressionUtil.getCommentText(FILE_COMMENT_PREFIX, existing, toAdd);
    }

    @Override
    @NotNull
    protected String buildLineCommentText(@Nullable String ruleCode, @Nullable String existingSuppressions) {
        return ESLintSuppressionUtil.getCommentText(LINE_COMMENT_PREFIX, existingSuppressions, ruleCode);
    }

    @NotNull
    private static String getCommentText(String prefix, @Nullable String existing, @Nullable String toAdd) {
        if (toAdd == null) {
            String string = prefix;
            if (string == null) {
                ESLintSuppressionUtil.$$$reportNull$$$0(3);
            }
            return string;
        }
        String rules = StringUtil.isEmpty((String)existing) ? toAdd : existing + "," + toAdd;
        String string = prefix + (String)(StringUtil.isEmpty((String)rules) ? "" : " " + rules);
        if (string == null) {
            ESLintSuppressionUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/ESLintSuppressionUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/ESLintSuppressionUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRulesFromFileLevelComment";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRulesFromLineSuppressionComment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

