/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.DatabaseRunners;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.console.client.SessionClientHolder;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.DataSourcePerFileMappingsImpl;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridSessionClient;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.intentions.RunQueryInConsoleIntentionAction;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import icons.DatabaseIcons;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseDataSourceAction
extends ActionGroup
implements DumbAware {
    public ChooseDataSourceAction() {
        this.setPopup(true);
        this.getTemplatePresentation().setPerformGroup(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ChooseDataSourceAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        if (AnAction.EMPTY_ARRAY == null) {
            ChooseDataSourceAction.$$$reportNull$$$0(1);
        }
        return AnAction.EMPTY_ARRAY;
    }

    public boolean displayTextInToolbar() {
        return true;
    }

    public void update(@NotNull AnActionEvent e) {
        LocalDataSource dataSource;
        if (e == null) {
            ChooseDataSourceAction.$$$reportNull$$$0(2);
        }
        Presentation p = e.getPresentation();
        if ("ServicesToolbar".equals(e.getPlace())) {
            p.setEnabledAndVisible(false);
            return;
        }
        FileActionContext context = ChooseDataSourceAction.getContext(e);
        if (context == null || !context.isVisible() && !context.isEnabled()) {
            p.setEnabledAndVisible(false);
            return;
        }
        boolean isToolbar = e.isFromActionToolbar();
        DatabaseSession session = DatabaseSessionManager.findSession((AnActionEvent)e);
        Project project = e.getProject();
        LocalDataSource localDataSource = dataSource = session == null ? null : session.getConnectionPoint().getDataSource();
        if (dataSource == null && project != null) {
            dataSource = (LocalDataSource)ReadAction.compute(() -> DataSourcePerFileMappingsImpl.getDataSourcePerFileMapping(project, context.myVirtualFile));
        }
        String fullText = isToolbar ? (dataSource == null ? DatabaseBundle.message((String)"choose.data.source.action.placeholder", (Object[])new Object[0]) : StringUtil.defaultIfEmpty((String)dataSource.getName(), (String)DatabaseBundle.message((String)"choose.data.source.action.empty.placeholder", (Object[])new Object[0]))) : (dataSource == null ? this.getTemplateText() : DatabaseBundle.message((String)"choose.data.source.action.switch.text", (Object[])new Object[0]));
        String text = fullText == null || fullText.length() <= 30 ? fullText : fullText.substring(0, 30) + "\u2026";
        p.setVisible(context.isVisible());
        p.setEnabled(context.isEnabled());
        p.setText(text, false);
        p.setIcon(e.isFromActionToolbar() ? (dataSource == null ? DatabaseIcons.ToolWindowDatabase : dataSource.getIcon()) : null);
        p.setPerformGroup(p.isEnabled());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        FileActionContext context;
        if (e == null) {
            ChooseDataSourceAction.$$$reportNull$$$0(3);
        }
        if ((context = ChooseDataSourceAction.getContext(e)) == null) {
            return;
        }
        DatabaseSession session = DatabaseSessionManager.findSession((AnActionEvent)e);
        RunQueryInConsoleIntentionAction.Manager.chooseAndRunRunners(context.getRunners(session), null, e);
    }

    @Nullable
    private static FileActionContext getContext(@NotNull AnActionEvent e) {
        if (e == null) {
            ChooseDataSourceAction.$$$reportNull$$$0(4);
        }
        if (ChooseDataSourceAction.contextMenuInvokedInsideSelection(e) || ChooseDataSourceAction.contextMenuInvokedOnResultSet(e)) {
            return null;
        }
        PsiFile psiFile = ChooseDataSourceAction.getClientPsiFile(e);
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)psiFile);
        if (psiFile == null || virtualFile == null || !JdbcConsoleProvider.isItPossibleToAttachConsoleTo(virtualFile)) {
            return null;
        }
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiElement elementAt = JdbcConsoleProvider.elementAt(psiFile, null, editor2);
        PsiFile elementPsiFile = elementAt == null ? null : elementAt.getContainingFile();
        PsiFile targetPsiFile = elementPsiFile == null ? psiFile : elementPsiFile;
        return new FileActionContext(targetPsiFile, virtualFile);
    }

    private static boolean contextMenuInvokedInsideSelection(@NotNull AnActionEvent e) {
        if (e == null) {
            ChooseDataSourceAction.$$$reportNull$$$0(5);
        }
        return PlatformUtils.isDataGrip() && e.getPlace().equals("EditorPopup") && EditorUtil.isCaretInsideSelection((Caret)((Caret)e.getData(CommonDataKeys.CARET)));
    }

    private static boolean contextMenuInvokedOnResultSet(@NotNull AnActionEvent e) {
        DataGrid grid;
        DataGridSessionClient client;
        if (e == null) {
            ChooseDataSourceAction.$$$reportNull$$$0(6);
        }
        return (client = DataGridUtil.getDataGridClient(grid = GridUtil.getDataGrid((DataContext)e.getDataContext()))) == null && grid != null;
    }

    @Nullable
    private static PsiFile getClientPsiFile(@NotNull AnActionEvent e) {
        PsiFile psiFile;
        if (e == null) {
            ChooseDataSourceAction.$$$reportNull$$$0(7);
        }
        if ((psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE)) != null) {
            return psiFile;
        }
        JdbcConsole console = (JdbcConsole)((Object)ObjectUtils.tryCast((Object)e.getData(SessionClientHolder.CLIENT_KEY), JdbcConsole.class));
        if (console != null) {
            return console.getFile();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/ChooseDataSourceAction";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/ChooseDataSourceAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getContext";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "contextMenuInvokedInsideSelection";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "contextMenuInvokedOnResultSet";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getClientPsiFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }

    private static class FileActionContext {
        private final PsiFile myFile;
        private final VirtualFile myVirtualFile;

        FileActionContext(@NotNull PsiFile file, @NotNull VirtualFile virtualFile) {
            if (file == null) {
                FileActionContext.$$$reportNull$$$0(0);
            }
            if (virtualFile == null) {
                FileActionContext.$$$reportNull$$$0(1);
            }
            this.myFile = file;
            this.myVirtualFile = virtualFile;
        }

        public boolean isEnabled() {
            JdbcConsole console = JdbcConsoleProvider.getConsole(this.myFile.getProject(), this.myVirtualFile);
            return console == null || console.getSession().isIdle();
        }

        public boolean isVisible() {
            return DbImplUtil.getLanguageDialectForExec((PsiFile)this.myFile) != null && DbImplUtil.getAllDataSourcesForExec((PsiFile)this.myFile).isNotEmpty() && !DbVFSUtils.isAssociatedWithDataSource((VirtualFile)this.myVirtualFile, (Project)this.myFile.getProject());
        }

        @NotNull
        public List<PersistenceConsoleProvider.Runner> getRunners(@Nullable DatabaseSession session) {
            Consumer consumer = newSession -> {
                JdbcConsoleProvider.reattachConsole(this.myFile.getProject(), newSession, this.myVirtualFile);
                DataSourcePerFileMappingsImpl.getInstance(this.myFile.getProject()).setMappingAsync(this.myVirtualFile, newSession == null ? null : newSession.getConnectionPoint().getDataSource(), () -> {
                    if (this.myVirtualFile.isValid()) {
                        ProjectView.getInstance((Project)this.myFile.getProject()).refresh();
                        FileEditorManager.getInstance((Project)this.myFile.getProject()).updateFilePresentation(this.myVirtualFile);
                    }
                });
            };
            @Nls String title = SessionsUtil.getSessionTitle((VirtualFile)this.myVirtualFile);
            List<PersistenceConsoleProvider.Runner> list = session == null ? DatabaseRunners.getAttachDataSourceRunners(this.myFile, title, (Consumer<? super DatabaseSession>)consumer) : DatabaseRunners.getSwitchDataSourceRunners(this.myFile, title, session, (Consumer<? super DatabaseSession>)consumer);
            if (list == null) {
                FileActionContext.$$$reportNull$$$0(2);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ChooseDataSourceAction$FileActionContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ChooseDataSourceAction$FileActionContext";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRunners";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

