/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.typescript;

import com.intellij.javascript.typeEngine.JSToTSTypeConverterKt;
import com.intellij.javascript.types.TSSymbol;
import com.intellij.javascript.types.TSType;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElement;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0014\u0010\r\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/intellij/lang/javascript/psi/types/typescript/TSSymbolBackedByPropertySignature;", "Lcom/intellij/javascript/types/TSSymbol;", "propertySignature", "Lcom/intellij/lang/javascript/psi/JSRecordType$PropertySignature;", "<init>", "(Lcom/intellij/lang/javascript/psi/JSRecordType$PropertySignature;)V", "escapedName", "", "getEscapedName", "()Ljava/lang/String;", "isOptional", "", "()Z", "isTransient", "findPsiDeclarations", "", "Lcom/intellij/psi/PsiElement;", "getType", "Lcom/intellij/javascript/types/TSType;", "intellij.javascript.psi.impl"})
public final class TSSymbolBackedByPropertySignature
implements TSSymbol {
    @NotNull
    private final JSRecordType.PropertySignature propertySignature;

    public TSSymbolBackedByPropertySignature(@NotNull JSRecordType.PropertySignature propertySignature) {
        Intrinsics.checkNotNullParameter((Object)propertySignature, (String)"propertySignature");
        this.propertySignature = propertySignature;
    }

    @Override
    @NotNull
    public String getEscapedName() {
        String string = this.propertySignature.getMemberName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMemberName(...)");
        return string;
    }

    @Override
    public boolean isOptional() {
        return this.propertySignature.isOptional();
    }

    @Override
    public boolean isTransient() {
        return this.propertySignature instanceof TypeScriptProxyImplicitElement;
    }

    @Override
    @NotNull
    public List<PsiElement> findPsiDeclarations() {
        List<PsiElement> list = this.propertySignature.getMemberSource().getAllSourceElements();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAllSourceElements(...)");
        return list;
    }

    @Override
    @Nullable
    public TSType getType() {
        JSType jSType = this.propertySignature.getJSType();
        return jSType != null ? JSToTSTypeConverterKt.toTSType(jSType) : null;
    }
}

