/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.data;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.cpu.calculation.CallTreesSerializer;
import com.jetbrains.nodejs.run.profile.cpu.calculation.V8ProfileLine;
import com.jetbrains.nodejs.run.profile.heap.io.RawSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FlatTopCalls {
    @NonNls
    public static final String JAVA_SCRIPT_GROUP = "JavaScript";
    private final List<V8ProfileLine> myUnknown;
    private final List<V8ProfileLine> mySharedLibraries;
    private final List<V8ProfileLine> myJavaScript;
    private final List<V8ProfileLine> myCpp;
    private final List<V8ProfileLine> myGc;

    public FlatTopCalls() {
        this.myUnknown = new ArrayList<V8ProfileLine>();
        this.mySharedLibraries = new ArrayList<V8ProfileLine>();
        this.myJavaScript = new ArrayList<V8ProfileLine>();
        this.myCpp = new ArrayList<V8ProfileLine>();
        this.myGc = new ArrayList<V8ProfileLine>();
    }

    public FlatTopCalls cloneMe() {
        return new FlatTopCalls(this.myUnknown, this.mySharedLibraries, this.myJavaScript, this.myCpp, this.myGc);
    }

    private FlatTopCalls(List<V8ProfileLine> unknown, List<V8ProfileLine> sharedLibraries, List<V8ProfileLine> javaScript, List<V8ProfileLine> cpp, List<V8ProfileLine> gc) {
        this.myUnknown = unknown;
        this.mySharedLibraries = sharedLibraries;
        this.myJavaScript = javaScript;
        this.myCpp = cpp;
        this.myGc = gc;
    }

    public List<Pair<String, List<V8ProfileLine>>> createPresentation() {
        ArrayList<Pair<String, List<V8ProfileLine>>> list = new ArrayList<Pair<String, List<V8ProfileLine>>>();
        FlatTopCalls.addList(list, this.myUnknown, "Unknown");
        FlatTopCalls.addList(list, this.myGc, "GC");
        FlatTopCalls.addList(list, this.mySharedLibraries, "Shared Libraries");
        FlatTopCalls.addList(list, this.myJavaScript, JAVA_SCRIPT_GROUP);
        FlatTopCalls.addList(list, this.myCpp, "C++");
        return list;
    }

    private static void addList(List<Pair<String, List<V8ProfileLine>>> list, List<V8ProfileLine> subList, String name) {
        if (!subList.isEmpty()) {
            V8ProfileLine line;
            if (subList.size() == 1 && StringUtil.isEmptyOrSpaces((String)(line = subList.get(0)).toString())) {
                line.setPresentation(NodeJSBundle.message("profile.cpu.line.total.text", new Object[0]));
                line.setIsInternal(true);
            }
            list.add((Pair<String, List<V8ProfileLine>>)Pair.create((Object)name, subList));
        }
    }

    public List<V8ProfileLine> getUnknown() {
        return this.myUnknown;
    }

    public List<V8ProfileLine> getSharedLibraries() {
        return this.mySharedLibraries;
    }

    public List<V8ProfileLine> getJavaScript() {
        return this.myJavaScript;
    }

    public List<V8ProfileLine> getCpp() {
        return this.myCpp;
    }

    public List<V8ProfileLine> getGc() {
        return this.myGc;
    }

    public static class MySerializer
    implements RawSerializer<FlatTopCalls> {
        @Override
        public long getRecordSize() {
            return -1L;
        }

        @Override
        public void write(@NotNull DataOutput os, @NotNull FlatTopCalls calls) throws IOException {
            if (os == null) {
                MySerializer.$$$reportNull$$$0(0);
            }
            if (calls == null) {
                MySerializer.$$$reportNull$$$0(1);
            }
            MySerializer.writeList(os, calls.myUnknown);
            MySerializer.writeList(os, calls.mySharedLibraries);
            MySerializer.writeList(os, calls.myJavaScript);
            MySerializer.writeList(os, calls.myCpp);
            MySerializer.writeList(os, calls.myGc);
        }

        private static void writeList(@NotNull DataOutput os, @NotNull List<V8ProfileLine> list) throws IOException {
            if (os == null) {
                MySerializer.$$$reportNull$$$0(2);
            }
            if (list == null) {
                MySerializer.$$$reportNull$$$0(3);
            }
            os.writeInt(list.size());
            for (V8ProfileLine line : list) {
                CallTreesSerializer.writeLine(os, line);
            }
        }

        private static void readList(@NotNull DataInput is, List<V8ProfileLine> list) throws IOException {
            if (is == null) {
                MySerializer.$$$reportNull$$$0(4);
            }
            int size = is.readInt();
            for (int i = 0; i < size; ++i) {
                list.add(CallTreesSerializer.readLine(is, null));
            }
        }

        @Override
        public FlatTopCalls read(@NotNull DataInput is) throws IOException {
            if (is == null) {
                MySerializer.$$$reportNull$$$0(5);
            }
            FlatTopCalls calls = new FlatTopCalls();
            MySerializer.readList(is, calls.myUnknown);
            MySerializer.readList(is, calls.mySharedLibraries);
            MySerializer.readList(is, calls.myJavaScript);
            MySerializer.readList(is, calls.myCpp);
            MySerializer.readList(is, calls.myGc);
            return calls;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "os";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "calls";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "is";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/v8log/data/FlatTopCalls$MySerializer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "write";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeList";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "readList";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

