/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins.wasm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.js.runtime.JSAgentWaiterList;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import com.oracle.truffle.js.runtime.builtins.JSSharedArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssembly;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyMemoryObject;

@ExportLibrary(value=InteropLibrary.class)
public final class JSWebAssemblyMemoryNotifyCallback
implements TruffleObject {
    private static final int INT32_BYTES_PER_ELEMENT = 4;
    private final JSRealm realm;
    private final JSContext context;
    private final Object memSetNotifyCallbackFunction;

    public JSWebAssemblyMemoryNotifyCallback(JSRealm realm, JSContext context, Object memSetNotifyCallbackFunction) {
        this.realm = realm;
        this.context = context;
        this.memSetNotifyCallbackFunction = memSetNotifyCallbackFunction;
    }

    public void attachToMemory(Object wasmMemory) {
        InteropLibrary lib = InteropLibrary.getUncached();
        try {
            lib.execute(this.memSetNotifyCallbackFunction, wasmMemory, this);
        }
        catch (InteropException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
    }

    @ExportMessage
    boolean isExecutable() {
        return true;
    }

    @ExportMessage
    Object execute(Object[] arguments) {
        assert (arguments.length == 3);
        Object embedderData = JSWebAssembly.getEmbedderData(this.realm, arguments[0]);
        assert (embedderData instanceof JSWebAssemblyMemoryObject);
        JSWebAssemblyMemoryObject memoryObject = (JSWebAssemblyMemoryObject)embedderData;
        long address = (Long)arguments[1];
        int count = (Integer)arguments[2];
        JSArrayBufferObject buffer = memoryObject.getBufferObject(this.context, this.realm);
        return JSWebAssemblyMemoryNotifyCallback.atomicsNotify(buffer, (int)address, count);
    }

    private static int atomicsNotify(JSArrayBufferObject buffer, int address, int count) {
        int convertedCount = Integer.max(count, 0);
        JSAgentWaiterList waiterList = JSSharedArrayBuffer.getWaiterList(buffer);
        JSAgentWaiterList.JSAgentWaiterListEntry wl = waiterList.getListForIndex(address * 4);
        return JSAgentWaiterList.JSAgentWaiterListEntry.notifyWaiters(wl, convertedCount);
    }
}

