/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.py.tables.output;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.scientific.py.tables.output.ArrayNodeUtilsKt;
import com.intellij.scientific.py.tables.output.ObjectNodeUtilsKt;
import com.intellij.scientific.py.tables.providers.polars.PyPolarsBaseProvider;
import com.intellij.scientific.tables.api.DSTableDataType;
import com.intellij.scientific.tables.api.TableDataTypeDetector;
import com.intellij.scientific.tables.settings.DSTablesSettingsState;
import com.intellij.util.text.StringKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u001d\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\u0005H\u0002J\n\u0010\r\u001a\u0004\u0018\u00010\u0005H\u0002J\n\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u0002J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0002J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u0011\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000bH\u0002J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u0014\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000bH\u0002J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u0016\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000bH\u0002J\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u0018\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000bH\u0002J\u0018\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u001a\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000bH\u0002J\u0018\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u001c\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000bH\u0002J\u0018\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u001e\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000bH\u0002J\u0018\u0010\u001f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010 \u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010!\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\"\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010#\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010$\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\u0010\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020\u000bH\u0002J\u0010\u0010'\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006("}, d2={"Lcom/intellij/scientific/py/tables/output/PythonTableDataTypeDetector;", "Lcom/intellij/scientific/tables/api/TableDataTypeDetector;", "<init>", "()V", "detectTableType", "Lcom/intellij/scientific/tables/api/DSTableDataType;", "dataObject", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "hasOutputInCurrentSession", "", "data", "", "doShowNumpyArrayAsTable", "doShowNumpyRecArrayAsTable", "doShowEagerTensorAsTable", "doShowTorchTensorAsTable", "isPandasSeries", "isPandasSeriesText", "text", "isDatasetTableData", "isDatasetText", "isEagerTensor", "isEagerTensorText", "isResourceVariable", "isResourceVariableText", "isSparseTensor", "isSparseTensorText", "isTorchTensor", "isTorchTensorText", "isNumpyArray", "isNumpyArrayText", "isNumpyRecArray", "isNumpyRecArrayText", "isPandasDataFrame", "isPolarsDataFrame", "isPolarsSeries", "isPolarsSeriesText", "isPandasDataFrameText", "html", "isPySparkTableData", "intellij.scientific.py.tables"})
@SourceDebugExtension(value={"SMAP\nPythonTableDataTypeDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonTableDataTypeDetector.kt\ncom/intellij/scientific/py/tables/output/PythonTableDataTypeDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,297:1\n1#2:298\n1#2:315\n1761#3,3:299\n1563#3:318\n1634#3,3:319\n774#3:322\n865#3,2:323\n1740#3,2:325\n1742#3:329\n995#4,11:302\n1188#4,2:313\n1190#4:316\n1006#4:317\n1232#5,2:327\n*S KotlinDebug\n*F\n+ 1 PythonTableDataTypeDetector.kt\ncom/intellij/scientific/py/tables/output/PythonTableDataTypeDetector\n*L\n283#1:315\n119#1:299,3\n291#1:318\n291#1:319,3\n292#1:322\n292#1:323,2\n293#1:325,2\n293#1:329\n283#1:302,11\n283#1:313,2\n283#1:316\n283#1:317\n294#1:327,2\n*E\n"})
public final class PythonTableDataTypeDetector
implements TableDataTypeDetector {
    @Nullable
    public DSTableDataType detectTableType(@NotNull ObjectNode dataObject, boolean hasOutputInCurrentSession) {
        Intrinsics.checkNotNullParameter((Object)dataObject, (String)"dataObject");
        return this.isPolarsSeries(dataObject) ? DSTableDataType.POLARS_SERIES : (this.isPolarsDataFrame(dataObject) ? DSTableDataType.POLARS_DATA_FRAME : (this.isPandasDataFrame(dataObject) ? DSTableDataType.PANDAS_DATA_FRAME : (this.isPandasSeries(dataObject, hasOutputInCurrentSession) ? DSTableDataType.PANDAS_SERIES : (this.isNumpyArray(dataObject, hasOutputInCurrentSession) ? this.doShowNumpyArrayAsTable() : (this.isNumpyRecArray(dataObject, hasOutputInCurrentSession) ? this.doShowNumpyRecArrayAsTable() : (this.isEagerTensor(dataObject, hasOutputInCurrentSession) ? this.doShowEagerTensorAsTable() : (this.isResourceVariable(dataObject, hasOutputInCurrentSession) ? DSTableDataType.RESOURCE_VARIABLE : (this.isSparseTensor(dataObject, hasOutputInCurrentSession) ? DSTableDataType.SPARSE_TENSOR : (this.isTorchTensor(dataObject, hasOutputInCurrentSession) ? this.doShowTorchTensorAsTable() : (this.isPySparkTableData(dataObject) ? DSTableDataType.PYSPARK_TABLE : (this.isDatasetTableData(dataObject, hasOutputInCurrentSession) ? DSTableDataType.HF_DATASET : null)))))))))));
    }

    @Nullable
    public DSTableDataType detectTableType(@Nullable String data) {
        if (data == null) {
            return null;
        }
        return this.isPolarsSeriesText(data) ? DSTableDataType.POLARS_SERIES : (PyPolarsBaseProvider.PolarsBaseUtils.extractFrameInfo(data) != null ? DSTableDataType.POLARS_DATA_FRAME : (this.isPandasDataFrameText(data) ? DSTableDataType.PANDAS_DATA_FRAME : (this.isPandasSeriesText(data) ? DSTableDataType.PANDAS_SERIES : (this.isNumpyArrayText(data) ? this.doShowNumpyArrayAsTable() : (this.isNumpyRecArrayText(data) ? this.doShowNumpyRecArrayAsTable() : (this.isEagerTensorText(data) ? this.doShowEagerTensorAsTable() : (this.isResourceVariableText(data) ? DSTableDataType.RESOURCE_VARIABLE : (this.isSparseTensorText(data) ? DSTableDataType.SPARSE_TENSOR : (this.isTorchTensorText(data) ? this.doShowTorchTensorAsTable() : (this.isDatasetText(data) ? DSTableDataType.HF_DATASET : null))))))))));
    }

    private final DSTableDataType doShowNumpyArrayAsTable() {
        return DSTablesSettingsState.Companion.getInstance().getNumpyTorchTensorflowDisplayAsTable() ? DSTableDataType.NUMPY_ARRAY : null;
    }

    private final DSTableDataType doShowNumpyRecArrayAsTable() {
        return DSTablesSettingsState.Companion.getInstance().getNumpyTorchTensorflowDisplayAsTable() ? DSTableDataType.NUMPY_RECARRAY : null;
    }

    private final DSTableDataType doShowEagerTensorAsTable() {
        return DSTablesSettingsState.Companion.getInstance().getNumpyTorchTensorflowDisplayAsTable() ? DSTableDataType.EAGER_TENSOR : null;
    }

    private final DSTableDataType doShowTorchTensorAsTable() {
        return DSTablesSettingsState.Companion.getInstance().getNumpyTorchTensorflowDisplayAsTable() ? DSTableDataType.TORCH_TENSOR : null;
    }

    private final boolean isPandasSeries(ObjectNode dataObject, boolean hasOutputInCurrentSession) {
        if (!hasOutputInCurrentSession) {
            return false;
        }
        if (dataObject.size() != 1) {
            return false;
        }
        String string = ObjectNodeUtilsKt.getTextPlain(dataObject);
        if (string == null) {
            return false;
        }
        String textPlain = string;
        return this.isPandasSeriesText(textPlain);
    }

    private final boolean isPandasSeriesText(String text) {
        block16: {
            block17: {
                boolean bl;
                block15: {
                    Object v1;
                    String it;
                    Object[] objectArray;
                    Object last;
                    block14: {
                        Object object = text;
                        if (object == null || (object = StringsKt.lines((CharSequence)((CharSequence)object))) == null || (object = CollectionsKt.toMutableList((Collection)((Collection)object))) == null) {
                            return false;
                        }
                        Object lines = object;
                        CollectionsKt.removeAll((List)lines, PythonTableDataTypeDetector::isPandasSeriesText$lambda$0);
                        if (lines.size() < 2) break block16;
                        String first = (String)CollectionsKt.first((List)lines);
                        if (StringsKt.startsWith$default((String)first, (String)"<bound method", (boolean)false, (int)2, null)) {
                            return false;
                        }
                        if (!StringsKt.contains$default((CharSequence)first, (CharSequence)" ", (boolean)false, (int)2, null)) {
                            String second = (String)lines.get(1);
                            if (StringsKt.endsWith$default((String)first, (String)"Array>", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)second, (CharSequence)"[", (boolean)false, (int)2, null)) {
                                return false;
                            }
                            if (!StringsKt.contains$default((CharSequence)second, (CharSequence)" ", (boolean)false, (int)2, null)) {
                                return false;
                            }
                        }
                        last = null;
                        last = CollectionsKt.last((List)lines);
                        if (StringsKt.contains$default((CharSequence)((CharSequence)last), (CharSequence)"Categories", (boolean)false, (int)2, null)) {
                            last = lines.get(lines.size() - 2);
                        }
                        if (!StringsKt.contains$default((CharSequence)((CharSequence)last), (CharSequence)"dtype:", (boolean)false, (int)2, null)) break block16;
                        objectArray = new String[]{")", "]", "}"};
                        Iterable iterable = CollectionsKt.listOf((Object[])objectArray);
                        for (Object t : iterable) {
                            it = (String)t;
                            boolean bl2 = false;
                            if (!StringsKt.contains$default((CharSequence)((CharSequence)last), (CharSequence)it, (boolean)false, (int)2, null)) continue;
                            v1 = t;
                            break block14;
                        }
                        v1 = null;
                    }
                    if (v1 == null) break block17;
                    objectArray = new String[]{"datetime", "timedelta", "period", "Sparse"};
                    Iterable $this$any$iv = CollectionsKt.listOf((Object[])objectArray);
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (String)element$iv;
                            boolean bl3 = false;
                            if (!StringsKt.contains$default((CharSequence)((CharSequence)last), (CharSequence)it, (boolean)false, (int)2, null)) continue;
                            bl = true;
                            break block15;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block16;
            }
            return true;
        }
        return false;
    }

    private final boolean isDatasetTableData(ObjectNode dataObject, boolean hasOutputInCurrentSession) {
        if (!hasOutputInCurrentSession) {
            return false;
        }
        String string = ObjectNodeUtilsKt.getTextPlain(dataObject);
        if (string == null) {
            return false;
        }
        String textPlain = string;
        return this.isDatasetText(textPlain);
    }

    private final boolean isDatasetText(String text) {
        if (text == null) {
            return false;
        }
        return StringsKt.startsWith$default((String)text, (String)"Dataset({", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)text, (CharSequence)"features: []", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)text, (CharSequence)"num_rows: 0", (boolean)false, (int)2, null);
    }

    private final boolean isEagerTensor(ObjectNode dataObject, boolean hasOutputInCurrentSession) {
        if (!hasOutputInCurrentSession) {
            return false;
        }
        if (dataObject.size() != 1) {
            return false;
        }
        String string = ObjectNodeUtilsKt.getTextPlain(dataObject);
        if (string == null) {
            return false;
        }
        String textPlain = string;
        return this.isEagerTensorText(textPlain);
    }

    private final boolean isEagerTensorText(String text) {
        if (text == null) {
            return false;
        }
        return StringsKt.startsWith$default((String)text, (String)"<tf.Tensor", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)text, (CharSequence)"array([[", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)text, (CharSequence)"array([[[", (boolean)false, (int)2, null);
    }

    private final boolean isResourceVariable(ObjectNode dataObject, boolean hasOutputInCurrentSession) {
        if (!hasOutputInCurrentSession) {
            return false;
        }
        if (dataObject.size() != 1) {
            return false;
        }
        String string = ObjectNodeUtilsKt.getTextPlain(dataObject);
        if (string == null) {
            return false;
        }
        String textPlain = string;
        return this.isResourceVariableText(textPlain);
    }

    private final boolean isResourceVariableText(String text) {
        if (text == null) {
            return false;
        }
        return StringsKt.startsWith$default((String)text, (String)"<tf.Variable", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)text, (CharSequence)"array([[", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)text, (CharSequence)"array([[[", (boolean)false, (int)2, null);
    }

    private final boolean isSparseTensor(ObjectNode dataObject, boolean hasOutputInCurrentSession) {
        if (!hasOutputInCurrentSession) {
            return false;
        }
        if (dataObject.size() != 1) {
            return false;
        }
        String string = ObjectNodeUtilsKt.getTextPlain(dataObject);
        if (string == null) {
            return false;
        }
        String textPlain = string;
        return this.isSparseTensorText(textPlain);
    }

    private final boolean isSparseTensorText(String text) {
        if (text == null) {
            return false;
        }
        return StringsKt.startsWith$default((String)text, (String)"SparseTensor(", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)text, (CharSequence)"indices=", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)text, (CharSequence)"values=", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)text, (CharSequence)"dense_shape=", (boolean)false, (int)2, null);
    }

    private final boolean isTorchTensor(ObjectNode dataObject, boolean hasOutputInCurrentSession) {
        if (!hasOutputInCurrentSession) {
            return false;
        }
        if (dataObject.size() != 1) {
            return false;
        }
        String string = ObjectNodeUtilsKt.getTextPlain(dataObject);
        if (string == null) {
            return false;
        }
        String textPlain = string;
        return this.isTorchTensorText(textPlain);
    }

    private final boolean isTorchTensorText(String text) {
        if (text == null) {
            return false;
        }
        return StringsKt.startsWith$default((String)text, (String)"tensor([[", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)text, (String)"tensor([[[", (boolean)false, (int)2, null);
    }

    private final boolean isNumpyArray(ObjectNode dataObject, boolean hasOutputInCurrentSession) {
        if (!hasOutputInCurrentSession) {
            return false;
        }
        if (dataObject.size() != 1) {
            return false;
        }
        String string = ObjectNodeUtilsKt.getTextPlain(dataObject);
        if (string == null) {
            return false;
        }
        String textPlain = string;
        return this.isNumpyArrayText(textPlain);
    }

    private final boolean isNumpyArrayText(String text) {
        if (text == null) {
            return false;
        }
        return (StringsKt.startsWith$default((String)text, (String)"array([[", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)text, (String)"array([(", (boolean)false, (int)2, null)) && !StringsKt.startsWith$default((String)text, (String)"array([[[", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)text, (String)"array([[(", (boolean)false, (int)2, null);
    }

    private final boolean isNumpyRecArray(ObjectNode dataObject, boolean hasOutputInCurrentSession) {
        if (!hasOutputInCurrentSession) {
            return false;
        }
        if (dataObject.size() != 1) {
            return false;
        }
        String string = ObjectNodeUtilsKt.getTextPlain(dataObject);
        if (string == null) {
            return false;
        }
        String textPlain = string;
        return this.isNumpyRecArrayText(textPlain);
    }

    private final boolean isNumpyRecArrayText(String text) {
        if (text == null) {
            return false;
        }
        return StringsKt.startsWith$default((String)text, (String)"rec.array([", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)text, (String)"rec.array([[", (boolean)false, (int)2, null);
    }

    private final boolean isPandasDataFrame(ObjectNode dataObject) {
        if (ObjectNodeUtilsKt.getTextPlain(dataObject) == null) {
            return false;
        }
        String string = ObjectNodeUtilsKt.getTextHtml(dataObject);
        if (string == null) {
            return false;
        }
        String textHtml = string;
        return this.isPandasDataFrameText(textHtml);
    }

    private final boolean isPolarsDataFrame(ObjectNode dataObject) {
        if (ObjectNodeUtilsKt.getTextPlain(dataObject) == null) {
            return false;
        }
        String string = ObjectNodeUtilsKt.getTextHtml(dataObject);
        if (string == null) {
            return false;
        }
        String textHtml = string;
        return PyPolarsBaseProvider.PolarsBaseUtils.extractFrameInfo(textHtml) != null;
    }

    private final boolean isPolarsSeries(ObjectNode dataObject) {
        String string = ObjectNodeUtilsKt.getTextHtml(dataObject);
        if (string == null) {
            return false;
        }
        String textHtml = string;
        String string2 = ObjectNodeUtilsKt.getTextPlain(dataObject);
        if (string2 == null) {
            return false;
        }
        String textPlain = string2;
        if (!this.isPolarsSeriesText(textPlain)) {
            return false;
        }
        return PyPolarsBaseProvider.PolarsBaseUtils.extractFrameInfo(textHtml) != null;
    }

    private final boolean isPolarsSeriesText(String text) {
        String[] stringArray = new String[]{"\n"};
        List textLines = StringsKt.split$default((CharSequence)text, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (textLines.size() < 2) {
            return false;
        }
        String firstLine = (String)textLines.get(0);
        String secondLine = (String)textLines.get(1);
        return StringsKt.startsWith$default((String)firstLine, (String)"shape", (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)secondLine, (String)"Series", (boolean)false, (int)2, null);
    }

    private final boolean isPandasDataFrameText(String html) {
        int countTables = SequencesKt.count((Sequence)StringKt.allOccurrencesOf((String)html, (String)"<table"));
        if (countTables != 1) {
            return false;
        }
        return !StringsKt.contains$default((CharSequence)html, (CharSequence)"<progress", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)html, (CharSequence)"<script", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)html, (CharSequence)"dataframe", (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isPySparkTableData(ObjectNode dataObject) {
        boolean bl;
        block14: {
            void $this$all$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            void $this$mapIndexedNotNullTo$iv$iv;
            Iterable $this$mapIndexedNotNull$iv;
            JsonNode jsonNode = dataObject.get("name");
            if (!Intrinsics.areEqual((Object)(jsonNode != null ? jsonNode.asText() : null), (Object)"stdout")) {
                return false;
            }
            JsonNode jsonNode2 = dataObject.get("output_type");
            if (!Intrinsics.areEqual((Object)(jsonNode2 != null ? jsonNode2.asText() : null), (Object)"stream")) {
                return false;
            }
            Object object = dataObject.get("text");
            ArrayNode arrayNode = object instanceof ArrayNode ? (ArrayNode)object : null;
            if (arrayNode == null) {
                return false;
            }
            ArrayNode textArray = arrayNode;
            if (textArray.isEmpty()) {
                return false;
            }
            ArrayNodeUtilsKt.removeLastIf(textArray, (Function1<? super JsonNode, Boolean>)((Function1)PythonTableDataTypeDetector::isPySparkTableData$lambda$0));
            if (textArray.size() < 4) {
                return false;
            }
            String string = textArray.get(0).asText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asText(...)");
            object = string;
            boolean $i$f$mapIndexedNotNull = false;
            Iterator iterator = $this$mapIndexedNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapIndexedNotNullTo = false;
            Iterator $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv$iv2 = 0;
            for (int i = 0; i < $this$forEachIndexed$iv$iv$iv.length(); ++i) {
                Integer it$iv$iv;
                void c;
                void element$iv$iv;
                char item$iv$iv$iv = $this$forEachIndexed$iv$iv$iv.charAt(i);
                int n = index$iv$iv$iv2++;
                char c2 = item$iv$iv$iv;
                int index$iv$iv = n;
                boolean bl2 = false;
                void var17_25 = element$iv$iv;
                int index = index$iv$iv;
                boolean bl3 = false;
                if ((c == 43 ? Integer.valueOf(index) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List delimiterCoordinates = CollectionsKt.dropLast((List)((List)destination$iv$iv), (int)1);
            if (delimiterCoordinates.isEmpty()) {
                return false;
            }
            ArrayNodeUtilsKt.removeLastIf(textArray, (Function1<? super JsonNode, Boolean>)((Function1)PythonTableDataTypeDetector::isPySparkTableData$lambda$2));
            $this$mapIndexedNotNull$iv = (Iterable)textArray;
            boolean $i$f$map = false;
            $this$mapIndexedNotNullTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JsonNode index$iv$iv$iv2 = (JsonNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl5 = false;
                collection.add(it.asText());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl6 = false;
                Intrinsics.checkNotNull((Object)it);
                boolean bl7 = !StringsKt.isBlank((CharSequence)it);
                if (!bl7) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    boolean bl8;
                    block13: {
                        String node = (String)element$iv;
                        boolean bl9 = false;
                        Sequence $this$all$iv2 = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)delimiterCoordinates), arg_0 -> PythonTableDataTypeDetector.isPySparkTableData$lambda$5$0(node, arg_0));
                        boolean $i$f$all2 = false;
                        for (Object element$iv2 : $this$all$iv2) {
                            boolean it = (Boolean)element$iv2;
                            boolean bl10 = false;
                            if (it) continue;
                            bl8 = false;
                            break block13;
                        }
                        bl8 = true;
                    }
                    if (bl8) continue;
                    bl = false;
                    break block14;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean isPandasSeriesText$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((CharSequence)it).length() == 0;
    }

    private static final boolean isPySparkTableData$lambda$0(JsonNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.asText(), (Object)"\n");
    }

    private static final boolean isPySparkTableData$lambda$2(JsonNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.asText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asText(...)");
        return StringsKt.startsWith$default((String)string, (String)"only showing top", (boolean)false, (int)2, null);
    }

    private static final boolean isPySparkTableData$lambda$5$0(String $node, int it) {
        return it < $node.length() && ($node.charAt(it) == '+' || $node.charAt(it) == '|');
    }
}

