/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.util;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VirtualFileUtil {
    public static final char VFS_PATH_SEPARATOR = '/';

    private VirtualFileUtil() {
    }

    public static String buildSystemIndependentPath(@NotNull String rootPath, @NotNull String relativePath) {
        String rootPathIN;
        if (rootPath == null) {
            VirtualFileUtil.$$$reportNull$$$0(0);
        }
        if (relativePath == null) {
            VirtualFileUtil.$$$reportNull$$$0(1);
        }
        return rootPathIN + String.valueOf((rootPathIN = FileUtil.toSystemIndependentName((String)rootPath)).endsWith(String.valueOf('/')) ? "" : Character.valueOf('/')) + FileUtil.toSystemIndependentName((String)relativePath);
    }

    @Nullable
    public static VirtualFile findFile(String path2) {
        if (!StringUtil.isEmpty((String)path2)) {
            return LocalFileSystem.getInstance().findFileByPath(path2);
        }
        return null;
    }

    @NotNull
    public static String getAbsolutePath(@NotNull VirtualFile parent, @NotNull String relPath) {
        if (parent == null) {
            VirtualFileUtil.$$$reportNull$$$0(2);
        }
        if (relPath == null) {
            VirtualFileUtil.$$$reportNull$$$0(3);
        }
        String parentPath = parent.getPath();
        relPath = FileUtil.toSystemIndependentName((String)relPath);
        String result = parentPath.endsWith(File.separator) && relPath.startsWith(File.separator) ? parentPath + relPath.substring(1) : (!parentPath.endsWith(File.separator) && !relPath.startsWith(File.separator) ? parentPath + File.separator + relPath : parentPath + relPath);
        String string = FileUtil.toSystemDependentName((String)result);
        if (string == null) {
            VirtualFileUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String getRelativePath(@NotNull VirtualFile parent, @NotNull String child) {
        if (parent == null) {
            VirtualFileUtil.$$$reportNull$$$0(5);
        }
        if (child == null) {
            VirtualFileUtil.$$$reportNull$$$0(6);
        }
        String parentPath = parent.getPath();
        if ((child = FileUtil.toSystemIndependentName((String)child)).startsWith(parentPath)) {
            String result = child.substring(parentPath.length());
            if (result.startsWith("/") || result.startsWith("\\")) {
                String string = result.substring(1);
                if (string == null) {
                    VirtualFileUtil.$$$reportNull$$$0(7);
                }
                return string;
            }
            String string = result;
            if (string == null) {
                VirtualFileUtil.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = child;
        if (string == null) {
            VirtualFileUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    public static String getRelativePath(VirtualFile parent, VirtualFile child) {
        if (parent == null || child == null) {
            return null;
        }
        return VfsUtilCore.getRelativePath((VirtualFile)child, (VirtualFile)parent, (char)'/');
    }

    public static List<VirtualFile> getHtmlFolders(VirtualFile folder) {
        if (folder == null) {
            return Collections.emptyList();
        }
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        VirtualFileUtil.collectHtmlFolders(folder, result);
        return result;
    }

    private static void collectHtmlFolders(VirtualFile folder, final List<VirtualFile> result) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)folder, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (VirtualFile child : file.getChildren()) {
                    if (child.isDirectory() || !"html".equals(child.getExtension())) continue;
                    result.add(file);
                    break;
                }
                return true;
            }

            @NotNull
            public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(1);
                }
                List list = ContainerUtil.filter((Object[])file.getChildren(), file1 -> file1.isDirectory());
                if (list == null) {
                    1.$$$reportNull$$$0(2);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/django/util/VirtualFileUtil$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/django/util/VirtualFileUtil$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getChildrenIterable";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getChildrenIterable";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        });
    }

    public static Set<VirtualFile> getFiles(VirtualFile root, String ... names) {
        if (root == null) {
            return Collections.emptySet();
        }
        HashSet<VirtualFile> result = new HashSet<VirtualFile>();
        VfsUtilCore.processFilesRecursively((VirtualFile)root, virtualFile -> {
            if (ArrayUtil.contains((Object)virtualFile.getName(), (Object[])names)) {
                result.add((VirtualFile)virtualFile);
            }
            return true;
        });
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relPath";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/util/VirtualFileUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/util/VirtualFileUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbsolutePath";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildSystemIndependentPath";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAbsolutePath";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

