/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.util;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.platform.codeWithMe.util.NetUtilKt;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\u0005J:\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\u00052\u0016\b\u0002\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eJ#\u0010\u0010\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002J-\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\b\b\u0002\u0010\u0018\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/util/NetUtil;", "", "<init>", "()V", "PORT_MIN_VALUE", "", "PORT_MAX_VALUE", "findFirstAvailablePort", "address", "Ljava/net/InetAddress;", "startPort", "endPort", "findRandomAvailablePort", "filter", "Lkotlin/Function1;", "", "findAvailablePortFromLookupArray", "lookupPorts", "", "(Ljava/net/InetAddress;[Ljava/lang/Integer;)I", "checkPortAvailability", "", "port", "getPortsToCheck", "isShuffled", "(IIZ)[Ljava/lang/Integer;", "intellij.platform.split"})
@SourceDebugExtension(value={"SMAP\nNetUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetUtil.kt\ncom/jetbrains/rd/platform/codeWithMe/util/NetUtil\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,113:1\n3919#2:114\n4434#2,2:115\n37#3,2:117\n37#3,2:134\n60#4,5:119\n60#4,5:124\n60#4,5:129\n*S KotlinDebug\n*F\n+ 1 NetUtil.kt\ncom/jetbrains/rd/platform/codeWithMe/util/NetUtil\n*L\n54#1:114\n54#1:115,2\n54#1:117,2\n102#1:134,2\n69#1:119,5\n72#1:124,5\n92#1:129,5\n*E\n"})
public final class NetUtil {
    @NotNull
    public static final NetUtil INSTANCE = new NetUtil();
    private static final int PORT_MIN_VALUE = 1;
    private static final int PORT_MAX_VALUE = 65535;

    private NetUtil() {
    }

    public final int findFirstAvailablePort(@NotNull InetAddress address, int startPort, int endPort) throws IllegalStateException {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return this.findAvailablePortFromLookupArray(address, this.getPortsToCheck(startPort, endPort, false));
    }

    public static /* synthetic */ int findFirstAvailablePort$default(NetUtil netUtil, InetAddress inetAddress, int n, int n2, int n3, Object object) throws IllegalStateException {
        if ((n3 & 2) != 0) {
            n = 1;
        }
        if ((n3 & 4) != 0) {
            n2 = 65535;
        }
        return netUtil.findFirstAvailablePort(inetAddress, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    public final int findRandomAvailablePort(@NotNull InetAddress address, int startPort, int endPort, @Nullable Function1<? super Integer, Boolean> filter) throws IllegalStateException {
        Integer[] integerArray;
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Integer[] lookupPorts = this.getPortsToCheck(startPort, endPort, true);
        if (filter == null) {
            integerArray = lookupPorts;
        } else {
            void $this$toTypedArray$iv;
            void $this$filterTo$iv$iv;
            Collection $this$filter$iv;
            Integer[] integerArray2 = lookupPorts;
            Function1<? super Integer, Boolean> predicate$iv = filter;
            boolean $i$f$filter = false;
            void var10_11 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                if (!((Boolean)predicate$iv.invoke((Object)element$iv$iv)).booleanValue()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            integerArray = thisCollection$iv.toArray(new Integer[0]);
        }
        Integer[] filteredPorts = integerArray;
        return this.findAvailablePortFromLookupArray(address, filteredPorts);
    }

    public static /* synthetic */ int findRandomAvailablePort$default(NetUtil netUtil, InetAddress inetAddress, int n, int n2, Function1 function1, int n3, Object object) throws IllegalStateException {
        if ((n3 & 2) != 0) {
            n = 1;
        }
        if ((n3 & 4) != 0) {
            n2 = 65535;
        }
        if ((n3 & 8) != 0) {
            function1 = null;
        }
        return netUtil.findRandomAvailablePort(inetAddress, n, n2, (Function1<? super Integer, Boolean>)function1);
    }

    private final int findAvailablePortFromLookupArray(InetAddress address, Integer[] lookupPorts) {
        Throwable lastThrowable = null;
        int n = lookupPorts.length;
        for (int i = 0; i < n; ++i) {
            Logger logger;
            boolean $i$f$debug;
            Throwable e$iv;
            Logger $this$debug_u24default$iv;
            int port = lookupPorts[i];
            lastThrowable = this.checkPortAvailability(port, address);
            if (lastThrowable == null) {
                $this$debug_u24default$iv = NetUtilKt.access$getLogger$p();
                e$iv = null;
                $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("Port " + port + " is available.", e$iv);
                }
                return port;
            }
            $this$debug_u24default$iv = NetUtilKt.access$getLogger$p();
            e$iv = null;
            $i$f$debug = false;
            if (!$this$debug_u24default$iv.isDebugEnabled()) continue;
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Failed to bind port " + port + ". Try next one.", e$iv);
        }
        throw new IllegalStateException("Unable to find free port in lookup ports array", lastThrowable);
    }

    private final Throwable checkPortAvailability(int port, InetAddress address) {
        try {
            ServerSocket ss = new ServerSocket();
            ss.setReuseAddress(true);
            ss.bind(new InetSocketAddress(address, port), 50);
            ss.close();
            return null;
        }
        catch (Throwable t) {
            Logger $this$debug_u24default$iv = NetUtilKt.access$getLogger$p();
            Object e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Unable to bind to port " + port + " (address: " + address + ")", (Throwable)e$iv);
            }
            return t;
        }
    }

    private final Integer[] getPortsToCheck(int startPort, int endPort, boolean isShuffled) {
        if (!(startPort >= 1 && endPort <= 65535)) {
            boolean $i$a$-require-NetUtil$getPortsToCheck$22 = false;
            String $i$a$-require-NetUtil$getPortsToCheck$22 = "Provided invalid start or end port value. Available port range: 1..65535";
            throw new IllegalArgumentException($i$a$-require-NetUtil$getPortsToCheck$22.toString());
        }
        Collection $this$toTypedArray$iv = CollectionsKt.toList((Iterable)((Iterable)new IntRange(startPort, endPort)));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] ports = thisCollection$iv.toArray(new Integer[0]);
        if (isShuffled) {
            ArraysKt.shuffle((Object[])ports);
        }
        return ports;
    }

    static /* synthetic */ Integer[] getPortsToCheck$default(NetUtil netUtil, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 4) != 0) {
            bl = false;
        }
        return netUtil.getPortsToCheck(n, n2, bl);
    }
}

