/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.base;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.util.Case;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LightPsiParser;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.PsiParser;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.completion.SqlKeywordCompletionContributor;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlGeneratedParser;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParserUtil;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.injection.SqlSuggestedInjection;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifierKeywordTokenType;
import com.intellij.sql.psi.SqlInfoElementType;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlLazyElementTypeImpl;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ArrayListSet;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlParser
implements PsiParser,
LightPsiParser,
SqlElementTypes {
    private static final WhitespacesAndCommentsBinder TRIM_SPACES_RIGHT = new WhitespacesAndCommentsBinder(){

        public int getEdgePosition(List<? extends IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter) {
            return 0;
        }

        public boolean isRecursive() {
            return true;
        }
    };
    private static final WhitespacesAndCommentsBinder ATTACH_SPACES_RIGHT = new WhitespacesAndCommentsBinder(){

        public int getEdgePosition(List<? extends IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter) {
            for (int i = 0; i < tokens.size(); ++i) {
                if (SqlTokens.WS_TOKENS.contains(tokens.get(i))) continue;
                return i;
            }
            return tokens.size();
        }
    };
    private static final WhitespacesAndCommentsBinder ADD_COMMENT_LEFT = new WhitespacesAndCommentsBinder(){

        public int getEdgePosition(List<? extends IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter) {
            int ws = 0;
            for (int idx = tokens.size() - 1; idx >= 0; --idx) {
                IElementType t = tokens.get(idx);
                if (SqlTokens.COMMENT_TOKENS.contains(t)) {
                    ws = 0;
                    continue;
                }
                if ((ws += StringUtil.countNewLines((CharSequence)getter.get(idx))) <= 1 && idx != 0) continue;
                return idx + 1;
            }
            return 0;
        }
    };
    private static final Pattern PL_PATTERN = Pattern.compile(".*_(?:CREATE|ALTER)_(?:PROCEDURE|FUNCTION|METHOD|TRIGGER|PACKAGE|VIEW)_.*");
    private final SqlLanguageDialectEx myLanguage;
    protected boolean myExternalReferenceJustParsed;
    private int mySeparatorParsed = -1;
    private boolean myStatementRecoverNewLine;
    private static final TokenSet SPLIT_QUALIFIED_REF_PREFIX_TOKENS = TokenSet.create((IElementType[])new IElementType[]{SQL_IDENT, SQL_CUSTOM_PARAM_LQUOTE, SQL_CUSTOM_PARAM_RQUOTE});

    protected SqlParser(SqlLanguageDialectEx language) {
        this.myLanguage = language;
    }

    public SqlLanguageDialectEx getLanguage() {
        return this.myLanguage;
    }

    public boolean shouldParseStatementSeparator(PsiBuilder b) {
        boolean result = !this.isStatementSeparatorParsed(b);
        this.mySeparatorParsed = -1;
        return result;
    }

    public void statementSeparatorParsed(PsiBuilder b) {
        b.eof();
        this.mySeparatorParsed = b.getCurrentOffset();
    }

    public boolean isStatementSeparatorParsed(PsiBuilder b) {
        b.eof();
        return this.mySeparatorParsed == b.getCurrentOffset();
    }

    @NotNull
    public ASTNode parse(@NotNull IElementType root, @NotNull PsiBuilder builder) {
        if (root == null) {
            SqlParser.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            SqlParser.$$$reportNull$$$0(1);
        }
        this.parseLight(root, builder);
        ASTNode aSTNode = builder.getTreeBuilt();
        if (aSTNode == null) {
            SqlParser.$$$reportNull$$$0(2);
        }
        return aSTNode;
    }

    public void parseLight(IElementType root, PsiBuilder initialBuilder) {
        boolean result;
        final PsiBuilder builder = this.adaptBuilder(root, initialBuilder);
        PsiBuilder.Marker marker = SqlGeneratedParserUtil.enter_section_((PsiBuilder)builder, (int)0, (int)1, null);
        if (root instanceof SqlReferenceElementType) {
            result = this.parseReferenceExpression(builder, (SqlReferenceElementType)root);
        } else if (root == SQL_TYPE_ELEMENT) {
            result = this.parseDataType(builder, 0, false);
        } else if (root == SQL_TYPE_ELEMENT_EXT) {
            result = this.parseDataTypeExt(builder);
        } else if (root == SQL_QUERY_EXPRESSION) {
            result = this.parseQueryExpression(builder, 0);
        } else if (root == SQL_TABLE_COLUMNS_LIST) {
            result = this.parseForeignKeyRefList(builder, 0);
        } else if (root == SQL_EXPRESSION) {
            result = this.parseValueExpression(builder, 0, false);
        } else if (root == SQL_STATEMENT) {
            result = this.parseSqlStatement(builder, 0);
        } else if (root == SQL_ARGUMENT_LIST) {
            SqlGeneratedParserUtil.addVariant((PsiBuilder)builder, (String)")");
            result = this.parseArgumentListInner(builder);
        } else if (root == SQL_EVALUABLE_EXPRESSION) {
            result = this.parseEvaluableExpression(builder, 0);
        } else if (this.parseJdbcProcedureCall(builder, 0)) {
            result = true;
        } else if (root instanceof IFileElementType) {
            this.parseScriptDefault(builder);
            result = true;
        } else {
            result = this.parseExtraRoots(root, builder, 0);
        }
        final GeneratedParserUtilBase.ErrorState state = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder);
        final GeneratedParserUtilBase.Parser prev = state.tokenAdvancer;
        state.tokenAdvancer = new GeneratedParserUtilBase.Parser(){

            public boolean parse(PsiBuilder b, int l) {
                state.tokenAdvancer = prev;
                boolean res = SqlGeneratedParserUtil.parseAsTree((GeneratedParserUtilBase.ErrorState)state, (PsiBuilder)builder, (int)0, (IElementType)SqlGeneratedParserUtil.DUMMY_BLOCK, (boolean)true, (GeneratedParserUtilBase.Parser)prev, (GeneratedParserUtilBase.Parser)SqlGeneratedParserUtil.TRUE_CONDITION);
                state.tokenAdvancer = this;
                return res;
            }
        };
        if (!builder.eof()) {
            GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder).currentFrame.errorReportedAt = -1;
        }
        SqlGeneratedParserUtil.exit_section_((PsiBuilder)builder, (int)0, (PsiBuilder.Marker)marker, (IElementType)root, (boolean)result, (boolean)true, (GeneratedParserUtilBase.Parser)SqlGeneratedParserUtil.TRUE_CONDITION);
        state.tokenAdvancer = prev;
    }

    protected boolean parseArgumentListInner(PsiBuilder builder) {
        if (SqlGeneratedParserUtil.parseKnownFunctionArgumentListInner(builder, 0)) {
            return true;
        }
        if (this.parseFunctionParametersStart(builder, 0, null)) {
            if (!SqlGeneratedParserUtil.isCompletionHere(builder, 0) && this.parseFunctionParametersEnd(builder, 0, null) && builder.eof()) {
                return true;
            }
            if (!SqlGeneratedParser.paren_expression_list_inner(builder, 0)) {
                return false;
            }
            return this.parseFunctionParametersEnd(builder, 0, null);
        }
        return false;
    }

    protected boolean parseDataTypeExt(PsiBuilder builder) {
        return this.parseDataType(builder, 0, true) || this.parseTableDataType(builder);
    }

    protected abstract boolean parseExtraRoots(IElementType var1, PsiBuilder var2, int var3);

    @NotNull
    public PsiBuilder adaptBuilder(IElementType root, PsiBuilder initialBuilder) {
        PsiBuilder psiBuilder = SqlGeneratedParserUtil.adapt_builder_(root, initialBuilder, this, this.getExtendsTokenSets());
        if (psiBuilder == null) {
            SqlParser.$$$reportNull$$$0(3);
        }
        return psiBuilder;
    }

    protected abstract TokenSet[] getExtendsTokenSets();

    public abstract boolean parseQueryExpression(PsiBuilder var1, int var2);

    public abstract boolean parseSqlStatement(PsiBuilder var1, int var2);

    protected abstract boolean parseDataType(PsiBuilder var1, int var2, boolean var3);

    protected boolean parseCastDataType(PsiBuilder builder, int level) {
        return this.parseDataType(builder, level, false);
    }

    protected boolean parseIntervalLiteral(PsiBuilder builder, int level) {
        return false;
    }

    protected boolean parseExpressionList(PsiBuilder builder, int level) {
        return false;
    }

    protected boolean parseTableDataType(PsiBuilder builder) {
        return SqlGeneratedParser.table_type(builder, 0, (b, l) -> this.parseDataType(b, l, false));
    }

    public abstract boolean parseValueExpression(PsiBuilder var1, int var2, boolean var3, boolean var4);

    public abstract boolean parseEvaluableExpression(PsiBuilder var1, int var2);

    public abstract boolean parseForeignKeyRefList(PsiBuilder var1, int var2);

    public boolean parseJdbcProcedureCall(PsiBuilder builder, int level) {
        PsiBuilder.Marker marker = builder.mark();
        if (SqlParserUtil.consumeOptionalToken(builder, (IElementType)SQL_LEFT_BRACE)) {
            boolean refAndEqAlreadyParsed = this.parseParameterOrVariableReference(builder, true) && SqlParserUtil.consumeOneOfTokens(builder, new IElementType[]{SQL_OP_EQ}) != null;
            boolean call = StringUtil.equalsIgnoreCase((CharSequence)builder.getTokenText(), (CharSequence)"call");
            if (call || refAndEqAlreadyParsed) {
                if (call) {
                    builder.advanceLexer();
                }
                if (!this.parseStatementInsideJdbcCall(builder, level)) {
                    this.parseJdbcProcedureCallBody(builder, level + 1, refAndEqAlreadyParsed);
                }
                SqlParserUtil.tryConsumeToken(builder, new IElementType[]{SQL_RIGHT_BRACE});
                SqlParserUtil.tryConsumeToken(builder, new IElementType[]{null});
                marker.done((IElementType)JDBC_PROCEDURE_CALL);
                return true;
            }
        }
        marker.rollbackTo();
        return false;
    }

    public boolean parseOdbcSequence(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        if (SqlParserUtil.consumeOptionalToken(builder, (IElementType)SQL_LEFT_BRACE)) {
            String text = builder.getTokenText();
            if (StringUtil.equalsIgnoreCase((CharSequence)text, (CharSequence)"fn")) {
                builder.advanceLexer();
                SqlGeneratedParser.database_function_call_expression(builder, 0);
                SqlParserUtil.tryConsumeToken(builder, new IElementType[]{SQL_RIGHT_BRACE});
                marker.done((IElementType)ODBC_FUNCTION_CALL);
                return true;
            }
            IElementType type = this.getOdbcTokenType(text);
            boolean skip = false;
            if (type != null || this.allowAnyIdentifierInOdbc() && (skip = this.consumeIdentifier(builder))) {
                if (!skip) {
                    builder.advanceLexer();
                }
                this.parseValueExpression(builder, 0, false, true);
                SqlParserUtil.tryConsumeToken(builder, new IElementType[]{SQL_RIGHT_BRACE});
                marker.done((IElementType)(type != null ? type : ODBC_GENERIC));
                return true;
            }
        }
        marker.rollbackTo();
        return false;
    }

    @Nullable
    protected IElementType getOdbcTokenType(@Nullable String text) {
        if (StringUtil.equalsIgnoreCase((CharSequence)text, (CharSequence)"fn")) {
            return ODBC_FUNCTION_CALL;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)text, (CharSequence)"d")) {
            return ODBC_DATE;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)text, (CharSequence)"t")) {
            return ODBC_TIME;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)text, (CharSequence)"ts")) {
            return ODBC_TIMESTAMP;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)text, (CharSequence)"escape")) {
            return ODBC_ESCAPE;
        }
        return null;
    }

    protected boolean allowNoStatementSeparator() {
        return false;
    }

    protected boolean allowAnyIdentifierInOdbc() {
        return false;
    }

    protected boolean parseStatementInsideJdbcCall(PsiBuilder builder, int level) {
        return false;
    }

    public void parseJdbcProcedureCallBody(PsiBuilder builder, int level, boolean refAlreadyParsed) {
        this.parseJdbcProcedureCallBody(builder, level, refAlreadyParsed, SQL_OP_EQ);
    }

    public void parseJdbcProcedureCallBody(PsiBuilder builder, int level, boolean refAlreadyParsed, SqlTokenType ... tokens) {
        if (!refAlreadyParsed && this.parseParameterOrVariableReference(builder, true)) {
            SqlParserUtil.consumeOneOfTokens(builder, (IElementType[])tokens);
        }
        this.parseJdbcFunctionCallExpression(builder, level);
    }

    public boolean parseJdbcFunctionCallExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParser.database_function_call_expression(builder, level);
    }

    public void parseScriptDefault(PsiBuilder builder) {
        this.parseStatementBlockBody(builder, true, SqlGeneratedParserUtil.TRUE_CONDITION);
    }

    public boolean parseStatementSeparatorAndMark(PsiBuilder builder, boolean mark2) {
        IElementType tokenType = builder.getTokenType();
        if (this.getLanguage().getStatementSeparators().contains(tokenType)) {
            builder.advanceLexer();
            if (mark2) {
                this.statementSeparatorParsed(builder);
            }
            return true;
        }
        return false;
    }

    public boolean parseStatementBlockBody(PsiBuilder builder, boolean allowNoSemicolonForLastStatement, SqlTokenType ... endTokens) {
        return this.parseStatementBlockBody(builder, allowNoSemicolonForLastStatement, SqlParserUtil.newTokenCondition((IElementType[])endTokens));
    }

    private boolean parseOuterLanguageStatement(@NotNull PsiBuilder builder) {
        String tokenText;
        if (builder == null) {
            SqlParser.$$$reportNull$$$0(4);
        }
        if ((tokenText = builder.getTokenText()) != null && tokenText.equals("jbIdentifier6b52cc4b")) {
            builder.advanceLexer();
            this.statementSeparatorParsed(builder);
            return true;
        }
        return false;
    }

    public boolean parseStatementBlockBody(PsiBuilder builder, boolean allowNoSemicolonForLastStatement, GeneratedParserUtilBase.Parser endCondition) {
        return this.parseStatementBlockBody(builder, allowNoSemicolonForLastStatement, new GeneratedParserUtilBase.Parser(){

            public boolean parse(PsiBuilder builder, int level) {
                int offset = builder.getCurrentOffset();
                try {
                    SqlParser.this.myStatementRecoverNewLine = false;
                    boolean bl = SqlParser.this.parseOuterLanguageStatement(builder) || SqlParser.this.parseSqlStatement(builder, level);
                    return bl;
                }
                catch (StackOverflowError e) {
                    CharSequence text = builder.getOriginalText();
                    CharSequence fragment = text.subSequence(offset, Math.min(text.length(), builder.getCurrentOffset() + 20));
                    SqlDialectImplUtilCore.LOG.error(SqlParser.this.getLanguage().getDisplayName() + ": " + String.valueOf(fragment), (Throwable)e);
                    throw e;
                }
                finally {
                    SqlParser.this.myStatementRecoverNewLine = false;
                }
            }
        }, endCondition);
    }

    public boolean parseGenericBlockBody(PsiBuilder builder, GeneratedParserUtilBase.Parser nestedParser, GeneratedParserUtilBase.Parser endCondition, GeneratedParserUtilBase.Parser separatorParser, Boolean lastSep, String name) {
        boolean inCompletion = SqlGeneratedParserUtil.isInCompletion(builder, 0);
        builder.eof();
        int currentOffset = builder.getCurrentOffset();
        boolean sepInside = lastSep == null || lastSep == false;
        SqlGeneratedParserUtil.parseAsTree(builder, 0, SQL_DUMMY_BLOCK, false, (b, l) -> {
            int offset = b.getCurrentOffset();
            nestedParser.parse(b, l);
            if (b.getCurrentOffset() == offset && !b.eof()) {
                if (SqlParser.tryParse(b, l, separatorParser)) {
                    SqlGeneratedParserUtil.report_error_((PsiBuilder)b, (boolean)false);
                } else {
                    SqlParserUtil.markTokenAsUnexpectedAndAdvance(b, name);
                }
            }
            if (!sepInside) {
                SqlGeneratedParserUtil.report_error_((PsiBuilder)b, (boolean)separatorParser.parse(b, l));
            }
            return inCompletion || !b.eof();
        }, (b, l) -> {
            if (!sepInside || b.getCurrentOffset() == currentOffset) {
                return endCondition.parse(b, l);
            }
            PsiBuilder.Marker m = b.mark();
            boolean sep = separatorParser.parse(b, l);
            boolean goOn = endCondition.parse(b, l);
            boolean mandatory = goOn || lastSep != null;
            SqlGeneratedParserUtil.report_error_((PsiBuilder)b, (!mandatory || sep ? 1 : 0) != 0);
            m.drop();
            return goOn;
        });
        return builder.getCurrentOffset() != currentOffset;
    }

    public boolean parseStatementBlockBody(PsiBuilder builder, final boolean allowNoSemicolonForLastStatement, final GeneratedParserUtilBase.Parser nestedParser, GeneratedParserUtilBase.Parser endCondition) {
        final boolean inCompletion = SqlGeneratedParserUtil.isInCompletion(builder, 0);
        int currentOffset = builder.getCurrentOffset();
        SqlGeneratedParserUtil.parseAsTree(builder, 0, SQL_DUMMY_BLOCK, false, new GeneratedParserUtilBase.Parser(){

            public boolean parse(PsiBuilder builder, int level) {
                boolean lastFail;
                boolean parsed = false;
                boolean advanced = false;
                if (!SqlParser.this.getLanguage().getStatementSeparators().contains(builder.getTokenType())) {
                    int offset = builder.getCurrentOffset();
                    parsed = nestedParser.parse(builder, level);
                    if (builder.getCurrentOffset() == offset && !builder.eof()) {
                        SqlParserUtil.markTokenAsUnexpectedAndAdvance(builder, "<statement>");
                    }
                    advanced = builder.getCurrentOffset() != offset;
                }
                boolean oneMore = false;
                boolean bl = lastFail = !parsed && builder.eof() && advanced;
                if (SqlParser.this.shouldParseStatementSeparator(builder) && !lastFail) {
                    boolean lastStatement = allowNoSemicolonForLastStatement && SqlGeneratedParserUtil.eof((PsiBuilder)builder, (int)level);
                    boolean optional = !parsed || lastStatement;
                    oneMore = SqlParserUtil.consumeOneOfTokens(builder, optional, SqlParser.this.getLanguage().getStatementSeparators().getTypes()) != null;
                } else if (parsed && inCompletion) {
                    oneMore = SqlParserUtil.endsWithNewLine(builder, 1);
                }
                if (!oneMore && advanced && inCompletion && builder.eof()) {
                    oneMore = SqlParserUtil.hasNMeaningfulNewLines(builder, 2);
                }
                if (parsed) {
                    SqlParser.this.applyStatementMarkerBinders(builder);
                }
                return inCompletion && oneMore || !builder.eof();
            }
        }, endCondition);
        return builder.getCurrentOffset() != currentOffset;
    }

    protected boolean parseBatchBlock(PsiBuilder builder, SqlCompositeElementType batchType, GeneratedParserUtilBase.Parser goParser, GeneratedParserUtilBase.Parser notGoCondition) {
        PsiBuilderImpl.ProductionMarker last;
        PsiBuilder.Marker mark2 = builder.mark();
        if (goParser.parse(builder, 0)) {
            mark2.drop();
            return !builder.eof();
        }
        boolean blockParsed = this.parseStatementBlockBody(builder, true, notGoCondition);
        if (blockParsed && (last = (PsiBuilderImpl.ProductionMarker)builder.getLatestDoneMarker()) != null && last.getStartIndex() <= mark2.getStartIndex()) {
            if (last.getTokenType() == SQL_DUMMY_BLOCK) {
                ((PsiBuilder.Marker)last).drop();
            } else {
                blockParsed = false;
            }
        }
        if (blockParsed) {
            mark2.done((IElementType)batchType);
            mark2.setCustomEdgeTokenBinders(ADD_COMMENT_LEFT, TRIM_SPACES_RIGHT);
        } else {
            mark2.drop();
        }
        if (goParser.parse(builder, 0)) {
            SqlParserUtil.consumeOptionalToken(builder, (IElementType)SQL_INTEGER_TOKEN);
            while (builder.getTokenType() == SQL_SEMICOLON) {
                builder.advanceLexer();
            }
        }
        return !builder.eof();
    }

    public boolean parseStringLiteral(PsiBuilder builder, int level) {
        boolean checkStringIdentifier = false;
        int start = builder.getCurrentOffset();
        PsiBuilder.Marker marker = builder.mark();
        IElementType resultType = this.parseStringLiteralWithCharsetSpec(builder);
        if (resultType == null && (resultType = this.parseStringLiteralInner(builder)) != null) {
            boolean bl = checkStringIdentifier = resultType == SQL_STRING_LITERAL;
        }
        if (resultType == null || checkStringIdentifier && this.allowStringsAsIdentifiers(null) && SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_PERIOD)) {
            if (start == builder.getCurrentOffset()) {
                marker.drop();
            } else {
                marker.rollbackTo();
            }
            return false;
        }
        marker.done(resultType);
        return true;
    }

    @Nullable
    public IElementType parseStringLiteralInner(PsiBuilder builder) {
        PsiBuilder.Marker mark2;
        boolean first = true;
        boolean allowNoopConcat = this.allowNoopStringConcatenation(builder, true);
        while (true) {
            mark2 = builder.mark();
            boolean param = false;
            boolean r = this.consumeStringToken(builder, true);
            if (!r && (r = (param = this.parseExternalParameterImpl(builder, false, false))) && builder.getTokenType() == SQL_PERIOD) {
                PsiBuilder.Marker precede = mark2.precede();
                mark2.rollbackTo();
                mark2 = precede;
                r = false;
            }
            if (!r) {
                boolean bl = r = (!first || this.allowIdentifiersAsStrings(builder)) && SqlGeneratedParserUtil.consumeTokenFast((PsiBuilder)builder, (IElementType)SQL_IDENT_DELIMITED);
            }
            if (!r) break;
            if (first && !(allowNoopConcat &= this.allowNoopStringConcatenation(builder, false)) || param) {
                mark2.drop();
            } else {
                mark2.done((IElementType)SQL_STRING_LITERAL);
            }
            if (!allowNoopConcat) {
                return first ? (param ? null : SQL_STRING_LITERAL) : SQL_STRING_LITERAL_CONCATENATION;
            }
            first = false;
        }
        mark2.drop();
        return null;
    }

    protected boolean allowIdentifiersAsStrings(PsiBuilder builder) {
        return false;
    }

    protected boolean allowNoopStringConcatenation(PsiBuilder builder, boolean first) {
        if (SqlGeneratedParserUtil.isExternalParameterFirst(builder.getTokenType())) {
            return true;
        }
        if (!SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_STRING_TOKEN)) {
            return false;
        }
        String text = builder.getTokenText();
        return text != null && (StringUtil.startsWith((CharSequence)text, (CharSequence)"'") || first && StringUtil.startsWithIgnoreCase((String)text, (String)"n"));
    }

    @Nullable
    protected IElementType parseStringLiteralWithCharsetSpec(PsiBuilder builder) {
        IElementType nextToken;
        PsiBuilder.Marker mark2 = builder.mark();
        if (!this.consumeUnderscoreAndCharSpec(builder)) {
            mark2.drop();
            return null;
        }
        SqlLanguageDialectEx language = this.getLanguage();
        IElementType result = null;
        SqlCompositeElementType parsed = null;
        if (language.supportsSql92CharSetSpecFor((IElementType)SQL_STRING_LITERAL) && (nextToken = builder.getTokenType()) != SQL_IDENT_DELIMITED) {
            result = this.parseStringLiteralInner(builder);
            parsed = SQL_STRING_LITERAL;
        }
        if (result == null && language.supportsSql92CharSetSpecFor((IElementType)SQL_PARAMETER_REFERENCE) && this.parseParameterOrVariableReference(builder, true)) {
            result = SQL_STRING_LITERAL;
        }
        if (result == null && language.supportsSql92CharSetSpecFor((IElementType)SQL_NUMERIC_LITERAL) && SqlGeneratedParserUtil.parseNumber(builder, 0)) {
            result = SQL_STRING_LITERAL;
        }
        if (result != null) {
            if (parsed == null) {
                LighterASTNode last = builder.getLatestDoneMarker();
                IElementType iElementType = parsed = last == null ? null : last.getTokenType();
            }
            if (parsed == null || !language.supportsSql92CharSetSpecFor((IElementType)parsed)) {
                result = null;
            }
        }
        if (result == null) {
            mark2.rollbackTo();
        } else {
            mark2.drop();
        }
        return result;
    }

    public boolean consumeUnderscoreAndCharSpec(PsiBuilder builder) {
        if (SqlGeneratedParserUtil.eof((PsiBuilder)builder, (int)0)) {
            return false;
        }
        IElementType tokenType = builder.getTokenType();
        if (tokenType == SQL_UNDERSCORE) {
            builder.advanceLexer();
            return this.parseCharacterSetSpec(builder);
        }
        if (tokenType == SQL_IDENT) {
            String tokenText = builder.getTokenText();
            if (tokenText == null || tokenText.isEmpty() || tokenText.charAt(0) != '_') {
                return false;
            }
            return this.parseCharacterSetSpec(builder);
        }
        return false;
    }

    public boolean parseNullOrStringLiteral(PsiBuilder builder) {
        PsiBuilder.Marker m = builder.mark();
        if (SqlParserUtil.consumeOptionalToken(builder, (IElementType)SQL_NULL)) {
            m.done((IElementType)SQL_SPECIAL_LITERAL);
            return true;
        }
        m.drop();
        return this.parseStringLiteral(builder, 0);
    }

    public boolean parseStringLiteralOrParameter(PsiBuilder builder) {
        return this.parseNullOrStringLiteral(builder) || this.parseParameterOrVariableReference(builder, true);
    }

    public boolean parseNumberLiteralOrParameter(PsiBuilder builder, boolean allowFloat) {
        if (SqlParserUtil.consumeOptionalToken(builder, (IElementType)SQL_NULL)) {
            return true;
        }
        if (this.parseParameterOrVariableReference(builder, true)) {
            return true;
        }
        return this.parseInteger(builder, allowFloat);
    }

    public boolean consumeStringToken(PsiBuilder builder, boolean optional) {
        if (SqlParserUtil.consumeOptionalToken(builder, (IElementType)SQL_CUSTOM_LQUOTE)) {
            while (SqlParserUtil.consumeOptionalToken(builder, (IElementType)SQL_CUSTOM_QUOTED_STRING_TOKEN) || this.parseExternalParameterImpl(builder, true, true)) {
            }
            if (SqlGeneratedParserUtil.consumeTokenFast((PsiBuilder)builder, (IElementType)SQL_UNCLOSED_TOKEN)) {
                return true;
            }
            SqlParserUtil.consumeToken(builder, (IElementType)SQL_CUSTOM_RQUOTE);
            return true;
        }
        if (SqlGeneratedParserUtil.consumeTokenFast((PsiBuilder)builder, (IElementType)SQL_UNCLOSED_TOKEN)) {
            return true;
        }
        return SqlParserUtil.consumeToken(builder, optional, (IElementType)SQL_STRING_TOKEN);
    }

    public boolean parseReferenceExpression(PsiBuilder builder, SqlReferenceElementType refType) {
        return this.parseReferenceExpressionInner(builder, false, refType);
    }

    public boolean parseReferenceExpression(PsiBuilder builder, boolean optional, SqlReferenceElementType refType) {
        return this.parseReferenceExpressionInner(builder, optional, refType);
    }

    public boolean parseReferenceExpressionInner(PsiBuilder builder, boolean optional, SqlReferenceElementType refType) {
        return this.parseReferenceExpressionInner(builder, optional, !optional, refType);
    }

    public boolean parseReferenceExpressionOrVariable(PsiBuilder builder, SqlReferenceElementType refType) {
        if ((refType == SQL_VARIABLE_REFERENCE || this.getVariableType(builder) != null) && refType != SQL_OPERATOR_REFERENCE) {
            return this.parseParameterOrVariableReference(builder, false);
        }
        return this.parseReferenceExpressionInner(builder, true, true, refType);
    }

    @Nullable
    protected IElementType getVariableType(PsiBuilder builder) {
        if (this.getLanguage().isOperatorSupported(builder.getTokenType())) {
            return null;
        }
        if (this.isParameterReference(builder)) {
            return SQL_PARAMETER_REFERENCE;
        }
        if (this.isVariableReference(builder)) {
            return SQL_VARIABLE_REFERENCE;
        }
        return null;
    }

    protected boolean isParameterReference(PsiBuilder builder) {
        return builder.getTokenType() == SQL_COLON;
    }

    protected boolean isVariableReference(PsiBuilder builder) {
        IElementType type = builder.getTokenType();
        if (type != SQL_IDENT) {
            return type == SQL_AT_SIGN;
        }
        String text = builder.getTokenText();
        return this.myLanguage.isVariablePrefix(text) || text != null && text.startsWith("@");
    }

    public boolean mergeOperatorWithQuestionMark(PsiBuilder builder) {
        return false;
    }

    public boolean parseCustomOperator(PsiBuilder builder, IElementType type, boolean mandatoryQuestion) {
        IElementType tokenType = builder.getTokenType();
        if (this.myLanguage.isOperatorSupported(tokenType)) {
            PsiBuilder.Marker m = builder.mark();
            if (builder.rawLookup(1) == SQL_QUESTION_MARK && this.myLanguage.isOperatorSupported((IElementType)SQL_QUESTION_MARK) && this.mergeOperatorWithQuestionMark(builder)) {
                builder.advanceLexer();
            } else if (mandatoryQuestion) {
                m.rollbackTo();
                return false;
            }
            builder.advanceLexer();
            m.done((IElementType)SQL_IDENTIFIER);
            if (type != null) {
                m.precede().done(type);
            }
            return true;
        }
        return false;
    }

    private boolean parseOperatorReferenceExpression(PsiBuilder builder, boolean optional, boolean force, SqlReferenceElementType refType) {
        if (this.parseCustomOperator(builder, (IElementType)refType, false)) {
            return true;
        }
        if (!this.parsingOperatorsAsIdentifier()) {
            if (!optional) {
                PsiBuilder.Marker m = builder.mark();
                m.done((IElementType)SQL_REFERENCE);
            }
            return !optional;
        }
        return this.parseQualifiedReferenceExpression(builder, optional, force, refType);
    }

    public boolean parseReferenceExpressionInner(PsiBuilder builder, boolean optional, boolean force, SqlReferenceElementType refType) {
        if (refType == SQL_OPERATOR_REFERENCE) {
            return this.parseOperatorReferenceExpression(builder, optional, force, refType);
        }
        return this.parseQualifiedReferenceExpression(builder, optional, force, refType);
    }

    public boolean parseAtSymbolNext(PsiBuilder builder, SqlReferenceElementType refType, int endOffset) {
        if (refType != SQL_USER_REFERENCE && endOffset != -1 && endOffset < builder.getCurrentOffset()) {
            return false;
        }
        if (this.isVariableReference(builder)) {
            builder.advanceLexer();
            return true;
        }
        return SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_IDENT) && StringUtil.startsWithChar((CharSequence)builder.getTokenText(), (char)'@');
    }

    private boolean isSplitQualifiedRef(PsiBuilder builder) {
        if (builder.getTokenType() != this.getSplitIdentifierStart()) {
            return false;
        }
        int i = 1;
        IElementType type;
        while ((type = builder.lookAhead(i)) != SQL_PERIOD) {
            if (!SPLIT_QUALIFIED_REF_PREFIX_TOKENS.contains(type)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean parseQualifiedReferenceExpression(PsiBuilder builder, boolean optional, boolean force, SqlReferenceElementType refType) {
        int endOffset;
        boolean isSplitRef;
        boolean bl = isSplitRef = this.allowIdentifierSplit(refType) && this.isSplitQualifiedRef(builder);
        if (isSplitRef) {
            builder.advanceLexer();
            boolean result = this.parseQualifiedReferenceExpression(builder, optional, force, refType);
            if (!result) {
                return false;
            }
            if (builder.getTokenType() == SQL_PERIOD) {
                SqlGeneratedParserUtil.setOn(builder, 0, "SPLIT_REF");
            } else {
                SqlGeneratedParserUtil.consumeTokenFast((PsiBuilder)builder, (IElementType)this.getSplitIdentifierEnd());
                PsiBuilder.Marker marker = (PsiBuilder.Marker)builder.getLatestDoneMarker();
                if (marker != null) {
                    marker.drop();
                }
            }
            return true;
        }
        boolean qualified = this.isQualified(refType);
        if (qualified && SqlGeneratedParserUtil.isQualificationForbidden(builder, 0)) {
            qualified = false;
            refType = SqlGeneratedParserUtil.shorten(refType);
        }
        PsiBuilder.Marker m = builder.mark();
        if (!this.parseIdentifierOrAsteriskInner(builder, optional, !optional || force || qualified && builder.rawLookup(1) == SQL_PERIOD, refType == SQL_CHARSET_REFERENCE, refType)) {
            m.drop();
            return false;
        }
        LighterASTNode latestDoneMarker = builder.getLatestDoneMarker();
        int n = endOffset = latestDoneMarker == null ? -1 : latestDoneMarker.getEndOffset();
        if (latestDoneMarker != null && this.myExternalReferenceJustParsed && refType.getTargetKind() == ObjectKind.COLUMN) {
            ((PsiBuilder.Marker)latestDoneMarker).drop();
            m.drop();
        } else {
            SqlReferenceElementType customRefType = this.getPreviousQualifiedReferenceTypeByDelimiter(builder);
            SqlReferenceElementType effectiveRefType = customRefType != null ? customRefType : (qualified && SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_PERIOD) ? SQL_REFERENCE : refType);
            m.done((IElementType)effectiveRefType);
        }
        return !qualified || this.parseQualifiedReferenceExpressionTail(builder, refType, endOffset);
    }

    protected boolean isQualified(SqlReferenceElementType refType) {
        return refType.isQualified();
    }

    protected boolean consumeQualificationToken(PsiBuilder builder) {
        return SqlGeneratedParserUtil.consumeTokenFast((PsiBuilder)builder, (IElementType)SQL_PERIOD);
    }

    @Nullable
    protected SqlReferenceElementType getPreviousQualifiedReferenceTypeByDelimiter(PsiBuilder builder) {
        return null;
    }

    @Nullable
    protected SqlReferenceElementType getCurrentQualifiedReferenceTypeByDelimiter(PsiBuilder builder) {
        return null;
    }

    private boolean parseQualifiedReferenceExpressionTail(PsiBuilder builder, SqlReferenceElementType refType, int endOffset) {
        PsiBuilder.Marker m = (PsiBuilder.Marker)builder.getLatestDoneMarker();
        if (m == null) {
            builder.error(DatabaseBundle.message((String)"parsing.error.qualification.needs.expression.to.qualify", (Object[])new Object[0]));
            return false;
        }
        while (true) {
            LighterASTNode marker;
            boolean atSign;
            SqlReferenceElementType customRefType = this.getCurrentQualifiedReferenceTypeByDelimiter(builder);
            if (this.consumeQualificationToken(builder)) {
                atSign = false;
            } else if (this.parseAtSymbolNext(builder, refType, endOffset)) {
                atSign = true;
            } else {
                return true;
            }
            m = m.precede();
            if (atSign) {
                if (!this.parseReferenceExpressionInner(builder, false, SQL_GENERIC_AT_REFERENCE)) {
                    break;
                }
            } else if (SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_PERIOD)) {
                builder.mark().done((IElementType)SQL_IDENTIFIER);
            } else if (!this.parseIdentifierOrAsteriskInner(builder, false, false, refType == SQL_CHARSET_REFERENCE, refType)) break;
            if (customRefType == null) {
                customRefType = this.getPreviousQualifiedReferenceTypeByDelimiter(builder);
            }
            int n = endOffset = (marker = builder.getLatestDoneMarker()) == null ? -1 : marker.getEndOffset();
            SqlReferenceElementType effectiveElementType = customRefType != null ? customRefType : (SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_PERIOD) ? SQL_REFERENCE : refType);
            m.done((IElementType)effectiveElementType);
        }
        m.done((IElementType)refType);
        return true;
    }

    protected boolean parsingOperatorsAsIdentifier() {
        return true;
    }

    public boolean parseIdentifier(PsiBuilder builder, boolean optional) {
        return this.parseIdentifierInner(builder, optional, !optional, false, null);
    }

    public boolean allowIdentifierSplit(SqlReferenceElementType refType) {
        return false;
    }

    @Nullable
    public IElementType getSplitIdentifierStart() {
        return null;
    }

    @Nullable
    public IElementType getSplitIdentifierEnd() {
        return null;
    }

    public boolean parsePossiblySplitIdentifier(PsiBuilder builder, SqlReferenceElementType refType, SqlTokenType startQuote, SqlTokenType endQuote, GeneratedParserUtilBase.Parser innerParse) {
        boolean allowSplit = this.allowIdentifierSplit(refType);
        if (SqlParserUtil.nextTokenIs(builder, (IElementType)startQuote) && !allowSplit) {
            PsiBuilder.Marker m = builder.mark();
            SqlGeneratedParserUtil.consumeDelimited(builder, startQuote, endQuote);
            m.done((IElementType)SQL_IDENTIFIER);
            return true;
        }
        return innerParse.parse(builder, 0);
    }

    public boolean parseIdentifierInner(PsiBuilder builder, boolean optional, boolean allowKeywords, boolean allowCharSetSpec, SqlReferenceElementType refType) {
        PsiBuilder.Marker mark2 = builder.mark();
        if (!allowCharSetSpec && this.getLanguage().supportsSql92CharSetSpecFor((IElementType)SQL_IDENTIFIER) && (builder.lookAhead(1) == SQL_IDENT || builder.lookAhead(1) instanceof SqlIdentifierKeywordTokenType)) {
            this.consumeUnderscoreAndCharSpec(builder);
        }
        if (this.consumeIdentifier(builder, allowKeywords, this.allowStringsAsIdentifiers(refType), refType)) {
            mark2.done((IElementType)SQL_IDENTIFIER);
            return true;
        }
        if (!optional) {
            mark2.error(SqlBundle.message((String)"identifier.expected", (Object[])new Object[0]));
        } else {
            mark2.drop();
        }
        return false;
    }

    public boolean parseIdentifierOrAsteriskInner(PsiBuilder builder, boolean optional, boolean allowKeywords, boolean allowCharSetSpec, SqlReferenceElementType refType) {
        if (!SqlGeneratedParserUtil.nextTokenIsFast((PsiBuilder)builder, (IElementType)SQL_ASTERISK)) {
            return this.parseIdentifierInner(builder, optional, allowKeywords, allowCharSetSpec, refType);
        }
        return SqlParserUtil.consumeToken(builder, optional, (IElementType)SQL_ASTERISK);
    }

    public boolean allowStringsAsIdentifiers(@Nullable SqlReferenceElementType refType) {
        return false;
    }

    public boolean consumeIdentifier(PsiBuilder builder) {
        return this.consumeIdentifier(builder, true, this.allowStringsAsIdentifiers(null));
    }

    public boolean consumeIdentifier(PsiBuilder builder, boolean allowKeywords, boolean allowString) {
        return this.consumeIdentifier(builder, allowKeywords, allowString, null);
    }

    public boolean consumeIdentifier(PsiBuilder builder, boolean allowKeywords, boolean allowString, @Nullable SqlReferenceElementType refType) {
        return this.consumeIdentifier(builder, allowKeywords, allowString, true, refType);
    }

    public boolean consumeIdentifier(PsiBuilder builder, boolean allowKeywords, boolean allowString, boolean canFollowParameterRef, @Nullable SqlReferenceElementType refType) {
        boolean external = this.parseExternalParameterImpl(builder, false, false);
        boolean advance = !external || builder.rawLookup(0) == builder.getTokenType();
        boolean bl = advance = advance && this.consumeIdentifierInner(builder, allowKeywords, allowString, refType);
        if (canFollowParameterRef && advance && !this.isWhitespaceHere(builder)) {
            this.parseExternalParameterImpl(builder, true, false);
            this.myExternalReferenceJustParsed = false;
        }
        return external || advance || this.parseQuestionMarkParameter(builder);
    }

    private boolean isWhitespaceHere(PsiBuilder builder) {
        return this.isWhitespace(builder.rawLookup(0)) || this.isWhitespace(builder.rawLookup(-1));
    }

    protected boolean consumeIdentifierInner(PsiBuilder builder, boolean allowKeywords, boolean allowString, @Nullable SqlReferenceElementType refType) {
        boolean advance = this.isIdentifierToken(builder, builder.getTokenType(), allowKeywords, allowString);
        if (advance) {
            IElementType tokenType = builder.getTokenType();
            if (tokenType instanceof SqlKeywordTokenType) {
                PsiBuilder.Marker m = builder.mark();
                builder.advanceLexer();
                m.collapse((IElementType)((SqlKeywordTokenType)tokenType).getIdentifierToken());
            } else {
                builder.advanceLexer();
            }
        }
        return advance;
    }

    protected boolean isIdentifierToken(PsiBuilder builder, @Nullable IElementType token, boolean allowKeywords, boolean allowString) {
        return token == SQL_IDENT || token == SQL_IDENT_DELIMITED || token == SQL_MODULE || token instanceof SqlKeywordTokenType && (allowKeywords || !this.isReservedKeywordHere(builder, token)) || allowString && token == SQL_STRING_TOKEN;
    }

    public boolean parseCharacterSetSpec(PsiBuilder builder) {
        return this.parseReferenceExpression(builder, SQL_CHARSET_REFERENCE);
    }

    protected boolean allowQuestionMarkParameter(PsiBuilder builder) {
        return !SqlGeneratedParserUtil.isOn(builder, 0, "DISABLE_QUESTION_PARAM");
    }

    public boolean parseQuestionMarkParameter(PsiBuilder builder) {
        if (SqlGeneratedParserUtil.nextTokenIsFast((PsiBuilder)builder, (IElementType)SQL_QUESTION_MARK) && this.allowQuestionMarkParameter(builder)) {
            PsiBuilder.Marker marker = builder.mark();
            SqlParserUtil.consumeToken(builder, (IElementType)SQL_QUESTION_MARK);
            SqlGeneratedParserUtil.consumeTokenFast((PsiBuilder)builder, (IElementType)SQL_INTEGER_TOKEN);
            marker.done((IElementType)SQL_PARAMETER_REFERENCE);
            return true;
        }
        return false;
    }

    public boolean parseParameterOrVariableReference(PsiBuilder builder, boolean optional) {
        PsiBuilder.Marker marker = builder.mark();
        if (this.parseQuestionMarkParameter(builder) || this.parseExternalParameterImpl(builder, false, true)) {
            if (builder.getTokenType() == SQL_PERIOD) {
                marker.rollbackTo();
                return false;
            }
            marker.drop();
            return true;
        }
        IElementType variableType = this.getVariableType(builder);
        if (variableType != null) {
            marker.drop();
            return this.parseParameterReferenceInner(builder, variableType);
        }
        IElementType resultType = this.consumeCustomParameterReference(builder);
        if (resultType == null) {
            marker.rollbackTo();
        } else {
            marker.done(resultType);
        }
        return resultType == null && !optional ? this.parseReferenceExpressionInner(builder, true, SQL_VARIABLE_REFERENCE) : resultType != null;
    }

    protected boolean parseExternalParameterImpl(PsiBuilder builder, boolean checkStart, boolean checkEnd) {
        this.myExternalReferenceJustParsed = false;
        if (!SqlGeneratedParserUtil.parseUserParameter(builder, checkStart, checkEnd)) {
            return false;
        }
        this.myExternalReferenceJustParsed = true;
        return true;
    }

    protected boolean parseParameterReferenceInner(PsiBuilder builder, IElementType resultType) {
        PsiBuilder.Marker mark2 = builder.mark();
        this.consumeParameterReferenceInner(builder);
        mark2.done(resultType);
        return true;
    }

    protected void consumeParameterReferenceInner(PsiBuilder builder) {
        boolean optional;
        if (builder.getTokenType() != SQL_IDENT) {
            builder.advanceLexer();
        }
        this.parseIdentifier(builder, false);
        boolean bl = optional = !SqlGeneratedParserUtil.consumeTokenFast((PsiBuilder)builder, (IElementType)SQL_INDICATOR);
        if (SqlParserUtil.consumeToken(builder, optional, (IElementType)SQL_COLON)) {
            this.parseIdentifier(builder, false);
        }
    }

    public IElementType consumeCustomParameterReference(PsiBuilder builder) {
        return null;
    }

    public boolean isReservedKeywordHere(PsiBuilder builder, IElementType type) {
        return type instanceof SqlKeywordTokenType && this.myLanguage.isReservedKeyword(type);
    }

    public boolean parseReferenceOrFunction(PsiBuilder builder, int level, boolean optional) {
        boolean skipFunction;
        IElementType type = builder.getTokenType();
        boolean bl = skipFunction = this.isReservedKeywordHere(builder, type) && !this.myLanguage.getSupportedFunctions().contains(builder.getTokenText()) && builder.rawLookup(1) != SQL_PERIOD;
        if (!skipFunction && SqlGeneratedParser.primary_expression(builder, level)) {
            LighterASTNode resultMarker = builder.getLatestDoneMarker();
            if (resultMarker != null && resultMarker.getTokenType() == SQL_REFERENCE) {
                ((PsiBuilderImpl.ProductionMarker)resultMarker).remapTokenType((IElementType)(SqlGeneratedParserUtil.isQualificationForbidden(builder, level) ? SQL_COLUMN_SHORT_REFERENCE : SQL_COLUMN_REFERENCE));
            }
            return true;
        }
        if (!optional) {
            builder.error(DatabaseBundle.message((String)"parsing.error.expression.required", (Object[])new Object[0]));
        }
        return false;
    }

    public boolean parseParenContentQorV(PsiBuilder builder, int level) {
        return this.parseValueExpression(builder, level, false);
    }

    public boolean parseParenContentQorJ(PsiBuilder builder, int level) {
        return this.parseQueryExpression(builder, level);
    }

    public boolean parseLValueExpression(PsiBuilder builder, int level) {
        if (SqlGeneratedParser.primary_expression(builder, level)) {
            LighterASTNode resultMarker = Objects.requireNonNull(builder.getLatestDoneMarker());
            if (resultMarker.getTokenType() == SQL_REFERENCE) {
                ((PsiBuilderImpl.ProductionMarker)resultMarker).remapTokenType((IElementType)SQL_COLUMN_REFERENCE);
            }
            return true;
        }
        return false;
    }

    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional) {
        return this.parseValueExpression(builder, level, optional, true);
    }

    protected Pair<String, Boolean> extractString(PsiBuilder builder, int start, int end) {
        int si;
        int ei;
        int moffs = -builder.rawTokenIndex();
        for (ei = 0; ei >= moffs && builder.rawTokenTypeStart(ei) > end; --ei) {
        }
        for (si = ei; si >= moffs && builder.rawTokenTypeStart(si) >= start; --si) {
        }
        if (ei - ++si < 1) {
            return Pair.create((Object)"", (Object)true);
        }
        int from = builder.rawTokenTypeStart(si);
        int to = builder.rawTokenTypeStart(ei);
        StringBuilder res = new StringBuilder(to - from);
        boolean plain = true;
        while (si < ei) {
            IElementType type = builder.rawLookup(si);
            if (this.isWhitespace(type)) {
                res.append(" ");
            } else if (!SqlGeneratedParserUtil.isWhitespaceOrComment((PsiBuilder)builder, (IElementType)type)) {
                CharSequence text = builder.getOriginalText().subSequence(builder.rawTokenTypeStart(si), builder.rawTokenTypeStart(si + 1));
                if (type == SQL_IDENT_DELIMITED) {
                    text = NamingServices.getNamingService((Dbms)this.getLanguage().getDbms()).unquoteIdentifier(text.toString());
                    plain = false;
                }
                res.append(text);
            }
            ++si;
        }
        return Pair.create((Object)res.toString(), (Object)plain);
    }

    public boolean parseKnownFunctionArgumentList(PsiBuilder builder, int level) {
        LighterASTNode refMarker = Objects.requireNonNull(builder.getLatestDoneMarker());
        Pair<String, Boolean> name = this.extractString(builder, refMarker.getStartOffset(), refMarker.getEndOffset());
        return this.parseKnownFunctionArgumentList(builder, level, ((String)name.first).trim(), (Boolean)name.second, false, false);
    }

    public boolean parseKnownFunctionArgumentList(PsiBuilder builder, int level, String fName, boolean isPlain, boolean ignoreParens, boolean qualified) {
        if (fName == null) {
            return false;
        }
        Case plain = this.myLanguage.getDatabaseDialect().getCasing((ObjectKind)ObjectKind.NONE, null).plain;
        String functionName = plain == Case.EXACT ? fName : Case.UPPER.apply(fName);
        BuiltinFunction definition = this.myLanguage.getSupportedFunctions().get(functionName);
        if (definition == null) {
            return false;
        }
        if (qualified && definition.getDialectAttribute("postfix") == null) {
            return false;
        }
        PsiElement element = SqlLazyElementTypeImpl.getContextElement((PsiBuilder)builder);
        SqlFunctionCallExpression call = (SqlFunctionCallExpression)ObjectUtils.tryCast((Object)(element == null ? null : element.getParent()), SqlFunctionCallExpression.class);
        SqlReferenceExpression foo = call == null ? null : call.getNameElement();
        Set locations = this.myLanguage.getExpectedFunctionLocations((SqlExpression)foo);
        if (!SqlImplUtil.hasLocationOf((BuiltinFunction)definition, (Set)locations)) {
            return false;
        }
        return this.parseFunctionParametersAndParens(builder, level + 1, functionName, definition, isPlain, ignoreParens, locations);
    }

    private static boolean isTableFunctionLocation(PsiBuilder builder) {
        GeneratedParserUtilBase.Frame frame = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder).currentFrame;
        while (frame != null && frame.elementType == null) {
            frame = frame.parentFrame;
        }
        while (frame != null && frame.elementType == SQL_FUNCTION_CALL) {
            frame = frame.parentFrame;
        }
        while (frame != null && frame.elementType == null) {
            frame = frame.parentFrame;
        }
        return frame != null && frame.elementType == SQL_TABLE_PROCEDURE_CALL_EXPRESSION;
    }

    protected boolean shouldRemapToCallable(IElementType refMarkerTokenType) {
        return refMarkerTokenType instanceof SqlReferenceElementType && refMarkerTokenType != SQL_METHOD_REFERENCE && !this.getLanguage().isSpecialFunctionReference(refMarkerTokenType);
    }

    public boolean parseFunctionCallTail(PsiBuilder builder, int level) {
        LighterASTNode refMarker = Objects.requireNonNull(builder.getLatestDoneMarker());
        IElementType refMarkerTokenType = refMarker.getTokenType();
        if (!this.canBeCalled(refMarkerTokenType, builder)) {
            return false;
        }
        Pair<String, Boolean> name = this.extractString(builder, refMarker.getStartOffset(), refMarker.getEndOffset());
        Case plain = this.myLanguage.getDatabaseDialect().getCasing((ObjectKind)ObjectKind.NONE, null).plain;
        String functionName = plain == Case.EXACT ? ((String)name.first).trim() : Case.UPPER.apply(((String)name.first).trim());
        BuiltinFunction definition = this.myLanguage.getSupportedFunctions().get(functionName);
        if (SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_LEFT_PAREN)) {
            boolean forbidParen;
            boolean bl = forbidParen = definition != null && "prohibited".equals(definition.getDialectAttribute("parens")) && (this.isOnlyEmptyProto(definition.getPrototypes()) || builder.lookAhead(1) == SQL_RIGHT_PAREN);
            if (forbidParen) {
                SqlParserUtil.markTokenAsUnexpectedAndAdvance(builder, null);
                SqlGeneratedParserUtil.consumeTokenFast((PsiBuilder)builder, (IElementType)SQL_RIGHT_PAREN);
                return true;
            }
            SqlParserUtil.consumeToken(builder, (IElementType)SQL_LEFT_PAREN);
            if (this.shouldRemapToCallable(refMarkerTokenType)) {
                ((PsiBuilderImpl.ProductionMarker)refMarker).remapTokenType((IElementType)SQL_ANY_CALLABLE_REFERENCE);
            }
            PsiBuilder.Marker m = builder.mark();
            SqlGeneratedParserUtil.consumeInsideParens(builder, level);
            m.collapse((IElementType)SQL_ARGUMENT_LIST);
            if (SqlGeneratedParserUtil.isCompletionHere(builder, level)) {
                m.setCustomEdgeTokenBinders(null, ATTACH_SPACES_RIGHT);
            }
            SqlParserUtil.consumeToken(builder, (IElementType)SQL_RIGHT_PAREN);
            return true;
        }
        if (refMarkerTokenType != SQL_FUNCTION_CALL && !SqlGeneratedParserUtil.nextTokenIsFast((PsiBuilder)builder, (IElementType)SQL_PERIOD) && this.handleNoParens(builder, definition, (Boolean)name.second)) {
            if (refMarkerTokenType == SQL_COLUMN_REFERENCE) {
                SqlGeneratedParserUtil.remapAnyReference(builder, level, (IElementType)SQL_REFERENCE);
            }
            return true;
        }
        return false;
    }

    @Nullable
    protected String adjustBuiltinParensPolicy(@Nullable String policy, @NotNull PsiBuilder builder, boolean plain) {
        if (builder == null) {
            SqlParser.$$$reportNull$$$0(5);
        }
        if (!"required".equals(policy) && SqlParser.isTableFunctionLocation(builder)) {
            return "required";
        }
        return policy;
    }

    public boolean handleNoParens(PsiBuilder builder, BuiltinFunction definition, boolean plain) {
        String parens = definition != null ? definition.getDialectAttribute("parens") : null;
        BuiltinFunction.Prototype[] prototypes = definition == null ? BuiltinFunction.Prototype.EMPTY_ARRAY : definition.getPrototypes();
        if ("required".equals(parens = this.adjustBuiltinParensPolicy(parens, builder, plain))) {
            SqlGeneratedParserUtil.addVariant((PsiBuilder)builder, (String)"(");
            return false;
        }
        if ("optional".equals(parens) || !SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_PERIOD) && definition != null && prototypes.length > 0 && this.myLanguage.canBeCalledWithoutParens(prototypes[0])) {
            SqlGeneratedParserUtil.addVariant((PsiBuilder)builder, (String)"(");
            return true;
        }
        if ("prohibited".equals(parens)) {
            return true;
        }
        if (definition == null) {
            SqlGeneratedParserUtil.addVariant((PsiBuilder)builder, (String)"(");
        }
        return false;
    }

    public boolean parseFunctionParametersAndParens(PsiBuilder builder, int level, String functionName, BuiltinFunction definition, boolean plain, boolean ignoreParens, Set<BuiltinFunction.Location> locations) {
        Object[] prototypes;
        String parens = definition != null ? definition.getDialectAttribute("parens") : null;
        Object[] objectArray = prototypes = definition == null ? BuiltinFunction.Prototype.EMPTY_ARRAY : definition.getPrototypes();
        if (!plain && "prohibited".equals(parens) && this.getLanguage().getDbms().isPostgres()) {
            parens = "required";
        }
        parens = this.adjustBuiltinParensPolicy(parens, builder, plain);
        if (!ignoreParens && "prohibited".equals(parens) && SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_LEFT_PAREN)) {
            if (this.isOnlyEmptyProto((BuiltinFunction.Prototype[])prototypes)) {
                SqlParserUtil.markTokenAsUnexpectedAndAdvance(builder, null);
                SqlGeneratedParserUtil.consumeTokenFast((PsiBuilder)builder, (IElementType)SQL_RIGHT_PAREN);
                return true;
            }
            prototypes = (BuiltinFunction.Prototype[])ArrayUtil.remove((Object[])prototypes, (int)0);
        } else if (!ignoreParens && "required".equals(parens) && !SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_LEFT_PAREN)) {
            return false;
        }
        if (ignoreParens || SqlGeneratedParserUtil.consumeTokenFast((PsiBuilder)builder, (IElementType)SQL_LEFT_PAREN)) {
            if (!this.parseFunctionParametersStart(builder, level, definition)) {
                return false;
            }
            boolean result = false;
            FunctionParsingContext context = new FunctionParsingContext();
            if (prototypes.length > 0) {
                LighterASTNode latestDoneMarker;
                Number protoId;
                boolean eatMore;
                boolean overloadable = definition == null || definition.isOverloadable();
                result = this.parseParameterChoice(builder, level, (BuiltinFunction.Parameter[])prototypes, true, context, !overloadable, locations);
                boolean bl = eatMore = !builder.eof() && builder.getTokenType() != SQL_SEMICOLON && !this.argumentListRecover(builder, level);
                if (!result || eatMore) {
                    result = false;
                }
                if ((protoId = (Number)SqlInfoElementType.getValue((IElementType)((latestDoneMarker = builder.getLatestDoneMarker()) == null ? null : latestDoneMarker.getTokenType()), Number.class)) != null && (!result || overloadable && context.errorCounter != 0)) {
                    ((PsiBuilder.Marker)latestDoneMarker).drop();
                }
            }
            if (!result) {
                this.parseSimpleArguments(builder, level, context);
            }
            this.parseFunctionParametersEnd(builder, level, definition);
            if (!ignoreParens) {
                SqlParserUtil.consumeToken(builder, (IElementType)SQL_RIGHT_PAREN);
            }
            return true;
        }
        return "optional".equals(parens) || !SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_PERIOD) && definition != null && prototypes.length > 0 && prototypes[0].getParams().length == 0;
    }

    protected boolean isOnlyEmptyProto(BuiltinFunction.Prototype[] prototypes) {
        return prototypes.length < 2 || prototypes[0].getParams().length > 0;
    }

    protected void parseSimpleArguments(PsiBuilder builder, int level, FunctionParsingContext context) {
        block0: while (true) {
            Collection<SqlInfoElementType<?>> infoElementTypes = context.get(builder.getCurrentOffset());
            if (!this.parseFunctionArgument(builder, level, true, true)) {
                IElementType tokenType = builder.getTokenType();
                if (!(tokenType instanceof SqlKeywordTokenType) && tokenType != SQL_COMMA || this.argumentListRecover(builder, level)) break;
                builder.advanceLexer();
            }
            Iterator<SqlInfoElementType<?>> iterator = infoElementTypes.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                SqlInfoElementType<?> type = iterator.next();
                builder.mark().done(type);
            }
            break;
        }
    }

    public boolean parseFunctionParametersEnd(PsiBuilder builder, int level, BuiltinFunction definition) {
        return true;
    }

    public boolean parseFunctionParametersStart(PsiBuilder builder, int level, BuiltinFunction definition) {
        return true;
    }

    public boolean parseParameterSequence(PsiBuilder builder, int level, BuiltinFunction.ParameterBlock block, FunctionParsingContext functionContext) {
        BuiltinFunction.Parameter[] parameters = block.getParams();
        if (block.getBlockType() == BuiltinFunction.ParameterBlockType.CHOICE) {
            return this.parseParameterChoice(builder, level, parameters, false, functionContext, true, Collections.emptySet());
        }
        if (parameters.length == 0) {
            return true;
        }
        boolean isOptionalSequence = block.getBlockType() == BuiltinFunction.ParameterBlockType.OPTIONAL_SEQUENCE;
        boolean result = true;
        boolean pinned = false;
        PsiBuilder.Marker mark2 = builder.mark();
        for (BuiltinFunction.Parameter parameter : parameters) {
            int offset = builder.getCurrentOffset();
            boolean shouldParse = pinned || result;
            boolean parsed = shouldParse && this.parseFunctionParameter(builder, level + 1, parameter, functionContext);
            result = parsed && result;
            int len = builder.getCurrentOffset() - offset;
            if (!pinned && result && parameter != BuiltinFunction.COMMA && len > 0 && block.isGreedy() && (!isOptionalSequence || parameter instanceof BuiltinFunction.Keyword)) {
                pinned = true;
                continue;
            }
            if (!shouldParse || parsed || !pinned) continue;
            SqlGeneratedParserUtil.report_error_((PsiBuilder)builder, (GeneratedParserUtilBase.ErrorState)GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder), (boolean)false);
            ++functionContext.errorCounter;
        }
        if (!result && !pinned) {
            mark2.rollbackTo();
        } else {
            mark2.drop();
        }
        return result || pinned || isOptionalSequence;
    }

    private SqlParserUtil.ParserChoice<Integer> createParserChoice(final BuiltinFunction.Parameter parameter, final int index, final FunctionParsingContext functionContext, final int[] prototypeIndex) {
        return new SqlParserUtil.ParserChoice<Integer>(){

            @Override
            public Integer parse(PsiBuilder builder, int level) {
                return this.parseAndGetError(builder, level, parameter);
            }

            @Nullable
            private Integer parseAndGetError(PsiBuilder builder, int level, BuiltinFunction.Parameter param) {
                prototypeIndex[0] = index;
                int counter = functionContext.errorCounter;
                functionContext.errorCounter = 0;
                boolean result = SqlParser.this.parseFunctionParameter(builder, level, param, functionContext);
                int errors = functionContext.errorCounter;
                functionContext.errorCounter = counter;
                return result ? Integer.valueOf(errors) : null;
            }
        };
    }

    private SqlParserUtil.ParserChoice<Integer> createSimpleArgumentsParser(final FunctionParsingContext functionContext, final int[] prototypeIndex) {
        return new SqlParserUtil.ParserChoice<Integer>(){

            @Override
            public boolean isSimple() {
                return true;
            }

            @Override
            public Integer parse(PsiBuilder builder, int level) {
                SqlKeywordCompletionContributor.FALLBACK_ARGUMENTS.set((UserDataHolder)builder, (Object)true);
                prototypeIndex[0] = -1;
                int counter = 0;
                boolean result = true;
                boolean first = true;
                while (true) {
                    Collection<SqlInfoElementType<?>> infoElementTypes = functionContext.get(builder.getCurrentOffset());
                    if (!SqlParser.this.parseFunctionArgument(builder, level, first, true)) {
                        counter = 1;
                        result = false;
                        break;
                    }
                    first = false;
                    for (SqlInfoElementType<?> type : infoElementTypes) {
                        builder.mark().done(type);
                    }
                    if (!SqlParserUtil.nextTokenIs(builder, (IElementType)SqlCommonTokens.SQL_COMMA)) break;
                    builder.advanceLexer();
                }
                SqlKeywordCompletionContributor.FALLBACK_ARGUMENTS.set((UserDataHolder)builder, null);
                return result ? Integer.valueOf(counter) : null;
            }
        };
    }

    private boolean parseParameterChoice(PsiBuilder builder, int level, BuiltinFunction.Parameter[] parameters, boolean storePrototypeIndex, FunctionParsingContext functionContext, boolean genError, Set<BuiltinFunction.Location> locations) {
        Integer result;
        BuiltinFunction function = parameters.length > 0 && parameters[0] instanceof BuiltinFunction.Prototype ? ((BuiltinFunction.Prototype)parameters[0]).getFunction() : null;
        int[] prototypeIndex = new int[]{-1};
        ArrayList parsers = new ArrayList(parameters.length);
        for (int i = parameters.length - 1; i >= 0; --i) {
            BuiltinFunction.Parameter parameter = parameters[i];
            if (parameter instanceof BuiltinFunction.Prototype && !locations.contains(((BuiltinFunction.Prototype)parameter).getLocation())) continue;
            parsers.add(this.createParserChoice(parameter, i, functionContext, prototypeIndex));
        }
        if (function != null && function.isOverloadable()) {
            parsers.add(this.createSimpleArgumentsParser(functionContext, prototypeIndex));
        }
        if ((result = (Integer)SqlParserUtil.chooseTheBestParser(builder, level, parsers)) == null) {
            if (!genError) {
                return false;
            }
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (BuiltinFunction.Parameter parameter : parameters) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(parameter.toString());
            }
            builder.error(SqlBundle.message((String)"one.of.expected.0", (Object[])new Object[]{sb.toString()}));
            return false;
        }
        functionContext.errorCounter += result.intValue();
        if (storePrototypeIndex && prototypeIndex[0] >= 0) {
            builder.mark().done((IElementType)SqlInfoElementType.getElementType((Object)prototypeIndex[0]));
        }
        return true;
    }

    public boolean parseFunctionParameter(PsiBuilder builder, int level, BuiltinFunction.Parameter parameter, FunctionParsingContext functionContext) {
        boolean parseComma = true;
        boolean atLeastOne = true;
        if (parameter instanceof BuiltinFunction.ParameterBlock) {
            BuiltinFunction.ParameterBlock block = (BuiltinFunction.ParameterBlock)parameter;
            parseComma = block.isFollowedByComma();
            atLeastOne = block.isAtLeastOne();
        }
        boolean result = this.parseFunctionParameterSingle(builder, level, parameter, functionContext);
        if (!parameter.isMany()) {
            return result;
        }
        if (!result) {
            return !atLeastOne;
        }
        if (parseComma) {
            while (SqlGeneratedParserUtil.nextTokenIsFast((PsiBuilder)builder, (IElementType)SQL_COMMA)) {
                PsiBuilder.Marker mark2 = builder.mark();
                SqlGeneratedParserUtil.consumeTokenFast((PsiBuilder)builder, (IElementType)SQL_COMMA);
                if (this.parseFunctionParameterSingle(builder, level, parameter, functionContext)) {
                    mark2.drop();
                    continue;
                }
                mark2.rollbackTo();
                break;
            }
        } else {
            while (this.parseFunctionParameterSingle(builder, level, parameter, functionContext)) {
            }
        }
        return true;
    }

    public boolean parseFunctionParameterSingle(PsiBuilder builder, int level, BuiltinFunction.Parameter parameter, FunctionParsingContext functionContext) {
        boolean result;
        Collection<SqlInfoElementType<?>> infoTypeCollection = functionContext.get(builder.getCurrentOffset());
        PsiBuilder.Marker mark2 = SqlGeneratedParserUtil.enter_section_((PsiBuilder)builder, (int)level, (int)0, null);
        if (parameter == BuiltinFunction.COMMA) {
            result = GeneratedParserUtilBase.consumeToken((PsiBuilder)builder, (IElementType)SQL_COMMA);
        } else if (parameter instanceof BuiltinFunction.SyntaxParameter) {
            String text = ((BuiltinFunction.SyntaxParameter)parameter).getText();
            result = GeneratedParserUtilBase.consumeToken((PsiBuilder)builder, (String)text);
        } else if (parameter instanceof BuiltinFunction.Keyword) {
            SqlTokenType expectedToken = SqlTokenRegistry.getType((String)((BuiltinFunction.Keyword)parameter).getName());
            result = GeneratedParserUtilBase.consumeToken((PsiBuilder)builder, (IElementType)expectedToken);
        } else if (parameter instanceof BuiltinFunction.SimpleParameter) {
            BuiltinFunction.SimpleParameter simpleParam = (BuiltinFunction.SimpleParameter)parameter;
            BuiltinFunction.Type type = simpleParam.getType();
            PsiBuilder.Marker prefixMark = builder.mark();
            boolean prefixParsed = this.parseNamedFunctionArgumentPrefix(builder, level);
            Boolean paramParsed = this.parseSimpleParameter(builder, level, type);
            if (paramParsed != null) {
                result = paramParsed;
            } else if (type == SqlFunctionsUtil.REF) {
                SqlReferenceElementType refType = SqlFunctionsUtil.getReferenceType((BuiltinFunction.ReferenceParameter)((BuiltinFunction.ReferenceParameter)simpleParam));
                result = this.parseTypedReference(builder, refType);
            } else {
                PsiBuilder.Marker marker = SqlGeneratedParserUtil.enter_section_((PsiBuilder)builder, (int)(level + 1), (int)0, (String)"<expression>");
                SqlGeneratedParserUtil.addVariant((PsiBuilder)builder, (String)"<expression>");
                DasType dasType = type.getDasType();
                boolean allowBoolean = dasType != null && DasTypeCategory.BOOLEAN == this.myLanguage.getTypeSystem().getTypeCategory(dasType.toDataType()) || type == SqlFunctionsUtil.ANY;
                result = this.parseValueExpression(builder, level + 1, false, allowBoolean);
                SqlGeneratedParserUtil.exit_section_((PsiBuilder)builder, (int)(level + 1), (PsiBuilder.Marker)marker, null, (boolean)result, (boolean)false, null);
            }
            if (prefixParsed) {
                prefixMark.done((IElementType)SQL_NAMED_PARAMETER_VALUE);
            } else {
                prefixMark.drop();
            }
            result |= prefixParsed;
        } else if (parameter instanceof BuiltinFunction.ParameterBlock) {
            BuiltinFunction.ParameterBlock block = (BuiltinFunction.ParameterBlock)parameter;
            result = this.parseParameterSequence(builder, level, block, functionContext);
        } else if (parameter instanceof BuiltinFunction.ExternalParameter) {
            result = this.parseExtraRoots(((BuiltinFunction.ExternalParameter)parameter).getNodeType(), builder, level);
        } else {
            throw new AssertionError((Object)("unknown parameter " + String.valueOf(parameter)));
        }
        SqlGeneratedParserUtil.exit_section_((PsiBuilder)builder, (int)level, (PsiBuilder.Marker)mark2, null, (boolean)result, (boolean)false, null);
        if (result && parameter != BuiltinFunction.COMMA && !(parameter instanceof BuiltinFunction.ParameterBlock)) {
            infoTypeCollection.add(SqlInfoElementType.getElementType((Object)parameter));
            for (SqlInfoElementType<?> type : infoTypeCollection) {
                builder.mark().done(type);
            }
        }
        return result;
    }

    protected Boolean parseSimpleParameter(PsiBuilder builder, int level, BuiltinFunction.Type type) {
        if (type == SqlFunctionsUtil.DATATYPE) {
            return this.parseDataType(builder, level, false);
        }
        if (type == SqlFunctionsUtil.CAST_DATATYPE) {
            return this.parseCastDataType(builder, level);
        }
        if (type == SqlFunctionsUtil.INTERVAL_LITERAL) {
            return this.parseIntervalLiteral(builder, level);
        }
        if (type == SqlFunctionsUtil.TABLE) {
            return this.parseQueryExpression(builder, level);
        }
        if (type == SqlFunctionsUtil.TOKEN) {
            return this.consumeIdentifier(builder);
        }
        if (type == SqlFunctionsUtil.STRING_LITERAL) {
            return SqlGeneratedParserUtil.parseString(builder, level);
        }
        return null;
    }

    protected boolean parseTypedReference(PsiBuilder builder, SqlReferenceElementType refType) {
        if (SqlGeneratedParser.primary_expression(builder, 0)) {
            LighterASTNode resultMarker = Objects.requireNonNull(builder.getLatestDoneMarker());
            if (refType != null && resultMarker.getTokenType() == SQL_REFERENCE) {
                ((PsiBuilderImpl.ProductionMarker)resultMarker).remapTokenType((IElementType)refType);
            }
            return true;
        }
        return false;
    }

    public boolean parseFunctionArgument(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        PsiBuilder.Marker mark2 = builder.mark();
        boolean parsed = this.parseNamedFunctionArgumentPrefix(builder, level);
        boolean parsedVal = this.parseFunctionArgumentValue(builder, level, !parsed && optional, allowBoolean);
        if (parsed) {
            mark2.done((IElementType)SQL_NAMED_PARAMETER_VALUE);
        } else {
            mark2.drop();
        }
        return parsed || parsedVal;
    }

    public boolean parseFunctionArgumentValue(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        return this.parseValueExpression(builder, level, optional, allowBoolean);
    }

    public boolean parseNamedFunctionArgumentPrefix(PsiBuilder builder, int level) {
        return false;
    }

    public boolean parseNamedFunctionArgumentPrefixImpl(PsiBuilder builder, IElementType token) {
        boolean result;
        PsiBuilder.Marker mark2 = builder.mark();
        boolean bl = result = this.parseReferenceExpression(builder, true, SQL_ARGUMENT_REFERENCE) && SqlParserUtil.consumeToken(builder, token);
        if (result) {
            mark2.drop();
        } else {
            mark2.rollbackTo();
        }
        return result;
    }

    public boolean statementRecoverPrefixParser(PsiBuilder builder, int level) {
        return false;
    }

    protected boolean isWhitespace(IElementType type) {
        return WS_TOKENS.contains(type);
    }

    public boolean statementRecover(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser prefixParser) {
        this.applyStatementMarkerBinders(builder);
        if (SqlGeneratedParserUtil.isCompletionHere(builder, level)) {
            return false;
        }
        IElementType tokenType = builder.getTokenType();
        if (tokenType == null) {
            return false;
        }
        if (this.isStatementSeparatorParsed(builder)) {
            return false;
        }
        if (this.myLanguage.getStatementSeparators().contains(tokenType)) {
            return false;
        }
        if (!this.myStatementRecoverNewLine && !this.allowNoStatementSeparator()) {
            int i = 1;
            while (true) {
                IElementType type;
                if ((type = builder.rawLookup(-i)) == null) {
                    this.myStatementRecoverNewLine = true;
                    break;
                }
                if (this.isWhitespace(type)) {
                    CharSequence s = PsiBuilderUtil.rawTokenText((PsiBuilder)builder, (int)(-i));
                    if (StringUtil.indexOf((CharSequence)s, (char)'\n') >= 0) {
                        this.myStatementRecoverNewLine = true;
                        break;
                    }
                } else if (!SqlGeneratedParserUtil.isWhitespaceOrComment((PsiBuilder)builder, (IElementType)type)) break;
                ++i;
            }
            if (!this.myStatementRecoverNewLine) {
                return true;
            }
        }
        PsiBuilder.Marker m = SqlGeneratedParserUtil.enter_section_((PsiBuilder)builder, (int)level, (int)16);
        boolean r = !prefixParser.parse(builder, level + 1);
        SqlGeneratedParserUtil.exit_section_((PsiBuilder)builder, (int)level, (PsiBuilder.Marker)m, (boolean)r, (boolean)false, null);
        return r;
    }

    private void applyStatementMarkerBinders(PsiBuilder builder) {
        WhitespacesAndCommentsBinder right;
        IElementType type;
        LighterASTNode last = builder.getLatestDoneMarker();
        IElementType iElementType = type = last != null ? last.getTokenType() : null;
        if (type == null || !GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder).typeExtends(type, (IElementType)SQL_STATEMENT)) {
            return;
        }
        WhitespacesAndCommentsBinder left = PL_PATTERN.matcher(type.toString()).matches() ? ADD_COMMENT_LEFT : null;
        WhitespacesAndCommentsBinder whitespacesAndCommentsBinder = right = !this.allowNoStatementSeparator() ? null : TRIM_SPACES_RIGHT;
        if (left != null || right != null) {
            ((PsiBuilder.Marker)last).setCustomEdgeTokenBinders(left, right);
        }
    }

    public boolean canBeCalled(IElementType type, PsiBuilder builder) {
        return type == SQL_COLUMN_REFERENCE || type == SQL_ARGUMENT_REFERENCE || type == SQL_FUNCTION_CALL || type == SQL_REFERENCE || type == SQL_METHOD_REFERENCE || this.getLanguage().isSpecialFunctionReference(type);
    }

    public boolean argumentListRecover(PsiBuilder builder, int level) {
        return false;
    }

    @Nullable
    public SqlSuggestedInjection getCurrentSqlInjection() {
        return null;
    }

    private static boolean tryParse(PsiBuilder b, int l, GeneratedParserUtilBase.Parser p) {
        PsiBuilder.Marker m = SqlGeneratedParserUtil.enter_section_((PsiBuilder)b, (int)l, (int)16);
        boolean res = p.parse(b, l);
        SqlGeneratedParserUtil.exit_section_((PsiBuilder)b, (int)l, (PsiBuilder.Marker)m, (boolean)false, (boolean)false, null);
        return res;
    }

    protected boolean consumeIntegerToken(PsiBuilder builder, boolean allowFloat) {
        boolean optional;
        boolean bl = optional = SqlParserUtil.consumeOneOfTokens(builder, true, new IElementType[]{SQL_OP_PLUS, SQL_OP_MINUS}) == null;
        return allowFloat ? SqlParserUtil.consumeOneOfTokens(builder, optional, new IElementType[]{SQL_INTEGER_TOKEN, SQL_FLOAT_TOKEN}) != null : SqlParserUtil.consumeToken(builder, true, (IElementType)SQL_INTEGER_TOKEN);
    }

    private boolean parseInteger(PsiBuilder builder, boolean allowFloat) {
        PsiBuilder.Marker mark2 = builder.mark();
        boolean result = this.consumeIntegerToken(builder, allowFloat);
        if (result) {
            mark2.done((IElementType)SQL_NUMERIC_LITERAL);
        } else {
            mark2.rollbackTo();
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/base/SqlParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/base/SqlParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "adaptBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseOuterLanguageStatement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "adjustBuiltinParensPolicy";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    public static class FunctionParsingContext {
        public Int2ObjectMap<Collection<SqlInfoElementType<?>>> map;
        public int errorCounter;

        public Collection<SqlInfoElementType<?>> get(int offset) {
            Collection list;
            if (this.map == null) {
                this.map = new Int2ObjectOpenHashMap();
            }
            if ((list = (Collection)this.map.get(offset)) == null) {
                list = new ArrayListSet();
                this.map.put(offset, (Object)list);
            }
            return list;
        }
    }
}

