/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.data.input;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.handlers.DataInputCodeGenerationContext;
import com.intellij.jupyter.core.editor.handlers.TableDataFileDropHandler;
import com.intellij.jupyter.core.editor.handlers.TableDataFileDropHandlerContext;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellMetadata;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellMetadataKt;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellTableMetadata;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellTableMetadataKt;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputPathWithVariableName;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ2\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\f\u001a\u00020\rJ \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\u0015J,\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u001d\u00a8\u0006\u001e"}, d2={"Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputUtil;", "", "<init>", "()V", "generateCell", "", "notebookFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "fileData", "Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputPathWithVariableName;", "generationContext", "Lcom/intellij/jupyter/core/editor/handlers/DataInputCodeGenerationContext;", "generateCells", "", "fileListData", "isValidIdentifier", "", "value", "language", "Lcom/intellij/lang/Language;", "setDataInfoUndoable", "", "cell", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;", "document", "Lcom/intellij/openapi/editor/Document;", "action", "Lkotlin/Function0;", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterDataInputUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterDataInputUtil.kt\ncom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputUtil\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n996#2:109\n1025#2,3:110\n1028#2,3:120\n382#3,7:113\n1573#4:123\n1604#4,4:124\n*S KotlinDebug\n*F\n+ 1 JupyterDataInputUtil.kt\ncom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputUtil\n*L\n41#1:109\n41#1:110,3\n41#1:120,3\n41#1:113,7\n48#1:123\n48#1:124,4\n*E\n"})
public final class JupyterDataInputUtil {
    @NotNull
    public static final JupyterDataInputUtil INSTANCE = new JupyterDataInputUtil();

    private JupyterDataInputUtil() {
    }

    @NotNull
    public final String generateCell(@NotNull BackedNotebookVirtualFile notebookFile, @NotNull Project project, @NotNull JupyterDataInputPathWithVariableName fileData, @NotNull DataInputCodeGenerationContext generationContext) {
        Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileData, (String)"fileData");
        Intrinsics.checkNotNullParameter((Object)((Object)generationContext), (String)"generationContext");
        return CollectionsKt.joinToString$default((Iterable)this.generateCells(notebookFile, project, CollectionsKt.listOf((Object)fileData), generationContext), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> generateCells(@NotNull BackedNotebookVirtualFile notebookFile, @NotNull Project project, @NotNull List<JupyterDataInputPathWithVariableName> fileListData, @NotNull DataInputCodeGenerationContext generationContext) {
        Iterable list$iv$iv;
        String key$iv$iv;
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(fileListData, (String)"fileListData");
        Intrinsics.checkNotNullParameter((Object)((Object)generationContext), (String)"generationContext");
        Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)fileListData), JupyterDataInputUtil::generateCells$lambda$0);
        boolean $i$f$groupBy = false;
        Iterator iterator = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            JupyterDataInputPathWithVariableName it = (JupyterDataInputPathWithVariableName)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)PathsKt.getExtension((Path)it.getPath()).toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            Map map = destination$iv$iv;
            String key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map extensionByFile = destination$iv$iv;
        List generatedCells = new ArrayList();
        JupyterNotebook notebook = notebookFile.getNotebook();
        for (Map.Entry entry : extensionByFile.entrySet()) {
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            String ext = (String)entry.getKey();
            List files = (List)entry.getValue();
            if (TableDataFileDropHandler.Companion.findApplicable(notebook, ext) == null) continue;
            list$iv$iv = files;
            List list = generatedCells;
            boolean $i$f$mapIndexed = false;
            key$iv$iv = $this$mapIndexed$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void index;
                TableDataFileDropHandler tableDataFileDropHandler;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                JupyterDataInputPathWithVariableName jupyterDataInputPathWithVariableName = (JupyterDataInputPathWithVariableName)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                Path file = jupyterDataInputPathWithVariableName.component1();
                String name = jupyterDataInputPathWithVariableName.component2();
                File file2 = file.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
                collection.add(tableDataFileDropHandler.generateCellCode(new TableDataFileDropHandlerContext(notebookFile, ext, project, file2, generationContext, (int)index, name)));
            }
            list.addAll((List)destination$iv$iv2);
        }
        return generatedCells;
    }

    public final boolean isValidIdentifier(@NotNull String value, @Nullable Project project, @NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        NamesValidator namesValidator = LanguageNamesValidation.INSTANCE.forLanguage(language);
        Intrinsics.checkNotNullExpressionValue((Object)namesValidator, (String)"forLanguage(...)");
        NamesValidator validator = namesValidator;
        return validator.isIdentifier(value, project);
    }

    public final void setDataInfoUndoable(@NotNull JupyterCell cell, @NotNull Project project, @NotNull Document document, @NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        ThreadingAssertions.assertWriteIntentReadAccess();
        JupyterDataInputCellMetadata prevDataInputMetadata = JupyterDataInputCellMetadataKt.getDataInputMetadata(cell);
        JupyterDataInputCellTableMetadata prevDataInputTableMetadata = JupyterDataInputCellTableMetadataKt.getDataInputTableMetadata(cell);
        action.invoke();
        JupyterDataInputCellMetadata newDataInputMetadata = JupyterDataInputCellMetadataKt.getDataInputMetadata(cell);
        JupyterDataInputCellTableMetadata newDataInputTableMetadata = JupyterDataInputCellTableMetadataKt.getDataInputTableMetadata(cell);
        UndoManager.getInstance((Project)project).undoableActionPerformed(new UndoableAction(cell, prevDataInputMetadata, prevDataInputTableMetadata, newDataInputMetadata, newDataInputTableMetadata, document){
            final /* synthetic */ JupyterCell $cell;
            final /* synthetic */ JupyterDataInputCellMetadata $prevDataInputMetadata;
            final /* synthetic */ JupyterDataInputCellTableMetadata $prevDataInputTableMetadata;
            final /* synthetic */ JupyterDataInputCellMetadata $newDataInputMetadata;
            final /* synthetic */ JupyterDataInputCellTableMetadata $newDataInputTableMetadata;
            final /* synthetic */ Document $document;
            {
                this.$cell = $cell;
                this.$prevDataInputMetadata = $prevDataInputMetadata;
                this.$prevDataInputTableMetadata = $prevDataInputTableMetadata;
                this.$newDataInputMetadata = $newDataInputMetadata;
                this.$newDataInputTableMetadata = $newDataInputTableMetadata;
                this.$document = $document;
            }

            public void undo() {
                JupyterDataInputCellMetadataKt.setDataInputMetadata(this.$cell, this.$prevDataInputMetadata);
                JupyterDataInputCellTableMetadataKt.setDataInputTableMetadata(this.$cell, this.$prevDataInputTableMetadata);
            }

            public void redo() {
                JupyterDataInputCellMetadataKt.setDataInputMetadata(this.$cell, this.$newDataInputMetadata);
                JupyterDataInputCellTableMetadataKt.setDataInputTableMetadata(this.$cell, this.$newDataInputTableMetadata);
            }

            public DocumentReference[] getAffectedDocuments() {
                DocumentReference[] documentReferenceArray = new DocumentReference[1];
                Intrinsics.checkNotNullExpressionValue((Object)DocumentReferenceManager.getInstance().create(this.$document), (String)"create(...)");
                return documentReferenceArray;
            }

            public boolean isGlobal() {
                return false;
            }
        });
    }

    private static final boolean generateCells$lambda$0(JupyterDataInputPathWithVariableName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return !Files.isDirectory(it.getPath(), Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }
}

