/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mongo.generator.dml;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.PredicateOperation;
import com.intellij.database.data.types.PredicateValue;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.dialects.mongo.MongoScriptUtilKt;
import com.intellij.database.model.DasObject;
import com.intellij.database.script.generator.dml.ColumnsOrderBy;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.OrderBy;
import com.intellij.database.script.generator.dml.PlainOrderBy;
import com.intellij.database.script.generator.dml.PlainWhereClause;
import com.intellij.database.script.generator.dml.PredicatesWhereClause;
import com.intellij.database.script.generator.dml.ValuesWhereClause;
import com.intellij.database.script.generator.dml.WhereClause;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u001aZ\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2&\u0010\u000f\u001a\"\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0010j\u0004\u0018\u0001`\u0014H\u0002\u001a0\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u0019\u001a0\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\u001a(\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\u001a\u001e\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001f\u00a8\u0006 "}, d2={"generateWhere", "", "dbms", "Lcom/intellij/database/Dbms;", "whereClause", "Lcom/intellij/database/script/generator/dml/WhereClause;", "builder", "Lcom/intellij/database/util/DdlBuilder;", "task", "Lcom/intellij/database/script/generator/dml/DmlTask;", "predicates", "", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "op", "", "processor", "Lkotlin/Function3;", "Lcom/intellij/database/data/types/ColumnRef;", "Lcom/intellij/database/data/types/PredicateValue;", "Lcom/intellij/database/data/types/PredicateOperation;", "Lcom/intellij/database/script/generator/dml/ColumnValueConsumer;", "generateOrderBy", "orderBy", "Lcom/intellij/database/script/generator/dml/OrderBy;", "printSortFunction", "", "insertNewLines", "Lcom/intellij/database/script/generator/dml/PlainOrderBy;", "Lcom/intellij/database/script/generator/dml/ColumnsOrderBy;", "dbCollection", "table", "Lcom/intellij/database/model/DasObject;", "intellij.database.dialects.mongo"})
@SourceDebugExtension(value={"SMAP\nutil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 util.kt\ncom/intellij/database/dialects/mongo/generator/dml/UtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1#2:99\n1869#3,2:100\n*S KotlinDebug\n*F\n+ 1 util.kt\ncom/intellij/database/dialects/mongo/generator/dml/UtilKt\n*L\n44#1:100,2\n*E\n"})
public final class UtilKt {
    public static final void generateWhere(@NotNull Dbms dbms, @Nullable WhereClause whereClause, @NotNull DdlBuilder builder, @NotNull DmlTask<?> task) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter(task, (String)"task");
        WhereClause whereClause2 = whereClause;
        if (whereClause2 instanceof ValuesWhereClause) {
            List predicates = ((ValuesWhereClause)whereClause).getPredicates(dbms, DmlTaskKt.getTableAlias(task), DmlTaskKt.getVersion(task), DmlTaskKt.inUpdate(task));
            UtilKt.generateWhere(builder, (List)predicates.get(0), ((ValuesWhereClause)whereClause).getOpInner(), task, (Function3<? super ColumnRef, ? super PredicateValue, ? super PredicateOperation, Unit>)((ValuesWhereClause)whereClause).getProcessor());
            v0 = Unit.INSTANCE;
        } else if (whereClause2 instanceof PlainWhereClause) {
            if (!StringsKt.isBlank((CharSequence)((PlainWhereClause)whereClause).getFilter())) {
                builder.plain(((PlainWhereClause)whereClause).getFilter());
            }
            v0 = Unit.INSTANCE;
        } else if (whereClause2 instanceof PredicatesWhereClause) {
            UtilKt.generateWhere(builder, ((PredicatesWhereClause)whereClause).getPredicates(), ((PredicatesWhereClause)whereClause).getOp(), task, (Function3<? super ColumnRef, ? super PredicateValue, ? super PredicateOperation, Unit>)((PredicatesWhereClause)whereClause).getProcessor());
            v0 = Unit.INSTANCE;
        } else {
            DdlBuilder ddlBuilder = builder.symbol("{}");
            v0 = ddlBuilder;
            Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"symbol(...)");
        }
    }

    private static final void generateWhere(DdlBuilder builder, List<PredicatesHelper.PredicateProducer> predicates, String op, DmlTask<?> task, Function3<? super ColumnRef, ? super PredicateValue, ? super PredicateOperation, Unit> processor) {
        boolean newLines = DmlTaskKt.insertNewLines(task) && predicates.size() > 1;
        MongoScriptUtilKt.inCurly$default(builder, false, newLines, () -> UtilKt.generateWhere$lambda$0(predicates, op, builder, newLines, processor), 1, null);
    }

    public static final void generateOrderBy(@NotNull Dbms dbms, @NotNull OrderBy orderBy, @NotNull DdlBuilder builder, boolean printSortFunction, boolean insertNewLines) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)orderBy, (String)"orderBy");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        OrderBy orderBy2 = orderBy;
        if (orderBy2 instanceof ColumnsOrderBy) {
            UtilKt.generateOrderBy((ColumnsOrderBy)orderBy, builder, printSortFunction, insertNewLines);
        } else if (orderBy2 instanceof PlainOrderBy) {
            UtilKt.generateOrderBy(dbms, (PlainOrderBy)orderBy, builder, printSortFunction, insertNewLines);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    public static /* synthetic */ void generateOrderBy$default(Dbms dbms, OrderBy orderBy, DdlBuilder ddlBuilder, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        UtilKt.generateOrderBy(dbms, orderBy, ddlBuilder, bl, bl2);
    }

    private static final void generateOrderBy(Dbms dbms, PlainOrderBy orderBy, DdlBuilder builder, boolean printSortFunction, boolean insertNewLines) {
        if (StringsKt.isBlank((CharSequence)orderBy.getText()) || Intrinsics.areEqual((Object)orderBy.getText(), (Object)"{}")) {
            return;
        }
        if (printSortFunction) {
            DmlUtilKt.newLine((DdlBuilder)builder, (boolean)insertNewLines).symbol(".").plain("sort");
        }
        MongoScriptUtilKt.inParenth(builder, printSortFunction, (Function0<Unit>)((Function0)() -> UtilKt.generateOrderBy$lambda$0(builder, orderBy)));
    }

    private static final void generateOrderBy(ColumnsOrderBy orderBy, DdlBuilder builder, boolean printSortFunction, boolean insertNewLines) {
        if (orderBy.getColumns().isEmpty()) {
            return;
        }
        if (printSortFunction) {
            DmlUtilKt.newLine((DdlBuilder)builder, (boolean)insertNewLines).symbol(".").plain("sort");
        }
        MongoScriptUtilKt.inParenth(builder, printSortFunction, (Function0<Unit>)((Function0)() -> UtilKt.generateOrderBy$lambda$1(builder, orderBy)));
    }

    @NotNull
    public static final DdlBuilder dbCollection(@NotNull Dbms dbms, @NotNull DdlBuilder builder, @NotNull DasObject table) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        builder.plain("db");
        if (!builder.inCurrentNamespace(table)) {
            String schemaName;
            String string;
            String it = string = DasUtil.getSchema((DasObject)table);
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            String string2 = schemaName = ((CharSequence)it).length() > 0 ? string : null;
            if (string2 != null) {
                it = string2;
                boolean bl2 = false;
                DdlBuilder ddlBuilder = builder.symbol(".").plain("getSiblingDB");
                Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"plain(...)");
                MongoScriptUtilKt.inParenth$default(ddlBuilder, false, () -> UtilKt.dbCollection$lambda$1$0(builder, schemaName, dbms), 1, null);
            }
        }
        DdlBuilder ddlBuilder = builder.symbol(".").plain("getCollection");
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"plain(...)");
        return MongoScriptUtilKt.inParenth$default(ddlBuilder, false, () -> UtilKt.dbCollection$lambda$2(builder, table, dbms), 1, null);
    }

    private static final Unit generateWhere$lambda$0(List $predicates, String $op, DdlBuilder $builder, boolean $newLines, Function3 $processor) {
        boolean isOr;
        if ($predicates.isEmpty()) {
            return Unit.INSTANCE;
        }
        boolean bl = isOr = Intrinsics.areEqual((Object)$op, (Object)"OR") && $predicates.size() > 1;
        if (isOr) {
            $builder.plain("$or").symbol(":").space();
        }
        MongoScriptUtilKt.inBrackets($builder, isOr, $newLines, (Function0<Unit>)((Function0)() -> UtilKt.generateWhere$lambda$0$0($predicates, $builder, $newLines, $processor, isOr)));
        return Unit.INSTANCE;
    }

    private static final Unit generateWhere$lambda$0$0(List $predicates, DdlBuilder $builder, boolean $newLines, Function3 $processor, boolean $isOr) {
        boolean first = true;
        for (PredicatesHelper.PredicateProducer predicate : $predicates) {
            if (first) {
                first = false;
            } else {
                DdlBuilder ddlBuilder = $builder.symbol(",");
                Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"symbol(...)");
                DmlUtilKt.space((DdlBuilder)ddlBuilder, (boolean)$newLines);
            }
            if ($processor != null) {
                Iterable $this$forEach$iv = predicate.getColumnRefs();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ColumnRef it = (ColumnRef)element$iv;
                    boolean bl = false;
                    $processor.invoke((Object)it, (Object)predicate.getValue(), (Object)predicate.getOperation());
                }
            }
            MongoScriptUtilKt.inCurly$default($builder, $isOr, false, () -> UtilKt.generateWhere$lambda$0$0$1(predicate, $builder), 2, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit generateWhere$lambda$0$0$1(PredicatesHelper.PredicateProducer $predicate, DdlBuilder $builder) {
        $predicate.getProduce().invoke((Object)$builder);
        return Unit.INSTANCE;
    }

    private static final Unit generateOrderBy$lambda$0(DdlBuilder $builder, PlainOrderBy $orderBy) {
        $builder.plain($orderBy.getText());
        return Unit.INSTANCE;
    }

    private static final Unit generateOrderBy$lambda$1(DdlBuilder $builder, ColumnsOrderBy $orderBy) {
        MongoScriptUtilKt.inCurly$default($builder, $orderBy.getColumns(), false, arg_0 -> UtilKt.generateOrderBy$lambda$1$0($builder, arg_0), 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit generateOrderBy$lambda$1$0(DdlBuilder $builder, Pair pair) {
        int n;
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        String name2 = (String)pair.component1();
        RowSortOrder.Type sortOrder = (RowSortOrder.Type)pair.component2();
        switch (WhenMappings.$EnumSwitchMapping$0[sortOrder.ordinal()]) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = -1;
                break;
            }
            default: {
                return Unit.INSTANCE;
            }
        }
        int order = n;
        $builder.identifier(null, name2).symbol(":").space().number(order);
        return Unit.INSTANCE;
    }

    private static final Unit dbCollection$lambda$1$0(DdlBuilder $builder, String $schemaName, Dbms $dbms) {
        $builder.literal(DbImplUtilCore.StringLiteralDecorator.PLAIN.decorate($schemaName, $dbms));
        return Unit.INSTANCE;
    }

    private static final Unit dbCollection$lambda$2(DdlBuilder $builder, DasObject $table, Dbms $dbms) {
        $builder.literal(DbImplUtilCore.StringLiteralDecorator.PLAIN.decorate($table.getName(), $dbms));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RowSortOrder.Type.values().length];
            try {
                nArray[RowSortOrder.Type.ASC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RowSortOrder.Type.DESC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

