/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aiplayground.ollama;

import com.intellij.aiplayground.models.chat.AssistantMessage;
import com.intellij.aiplayground.models.chat.ChatMessage;
import com.intellij.aiplayground.models.chat.SystemMessage;
import com.intellij.aiplayground.models.chat.UserMessage;
import com.intellij.aiplayground.ollama.OllamaOptions;
import com.intellij.aiplayground.ollama.dto.MessageDTO;
import com.intellij.aiplayground.ollama.dto.RoleDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\b\u0012\u0004\u0012\u00020\u00070\u0005H\u0002\u001a\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u001a\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0002\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\f"}, d2={"OllamaJson", "Lkotlinx/serialization/json/Json;", "getOllamaJson", "()Lkotlinx/serialization/json/Json;", "toMessageDTOs", "", "Lcom/intellij/aiplayground/ollama/dto/MessageDTO;", "Lcom/intellij/aiplayground/models/chat/ChatMessage;", "mergeConsequentAssistantMessages", "toJson", "Lkotlinx/serialization/json/JsonObject;", "Lcom/intellij/aiplayground/ollama/OllamaOptions;", "intellij.aiplayground.ollama"})
@SourceDebugExtension(value={"SMAP\nOllamaKtorClientAPIImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OllamaKtorClientAPIImpl.kt\ncom/intellij/aiplayground/ollama/OllamaKtorClientAPIImplKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,214:1\n1563#2:215\n1634#2,3:216\n1#3:219\n*S KotlinDebug\n*F\n+ 1 OllamaKtorClientAPIImpl.kt\ncom/intellij/aiplayground/ollama/OllamaKtorClientAPIImplKt\n*L\n166#1:215\n166#1:216,3\n*E\n"})
public final class OllamaKtorClientAPIImplKt {
    @NotNull
    private static final Json OllamaJson = JsonKt.Json$default(null, OllamaKtorClientAPIImplKt::OllamaJson$lambda$0, (int)1, null);

    @NotNull
    public static final Json getOllamaJson() {
        return OllamaJson;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<MessageDTO> toMessageDTOs(List<? extends ChatMessage> $this$toMessageDTOs) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toMessageDTOs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            MessageDTO messageDTO;
            void message;
            ChatMessage chatMessage = (ChatMessage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var10_10 = message;
            if (var10_10 instanceof SystemMessage) {
                messageDTO = new MessageDTO(RoleDTO.SYSTEM, ((SystemMessage)message).getContent(), null, 4, null);
            } else if (var10_10 instanceof AssistantMessage) {
                messageDTO = new MessageDTO(RoleDTO.ASSISTANT, ((AssistantMessage)message).getContent(), null, 4, null);
            } else if (var10_10 instanceof UserMessage) {
                messageDTO = new MessageDTO(RoleDTO.USER, ((UserMessage)message).getContent(), null, 4, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            collection.add(messageDTO);
        }
        return OllamaKtorClientAPIImplKt.mergeConsequentAssistantMessages((List)destination$iv$iv);
    }

    private static final List<MessageDTO> mergeConsequentAssistantMessages(List<MessageDTO> $this$mergeConsequentAssistantMessages) {
        List result = new ArrayList();
        for (MessageDTO m : $this$mergeConsequentAssistantMessages) {
            boolean bl;
            if (WhenMappings.$EnumSwitchMapping$0[m.getRole().ordinal()] == 1) {
                if (!((Collection)result).isEmpty() && ((MessageDTO)CollectionsKt.last((List)result)).getRole() == RoleDTO.ASSISTANT) {
                    Object e = result.removeLast();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"removeLast(...)");
                    MessageDTO last = (MessageDTO)e;
                    bl = result.add(new MessageDTO(RoleDTO.ASSISTANT, last.getContent() + "\n" + m.getContent(), CollectionsKt.plus((Collection)last.getToolCalls(), (Iterable)m.getToolCalls())));
                    continue;
                }
                bl = result.add(m);
                continue;
            }
            bl = result.add(m);
        }
        return result;
    }

    private static final JsonObject toJson(OllamaOptions $this$toJson) {
        Map map;
        Map $this$toJson_u24lambda_u240 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        Integer n = $this$toJson.getContextSize();
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl2 = false;
            JsonElement cfr_ignored_0 = (JsonElement)$this$toJson_u24lambda_u240.put("num_ctx", JsonElementKt.JsonPrimitive((Number)it));
        }
        $this$toJson_u24lambda_u240.put("num_predict", JsonElementKt.JsonPrimitive((Number)$this$toJson.getNumPredict()));
        $this$toJson_u24lambda_u240.put("temperature", JsonElementKt.JsonPrimitive((Number)$this$toJson.getTemperature()));
        $this$toJson_u24lambda_u240.put("top_p", JsonElementKt.JsonPrimitive((Number)$this$toJson.getTopP()));
        Map map2 = MapsKt.build((Map)map);
        return new JsonObject(map2);
    }

    private static final Unit OllamaJson$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setEncodeDefaults(false);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ List access$toMessageDTOs(List $receiver) {
        return OllamaKtorClientAPIImplKt.toMessageDTOs($receiver);
    }

    public static final /* synthetic */ JsonObject access$toJson(OllamaOptions $receiver) {
        return OllamaKtorClientAPIImplKt.toJson($receiver);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RoleDTO.values().length];
            try {
                nArray[RoleDTO.ASSISTANT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

