/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pycharm.pro.customization.aitoolkit.listeners;

import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.pycharm.pro.customization.aitoolkit.AiDebuggerInstallToolWindowKt;
import com.intellij.pycharm.pro.customization.aitoolkit.AiToolkitHelperPluginCollector;
import com.intellij.pycharm.pro.customization.aitoolkit.listeners.AiToolkitExecutionListenerKt;
import com.intellij.pycharm.pro.customization.aitoolkit.services.GlobalSettingsService;
import com.intellij.pycharm.pro.customization.aitoolkit.services.ProjectLifecycleService;
import com.intellij.pycharm.pro.customization.aitoolkit.services.ProjectSettingsService;
import com.intellij.pycharm.pro.customization.aitoolkit.services.Requirements;
import com.intellij.pycharm.pro.customization.aitoolkit.utility.RunnerCommon;
import com.jetbrains.python.sdk.legacy.PythonSdkUtil;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/intellij/pycharm/pro/customization/aitoolkit/listeners/AiToolkitExecutionListener;", "Lcom/intellij/execution/ExecutionListener;", "<init>", "()V", "isPluginInstalled", "", "()Z", "processStartScheduled", "", "executorId", "", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "Companion", "intellij.pycharm.pro.customization"})
@SourceDebugExtension(value={"SMAP\nAiToolkitExecutionListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AiToolkitExecutionListener.kt\ncom/intellij/pycharm/pro/customization/aitoolkit/listeners/AiToolkitExecutionListener\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,148:1\n30#2,2:149\n30#2,2:151\n42#3,3:153\n*S KotlinDebug\n*F\n+ 1 AiToolkitExecutionListener.kt\ncom/intellij/pycharm/pro/customization/aitoolkit/listeners/AiToolkitExecutionListener\n*L\n40#1:149,2\n41#1:151,2\n42#1:153,3\n*E\n"})
public final class AiToolkitExecutionListener
implements ExecutionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<String> allSupportedExecutors;

    private final boolean isPluginInstalled() {
        return PluginManagerCore.findPlugin((PluginId)Requirements.INSTANCE.getPluginId()) != null;
    }

    public void processStartScheduled(@NotNull String executorId, @NotNull ExecutionEnvironment env) {
        boolean hasAnyImportsOfInterest;
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Project project = env.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<ProjectLifecycleService> serviceClass$iv = ProjectLifecycleService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ProjectLifecycleService lifecycleService = (ProjectLifecycleService)object;
        ComponentManager $this$service$iv2 = (ComponentManager)project2;
        boolean $i$f$service2 = false;
        Class serviceClass$iv2 = ProjectSettingsService.class;
        Object object2 = $this$service$iv2.getService(serviceClass$iv2);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv2, serviceClass$iv2);
        }
        ProjectSettingsService projectSettings = (ProjectSettingsService)object2;
        $i$f$service2 = false;
        serviceClass$iv2 = GlobalSettingsService.class;
        Object object3 = ApplicationManager.getApplication().getService(serviceClass$iv2);
        if (object3 == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv2.getName() + " (classloader=" + serviceClass$iv2.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        GlobalSettingsService globalSettings = (GlobalSettingsService)object3;
        RunProfile runProfile = env.getRunProfile();
        Intrinsics.checkNotNullExpressionValue((Object)runProfile, (String)"getRunProfile(...)");
        RunProfile profile = runProfile;
        if (globalSettings.getAlwaysShow()) {
            AiDebuggerInstallToolWindowKt.createAiDebuggerInstallToolWindow(project2, true);
            return;
        }
        if (PythonSdkUtil.isFreeTier()) {
            AiToolkitHelperPluginCollector.INSTANCE.getMarketingSkipped().log((Object)"free_tier");
            return;
        }
        if (!RunnerCommon.INSTANCE.isSupportedExecutor(executorId, profile, allSupportedExecutors)) {
            AiToolkitHelperPluginCollector.INSTANCE.getMarketingSkipped().log(project2, (Object)"unsupported_executor");
            return;
        }
        boolean hasLangGraphImports = AiToolkitExecutionListenerKt.hasImportsOfInterestInIndex(project2, Requirements.INSTANCE.getImportsOfInterestLangGraph());
        boolean hasLangChainImports = AiToolkitExecutionListenerKt.hasImportsOfInterestInIndex(project2, Requirements.INSTANCE.getImportsOfInterestLangChain());
        boolean bl = hasAnyImportsOfInterest = hasLangGraphImports || hasLangChainImports;
        if (!projectSettings.isAiProject() && !projectSettings.getImportsOfInterestPresent() && hasAnyImportsOfInterest) {
            projectSettings.setImportsOfInterestPresent(true);
            if (hasLangGraphImports) {
                AiToolkitHelperPluginCollector.INSTANCE.getProjectOfInterestDetected().log(project2, (Object)"langgraph");
            }
            if (hasLangChainImports) {
                AiToolkitHelperPluginCollector.INSTANCE.getProjectOfInterestDetected().log(project2, (Object)"langchain");
            }
        }
        if (globalSettings.getDontShowAgain()) {
            AiToolkitHelperPluginCollector.INSTANCE.getMarketingSkipped().log(project2, (Object)"dont_show_again");
            return;
        }
        if (!projectSettings.isAiProject()) {
            AiToolkitHelperPluginCollector.INSTANCE.getMarketingSkipped().log(project2, (Object)"non_ai_project");
            return;
        }
        if (this.isPluginInstalled()) {
            AiToolkitHelperPluginCollector.INSTANCE.getMarketingSkipped().log(project2, (Object)"plugin_already_installed");
            return;
        }
        if (AiToolkitExecutionListenerKt.isToolWindowShown(project2)) {
            AiToolkitHelperPluginCollector.INSTANCE.getMarketingSkipped().log(project2, (Object)"marketing_is_already_visible");
            return;
        }
        BuildersKt.launch$default((CoroutineScope)lifecycleService.getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(globalSettings, hasLangGraphImports, hasLangChainImports, project2, projectSettings, null){
            boolean Z$0;
            boolean Z$1;
            int I$0;
            int label;
            final /* synthetic */ GlobalSettingsService $globalSettings;
            final /* synthetic */ boolean $hasLangGraphImports;
            final /* synthetic */ boolean $hasLangChainImports;
            final /* synthetic */ Project $project;
            final /* synthetic */ ProjectSettingsService $projectSettings;
            {
                this.$globalSettings = $globalSettings;
                this.$hasLangGraphImports = $hasLangGraphImports;
                this.$hasLangChainImports = $hasLangChainImports;
                this.$project = $project;
                this.$projectSettings = $projectSettings;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = this.$globalSettings.isLangGraphCampaignActive((Continuation<? super Boolean>)((Continuation)this));
                        if (v0 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        this.Z$0 = langGraphCampaignActive = ((Boolean)v0).booleanValue();
                        this.label = 2;
                        v1 = this.$globalSettings.isLangChainCampaignActive((Continuation<? super Boolean>)((Continuation)this));
                        if (v1 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl23
                    }
                    case 2: {
                        langGraphCampaignActive = this.Z$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl23:
                        // 2 sources

                        langChainCampaignActive = (Boolean)v1;
                        active = langGraphCampaignActive != false && this.$hasLangGraphImports != false || langChainCampaignActive != false && this.$hasLangChainImports != false ? 1 : 0;
                        AiToolkitHelperPluginCollector.INSTANCE.getRunClicked().log(this.$project, (Object)Boxing.boxBoolean((boolean)(active != 0)));
                        if (active == 0) {
                            if (this.$hasLangGraphImports) {
                                AiToolkitHelperPluginCollector.INSTANCE.getMarketingSkipped().log((Object)"experiment_disabled_langgraph");
                            }
                            if (this.$hasLangChainImports) {
                                AiToolkitHelperPluginCollector.INSTANCE.getMarketingSkipped().log((Object)"experiment_disabled_langchain");
                            }
                            return Unit.INSTANCE;
                        }
                        this.Z$0 = langGraphCampaignActive;
                        this.Z$1 = langChainCampaignActive;
                        this.I$0 = active;
                        this.label = 3;
                        v2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$projectSettings, this.$project, null){
                            int label;
                            final /* synthetic */ ProjectSettingsService $projectSettings;
                            final /* synthetic */ Project $project;
                            {
                                this.$projectSettings = $projectSettings;
                                this.$project = $project;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        boolean isVisible = this.$projectSettings.isToolWindowVisible();
                                        AiDebuggerInstallToolWindowKt.createAiDebuggerInstallToolWindow(this.$project, isVisible);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v2 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl46
                    }
                    case 3: {
                        active = this.I$0;
                        langChainCampaignActive = this.Z$1;
                        langGraphCampaignActive = this.Z$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl46:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    static {
        Object[] objectArray = new String[]{"Run", "Debug"};
        allSupportedExecutors = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/pycharm/pro/customization/aitoolkit/listeners/AiToolkitExecutionListener$Companion;", "", "<init>", "()V", "allSupportedExecutors", "", "", "intellij.pycharm.pro.customization"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

