/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.remotedriver.robot;

import com.intellij.driver.model.RemoteMouseButton;
import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.performancePlugin.remotedriver.RobotUtilsKt;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.assertj.swing.awt.AWT;
import org.assertj.swing.core.BasicRobot;
import org.assertj.swing.core.ComponentFinder;
import org.assertj.swing.core.ComponentPrinter;
import org.assertj.swing.core.MouseButton;
import org.assertj.swing.core.Robot;
import org.assertj.swing.core.Scrolling;
import org.assertj.swing.core.Settings;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.edt.GuiQuery;
import org.assertj.swing.hierarchy.ComponentHierarchy;
import org.assertj.swing.timing.Pause;
import org.assertj.swing.util.Modifiers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\b\u0000\u0018\u0000 l2\u00020\u0001:\u0001lB\u001d\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0018H\u0016J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0013J \u0010\u0015\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0013H\u0016J&\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0013J\u001e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0017J\u0016\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0017J\u001e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0013J(\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0013H\u0016J \u0010\u0015\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0013H\u0016J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u000e\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fJ\u000e\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017J\u001e\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u001f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u001f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0018H\u0016J\u0018\u0010\u001f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0018H\u0016J\u000e\u0010 \u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u0013J\u000e\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0013J\u0010\u0010%\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020(J&\u0010)\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\u0013J\u0006\u0010-\u001a\u00020.J\u0018\u0010/\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J*\u00100\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J\u001a\u00101\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u001a\u00102\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000eH\u0002J\u001c\u00103\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u00132\n\u00104\u001a\u000205\"\u00020\u0013H\u0002J\u0010\u0010-\u001a\u00020.2\u0006\u00106\u001a\u000207H\u0002J \u00108\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0013H\u0002J*\u00108\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0013H\u0002J\u0018\u00109\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000eJ*\u0010:\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\b\b\u0002\u0010;\u001a\u00020\u0013H\u0002J0\u0010<\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u001b\u001a\u00020\u00182\b\b\u0002\u0010=\u001a\u00020\u00132\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u000eH\u0002J\t\u0010>\u001a\u00020\u0010H\u0096\u0001J\t\u0010?\u001a\u00020\u0010H\u0096\u0001J\u001b\u0010@\u001a\u00020\u00102\u0010\b\u0001\u0010A\u001a\n C*\u0004\u0018\u00010B0BH\u0096\u0001J\u001b\u0010D\u001a\u00020\u00102\u0010\b\u0001\u0010A\u001a\n C*\u0004\u0018\u00010E0EH\u0096\u0001J\u0011\u0010F\u001a\n C*\u0004\u0018\u00010G0GH\u0097\u0001J\u0011\u0010H\u001a\n C*\u0004\u0018\u00010I0IH\u0097\u0001J\u001b\u0010J\u001a\u00020\u00102\u0010\b\u0001\u0010A\u001a\n C*\u0004\u0018\u00010\f0\fH\u0096\u0001J\u001b\u0010K\u001a\u00020\u00102\u0010\b\u0001\u0010A\u001a\n C*\u0004\u0018\u00010\f0\fH\u0096\u0001J\u0011\u0010L\u001a\n C*\u0004\u0018\u00010M0MH\u0097\u0001J\t\u0010N\u001a\u00020\bH\u0096\u0001J\t\u0010O\u001a\u00020\bH\u0096\u0001J\u001b\u0010P\u001a\u00020\b2\u0010\b\u0001\u0010A\u001a\n C*\u0004\u0018\u00010\f0\fH\u0096\u0001J\u001b\u0010Q\u001a\u00020\u00102\u0010\b\u0001\u0010A\u001a\n C*\u0004\u0018\u00010\f0\fH\u0096\u0001J-\u0010Q\u001a\u00020\u00102\u0010\b\u0001\u0010A\u001a\n C*\u0004\u0018\u00010\f0\f2\u0010\b\u0001\u0010R\u001a\n C*\u0004\u0018\u00010\u000e0\u000eH\u0096\u0001J'\u0010S\u001a\u00020\u00102\u0006\u0010A\u001a\u00020\u00132\u0014\b\u0001\u0010R\u001a\n C*\u0004\u0018\u00010505\"\u00020\u0013H\u0096\u0001J\u001f\u0010T\u001a\u00020\u00102\u0014\b\u0001\u0010A\u001a\n C*\u0004\u0018\u00010505\"\u00020\u0013H\u0096\u0001J\u0011\u0010U\u001a\u00020\u00102\u0006\u0010A\u001a\u00020\u0013H\u0096\u0001J#\u0010V\u001a\u00020\u00102\u0006\u0010A\u001a\u00020\u00132\u0010\b\u0001\u0010R\u001a\n C*\u0004\u0018\u00010W0WH\u0096\u0001J\u0011\u0010X\u001a\u00020\u00102\u0006\u0010A\u001a\u00020\u0013H\u0096\u0001J#\u0010Y\u001a\u00020\u00102\u0006\u0010A\u001a\u00020\u00132\u0010\b\u0001\u0010R\u001a\n C*\u0004\u0018\u00010W0WH\u0096\u0001J\u001b\u0010\u001f\u001a\u00020\u00102\u0010\b\u0001\u0010A\u001a\n C*\u0004\u0018\u00010\u00180\u0018H\u0096\u0001J-\u0010Z\u001a\u00020\u00102\u0010\b\u0001\u0010A\u001a\n C*\u0004\u0018\u00010\u00180\u00182\u0010\b\u0001\u0010R\u001a\n C*\u0004\u0018\u00010W0WH\u0096\u0001J?\u0010Z\u001a\u00020\u00102\u0010\b\u0001\u0010A\u001a\n C*\u0004\u0018\u00010\f0\f2\u0010\b\u0001\u0010R\u001a\n C*\u0004\u0018\u00010\u000e0\u000e2\u0010\b\u0001\u0010[\u001a\n C*\u0004\u0018\u00010W0WH\u0096\u0001J?\u0010Z\u001a\u00020\u00102\u0010\b\u0001\u0010A\u001a\n C*\u0004\u0018\u00010\u000e0\u000e2\u0010\b\u0001\u0010R\u001a\n C*\u0004\u0018\u00010\u00180\u00182\u0010\b\u0001\u0010[\u001a\n C*\u0004\u0018\u00010W0WH\u0096\u0001JQ\u0010Z\u001a\u00020\u00102\u0010\b\u0001\u0010A\u001a\n C*\u0004\u0018\u00010\f0\f2\u0010\b\u0001\u0010R\u001a\n C*\u0004\u0018\u00010\u000e0\u000e2\u0010\b\u0001\u0010[\u001a\n C*\u0004\u0018\u00010\u00180\u00182\u0010\b\u0001\u0010\\\u001a\n C*\u0004\u0018\u00010W0WH\u0096\u0001J\u0011\u0010]\u001a\n C*\u0004\u0018\u00010^0^H\u0097\u0001J\u0011\u0010_\u001a\u00020\u00102\u0006\u0010A\u001a\u00020\u0013H\u0096\u0001J\u0011\u0010`\u001a\u00020\u00102\u0006\u0010A\u001a\u00020\u0013H\u0096\u0001J\u001b\u0010 \u001a\u00020\u00102\u0010\b\u0001\u0010A\u001a\n C*\u0004\u0018\u00010\u00180\u0018H\u0096\u0001J\t\u0010a\u001a\u00020\u0010H\u0096\u0001J\t\u0010b\u001a\u00020\u0010H\u0096\u0001J\u0011\u0010c\u001a\u00020\u00102\u0006\u0010A\u001a\u00020\u0013H\u0096\u0001J#\u0010c\u001a\u00020\u00102\u0010\b\u0001\u0010A\u001a\n C*\u0004\u0018\u00010\f0\f2\u0006\u0010R\u001a\u00020\u0013H\u0096\u0001J\u0011\u0010d\u001a\n C*\u0004\u0018\u00010e0eH\u0097\u0001J#\u0010f\u001a\n C*\u0004\u0018\u00010G0G2\u0010\b\u0001\u0010A\u001a\n C*\u0004\u0018\u00010\f0\fH\u0097\u0001J5\u0010f\u001a\n C*\u0004\u0018\u00010G0G2\u0010\b\u0001\u0010A\u001a\n C*\u0004\u0018\u00010\f0\f2\u0010\b\u0001\u0010R\u001a\n C*\u0004\u0018\u00010\u000e0\u000eH\u0097\u0001J\u001b\u0010g\u001a\u00020\u00102\u0010\b\u0001\u0010A\u001a\n C*\u0004\u0018\u00010B0BH\u0096\u0001J-\u0010g\u001a\u00020\u00102\u0010\b\u0001\u0010A\u001a\n C*\u0004\u0018\u00010B0B2\u0010\b\u0001\u0010R\u001a\n C*\u0004\u0018\u00010h0hH\u0096\u0001J5\u0010g\u001a\u00020\u00102\u0010\b\u0001\u0010A\u001a\n C*\u0004\u0018\u00010B0B2\u0010\b\u0001\u0010R\u001a\n C*\u0004\u0018\u00010h0h2\u0006\u0010[\u001a\u00020\bH\u0096\u0001J\u0011\u0010i\u001a\u00020\u00102\u0006\u0010A\u001a\u00020jH\u0096\u0001J\t\u0010k\u001a\u00020\u0010H\u0096\u0001R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006m"}, d2={"Lcom/jetbrains/performancePlugin/remotedriver/robot/SmoothRobot;", "Lorg/assertj/swing/core/Robot;", "basicRobot", "awtRobot", "Ljava/awt/Robot;", "<init>", "(Lorg/assertj/swing/core/Robot;Ljava/awt/Robot;)V", "hasInputFocus", "", "getColor", "Ljava/awt/Color;", "component", "Ljava/awt/Component;", "point", "Ljava/awt/Point;", "moveMouse", "", "c", "x", "", "y", "click", "mouseButton", "Lcom/intellij/driver/model/RemoteMouseButton;", "Lorg/assertj/swing/core/MouseButton;", "counts", "where", "button", "times", "doubleClick", "tripleClick", "pressMouse", "releaseMouse", "doubleKey", "keyCode", "doublePressKeyAndHold", "key", "rightClick", "shortcut", "keyStoke", "Ljavax/swing/KeyStroke;", "selectAndDrag", "from", "to", "delayMs", "makeScreenshot", "", "smoothMoveMouse", "clickWithRetry", "strictClick", "strictClickWithRetry", "fastPressAndReleaseKey", "modifiers", "", "screenshotArea", "Ljava/awt/Rectangle;", "moveMouseAndClick", "moveMouseAndPress", "moveMouseWithAttempts", "attempts", "postClickEvent", "clickCount", "cleanUp", "cleanUpWithoutDisposingWindows", "close", "p0", "Ljava/awt/Window;", "kotlin.jvm.PlatformType", "enterText", "", "findActivePopupMenu", "Ljavax/swing/JPopupMenu;", "finder", "Lorg/assertj/swing/core/ComponentFinder;", "focus", "focusAndWaitForFocusGain", "hierarchy", "Lorg/assertj/swing/hierarchy/ComponentHierarchy;", "isActive", "isDragging", "isReadyForInput", "jitter", "p1", "pressAndReleaseKey", "pressAndReleaseKeys", "pressKey", "pressKeyWhileRunning", "Ljava/lang/Runnable;", "pressModifiers", "pressModifiersWhileRunning", "pressMouseWhileRunning", "p2", "p3", "printer", "Lorg/assertj/swing/core/ComponentPrinter;", "releaseKey", "releaseModifiers", "releaseMouseButtons", "requireNoJOptionPaneIsShowing", "rotateMouseWheel", "settings", "Lorg/assertj/swing/core/Settings;", "showPopupMenu", "showWindow", "Ljava/awt/Dimension;", "type", "", "waitForIdle", "Companion", "intellij.performanceTesting.remoteDriver"})
@SourceDebugExtension(value={"SMAP\nSmoothRobot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SmoothRobot.kt\ncom/jetbrains/performancePlugin/remotedriver/robot/SmoothRobot\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,448:1\n1#2:449\n13826#3,2:450\n1869#4,2:452\n13#5:454\n*S KotlinDebug\n*F\n+ 1 SmoothRobot.kt\ncom/jetbrains/performancePlugin/remotedriver/robot/SmoothRobot\n*L\n354#1:450,2\n359#1:452,2\n431#1:454\n*E\n"})
public final class SmoothRobot
implements Robot {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Robot basicRobot;
    @NotNull
    private final java.awt.Robot awtRobot;
    @NotNull
    private static final Logger logger;

    @JvmOverloads
    public SmoothRobot(@NotNull Robot basicRobot, @NotNull java.awt.Robot awtRobot) {
        Settings settings;
        Intrinsics.checkNotNullParameter((Object)basicRobot, (String)"basicRobot");
        Intrinsics.checkNotNullParameter((Object)awtRobot, (String)"awtRobot");
        this.basicRobot = basicRobot;
        this.awtRobot = awtRobot;
        Settings $this$_init__u24lambda_u240 = settings = this.settings();
        boolean bl = false;
        $this$_init__u24lambda_u240.delayBetweenEvents(10);
        $this$_init__u24lambda_u240.simpleWaitForIdle(true);
        $this$_init__u24lambda_u240.timeoutToFindPopup(1000);
    }

    public /* synthetic */ SmoothRobot(Robot robot, java.awt.Robot robot2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Robot robot3 = BasicRobot.robotWithCurrentAwtHierarchyWithoutScreenLock();
            Intrinsics.checkNotNullExpressionValue((Object)robot3, (String)"robotWithCurrentAwtHierarchyWithoutScreenLock(...)");
            robot = robot3;
        }
        if ((n & 2) != 0) {
            robot2 = new java.awt.Robot();
        }
        this(robot, robot2);
    }

    public final boolean hasInputFocus() {
        IdeEventQueue eventQueue = IdeEventQueue.Companion.getInstance();
        int keyEventsPostedBefore = eventQueue.keyboardEventPosted.get();
        this.pressAndReleaseKey(61440, new int[0]);
        return keyEventsPostedBefore < eventQueue.keyboardEventPosted.get();
    }

    @NotNull
    public final Color getColor(@NotNull Component component, @Nullable Point point) {
        Point translatedPoint;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Ref.ObjectRef where = new Ref.ObjectRef();
        where.element = point;
        if (where.element == null) {
            where.element = AWT.visibleCenterOf((Component)component);
        }
        if ((translatedPoint = (Point)SmoothRobot.Companion.performOnEdt(() -> SmoothRobot.getColor$lambda$0(component, where))) == null) {
            boolean bl = false;
            String string = "Translated point should be not null";
            throw new IllegalStateException(string.toString());
        }
        Color color = this.awtRobot.getPixelColor(translatedPoint.x, translatedPoint.y);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getPixelColor(...)");
        return color;
    }

    public static /* synthetic */ Color getColor$default(SmoothRobot smoothRobot, Component component, Point point, int n, Object object) {
        if ((n & 2) != 0) {
            point = null;
        }
        return smoothRobot.getColor(component, point);
    }

    public void moveMouse(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        if (component instanceof JComponent) {
            Scrolling.scrollToVisible((Robot)this, (JComponent)((JComponent)component));
        }
        Point where = AWT.visibleCenterOf((Component)component);
        Intrinsics.checkNotNull((Object)where);
        this.moveMouse(component, where);
    }

    public void moveMouse(@NotNull Component component, @NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Point translatedPoint = (Point)SmoothRobot.Companion.performOnEdt(() -> SmoothRobot.moveMouse$lambda$0(component, point));
        if (translatedPoint == null) {
            boolean bl = false;
            String string = "Translated point should be not null";
            throw new IllegalStateException(string.toString());
        }
        this.moveMouse(translatedPoint.x, translatedPoint.y);
    }

    public void moveMouse(@NotNull Component c, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        SmoothRobot.moveMouseWithAttempts$default(this, c, x, y, 0, 8, null);
    }

    public void moveMouse(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        this.moveMouse(point.x, point.y);
    }

    public void moveMouse(int x, int y) {
        this.smoothMoveMouse(x, y);
    }

    public void click(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.click(component, MouseButton.LEFT_BUTTON);
    }

    public final void click(@NotNull Component component, @NotNull RemoteMouseButton mouseButton) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)mouseButton, (String)"mouseButton");
        this.click(component, SmoothRobot.Companion.toAssertJ(mouseButton));
    }

    public void click(@NotNull Component component, @NotNull MouseButton mouseButton) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)mouseButton, (String)"mouseButton");
        this.click(component, mouseButton, 1);
    }

    public void click(@NotNull Component component, @NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        this.click(component, point, MouseButton.LEFT_BUTTON, 1);
    }

    public final void click(@NotNull Component component, @NotNull RemoteMouseButton mouseButton, int counts) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)mouseButton, (String)"mouseButton");
        this.click(component, SmoothRobot.Companion.toAssertJ(mouseButton), counts);
    }

    public void click(@NotNull Component component, @NotNull MouseButton mouseButton, int counts) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)mouseButton, (String)"mouseButton");
        this.clickWithRetry(component, null, mouseButton, counts);
    }

    public final void click(@NotNull Component c, @NotNull Point where, @NotNull RemoteMouseButton button, int times) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)where, (String)"where");
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        this.click(c, where, SmoothRobot.Companion.toAssertJ(button), times);
    }

    public final void click(@NotNull Component c, @NotNull Point where, @NotNull RemoteMouseButton button) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)where, (String)"where");
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        this.click(c, where, SmoothRobot.Companion.toAssertJ(button), 1);
    }

    public final void click(@NotNull Point where, @NotNull RemoteMouseButton button) {
        Intrinsics.checkNotNullParameter((Object)where, (String)"where");
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        this.click(where, SmoothRobot.Companion.toAssertJ(button), 1);
    }

    public final void click(@NotNull Point where, @NotNull RemoteMouseButton button, int times) {
        Intrinsics.checkNotNullParameter((Object)where, (String)"where");
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        this.click(where, SmoothRobot.Companion.toAssertJ(button), times);
    }

    public void click(@NotNull Component c, @NotNull Point where, @NotNull MouseButton button, int times) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)where, (String)"where");
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        this.clickWithRetry(c, where, button, times);
    }

    public void click(@NotNull Point where, @NotNull MouseButton button, int times) {
        Intrinsics.checkNotNullParameter((Object)where, (String)"where");
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        this.moveMouseAndClick(where, button, times);
    }

    public void doubleClick(@NotNull Component c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this.click(c, MouseButton.LEFT_BUTTON, 2);
    }

    public final void tripleClick(@NotNull Component c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this.click(c, MouseButton.LEFT_BUTTON, 3);
    }

    public final void pressMouse(@NotNull RemoteMouseButton mouseButton) {
        Intrinsics.checkNotNullParameter((Object)mouseButton, (String)"mouseButton");
        this.pressMouse(SmoothRobot.Companion.toAssertJ(mouseButton));
    }

    public final void pressMouse(@NotNull Component component, @NotNull Point point, @NotNull RemoteMouseButton mouseButton) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)mouseButton, (String)"mouseButton");
        this.pressMouse(component, point, SmoothRobot.Companion.toAssertJ(mouseButton));
    }

    public final void pressMouse(@NotNull Point point, @NotNull RemoteMouseButton mouseButton) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)mouseButton, (String)"mouseButton");
        this.pressMouse(point, SmoothRobot.Companion.toAssertJ(mouseButton));
    }

    public void pressMouse(@NotNull Component component, @NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        this.moveMouse(component, point);
        this.basicRobot.pressMouse(component, point);
    }

    public void pressMouse(@NotNull Component component, @NotNull Point point, @NotNull MouseButton mouseButton) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)mouseButton, (String)"mouseButton");
        this.moveMouse(component, point);
        this.basicRobot.pressMouse(component, point, mouseButton);
    }

    public void pressMouse(@NotNull Point point, @NotNull MouseButton mouseButton) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)mouseButton, (String)"mouseButton");
        this.moveMouse(point);
        this.basicRobot.pressMouse(point, mouseButton);
    }

    public final void releaseMouse(@NotNull RemoteMouseButton mouseButton) {
        Intrinsics.checkNotNullParameter((Object)mouseButton, (String)"mouseButton");
        this.releaseMouse(SmoothRobot.Companion.toAssertJ(mouseButton));
    }

    public final void doubleKey(int keyCode) {
        this.awtRobot.keyPress(keyCode);
        this.awtRobot.keyRelease(keyCode);
        Thread.sleep(10L);
        this.awtRobot.keyPress(keyCode);
        this.awtRobot.keyRelease(keyCode);
    }

    public final void doublePressKeyAndHold(int key) {
        this.awtRobot.keyPress(key);
        this.awtRobot.keyRelease(key);
        Thread.sleep(10L);
        this.awtRobot.keyPress(key);
    }

    public void rightClick(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        if (SmoothRobot.Companion.useInputEvents()) {
            SmoothRobot.postClickEvent$default(this, component, MouseButton.RIGHT_BUTTON, 0, null, 12, null);
        } else {
            this.moveMouse(component);
            this.basicRobot.rightClick(component);
        }
    }

    public final void shortcut(@NotNull KeyStroke keyStoke) {
        Intrinsics.checkNotNullParameter((Object)keyStoke, (String)"keyStoke");
        int[] nArray = new int[]{keyStoke.getModifiers()};
        this.fastPressAndReleaseKey(keyStoke.getKeyCode(), nArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void selectAndDrag(@NotNull Component component, @NotNull Point from, @NotNull Point to, int delayMs) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        this.moveMouse(component, from);
        try {
            this.click(component, from);
            this.pressMouse(RemoteMouseButton.LEFT);
            Thread.sleep(delayMs);
            this.moveMouse(component, to);
            Thread.sleep(delayMs);
            this.moveMouse(component, to);
        }
        finally {
            this.releaseMouse(RemoteMouseButton.LEFT);
        }
    }

    @NotNull
    public final byte[] makeScreenshot() {
        return this.makeScreenshot(new Rectangle(Toolkit.getDefaultToolkit().getScreenSize()));
    }

    private final void smoothMoveMouse(int x, int y) {
        long pauseConstMs = this.settings().delayBetweenEvents();
        int n = 20;
        Point start = MouseInfo.getPointerInfo().getLocation();
        double dx = (double)(x - start.x) / (double)n;
        double dy = (double)(y - start.y) / (double)n;
        int step = 1;
        while (true) {
            this.basicRobot.moveMouse((int)((double)start.x + dx * ((Math.log(1.0 * (double)step / (double)n) - Math.log(1.0 / (double)n)) * (double)n / (0.0 - Math.log(1.0 / (double)n)))), (int)((double)start.y + dy * ((Math.log(1.0 * (double)step / (double)n) - Math.log(1.0 / (double)n)) * (double)n / (0.0 - Math.log(1.0 / (double)n)))));
            Pause.pause((long)pauseConstMs);
            if (step == n) break;
            ++step;
        }
        this.basicRobot.moveMouse(x, y);
    }

    private final void clickWithRetry(Component component, Point where, MouseButton mouseButton, int counts) {
        if (SmoothRobot.Companion.useInputEvents()) {
            SmoothRobot.postClickEvent$default(this, component, mouseButton, counts, null, 8, null);
            return;
        }
        MouseListener[] mouseListenerArray = component.getMouseListeners();
        Intrinsics.checkNotNullExpressionValue((Object)mouseListenerArray, (String)"getMouseListeners(...)");
        if (((Object[])mouseListenerArray).length == 0) {
            this.moveMouseAndClick(component, where, mouseButton, counts);
            return;
        }
        for (int attempt = 0; attempt < 3; ++attempt) {
            CountDownLatch clickLatch = new CountDownLatch(1);
            MouseAdapter mouseListener2 = new MouseAdapter(clickLatch, component){
                final /* synthetic */ CountDownLatch $clickLatch;
                final /* synthetic */ Component $component;
                {
                    this.$clickLatch = $clickLatch;
                    this.$component = $component;
                }

                public void mouseClicked(MouseEvent e) {
                    this.$clickLatch.countDown();
                    SmoothRobot.access$getLogger$cp().info("Mouse clicked on " + this.$component);
                }

                public void mouseReleased(MouseEvent e) {
                    this.$clickLatch.countDown();
                    SmoothRobot.access$getLogger$cp().info("Mouse released on " + this.$component);
                }

                public void mousePressed(MouseEvent e) {
                    this.$clickLatch.countDown();
                    SmoothRobot.access$getLogger$cp().info("Mouse pressed on " + this.$component);
                }
            };
            component.addMouseListener(mouseListener2);
            this.moveMouseAndClick(component, where, mouseButton, counts);
            boolean clicked = clickLatch.await(3L, TimeUnit.SECONDS);
            component.removeMouseListener(mouseListener2);
            if (clicked) break;
            logger.warn("Repeating click. Click was unsuccessful on " + component);
        }
    }

    public final void strictClick(@NotNull Component component, @Nullable Point point) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.strictClickWithRetry(component, point);
    }

    public static /* synthetic */ void strictClick$default(SmoothRobot smoothRobot, Component component, Point point, int n, Object object) {
        if ((n & 2) != 0) {
            point = null;
        }
        smoothRobot.strictClick(component, point);
    }

    private final void strictClickWithRetry(Component component, Point where) {
        if (SmoothRobot.Companion.useInputEvents()) {
            SmoothRobot.postClickEvent$default(this, component, MouseButton.LEFT_BUTTON, 1, null, 8, null);
            return;
        }
        MouseListener[] mouseListenerArray = component.getMouseListeners();
        Intrinsics.checkNotNullExpressionValue((Object)mouseListenerArray, (String)"getMouseListeners(...)");
        if (((Object[])mouseListenerArray).length == 0) {
            this.moveMouseAndClick(component, where, MouseButton.LEFT_BUTTON, 1);
            return;
        }
        for (int attempt = 0; attempt < 3; ++attempt) {
            CountDownLatch clickLatch = new CountDownLatch(1);
            MouseAdapter mouseListener2 = new MouseAdapter(clickLatch, component){
                final /* synthetic */ CountDownLatch $clickLatch;
                final /* synthetic */ Component $component;
                {
                    this.$clickLatch = $clickLatch;
                    this.$component = $component;
                }

                public void mouseClicked(MouseEvent e) {
                    this.$clickLatch.countDown();
                    SmoothRobot.access$getLogger$cp().info("Mouse clicked on " + this.$component);
                }
            };
            component.addMouseListener(mouseListener2);
            this.moveMouseAndClick(component, where, MouseButton.LEFT_BUTTON, 1);
            boolean clicked = clickLatch.await(3L, TimeUnit.SECONDS);
            component.removeMouseListener(mouseListener2);
            if (clicked) break;
            logger.warn("Repeating click. Click was unsuccessful on " + component);
        }
    }

    private final void fastPressAndReleaseKey(int keyCode, int ... modifiers) {
        int unifiedModifiers = SmoothRobot.Companion.unify(Arrays.copyOf(modifiers, modifiers.length));
        int updatedModifiers = Modifiers.updateModifierWithKeyCode((int)keyCode, (int)unifiedModifiers);
        int[] modifiersKeys = Modifiers.keysFor((int)updatedModifiers);
        Intrinsics.checkNotNull((Object)modifiersKeys);
        Object $this$forEach$iv = modifiersKeys;
        boolean $i$f$forEach = false;
        int n = ((int[])$this$forEach$iv).length;
        for (int i = 0; i < n; ++i) {
            int element$iv;
            int it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            this.awtRobot.keyPress(it);
        }
        if (updatedModifiers == unifiedModifiers) {
            this.awtRobot.keyPress(keyCode);
            this.awtRobot.keyRelease(keyCode);
        }
        $this$forEach$iv = ArraysKt.reversed((int[])modifiersKeys);
        $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            this.awtRobot.keyRelease(it);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] makeScreenshot(Rectangle screenshotArea) {
        byte[] byArray;
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream b = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            ImageIO.write((RenderedImage)this.awtRobot.createScreenCapture(screenshotArea), "png", b);
            byArray = b.toByteArray();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"use(...)");
        return byArray;
    }

    private final void moveMouseAndClick(Point where, MouseButton button, int times) {
        this.moveMouse(where.x, where.y);
        this.basicRobot.click(where, button, times);
    }

    private final void moveMouseAndClick(Component component, Point where, MouseButton button, int times) {
        if (where != null) {
            this.moveMouse(component, where);
            ApplicationManager.getApplication().invokeAndWait(SmoothRobot::moveMouseAndClick$lambda$0, ModalityState.any());
            this.basicRobot.click(component, where, button, times);
        } else {
            this.moveMouse(component);
            ApplicationManager.getApplication().invokeAndWait(SmoothRobot::moveMouseAndClick$lambda$1, ModalityState.any());
            this.basicRobot.click(component, button, times);
        }
    }

    public final void moveMouseAndPress(@NotNull Component component, @Nullable Point where) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        if (where != null) {
            this.moveMouse(component, where);
        } else {
            this.moveMouse(component);
        }
        ApplicationManager.getApplication().invokeAndWait(SmoothRobot::moveMouseAndPress$lambda$0, ModalityState.any());
        this.basicRobot.pressMouse(MouseButton.LEFT_BUTTON);
    }

    private final void moveMouseWithAttempts(Component c, int x, int y, int attempts) {
        Duration duration = Duration.ofSeconds(5L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        Duration duration2 = Duration.ofSeconds(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
        RobotUtilsKt.waitFor$default(duration, duration2, null, () -> SmoothRobot.moveMouseWithAttempts$lambda$0(c), 4, null);
        Object object = SmoothRobot.Companion.performOnEdt(() -> SmoothRobot.moveMouseWithAttempts$lambda$1(c, x, y));
        if (object == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        Point componentLocation = (Point)object;
        this.moveMouse(componentLocation.x, componentLocation.y);
        Object object2 = SmoothRobot.Companion.performOnEdt(() -> SmoothRobot.moveMouseWithAttempts$lambda$2(c, x, y));
        if (object2 == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        Point componentLocationAfterMove = (Point)object2;
        Point mouseLocation = MouseInfo.getPointerInfo().getLocation();
        if (mouseLocation.x != componentLocationAfterMove.x || mouseLocation.y != componentLocationAfterMove.y) {
            this.moveMouseWithAttempts(c, x, y, attempts - 1);
        }
    }

    static /* synthetic */ void moveMouseWithAttempts$default(SmoothRobot smoothRobot, Component component, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 8) != 0) {
            n3 = 3;
        }
        smoothRobot.moveMouseWithAttempts(component, n, n2, n3);
    }

    private final void postClickEvent(Component component, MouseButton button, int clickCount, Point where) {
        int awtMouseButton = switch (WhenMappings.$EnumSwitchMapping$0[button.ordinal()]) {
            case 1 -> 1;
            case 2 -> 3;
            case 3 -> 2;
            default -> throw new NoWhenBranchMatchedException();
        };
        IdeEventQueue eventQueue = IdeEventQueue.Companion.getInstance();
        Window window = SwingUtilities.getWindowAncestor(component);
        Point point = where;
        if (point == null) {
            point = AWT.visibleCenterOf((Component)component);
        }
        Point clickPoint = SwingUtilities.convertPoint(component, point, window);
        for (int i = 0; i < clickCount; ++i) {
            int it = i;
            boolean bl = false;
            MouseEvent mousePressedEvent = new MouseEvent(window, 501, System.currentTimeMillis(), 0, clickPoint.x, clickPoint.y, 1, awtMouseButton == 3, awtMouseButton);
            eventQueue.postEvent((AWTEvent)mousePressedEvent);
            MouseEvent mouseReleasedEvent = new MouseEvent(window, 502, System.currentTimeMillis(), 0, clickPoint.x, clickPoint.y, 1, false, awtMouseButton);
            eventQueue.postEvent((AWTEvent)mouseReleasedEvent);
        }
    }

    static /* synthetic */ void postClickEvent$default(SmoothRobot smoothRobot, Component component, MouseButton mouseButton, int n, Point point, int n2, Object object) {
        if ((n2 & 2) != 0) {
            mouseButton = MouseButton.LEFT_BUTTON;
        }
        if ((n2 & 4) != 0) {
            n = 1;
        }
        if ((n2 & 8) != 0) {
            point = null;
        }
        smoothRobot.postClickEvent(component, mouseButton, n, point);
    }

    @Nonnull
    public ComponentHierarchy hierarchy() {
        return this.basicRobot.hierarchy();
    }

    @Nonnull
    public ComponentFinder finder() {
        return this.basicRobot.finder();
    }

    @Nonnull
    public ComponentPrinter printer() {
        return this.basicRobot.printer();
    }

    public void showWindow(@Nonnull Window p0) {
        this.basicRobot.showWindow(p0);
    }

    public void showWindow(@Nonnull Window p0, @Nonnull Dimension p1) {
        this.basicRobot.showWindow(p0, p1);
    }

    public void showWindow(@Nonnull Window p0, @org.assertj.swing.dependency.jsr305.Nullable Dimension p1, boolean p2) {
        this.basicRobot.showWindow(p0, p1, p2);
    }

    public void close(@Nonnull Window p0) {
        this.basicRobot.close(p0);
    }

    public void focus(@Nonnull Component p0) {
        this.basicRobot.focus(p0);
    }

    public void focusAndWaitForFocusGain(@Nonnull Component p0) {
        this.basicRobot.focusAndWaitForFocusGain(p0);
    }

    public void cleanUp() {
        this.basicRobot.cleanUp();
    }

    public void cleanUpWithoutDisposingWindows() {
        this.basicRobot.cleanUpWithoutDisposingWindows();
    }

    public void pressMouse(@Nonnull MouseButton p0) {
        this.basicRobot.pressMouse(p0);
    }

    public void pressMouseWhileRunning(@Nonnull MouseButton p0, @Nonnull Runnable p1) {
        this.basicRobot.pressMouseWhileRunning(p0, p1);
    }

    public void pressMouseWhileRunning(@Nonnull Component p0, @Nonnull Point p1, @Nonnull Runnable p2) {
        this.basicRobot.pressMouseWhileRunning(p0, p1, p2);
    }

    public void pressMouseWhileRunning(@Nonnull Component p0, @Nonnull Point p1, @Nonnull MouseButton p2, @Nonnull Runnable p3) {
        this.basicRobot.pressMouseWhileRunning(p0, p1, p2, p3);
    }

    public void pressMouseWhileRunning(@Nonnull Point p0, @Nonnull MouseButton p1, @Nonnull Runnable p2) {
        this.basicRobot.pressMouseWhileRunning(p0, p1, p2);
    }

    public void releaseMouse(@Nonnull MouseButton p0) {
        this.basicRobot.releaseMouse(p0);
    }

    public void releaseMouseButtons() {
        this.basicRobot.releaseMouseButtons();
    }

    public void rotateMouseWheel(@Nonnull Component p0, int p1) {
        this.basicRobot.rotateMouseWheel(p0, p1);
    }

    public void rotateMouseWheel(int p0) {
        this.basicRobot.rotateMouseWheel(p0);
    }

    public void jitter(@Nonnull Component p0) {
        this.basicRobot.jitter(p0);
    }

    public void jitter(@Nonnull Component p0, @Nonnull Point p1) {
        this.basicRobot.jitter(p0, p1);
    }

    public void enterText(@Nonnull String p0) {
        this.basicRobot.enterText(p0);
    }

    public void type(char p0) {
        this.basicRobot.type(p0);
    }

    public void pressAndReleaseKey(int p0, int ... p1) {
        this.basicRobot.pressAndReleaseKey(p0, p1);
    }

    public void pressAndReleaseKeys(int ... p0) {
        this.basicRobot.pressAndReleaseKeys(p0);
    }

    public void pressKey(int p0) {
        this.basicRobot.pressKey(p0);
    }

    public void pressKeyWhileRunning(int p0, @Nonnull Runnable p1) {
        this.basicRobot.pressKeyWhileRunning(p0, p1);
    }

    public void releaseKey(int p0) {
        this.basicRobot.releaseKey(p0);
    }

    public void pressModifiers(int p0) {
        this.basicRobot.pressModifiers(p0);
    }

    public void pressModifiersWhileRunning(int p0, @Nonnull Runnable p1) {
        this.basicRobot.pressModifiersWhileRunning(p0, p1);
    }

    public void releaseModifiers(int p0) {
        this.basicRobot.releaseModifiers(p0);
    }

    public void waitForIdle() {
        this.basicRobot.waitForIdle();
    }

    public boolean isDragging() {
        return this.basicRobot.isDragging();
    }

    public boolean isReadyForInput(@Nonnull Component p0) {
        return this.basicRobot.isReadyForInput(p0);
    }

    @Nonnull
    public JPopupMenu showPopupMenu(@Nonnull Component p0) {
        return this.basicRobot.showPopupMenu(p0);
    }

    @Nonnull
    public JPopupMenu showPopupMenu(@Nonnull Component p0, @Nonnull Point p1) {
        return this.basicRobot.showPopupMenu(p0, p1);
    }

    @org.assertj.swing.dependency.jsr305.Nullable
    public JPopupMenu findActivePopupMenu() {
        return this.basicRobot.findActivePopupMenu();
    }

    public void requireNoJOptionPaneIsShowing() {
        this.basicRobot.requireNoJOptionPaneIsShowing();
    }

    @Nonnull
    public Settings settings() {
        return this.basicRobot.settings();
    }

    public boolean isActive() {
        return this.basicRobot.isActive();
    }

    @JvmOverloads
    public SmoothRobot(@NotNull Robot basicRobot) {
        Intrinsics.checkNotNullParameter((Object)basicRobot, (String)"basicRobot");
        this(basicRobot, null, 2, null);
    }

    @JvmOverloads
    public SmoothRobot() {
        this(null, null, 3, null);
    }

    private static final Point getColor$lambda$0(Component $component, Ref.ObjectRef $where) {
        Object object = $where.element;
        Intrinsics.checkNotNull((Object)object);
        int n = ((Point)object).x;
        Object object2 = $where.element;
        Intrinsics.checkNotNull((Object)object2);
        return AWT.translate((Component)$component, (int)n, (int)((Point)object2).y);
    }

    private static final Point moveMouse$lambda$0(Component $component, Point $point) {
        return AWT.translate((Component)$component, (int)$point.x, (int)$point.y);
    }

    private static final void moveMouseAndClick$lambda$0() {
    }

    private static final void moveMouseAndClick$lambda$1() {
    }

    private static final void moveMouseAndPress$lambda$0() {
    }

    private static final boolean moveMouseWithAttempts$lambda$0(Component $c) {
        Object object = SmoothRobot.Companion.performOnEdt(() -> SmoothRobot.moveMouseWithAttempts$lambda$0$0($c));
        Intrinsics.checkNotNull((Object)object);
        return (Boolean)object;
    }

    private static final boolean moveMouseWithAttempts$lambda$0$0(Component $c) {
        return $c.isShowing();
    }

    private static final Point moveMouseWithAttempts$lambda$1(Component $c, int $x, int $y) {
        return AWT.translate((Component)$c, (int)$x, (int)$y);
    }

    private static final Point moveMouseWithAttempts$lambda$2(Component $c, int $x, int $y) {
        return AWT.translate((Component)$c, (int)$x, (int)$y);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SmoothRobot.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        SmoothRobot.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\f\u0010\b\u001a\u00020\t*\u00020\nH\u0002J\u0014\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00020\u000e\"\u00020\fH\u0002J#\u0010\u000f\u001a\u0004\u0018\u0001H\u0010\"\u0004\b\u0000\u0010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/performancePlugin/remotedriver/robot/SmoothRobot$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "useInputEvents", "", "toAssertJ", "Lorg/assertj/swing/core/MouseButton;", "Lcom/intellij/driver/model/RemoteMouseButton;", "unify", "", "modifiers", "", "performOnEdt", "T", "body", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.performanceTesting.remoteDriver"})
    @SourceDebugExtension(value={"SMAP\nSmoothRobot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SmoothRobot.kt\ncom/jetbrains/performancePlugin/remotedriver/robot/SmoothRobot$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,448:1\n20931#2,7:449\n*S KotlinDebug\n*F\n+ 1 SmoothRobot.kt\ncom/jetbrains/performancePlugin/remotedriver/robot/SmoothRobot$Companion\n*L\n441#1:449,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean useInputEvents() {
            return Boolean.parseBoolean(System.getProperty("driver.robot.use.input.events"));
        }

        private final MouseButton toAssertJ(RemoteMouseButton $this$toAssertJ) {
            return switch (WhenMappings.$EnumSwitchMapping$0[$this$toAssertJ.ordinal()]) {
                case 1 -> MouseButton.LEFT_BUTTON;
                case 2 -> MouseButton.MIDDLE_BUTTON;
                case 3 -> MouseButton.RIGHT_BUTTON;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        /*
         * WARNING - void declaration
         */
        private final int unify(int ... modifiers) {
            Integer n;
            int[] $this$reduceOrNull$iv = modifiers;
            boolean $i$f$reduceOrNull = false;
            if ($this$reduceOrNull$iv.length == 0) {
                n = null;
            } else {
                int accumulator$iv = $this$reduceOrNull$iv[0];
                int index$iv = 1;
                int n2 = ArraysKt.getLastIndex((int[])$this$reduceOrNull$iv);
                if (index$iv <= n2) {
                    while (true) {
                        void i;
                        int n3 = $this$reduceOrNull$iv[index$iv];
                        int acc = accumulator$iv;
                        boolean bl = false;
                        accumulator$iv = acc | i;
                        if (index$iv == n2) break;
                        ++index$iv;
                    }
                }
                n = accumulator$iv;
            }
            return n != null ? n : 0;
        }

        private final <T> T performOnEdt(Function0<? extends T> body) {
            return (T)GuiActionRunner.execute((GuiQuery)new GuiQuery<T>(body){
                final /* synthetic */ Function0<T> $body;
                {
                    this.$body = $body;
                }

                protected T executeInEDT() {
                    return (T)this.$body.invoke();
                }
            });
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[RemoteMouseButton.values().length];
                try {
                    nArray[RemoteMouseButton.LEFT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[RemoteMouseButton.MIDDLE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[RemoteMouseButton.RIGHT.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MouseButton.values().length];
            try {
                nArray[MouseButton.LEFT_BUTTON.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MouseButton.RIGHT_BUTTON.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MouseButton.MIDDLE_BUTTON.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

