/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 63586013852072L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(976995780 - 30982, -976995780 - -((char)-18201), (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(976995780 - 30981, -976995780 - -((char)-16771), (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 27434207690807L;
                thread = Thread.currentThread();
                boolean bl2 = SshAgentIpcService.R();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (bl2) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl3 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(2043381300 + 14063, -2043381300 + -22479, (int)l2) + string + WindowsNamedPipeAgentIpc.b(2043381300 + 14062, 2043381300 - 1472, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(2043381300 + 14065, -2043381300 + -28079, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        block17: {
            boolean bl;
            block19: {
                block18: {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
                    boolean bl2;
                    long l2;
                    block15: {
                        block16: {
                            l2 = 37472689003264L;
                            Object object = this.lock;
                            synchronized (object) {
                                boolean bl3;
                                bl2 = SshAgentIpcService.R();
                                boolean bl4 = false;
                                try {
                                    bl3 = this.connectionThread == null;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                if (!bl3) {
                                    boolean bl5 = false;
                                    String string = WindowsNamedPipeAgentIpc.b(900713040 - (char)-7107, -900713040 - -((char)-6629), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(900713040 - (char)-7104, -900581970 + -((char)-11154), (int)l2) + this.state;
                                    throw new IllegalArgumentException(string.toString());
                                }
                                this.connectionThread = Thread.currentThread();
                                Unit unit = Unit.INSTANCE;
                            }
                            try {
                                try {
                                    WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                                    Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(900713040 - (char)-7105, 900713040 - (char)-950, (int)l2));
                                    this.hPipe = hANDLE;
                                    windowsNamedPipeAgentIpc = this;
                                    if (bl2) break block15;
                                    if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                                    }
                                    break block16;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                throw new RuntimeException(WindowsNamedPipeAgentIpc.b(900713040 - (char)-7118, 900581970 + (char)-15724, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(900713040 - (char)-7119, -900581970 + -((char)-15439), (int)l2) + ErrorToolsKt.kernel32LastError());
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        this.state = NamedPipeState.Open;
                        windowsNamedPipeAgentIpc = this;
                    }
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
                    boolean bl6 = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(900713040 - (char)-7116, -900581970 + -((char)-16099), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(900713040 - (char)-7118, 900581970 + (char)-15724, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(900713040 - (char)-7117, 900713040 - (char)-9152, (int)l2));
                            if (ActionTimestamp.b() == null) break block17;
                            if (!bl2) break block18;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = false;
                        break block19;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = true;
            }
            SshAgentIpcService.b(bl);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                boolean bl;
                block6: {
                    long l2 = 115823535458031L;
                    bl = SshAgentIpcService.R();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (bl) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (bl) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        boolean bl;
        long l2;
        block27: {
            block28: {
                l2 = 140043641760522L;
                boolean bl2 = SshAgentIpcService.R();
                this.assertConnectionThread();
                bl = bl2;
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl3;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl4 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (bl) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl5 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1938132090 - -25226, 1938132090 - 30528, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1938132090 - -25230, -1938132090 - -18790, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1938132090 - -25227, -1938132090 - -((char)-31083), (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl3 = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl3) {
                        boolean bl6 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1938132090 - -25230, -1938132090 - -18790, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1938132090 - -25228, 1938132090 - 30083, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl7 = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1938132090 - -25226, 1938132090 - 30528, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1938132090 - -25230, -1938132090 - -18790, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1938132090 - -25229, 1938132090 - 8560, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (bl) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl8 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1938132090 - -25226, 1938132090 - 30528, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1938132090 - -25230, -1938132090 - -18790, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1938132090 - -25222, -1938132090 - -9773, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-1938132090 - -25230, -1938132090 - -18790, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1938132090 - -25223, -1938132090 - -28088, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl9;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl10 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (bl) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl9 = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl9) {
                boolean bl11 = false;
                String string = WindowsNamedPipeAgentIpc.b(-1938132090 - -25230, -1938132090 - -18790, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1938132090 - -25228, 1938132090 - 30083, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl12 = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1938132090 - -25226, 1938132090 - 30528, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-1938132090 - -25230, -1938132090 - -18790, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1938132090 - -25224, 1938132090 - 15970, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 82731324580732L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-1664589000 - -((char)-24660), -1664589000 - -((char)-18424), (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 48810957229773L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(1346088900 + 16272, -1346088900 + -5187, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u0094@\u00ccbw[\u0080{\u00d7k[\u00eb1aY\u008d\u00a2\u009e\u008f\u0014;*9)\u00d2\u00f0I\u008bls\u00e9<\u00a5b\nf%%xa";
                        var4_3 = "\u0094@\u00ccbw[\u0080{\u00d7k[\u00eb1aY\u008d\u00a2\u009e\u008f\u0014;*9)\u00d2\u00f0I\u008bls\u00e9<\u00a5b\nf%%xa".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 59;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 108;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 55;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 91;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 80;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 46;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 81;
                                        break;
                                    }
                                    default: {
                                        v11 = 33;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0xFFFFA198) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 111;
                            case 1 -> 33;
                            case 2 -> 120;
                            case 3 -> 97;
                            case 4 -> 244;
                            case 5 -> 16;
                            case 6 -> 119;
                            case 7 -> 163;
                            case 8 -> 42;
                            case 9 -> 211;
                            case 10 -> 115;
                            case 11 -> 134;
                            case 12 -> 202;
                            case 13 -> 162;
                            case 14 -> 203;
                            case 15 -> 125;
                            case 16 -> 84;
                            case 17 -> 196;
                            case 18 -> 227;
                            case 19 -> 151;
                            case 20 -> 184;
                            case 21 -> 11;
                            case 22 -> 59;
                            case 23 -> 107;
                            case 24 -> 108;
                            case 25 -> 96;
                            case 26 -> 141;
                            case 27 -> 4;
                            case 28 -> 166;
                            case 29 -> 171;
                            case 30 -> 48;
                            case 31 -> 58;
                            case 32 -> 145;
                            case 33 -> 13;
                            case 34 -> 80;
                            case 35 -> 69;
                            case 36 -> 138;
                            case 37 -> 201;
                            case 38 -> 67;
                            case 39 -> 35;
                            case 40 -> 118;
                            case 41 -> 130;
                            case 42 -> 98;
                            case 43 -> 63;
                            case 44 -> 240;
                            case 45 -> 57;
                            case 46 -> 78;
                            case 47 -> 110;
                            case 48 -> 233;
                            case 49 -> 101;
                            case 50 -> 236;
                            case 51 -> 76;
                            case 52 -> 128;
                            case 53 -> 248;
                            case 54 -> 245;
                            case 55 -> 49;
                            case 56 -> 152;
                            case 57 -> 140;
                            case 58 -> 122;
                            case 59 -> 46;
                            case 60 -> 217;
                            case 61 -> 191;
                            case 62 -> 81;
                            case 63 -> 234;
                            case 64 -> 15;
                            case 65 -> 198;
                            case 66 -> 61;
                            case 67 -> 208;
                            case 68 -> 28;
                            case 69 -> 214;
                            case 70 -> 209;
                            case 71 -> 3;
                            case 72 -> 164;
                            case 73 -> 200;
                            case 74 -> 6;
                            case 75 -> 53;
                            case 76 -> 104;
                            case 77 -> 192;
                            case 78 -> 22;
                            case 79 -> 26;
                            case 80 -> 235;
                            case 81 -> 30;
                            case 82 -> 100;
                            case 83 -> 43;
                            case 84 -> 106;
                            case 85 -> 79;
                            case 86 -> 2;
                            case 87 -> 62;
                            case 88 -> 199;
                            case 89 -> 124;
                            case 90 -> 66;
                            case 91 -> 7;
                            case 92 -> 117;
                            case 93 -> 17;
                            case 94 -> 213;
                            case 95 -> 135;
                            case 96 -> 116;
                            case 97 -> 73;
                            case 98 -> 218;
                            case 99 -> 160;
                            case 100 -> 142;
                            case 101 -> 224;
                            case 102 -> 55;
                            case 103 -> 121;
                            case 104 -> 1;
                            case 105 -> 139;
                            case 106 -> 93;
                            case 107 -> 114;
                            case 108 -> 50;
                            case 109 -> 23;
                            case 110 -> 95;
                            case 111 -> 103;
                            case 112 -> 179;
                            case 113 -> 99;
                            case 114 -> 132;
                            case 115 -> 161;
                            case 116 -> 70;
                            case 117 -> 136;
                            case 118 -> 254;
                            case 119 -> 39;
                            case 120 -> 194;
                            case 121 -> 51;
                            case 122 -> 250;
                            case 123 -> 113;
                            case 124 -> 239;
                            case 125 -> 182;
                            case 126 -> 112;
                            case 127 -> 148;
                            case 128 -> 206;
                            case 129 -> 219;
                            case 130 -> 87;
                            case 131 -> 185;
                            case 132 -> 5;
                            case 133 -> 230;
                            case 134 -> 170;
                            case 135 -> 86;
                            case 136 -> 27;
                            case 137 -> 156;
                            case 138 -> 19;
                            case 139 -> 158;
                            case 140 -> 92;
                            case 141 -> 249;
                            case 142 -> 195;
                            case 143 -> 71;
                            case 144 -> 180;
                            case 145 -> 181;
                            case 146 -> 72;
                            case 147 -> 90;
                            case 148 -> 34;
                            case 149 -> 131;
                            case 150 -> 25;
                            case 151 -> 82;
                            case 152 -> 105;
                            case 153 -> 146;
                            case 154 -> 40;
                            case 155 -> 144;
                            case 156 -> 207;
                            case 157 -> 157;
                            case 158 -> 229;
                            case 159 -> 172;
                            case 160 -> 149;
                            case 161 -> 133;
                            case 162 -> 255;
                            case 163 -> 169;
                            case 164 -> 231;
                            case 165 -> 155;
                            case 166 -> 9;
                            case 167 -> 167;
                            case 168 -> 38;
                            case 169 -> 150;
                            case 170 -> 232;
                            case 171 -> 165;
                            case 172 -> 242;
                            case 173 -> 126;
                            case 174 -> 246;
                            case 175 -> 21;
                            case 176 -> 20;
                            case 177 -> 174;
                            case 178 -> 193;
                            case 179 -> 225;
                            case 180 -> 241;
                            case 181 -> 197;
                            case 182 -> 226;
                            case 183 -> 129;
                            case 184 -> 137;
                            case 185 -> 109;
                            case 186 -> 238;
                            case 187 -> 175;
                            case 188 -> 168;
                            case 189 -> 54;
                            case 190 -> 18;
                            case 191 -> 188;
                            case 192 -> 32;
                            case 193 -> 14;
                            case 194 -> 190;
                            case 195 -> 143;
                            case 196 -> 47;
                            case 197 -> 176;
                            case 198 -> 221;
                            case 199 -> 253;
                            case 200 -> 237;
                            case 201 -> 228;
                            case 202 -> 8;
                            case 203 -> 29;
                            case 204 -> 123;
                            case 205 -> 220;
                            case 206 -> 65;
                            case 207 -> 222;
                            case 208 -> 187;
                            case 209 -> 37;
                            case 210 -> 12;
                            case 211 -> 102;
                            case 212 -> 52;
                            case 213 -> 177;
                            case 214 -> 74;
                            case 215 -> 186;
                            case 216 -> 89;
                            case 217 -> 91;
                            case 218 -> 68;
                            case 219 -> 75;
                            case 220 -> 0;
                            case 221 -> 215;
                            case 222 -> 251;
                            case 223 -> 147;
                            case 224 -> 31;
                            case 225 -> 41;
                            case 226 -> 94;
                            case 227 -> 83;
                            case 228 -> 85;
                            case 229 -> 64;
                            case 230 -> 159;
                            case 231 -> 247;
                            case 232 -> 223;
                            case 233 -> 24;
                            case 234 -> 189;
                            case 235 -> 88;
                            case 236 -> 212;
                            case 237 -> 178;
                            case 238 -> 173;
                            case 239 -> 10;
                            case 240 -> 204;
                            case 241 -> 154;
                            case 242 -> 210;
                            case 243 -> 45;
                            case 244 -> 36;
                            case 245 -> 153;
                            case 246 -> 205;
                            case 247 -> 56;
                            case 248 -> 252;
                            case 249 -> 77;
                            case 250 -> 216;
                            case 251 -> 243;
                            case 252 -> 60;
                            case 253 -> 44;
                            case 254 -> 183;
                            default -> 127;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (bl) {
                ActionTimestamp.b("dYzRNc");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 13053070357689L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    boolean bl2 = SshAgentIpcService.k();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (!bl2) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-664787040 - -((char)-24061), 664787040 - (char)-12841, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-664787040 - -((char)-24057), -664787040 - -31679, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-664787040 - -((char)-24036), -664787040 - -((char)-26139), (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-664787040 - -((char)-24061), 664787040 - (char)-12841, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-664787040 - -((char)-24057), -664787040 - -31679, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-664787040 - -((char)-24037), 664787040 - (char)-19016, (int)l3) + ErrorToolsKt.prettyHRESULT((int)n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    boolean bl2;
                    block13: {
                        long l2 = 96219914416178L;
                        boolean bl3 = SshAgentIpcService.k();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(237892050 + 23391, -237892050 + -28387, (int)l2));
                        bl2 = bl3;
                        try {
                            try {
                                try {
                                    try {
                                        if (!bl2 || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (!bl2) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(237892050 + 23392, 237892050 + 29737, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (!bl2) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        boolean bl;
        long l2;
        block25: {
            block26: {
                l2 = 80241576348688L;
                boolean bl2 = SshAgentIpcService.R();
                this.assertConnectionThread();
                Object object2 = this.lock;
                bl = bl2;
                synchronized (object2) {
                    boolean bl3;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl4 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (bl) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (bl) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl5 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1297593000 + (char)-16798, -1297593000 + -((char)-25800), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1297593000 + (char)-16794, 1297593000 + 26958, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1297593000 + (char)-16791, -1297593000 + -((char)-25440), (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl3 = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl3) {
                        boolean bl6 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1297593000 + (char)-16794, 1297593000 + 26958, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1297593000 + (char)-16800, -1297593000 + -((char)-25749), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl7 = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1297593000 + (char)-16798, -1297593000 + -((char)-25800), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1297593000 + (char)-16794, 1297593000 + 26958, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1297593000 + (char)-16778, -1297593000 + -((char)-19137), (int)l2));
                    object = Kernel32.INSTANCE;
                    if (bl) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl7 = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1297593000 + (char)-16798, -1297593000 + -((char)-25800), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1297593000 + (char)-16794, 1297593000 + 26958, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1297593000 + (char)-16777, -1297593000 + -30147, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl8 = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (bl) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl9 = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1297593000 + (char)-16798, -1297593000 + -((char)-25800), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1297593000 + (char)-16794, 1297593000 + 26958, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1297593000 + (char)-16780, -1297593000 + -20400, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                boolean bl2;
                block16: {
                    l2 = 99800454128327L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                bl2 = SshAgentIpcService.R();
                                boolean bl3 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (bl2) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl4 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1700895390 + (char)-31425, -1700895390 + -((char)-30613), (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(1700895390 + (char)-31429, 1700895390 + (char)-9597, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1700895390 + (char)-31444, 1700895390 + (char)-15606, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(1700895390 + (char)-31441, -1700895390 + -((char)-14470), (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1700895390 + (char)-31425, -1700895390 + -((char)-30613), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1700895390 + (char)-31429, 1700895390 + (char)-9597, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1700895390 + (char)-31442, -1700895390 + -((char)-12379), (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (bl2) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (bl2) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl5 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1700895390 + (char)-31425, -1700895390 + -((char)-30613), (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(1700895390 + (char)-31429, 1700895390 + (char)-9597, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1700895390 + (char)-31439, -1700895390 + -((char)-24288), (int)l2) + ErrorToolsKt.prettyHRESULT((int)n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1700895390 + (char)-31425, -1700895390 + -((char)-30613), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1700895390 + (char)-31429, 1700895390 + (char)-9597, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1700895390 + (char)-31440, 1700895390 + (char)-26273, (int)l2));
                    if (bl2) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1700895390 + (char)-31425, -1700895390 + -((char)-30613), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1700895390 + (char)-31429, 1700895390 + (char)-9597, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1700895390 + (char)-31405, -1700895390 + -((char)-12697), (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1700895390 + (char)-31406, 1700895390 + (char)-7568, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "d \u00d3\u00cf\u0093\u0095\u00a7\u00f0\u0014\u0003j\u0007a\u00f7\u00c8\u0084A\u0006\u008c%{\u00ab\u001d\u0088\n\u00b5{M+\u0006\u00a8\\J@\u00ca%\u00184\u00f0\u0081\u0002\u00a5a\u00cc\u00b4\u00c7O\u0012s+\u00e3\u00caWT\u00b9_\u00ee\u00ad\u00d09\u00bf\t\r18\u008b\u00f9\u00cf_)\u0089\u0005\u00e6$\u0083O\u00e9\b\u0013!=\u009e\u001c\u0099P\u0093\u0014g\u0013\u00f3\u00d5\u0004V\u00cf\u0005\u0001\u00d9ne\u0088}W\u00eb\\\u0094\u0089\u0094\u0005\u00a6x\u008b\u00c4\u00e8\u001e\u00c6_\u0092DVm\u0010O\u00f9$\u009e\u0099\u00f6\u009e\u00d3\u009c\u0096Q\u00d5\u0007P\u00c2\u008a0\u00e3I'\u0081\u00cd\u009d\u0010[-\u00c5\u00cf\u00eb.Q\u00de\u00ac\u00a4\u00b9t\u0014v \u001e\t\u00a8\u0081Z\u008c\u00e6\b\u009aN\u00df\u0010NHgc\u00bf\u00bb\u00dbl\u00fd\u00f2\u0093\u00beQ/\u00885?\u00b9\u00f5u\u0011\u00a7\u00ce\u00abW\u00ff\u00f6\u001b8\u00f9\\\u000f\u00fd\u00c8\u0018c\u00eb\b\r\u00fa\u00af\u00fdR\u00e9V#1\u00b2\u009a3\u00c8\u00d5\u001e:y\u00de\u00cb\u0090)\u00bfr\u00c7\u0087\u00f3\u00e3'\u0080\u00b1o\u00b6U\u00af\u0001H\u00aa\b\u00c3H\u00945\b\u00c6\u008a\u0087\u00ebK7\u00baF\fH\u0004F!n\f\u00f0&\u00b1\u00f3H\u009aF\u00bc\u00b9\u00d8\u0096\u00bd\u00fa\u008a\u00f8\u00fe$\u00ab\u00a4y\u00c7\u0000\u00a8\u00d5\u00d5\u00c0\u00fdn\u009d5\u008f2}\u00e3\u00b8\u00dd\u00c5W8\u00b3*\u0007c\u00ba\u009beSt/\u00a8I\u00fbe \u00c2\u00ba\\d^\u00e3\u00e5\u0013\f@\u007f\u009f\u00c5\u0089=Q*\u0010\u00b0qP\u00c0\u00d0\u001fE\u00f7\u00e2QX\u00cf\u00d1\u001b\u00c1\u00ae\u0099\u00c8\u0016\u00a9\u00c4\u00cb\u000fS\u009b\u008dR\u0013\u001d\u00a1p\u00abB\u0011|~a\u000b+\u0092*\u00f3\u00e3VAm\u0087\u0096\u0084\u0015\u00e9.rg\u00ef\u00ac,O\u00142>\u0090\\\u000e\u0090i~\u0093h\u00ec\u001a)\u000f8\u00ab\u00a8q\u00f0\u00f4\u00fceR\rW\u0080P\u0088\u00f1\u00d9\u009c\u009a\u00d3\u0082\u00a0\u00c1\u00cf\u0084/\u000b\u00f9z\u0097#L\u00c3\u0001o\u008b\u00a9\u009b\u008c\u00fa\u00ea\u0007\u0097M\u00b2\u001cv;\u008f\u0007\u00a8\u00b21\u008f\u00e1\u00a6k(\u00de=\u00dd)\u000f\u00aa\u00cd\u00902\b\u00cd*\u00bb~\u00ad\u00b7z\u00f9@<\u00b8c\u00e9|\u0011\u00e5\u000f\u00db\u00cd\u00b3\u000e\u00d1\u009d\u00d9:=\u00b90\u001d|\u000f*\u00d9\r\u009c\u00fdp6\b8\u0096-\u00a8\u0007z\u00a4\"lN\u00c7f\u00fc)E\u00c7S5\u00cb\u00bb[\u00c1\u0097\r\u00d1*\u0011G\u00192\u0012\u00cdm;\u00fb\u00a5@.\u00c6|Q\u00f4\u000e\u00f9>w`\u00b2\u00ef\u00df\u00fb\u0005\u00e8\u008ag\u00ff\u0089\u001b\u00f7\u00ab\u00b1\u00d7\u0091\u00ac.\u00cfl\u00e9*F\u00bb\u009b\u00adP>+Q\u00fb*\u0091\u0007\u001f\u0084\f\u0093\nd.\u0007`S\u00be\u00a5\u00a7\u00b6\u0086\u0018\u00cd\u00c6\u00f6wx\u00042\u0084\u00f1I[\u00cd,\u00b9\u00a35\u0088\u0086P7rCW\u0016)\u00e6\u000b\u0096\u00ce\u00d6<\u0000e\u00fba\u00de1\u00fe\u0095\u00d82\u00ad\u0091\u00cb\u00b7\u0092<\u008aP\u0098N\u00159\u00ea\u00d3\u008aU\u00d3\u00fc\u00b8\u00a0\u008d\u00da\b\u00d2z\t\u0094\u0007\u00ddB\u001c\u001e\u0093\u00d7C";
                var4_3 = "d \u00d3\u00cf\u0093\u0095\u00a7\u00f0\u0014\u0003j\u0007a\u00f7\u00c8\u0084A\u0006\u008c%{\u00ab\u001d\u0088\n\u00b5{M+\u0006\u00a8\\J@\u00ca%\u00184\u00f0\u0081\u0002\u00a5a\u00cc\u00b4\u00c7O\u0012s+\u00e3\u00caWT\u00b9_\u00ee\u00ad\u00d09\u00bf\t\r18\u008b\u00f9\u00cf_)\u0089\u0005\u00e6$\u0083O\u00e9\b\u0013!=\u009e\u001c\u0099P\u0093\u0014g\u0013\u00f3\u00d5\u0004V\u00cf\u0005\u0001\u00d9ne\u0088}W\u00eb\\\u0094\u0089\u0094\u0005\u00a6x\u008b\u00c4\u00e8\u001e\u00c6_\u0092DVm\u0010O\u00f9$\u009e\u0099\u00f6\u009e\u00d3\u009c\u0096Q\u00d5\u0007P\u00c2\u008a0\u00e3I'\u0081\u00cd\u009d\u0010[-\u00c5\u00cf\u00eb.Q\u00de\u00ac\u00a4\u00b9t\u0014v \u001e\t\u00a8\u0081Z\u008c\u00e6\b\u009aN\u00df\u0010NHgc\u00bf\u00bb\u00dbl\u00fd\u00f2\u0093\u00beQ/\u00885?\u00b9\u00f5u\u0011\u00a7\u00ce\u00abW\u00ff\u00f6\u001b8\u00f9\\\u000f\u00fd\u00c8\u0018c\u00eb\b\r\u00fa\u00af\u00fdR\u00e9V#1\u00b2\u009a3\u00c8\u00d5\u001e:y\u00de\u00cb\u0090)\u00bfr\u00c7\u0087\u00f3\u00e3'\u0080\u00b1o\u00b6U\u00af\u0001H\u00aa\b\u00c3H\u00945\b\u00c6\u008a\u0087\u00ebK7\u00baF\fH\u0004F!n\f\u00f0&\u00b1\u00f3H\u009aF\u00bc\u00b9\u00d8\u0096\u00bd\u00fa\u008a\u00f8\u00fe$\u00ab\u00a4y\u00c7\u0000\u00a8\u00d5\u00d5\u00c0\u00fdn\u009d5\u008f2}\u00e3\u00b8\u00dd\u00c5W8\u00b3*\u0007c\u00ba\u009beSt/\u00a8I\u00fbe \u00c2\u00ba\\d^\u00e3\u00e5\u0013\f@\u007f\u009f\u00c5\u0089=Q*\u0010\u00b0qP\u00c0\u00d0\u001fE\u00f7\u00e2QX\u00cf\u00d1\u001b\u00c1\u00ae\u0099\u00c8\u0016\u00a9\u00c4\u00cb\u000fS\u009b\u008dR\u0013\u001d\u00a1p\u00abB\u0011|~a\u000b+\u0092*\u00f3\u00e3VAm\u0087\u0096\u0084\u0015\u00e9.rg\u00ef\u00ac,O\u00142>\u0090\\\u000e\u0090i~\u0093h\u00ec\u001a)\u000f8\u00ab\u00a8q\u00f0\u00f4\u00fceR\rW\u0080P\u0088\u00f1\u00d9\u009c\u009a\u00d3\u0082\u00a0\u00c1\u00cf\u0084/\u000b\u00f9z\u0097#L\u00c3\u0001o\u008b\u00a9\u009b\u008c\u00fa\u00ea\u0007\u0097M\u00b2\u001cv;\u008f\u0007\u00a8\u00b21\u008f\u00e1\u00a6k(\u00de=\u00dd)\u000f\u00aa\u00cd\u00902\b\u00cd*\u00bb~\u00ad\u00b7z\u00f9@<\u00b8c\u00e9|\u0011\u00e5\u000f\u00db\u00cd\u00b3\u000e\u00d1\u009d\u00d9:=\u00b90\u001d|\u000f*\u00d9\r\u009c\u00fdp6\b8\u0096-\u00a8\u0007z\u00a4\"lN\u00c7f\u00fc)E\u00c7S5\u00cb\u00bb[\u00c1\u0097\r\u00d1*\u0011G\u00192\u0012\u00cdm;\u00fb\u00a5@.\u00c6|Q\u00f4\u000e\u00f9>w`\u00b2\u00ef\u00df\u00fb\u0005\u00e8\u008ag\u00ff\u0089\u001b\u00f7\u00ab\u00b1\u00d7\u0091\u00ac.\u00cfl\u00e9*F\u00bb\u009b\u00adP>+Q\u00fb*\u0091\u0007\u001f\u0084\f\u0093\nd.\u0007`S\u00be\u00a5\u00a7\u00b6\u0086\u0018\u00cd\u00c6\u00f6wx\u00042\u0084\u00f1I[\u00cd,\u00b9\u00a35\u0088\u0086P7rCW\u0016)\u00e6\u000b\u0096\u00ce\u00d6<\u0000e\u00fba\u00de1\u00fe\u0095\u00d82\u00ad\u0091\u00cb\u00b7\u0092<\u008aP\u0098N\u00159\u00ea\u00d3\u008aU\u00d3\u00fc\u00b8\u00a0\u008d\u00da\b\u00d2z\t\u0094\u0007\u00ddB\u001c\u001e\u0093\u00d7C".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 63;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00c6\u0002E8{5b\u0093`hz\u00c7\u00bd\u009cg\u00c4\u008d\u0094HD`\u00aa\u00f0\u008b\u00ab\u00fe5\u00bd\u00a9\u0014\u008f\u00a8A\u00ee\u00e8\u00ee\u00b0RW9\u00d8\u001a\u00c3\u00e6R\u00a29\u00b9\u000b\u00a4";
                    var4_3 = "\u00c6\u0002E8{5b\u0093`hz\u00c7\u00bd\u009cg\u00c4\u008d\u0094HD`\u00aa\u00f0\u008b\u00ab\u00fe5\u00bd\u00a9\u0014\u008f\u00a8A\u00ee\u00e8\u00ee\u00b0RW9\u00d8\u001a\u00c3\u00e6R\u00a29\u00b9\u000b\u00a4".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 99;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 85;
                            break;
                        }
                        case 1: {
                            v15 = 67;
                            break;
                        }
                        case 2: {
                            v15 = 35;
                            break;
                        }
                        case 3: {
                            v15 = 90;
                            break;
                        }
                        case 4: {
                            v15 = 123;
                            break;
                        }
                        case 5: {
                            v15 = 87;
                            break;
                        }
                        default: {
                            v15 = 76;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFFFD16) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 225;
                case 1 -> 249;
                case 2 -> 159;
                case 3 -> 53;
                case 4 -> 7;
                case 5 -> 77;
                case 6 -> 73;
                case 7 -> 86;
                case 8 -> 95;
                case 9 -> 170;
                case 10 -> 91;
                case 11 -> 2;
                case 12 -> 55;
                case 13 -> 184;
                case 14 -> 13;
                case 15 -> 248;
                case 16 -> 152;
                case 17 -> 72;
                case 18 -> 128;
                case 19 -> 169;
                case 20 -> 132;
                case 21 -> 231;
                case 22 -> 62;
                case 23 -> 75;
                case 24 -> 172;
                case 25 -> 179;
                case 26 -> 124;
                case 27 -> 67;
                case 28 -> 201;
                case 29 -> 140;
                case 30 -> 113;
                case 31 -> 38;
                case 32 -> 189;
                case 33 -> 182;
                case 34 -> 232;
                case 35 -> 134;
                case 36 -> 237;
                case 37 -> 218;
                case 38 -> 74;
                case 39 -> 185;
                case 40 -> 162;
                case 41 -> 204;
                case 42 -> 245;
                case 43 -> 238;
                case 44 -> 212;
                case 45 -> 28;
                case 46 -> 18;
                case 47 -> 31;
                case 48 -> 41;
                case 49 -> 59;
                case 50 -> 70;
                case 51 -> 157;
                case 52 -> 50;
                case 53 -> 206;
                case 54 -> 190;
                case 55 -> 98;
                case 56 -> 108;
                case 57 -> 164;
                case 58 -> 163;
                case 59 -> 88;
                case 60 -> 247;
                case 61 -> 183;
                case 62 -> 208;
                case 63 -> 43;
                case 64 -> 143;
                case 65 -> 151;
                case 66 -> 251;
                case 67 -> 83;
                case 68 -> 49;
                case 69 -> 252;
                case 70 -> 199;
                case 71 -> 133;
                case 72 -> 100;
                case 73 -> 44;
                case 74 -> 111;
                case 75 -> 129;
                case 76 -> 27;
                case 77 -> 34;
                case 78 -> 239;
                case 79 -> 35;
                case 80 -> 112;
                case 81 -> 90;
                case 82 -> 81;
                case 83 -> 166;
                case 84 -> 19;
                case 85 -> 233;
                case 86 -> 158;
                case 87 -> 22;
                case 88 -> 10;
                case 89 -> 48;
                case 90 -> 214;
                case 91 -> 139;
                case 92 -> 92;
                case 93 -> 121;
                case 94 -> 197;
                case 95 -> 168;
                case 96 -> 80;
                case 97 -> 65;
                case 98 -> 177;
                case 99 -> 211;
                case 100 -> 21;
                case 101 -> 178;
                case 102 -> 78;
                case 103 -> 223;
                case 104 -> 23;
                case 105 -> 241;
                case 106 -> 153;
                case 107 -> 171;
                case 108 -> 4;
                case 109 -> 198;
                case 110 -> 120;
                case 111 -> 228;
                case 112 -> 174;
                case 113 -> 26;
                case 114 -> 219;
                case 115 -> 216;
                case 116 -> 242;
                case 117 -> 36;
                case 118 -> 147;
                case 119 -> 47;
                case 120 -> 76;
                case 121 -> 253;
                case 122 -> 33;
                case 123 -> 37;
                case 124 -> 52;
                case 125 -> 254;
                case 126 -> 99;
                case 127 -> 191;
                case 128 -> 39;
                case 129 -> 156;
                case 130 -> 9;
                case 131 -> 131;
                case 132 -> 104;
                case 133 -> 5;
                case 134 -> 146;
                case 135 -> 16;
                case 136 -> 209;
                case 137 -> 89;
                case 138 -> 141;
                case 139 -> 0;
                case 140 -> 207;
                case 141 -> 102;
                case 142 -> 220;
                case 143 -> 167;
                case 144 -> 196;
                case 145 -> 195;
                case 146 -> 3;
                case 147 -> 15;
                case 148 -> 226;
                case 149 -> 181;
                case 150 -> 45;
                case 151 -> 176;
                case 152 -> 87;
                case 153 -> 30;
                case 154 -> 149;
                case 155 -> 210;
                case 156 -> 97;
                case 157 -> 200;
                case 158 -> 127;
                case 159 -> 106;
                case 160 -> 230;
                case 161 -> 244;
                case 162 -> 188;
                case 163 -> 135;
                case 164 -> 66;
                case 165 -> 79;
                case 166 -> 213;
                case 167 -> 221;
                case 168 -> 187;
                case 169 -> 202;
                case 170 -> 136;
                case 171 -> 126;
                case 172 -> 103;
                case 173 -> 154;
                case 174 -> 71;
                case 175 -> 229;
                case 176 -> 8;
                case 177 -> 165;
                case 178 -> 186;
                case 179 -> 68;
                case 180 -> 20;
                case 181 -> 148;
                case 182 -> 224;
                case 183 -> 101;
                case 184 -> 94;
                case 185 -> 217;
                case 186 -> 155;
                case 187 -> 63;
                case 188 -> 54;
                case 189 -> 137;
                case 190 -> 69;
                case 191 -> 144;
                case 192 -> 107;
                case 193 -> 1;
                case 194 -> 24;
                case 195 -> 175;
                case 196 -> 173;
                case 197 -> 32;
                case 198 -> 222;
                case 199 -> 46;
                case 200 -> 110;
                case 201 -> 243;
                case 202 -> 161;
                case 203 -> 64;
                case 204 -> 42;
                case 205 -> 14;
                case 206 -> 56;
                case 207 -> 61;
                case 208 -> 142;
                case 209 -> 215;
                case 210 -> 123;
                case 211 -> 40;
                case 212 -> 82;
                case 213 -> 255;
                case 214 -> 205;
                case 215 -> 115;
                case 216 -> 57;
                case 217 -> 119;
                case 218 -> 125;
                case 219 -> 130;
                case 220 -> 12;
                case 221 -> 150;
                case 222 -> 145;
                case 223 -> 240;
                case 224 -> 203;
                case 225 -> 116;
                case 226 -> 29;
                case 227 -> 193;
                case 228 -> 25;
                case 229 -> 138;
                case 230 -> 6;
                case 231 -> 93;
                case 232 -> 160;
                case 233 -> 84;
                case 234 -> 109;
                case 235 -> 58;
                case 236 -> 11;
                case 237 -> 192;
                case 238 -> 105;
                case 239 -> 194;
                case 240 -> 114;
                case 241 -> 180;
                case 242 -> 96;
                case 243 -> 51;
                case 244 -> 60;
                case 245 -> 17;
                case 246 -> 122;
                case 247 -> 246;
                case 248 -> 117;
                case 249 -> 234;
                case 250 -> 250;
                case 251 -> 235;
                case 252 -> 227;
                case 253 -> 236;
                case 254 -> 118;
                default -> 85;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 44833024465638L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-2139193470 - -((char)-22301), -2139193470 - -((char)-10473), (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        boolean bl2;
                        block4: {
                            l2 = 32768694910400L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            bl2 = SshAgentIpcService.k();
                            try {
                                hANDLE2 = hANDLE;
                                if (!bl2) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (!bl2) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl3 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1905626730 - -((char)-25172), 1905626730 - (char)-19230, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1905626730 - -((char)-25173), 1905626730 - (char)-25177, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1905626730 - -((char)-25174), -1905626730 - -((char)-23108), (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "_\u00dd!\u00bd\u0095\u00be\u00b2\u00be\u0010\u009c<\u00a8 \u001e\u00b6:\u00e6\u001d6B~\u000e\u00e2HP";
                    var4_3 = "_\u00dd!\u00bd\u0095\u00be\u00b2\u00be\u0010\u009c<\u00a8 \u001e\u00b6:\u00e6\u001d6B~\u000e\u00e2HP".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 26;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u008ao\u00f8\u0088\u00bd5Qe\u0094\u00a5\u00e2\\\u00des\u0095\\\u00a2\u0090\u0086\u00b6?3&\u00a6\u0012\u00ab\u008c\u00c8y\u00b5B\u0085\u00070&r5\u001b\u0004B\u0081F\u00ca\u00ae*a\u00b8\u00e5e\u00bc?\u001b%\u00e4\u00ff\u00de\u0006w\u00ab";
                        var4_3 = "\u008ao\u00f8\u0088\u00bd5Qe\u0094\u00a5\u00e2\\\u00des\u0095\\\u00a2\u0090\u0086\u00b6?3&\u00a6\u0012\u00ab\u008c\u00c8y\u00b5B\u0085\u00070&r5\u001b\u0004B\u0081F\u00ca\u00ae*a\u00b8\u00e5e\u00bc?\u001b%\u00e4\u00ff\u00de\u0006w\u00ab".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 25;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 95;
                                break;
                            }
                            case 1: {
                                v15 = 89;
                                break;
                            }
                            case 2: {
                                v15 = 118;
                                break;
                            }
                            case 3: {
                                v15 = 85;
                                break;
                            }
                            case 4: {
                                v15 = 8;
                                break;
                            }
                            case 5: {
                                v15 = 82;
                                break;
                            }
                            default: {
                                v15 = 118;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x7283) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 226;
                    case 1 -> 221;
                    case 2 -> 19;
                    case 3 -> 92;
                    case 4 -> 37;
                    case 5 -> 246;
                    case 6 -> 16;
                    case 7 -> 170;
                    case 8 -> 189;
                    case 9 -> 140;
                    case 10 -> 113;
                    case 11 -> 211;
                    case 12 -> 153;
                    case 13 -> 90;
                    case 14 -> 36;
                    case 15 -> 207;
                    case 16 -> 120;
                    case 17 -> 80;
                    case 18 -> 204;
                    case 19 -> 98;
                    case 20 -> 45;
                    case 21 -> 234;
                    case 22 -> 255;
                    case 23 -> 101;
                    case 24 -> 132;
                    case 25 -> 237;
                    case 26 -> 21;
                    case 27 -> 182;
                    case 28 -> 128;
                    case 29 -> 188;
                    case 30 -> 12;
                    case 31 -> 185;
                    case 32 -> 175;
                    case 33 -> 119;
                    case 34 -> 72;
                    case 35 -> 178;
                    case 36 -> 108;
                    case 37 -> 152;
                    case 38 -> 201;
                    case 39 -> 54;
                    case 40 -> 142;
                    case 41 -> 3;
                    case 42 -> 151;
                    case 43 -> 49;
                    case 44 -> 2;
                    case 45 -> 227;
                    case 46 -> 105;
                    case 47 -> 219;
                    case 48 -> 78;
                    case 49 -> 244;
                    case 50 -> 166;
                    case 51 -> 186;
                    case 52 -> 199;
                    case 53 -> 53;
                    case 54 -> 127;
                    case 55 -> 22;
                    case 56 -> 74;
                    case 57 -> 56;
                    case 58 -> 179;
                    case 59 -> 249;
                    case 60 -> 122;
                    case 61 -> 229;
                    case 62 -> 184;
                    case 63 -> 69;
                    case 64 -> 174;
                    case 65 -> 215;
                    case 66 -> 38;
                    case 67 -> 202;
                    case 68 -> 51;
                    case 69 -> 31;
                    case 70 -> 203;
                    case 71 -> 163;
                    case 72 -> 143;
                    case 73 -> 104;
                    case 74 -> 125;
                    case 75 -> 181;
                    case 76 -> 39;
                    case 77 -> 218;
                    case 78 -> 241;
                    case 79 -> 118;
                    case 80 -> 144;
                    case 81 -> 130;
                    case 82 -> 94;
                    case 83 -> 253;
                    case 84 -> 88;
                    case 85 -> 147;
                    case 86 -> 6;
                    case 87 -> 193;
                    case 88 -> 62;
                    case 89 -> 236;
                    case 90 -> 161;
                    case 91 -> 41;
                    case 92 -> 208;
                    case 93 -> 160;
                    case 94 -> 30;
                    case 95 -> 231;
                    case 96 -> 148;
                    case 97 -> 14;
                    case 98 -> 59;
                    case 99 -> 155;
                    case 100 -> 171;
                    case 101 -> 65;
                    case 102 -> 77;
                    case 103 -> 112;
                    case 104 -> 146;
                    case 105 -> 15;
                    case 106 -> 197;
                    case 107 -> 34;
                    case 108 -> 93;
                    case 109 -> 46;
                    case 110 -> 86;
                    case 111 -> 32;
                    case 112 -> 82;
                    case 113 -> 11;
                    case 114 -> 220;
                    case 115 -> 44;
                    case 116 -> 177;
                    case 117 -> 206;
                    case 118 -> 216;
                    case 119 -> 43;
                    case 120 -> 251;
                    case 121 -> 240;
                    case 122 -> 116;
                    case 123 -> 254;
                    case 124 -> 129;
                    case 125 -> 248;
                    case 126 -> 117;
                    case 127 -> 167;
                    case 128 -> 48;
                    case 129 -> 250;
                    case 130 -> 190;
                    case 131 -> 61;
                    case 132 -> 156;
                    case 133 -> 223;
                    case 134 -> 195;
                    case 135 -> 23;
                    case 136 -> 5;
                    case 137 -> 213;
                    case 138 -> 87;
                    case 139 -> 154;
                    case 140 -> 63;
                    case 141 -> 1;
                    case 142 -> 95;
                    case 143 -> 91;
                    case 144 -> 103;
                    case 145 -> 198;
                    case 146 -> 150;
                    case 147 -> 228;
                    case 148 -> 194;
                    case 149 -> 158;
                    case 150 -> 245;
                    case 151 -> 123;
                    case 152 -> 42;
                    case 153 -> 57;
                    case 154 -> 233;
                    case 155 -> 55;
                    case 156 -> 162;
                    case 157 -> 76;
                    case 158 -> 99;
                    case 159 -> 224;
                    case 160 -> 115;
                    case 161 -> 169;
                    case 162 -> 0;
                    case 163 -> 17;
                    case 164 -> 68;
                    case 165 -> 35;
                    case 166 -> 84;
                    case 167 -> 176;
                    case 168 -> 60;
                    case 169 -> 183;
                    case 170 -> 50;
                    case 171 -> 139;
                    case 172 -> 214;
                    case 173 -> 83;
                    case 174 -> 28;
                    case 175 -> 196;
                    case 176 -> 124;
                    case 177 -> 102;
                    case 178 -> 187;
                    case 179 -> 230;
                    case 180 -> 81;
                    case 181 -> 200;
                    case 182 -> 9;
                    case 183 -> 136;
                    case 184 -> 232;
                    case 185 -> 131;
                    case 186 -> 73;
                    case 187 -> 222;
                    case 188 -> 7;
                    case 189 -> 168;
                    case 190 -> 209;
                    case 191 -> 149;
                    case 192 -> 191;
                    case 193 -> 110;
                    case 194 -> 126;
                    case 195 -> 192;
                    case 196 -> 180;
                    case 197 -> 242;
                    case 198 -> 8;
                    case 199 -> 13;
                    case 200 -> 137;
                    case 201 -> 79;
                    case 202 -> 47;
                    case 203 -> 121;
                    case 204 -> 71;
                    case 205 -> 97;
                    case 206 -> 25;
                    case 207 -> 239;
                    case 208 -> 100;
                    case 209 -> 157;
                    case 210 -> 52;
                    case 211 -> 4;
                    case 212 -> 66;
                    case 213 -> 89;
                    case 214 -> 107;
                    case 215 -> 111;
                    case 216 -> 238;
                    case 217 -> 138;
                    case 218 -> 165;
                    case 219 -> 27;
                    case 220 -> 133;
                    case 221 -> 134;
                    case 222 -> 217;
                    case 223 -> 70;
                    case 224 -> 114;
                    case 225 -> 164;
                    case 226 -> 10;
                    case 227 -> 205;
                    case 228 -> 67;
                    case 229 -> 18;
                    case 230 -> 40;
                    case 231 -> 141;
                    case 232 -> 106;
                    case 233 -> 58;
                    case 234 -> 26;
                    case 235 -> 145;
                    case 236 -> 173;
                    case 237 -> 135;
                    case 238 -> 210;
                    case 239 -> 247;
                    case 240 -> 75;
                    case 241 -> 212;
                    case 242 -> 235;
                    case 243 -> 33;
                    case 244 -> 109;
                    case 245 -> 96;
                    case 246 -> 172;
                    case 247 -> 29;
                    case 248 -> 159;
                    case 249 -> 243;
                    case 250 -> 24;
                    case 251 -> 20;
                    case 252 -> 64;
                    case 253 -> 225;
                    case 254 -> 85;
                    default -> 252;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 3181722659284L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "U\u001fI\u00028oY\f\tR\u0015Z\bu-D\u0010S";
                    var5_4 = "U\u001fI\u00028oY\f\tR\u0015Z\bu-D\u0010S".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 26;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 36;
                                    break;
                                }
                                case 1: {
                                    v11 = 96;
                                    break;
                                }
                                case 2: {
                                    v11 = 33;
                                    break;
                                }
                                case 3: {
                                    v11 = 118;
                                    break;
                                }
                                case 4: {
                                    v11 = 71;
                                    break;
                                }
                                case 5: {
                                    v11 = 25;
                                    break;
                                }
                                default: {
                                    v11 = 112;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 53745469447358L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "coZk\u007fzE\u0004eqVq\nin]qsx]CoT\tin]qsx]Oe\rnh@|yuGObGvx|";
                    var5_4 = "coZk\u007fzE\u0004eqVq\nin]qsx]CoT\tin]qsx]Oe\rnh@|yuGObGvx|".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 46;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "\t\r<\f\u001f\u0015.\u0006\t\r<\f\u0013\u001f";
                        var5_4 = "\t\r<\f\u001f\u0015.\u0006\t\r<\f\u0013\u001f".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 78;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 4;
                                break;
                            }
                            case 1: {
                                v15 = 47;
                                break;
                            }
                            case 2: {
                                v15 = 29;
                                break;
                            }
                            case 3: {
                                v15 = 49;
                                break;
                            }
                            case 4: {
                                v15 = 56;
                                break;
                            }
                            case 5: {
                                v15 = 53;
                                break;
                            }
                            default: {
                                v15 = 7;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 90293881717552L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-784322880 - -((char)-6648), -784191810 + -((char)-14003), (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 7687268339887L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00c3d\u00f6Y\u00ce\u0003E\u00d8\u0092\u0005Y,\u0083\u0094\u0083\r\u00fa\u00ef\u00c1\u00a6>h:\u00cc-\u0095\u00b0u-\u0010\u009b\u00d1*\u008a|xY\u00f3\u0088\u00f6\u00e7T!\u0088a\u00e4\u0005.\u0087m\u00e1^3I\u00d7\u0090\u009c\u00fe\u00fe97\u00f9\u0093B\u00d1Si\u0003\u00c7\u0090W\u00e2my\u00b9;\u0012\u00b5\u00bf\u00e8m\u00ca\u00f7\u0096\u0082\u00e0/\u00b1/\u00ac\u00c0\"\u00f7\u00dc!W\u008c\t\u001b\u00dc6\u0005\u001b3";
                    var4_3 = "\u00c3d\u00f6Y\u00ce\u0003E\u00d8\u0092\u0005Y,\u0083\u0094\u0083\r\u00fa\u00ef\u00c1\u00a6>h:\u00cc-\u0095\u00b0u-\u0010\u009b\u00d1*\u008a|xY\u00f3\u0088\u00f6\u00e7T!\u0088a\u00e4\u0005.\u0087m\u00e1^3I\u00d7\u0090\u009c\u00fe\u00fe97\u00f9\u0093B\u00d1Si\u0003\u00c7\u0090W\u00e2my\u00b9;\u0012\u00b5\u00bf\u00e8m\u00ca\u00f7\u0096\u0082\u00e0/\u00b1/\u00ac\u00c0\"\u00f7\u00dc!W\u008c\t\u001b\u00dc6\u0005\u001b3".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 118;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00d1P\u00c5\u001c'\f\u0094\u00db\u0097U\u00a2\u0086/t\u0006\u00ddLk\u00b6e\n\u0019\u0006=\u00f4+#\u0099\u00f1F\u0014\u00b8\u00a8D\u00cd!n\u00cf\u001baB{\u00f8\u00b2\u00e5\u00dd\t=\u0094#\u00a5\u001e\u00c4\u00cd\u00c5\u0092\u0097Zv\u00ee\u00bd\u008dE!c\u00ee#\u0000\u00fb\u00d3\u00d2\u00a4_l6\u0012\u0015\u00f3n\u00b6t\u001a*\u00b6\u00ae\u00c9\u0004\u001fz_\u00a8OU";
                        var4_3 = "\u00d1P\u00c5\u001c'\f\u0094\u00db\u0097U\u00a2\u0086/t\u0006\u00ddLk\u00b6e\n\u0019\u0006=\u00f4+#\u0099\u00f1F\u0014\u00b8\u00a8D\u00cd!n\u00cf\u001baB{\u00f8\u00b2\u00e5\u00dd\t=\u0094#\u00a5\u001e\u00c4\u00cd\u00c5\u0092\u0097Zv\u00ee\u00bd\u008dE!c\u00ee#\u0000\u00fb\u00d3\u00d2\u00a4_l6\u0012\u0015\u00f3n\u00b6t\u001a*\u00b6\u00ae\u00c9\u0004\u001fz_\u00a8OU".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 57;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 120;
                                break;
                            }
                            case 1: {
                                v15 = 100;
                                break;
                            }
                            case 2: {
                                v15 = 17;
                                break;
                            }
                            case 3: {
                                v15 = 4;
                                break;
                            }
                            case 4: {
                                v15 = 55;
                                break;
                            }
                            case 5: {
                                v15 = 2;
                                break;
                            }
                            default: {
                                v15 = 95;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFD7F8) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 82;
                    case 1 -> 157;
                    case 2 -> 35;
                    case 3 -> 228;
                    case 4 -> 250;
                    case 5 -> 221;
                    case 6 -> 130;
                    case 7 -> 93;
                    case 8 -> 105;
                    case 9 -> 174;
                    case 10 -> 97;
                    case 11 -> 68;
                    case 12 -> 144;
                    case 13 -> 246;
                    case 14 -> 11;
                    case 15 -> 84;
                    case 16 -> 214;
                    case 17 -> 153;
                    case 18 -> 116;
                    case 19 -> 67;
                    case 20 -> 229;
                    case 21 -> 27;
                    case 22 -> 170;
                    case 23 -> 119;
                    case 24 -> 129;
                    case 25 -> 185;
                    case 26 -> 5;
                    case 27 -> 134;
                    case 28 -> 118;
                    case 29 -> 56;
                    case 30 -> 169;
                    case 31 -> 192;
                    case 32 -> 89;
                    case 33 -> 243;
                    case 34 -> 154;
                    case 35 -> 102;
                    case 36 -> 184;
                    case 37 -> 24;
                    case 38 -> 166;
                    case 39 -> 233;
                    case 40 -> 127;
                    case 41 -> 203;
                    case 42 -> 52;
                    case 43 -> 141;
                    case 44 -> 36;
                    case 45 -> 198;
                    case 46 -> 25;
                    case 47 -> 109;
                    case 48 -> 178;
                    case 49 -> 194;
                    case 50 -> 239;
                    case 51 -> 92;
                    case 52 -> 195;
                    case 53 -> 80;
                    case 54 -> 172;
                    case 55 -> 101;
                    case 56 -> 75;
                    case 57 -> 28;
                    case 58 -> 121;
                    case 59 -> 38;
                    case 60 -> 202;
                    case 61 -> 182;
                    case 62 -> 88;
                    case 63 -> 217;
                    case 64 -> 205;
                    case 65 -> 193;
                    case 66 -> 164;
                    case 67 -> 133;
                    case 68 -> 83;
                    case 69 -> 176;
                    case 70 -> 76;
                    case 71 -> 94;
                    case 72 -> 41;
                    case 73 -> 231;
                    case 74 -> 183;
                    case 75 -> 49;
                    case 76 -> 47;
                    case 77 -> 91;
                    case 78 -> 107;
                    case 79 -> 48;
                    case 80 -> 255;
                    case 81 -> 16;
                    case 82 -> 40;
                    case 83 -> 146;
                    case 84 -> 224;
                    case 85 -> 218;
                    case 86 -> 98;
                    case 87 -> 125;
                    case 88 -> 64;
                    case 89 -> 199;
                    case 90 -> 123;
                    case 91 -> 177;
                    case 92 -> 234;
                    case 93 -> 160;
                    case 94 -> 29;
                    case 95 -> 115;
                    case 96 -> 219;
                    case 97 -> 31;
                    case 98 -> 189;
                    case 99 -> 73;
                    case 100 -> 62;
                    case 101 -> 126;
                    case 102 -> 175;
                    case 103 -> 50;
                    case 104 -> 225;
                    case 105 -> 140;
                    case 106 -> 59;
                    case 107 -> 37;
                    case 108 -> 120;
                    case 109 -> 18;
                    case 110 -> 171;
                    case 111 -> 39;
                    case 112 -> 112;
                    case 113 -> 2;
                    case 114 -> 207;
                    case 115 -> 22;
                    case 116 -> 90;
                    case 117 -> 156;
                    case 118 -> 143;
                    case 119 -> 148;
                    case 120 -> 187;
                    case 121 -> 74;
                    case 122 -> 1;
                    case 123 -> 227;
                    case 124 -> 106;
                    case 125 -> 103;
                    case 126 -> 191;
                    case 127 -> 0;
                    case 128 -> 188;
                    case 129 -> 216;
                    case 130 -> 69;
                    case 131 -> 180;
                    case 132 -> 215;
                    case 133 -> 209;
                    case 134 -> 136;
                    case 135 -> 254;
                    case 136 -> 226;
                    case 137 -> 155;
                    case 138 -> 163;
                    case 139 -> 213;
                    case 140 -> 222;
                    case 141 -> 253;
                    case 142 -> 7;
                    case 143 -> 114;
                    case 144 -> 10;
                    case 145 -> 159;
                    case 146 -> 3;
                    case 147 -> 43;
                    case 148 -> 110;
                    case 149 -> 238;
                    case 150 -> 17;
                    case 151 -> 236;
                    case 152 -> 79;
                    case 153 -> 95;
                    case 154 -> 132;
                    case 155 -> 122;
                    case 156 -> 117;
                    case 157 -> 145;
                    case 158 -> 13;
                    case 159 -> 30;
                    case 160 -> 54;
                    case 161 -> 81;
                    case 162 -> 14;
                    case 163 -> 168;
                    case 164 -> 223;
                    case 165 -> 111;
                    case 166 -> 196;
                    case 167 -> 12;
                    case 168 -> 86;
                    case 169 -> 210;
                    case 170 -> 87;
                    case 171 -> 15;
                    case 172 -> 220;
                    case 173 -> 42;
                    case 174 -> 173;
                    case 175 -> 44;
                    case 176 -> 100;
                    case 177 -> 235;
                    case 178 -> 46;
                    case 179 -> 162;
                    case 180 -> 197;
                    case 181 -> 167;
                    case 182 -> 204;
                    case 183 -> 65;
                    case 184 -> 142;
                    case 185 -> 71;
                    case 186 -> 23;
                    case 187 -> 66;
                    case 188 -> 135;
                    case 189 -> 99;
                    case 190 -> 8;
                    case 191 -> 211;
                    case 192 -> 230;
                    case 193 -> 108;
                    case 194 -> 70;
                    case 195 -> 20;
                    case 196 -> 96;
                    case 197 -> 104;
                    case 198 -> 45;
                    case 199 -> 161;
                    case 200 -> 77;
                    case 201 -> 245;
                    case 202 -> 128;
                    case 203 -> 60;
                    case 204 -> 58;
                    case 205 -> 149;
                    case 206 -> 206;
                    case 207 -> 179;
                    case 208 -> 137;
                    case 209 -> 244;
                    case 210 -> 53;
                    case 211 -> 150;
                    case 212 -> 33;
                    case 213 -> 57;
                    case 214 -> 113;
                    case 215 -> 55;
                    case 216 -> 200;
                    case 217 -> 252;
                    case 218 -> 242;
                    case 219 -> 151;
                    case 220 -> 181;
                    case 221 -> 78;
                    case 222 -> 241;
                    case 223 -> 63;
                    case 224 -> 138;
                    case 225 -> 72;
                    case 226 -> 21;
                    case 227 -> 186;
                    case 228 -> 190;
                    case 229 -> 61;
                    case 230 -> 247;
                    case 231 -> 51;
                    case 232 -> 249;
                    case 233 -> 85;
                    case 234 -> 208;
                    case 235 -> 131;
                    case 236 -> 34;
                    case 237 -> 237;
                    case 238 -> 139;
                    case 239 -> 147;
                    case 240 -> 19;
                    case 241 -> 9;
                    case 242 -> 248;
                    case 243 -> 152;
                    case 244 -> 201;
                    case 245 -> 26;
                    case 246 -> 232;
                    case 247 -> 32;
                    case 248 -> 4;
                    case 249 -> 6;
                    case 250 -> 158;
                    case 251 -> 240;
                    case 252 -> 251;
                    case 253 -> 124;
                    case 254 -> 212;
                    default -> 165;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 549833651472L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-77855580 - -3504, 77855580 - 10392, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 62797932398972L;
                    boolean bl = SshAgentIpcService.R();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-1215543180 + -((char)-26053), -1215543180 + -((char)-30452), (int)l2));
                    boolean bl2 = bl;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (bl2) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 8528936582071L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u0017\u00a4\fY\"\u0003Q\u00d4\u0092";
                var4_3 = "\u0017\u00a4\fY\"\u0003Q\u00d4\u0092".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 46;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 16;
                                break;
                            }
                            case 1: {
                                v11 = 54;
                                break;
                            }
                            case 2: {
                                v11 = 47;
                                break;
                            }
                            case 3: {
                                v11 = 5;
                                break;
                            }
                            case 4: {
                                v11 = 16;
                                break;
                            }
                            case 5: {
                                v11 = 92;
                                break;
                            }
                            default: {
                                v11 = 120;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFA744) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 83;
                    case 1 -> 10;
                    case 2 -> 115;
                    case 3 -> 56;
                    case 4 -> 222;
                    case 5 -> 24;
                    case 6 -> 9;
                    case 7 -> 66;
                    case 8 -> 116;
                    case 9 -> 12;
                    case 10 -> 98;
                    case 11 -> 38;
                    case 12 -> 168;
                    case 13 -> 86;
                    case 14 -> 159;
                    case 15 -> 75;
                    case 16 -> 162;
                    case 17 -> 191;
                    case 18 -> 181;
                    case 19 -> 100;
                    case 20 -> 99;
                    case 21 -> 145;
                    case 22 -> 241;
                    case 23 -> 48;
                    case 24 -> 44;
                    case 25 -> 148;
                    case 26 -> 155;
                    case 27 -> 97;
                    case 28 -> 151;
                    case 29 -> 129;
                    case 30 -> 50;
                    case 31 -> 218;
                    case 32 -> 74;
                    case 33 -> 174;
                    case 34 -> 126;
                    case 35 -> 41;
                    case 36 -> 78;
                    case 37 -> 185;
                    case 38 -> 143;
                    case 39 -> 254;
                    case 40 -> 49;
                    case 41 -> 140;
                    case 42 -> 178;
                    case 43 -> 208;
                    case 44 -> 37;
                    case 45 -> 112;
                    case 46 -> 4;
                    case 47 -> 233;
                    case 48 -> 250;
                    case 49 -> 71;
                    case 50 -> 7;
                    case 51 -> 253;
                    case 52 -> 101;
                    case 53 -> 27;
                    case 54 -> 30;
                    case 55 -> 196;
                    case 56 -> 108;
                    case 57 -> 232;
                    case 58 -> 195;
                    case 59 -> 109;
                    case 60 -> 214;
                    case 61 -> 53;
                    case 62 -> 212;
                    case 63 -> 161;
                    case 64 -> 245;
                    case 65 -> 176;
                    case 66 -> 91;
                    case 67 -> 133;
                    case 68 -> 96;
                    case 69 -> 158;
                    case 70 -> 227;
                    case 71 -> 242;
                    case 72 -> 136;
                    case 73 -> 65;
                    case 74 -> 160;
                    case 75 -> 146;
                    case 76 -> 255;
                    case 77 -> 85;
                    case 78 -> 139;
                    case 79 -> 43;
                    case 80 -> 231;
                    case 81 -> 135;
                    case 82 -> 127;
                    case 83 -> 153;
                    case 84 -> 167;
                    case 85 -> 211;
                    case 86 -> 94;
                    case 87 -> 216;
                    case 88 -> 149;
                    case 89 -> 93;
                    case 90 -> 194;
                    case 91 -> 240;
                    case 92 -> 172;
                    case 93 -> 68;
                    case 94 -> 247;
                    case 95 -> 236;
                    case 96 -> 131;
                    case 97 -> 134;
                    case 98 -> 67;
                    case 99 -> 31;
                    case 100 -> 88;
                    case 101 -> 205;
                    case 102 -> 202;
                    case 103 -> 166;
                    case 104 -> 228;
                    case 105 -> 204;
                    case 106 -> 157;
                    case 107 -> 197;
                    case 108 -> 47;
                    case 109 -> 156;
                    case 110 -> 173;
                    case 111 -> 248;
                    case 112 -> 128;
                    case 113 -> 5;
                    case 114 -> 121;
                    case 115 -> 225;
                    case 116 -> 183;
                    case 117 -> 219;
                    case 118 -> 92;
                    case 119 -> 90;
                    case 120 -> 72;
                    case 121 -> 198;
                    case 122 -> 169;
                    case 123 -> 103;
                    case 124 -> 200;
                    case 125 -> 21;
                    case 126 -> 62;
                    case 127 -> 70;
                    case 128 -> 142;
                    case 129 -> 59;
                    case 130 -> 63;
                    case 131 -> 213;
                    case 132 -> 2;
                    case 133 -> 36;
                    case 134 -> 186;
                    case 135 -> 125;
                    case 136 -> 234;
                    case 137 -> 224;
                    case 138 -> 6;
                    case 139 -> 55;
                    case 140 -> 252;
                    case 141 -> 60;
                    case 142 -> 79;
                    case 143 -> 81;
                    case 144 -> 246;
                    case 145 -> 238;
                    case 146 -> 25;
                    case 147 -> 3;
                    case 148 -> 77;
                    case 149 -> 102;
                    case 150 -> 54;
                    case 151 -> 132;
                    case 152 -> 187;
                    case 153 -> 152;
                    case 154 -> 61;
                    case 155 -> 16;
                    case 156 -> 113;
                    case 157 -> 82;
                    case 158 -> 226;
                    case 159 -> 52;
                    case 160 -> 193;
                    case 161 -> 106;
                    case 162 -> 203;
                    case 163 -> 29;
                    case 164 -> 217;
                    case 165 -> 144;
                    case 166 -> 33;
                    case 167 -> 119;
                    case 168 -> 45;
                    case 169 -> 122;
                    case 170 -> 184;
                    case 171 -> 8;
                    case 172 -> 124;
                    case 173 -> 26;
                    case 174 -> 18;
                    case 175 -> 137;
                    case 176 -> 165;
                    case 177 -> 89;
                    case 178 -> 105;
                    case 179 -> 130;
                    case 180 -> 58;
                    case 181 -> 206;
                    case 182 -> 51;
                    case 183 -> 210;
                    case 184 -> 141;
                    case 185 -> 28;
                    case 186 -> 138;
                    case 187 -> 221;
                    case 188 -> 19;
                    case 189 -> 20;
                    case 190 -> 114;
                    case 191 -> 223;
                    case 192 -> 123;
                    case 193 -> 17;
                    case 194 -> 171;
                    case 195 -> 111;
                    case 196 -> 163;
                    case 197 -> 42;
                    case 198 -> 207;
                    case 199 -> 180;
                    case 200 -> 154;
                    case 201 -> 179;
                    case 202 -> 237;
                    case 203 -> 209;
                    case 204 -> 229;
                    case 205 -> 150;
                    case 206 -> 13;
                    case 207 -> 95;
                    case 208 -> 84;
                    case 209 -> 46;
                    case 210 -> 239;
                    case 211 -> 107;
                    case 212 -> 57;
                    case 213 -> 182;
                    case 214 -> 87;
                    case 215 -> 120;
                    case 216 -> 1;
                    case 217 -> 64;
                    case 218 -> 220;
                    case 219 -> 11;
                    case 220 -> 118;
                    case 221 -> 243;
                    case 222 -> 76;
                    case 223 -> 34;
                    case 224 -> 69;
                    case 225 -> 104;
                    case 226 -> 110;
                    case 227 -> 251;
                    case 228 -> 80;
                    case 229 -> 230;
                    case 230 -> 201;
                    case 231 -> 32;
                    case 232 -> 22;
                    case 233 -> 189;
                    case 234 -> 170;
                    case 235 -> 249;
                    case 236 -> 244;
                    case 237 -> 73;
                    case 238 -> 147;
                    case 239 -> 190;
                    case 240 -> 35;
                    case 241 -> 15;
                    case 242 -> 40;
                    case 243 -> 164;
                    case 244 -> 175;
                    case 245 -> 23;
                    case 246 -> 215;
                    case 247 -> 188;
                    case 248 -> 117;
                    case 249 -> 0;
                    case 250 -> 192;
                    case 251 -> 39;
                    case 252 -> 199;
                    case 253 -> 177;
                    case 254 -> 14;
                    default -> 235;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

