/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleSegment;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.observable.collections.list.ObservableList;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.GeomKind;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.aes.AesScaling;
import org.jetbrains.letsPlot.core.plot.base.geom.DimensionUnit;
import org.jetbrains.letsPlot.core.plot.base.geom.DimensionsUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.WithWidth;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.HintColorUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.RectangleTooltipHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.RectanglesHelper;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgLineElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 ,2\u00020\u00012\u00020\u0002:\u0002,-B\u0005\u00a2\u0006\u0002\u0010\u0003J0\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u001e\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001f\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u001fH\u0002\u00a2\u0006\u0002\u0010$J0\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\"\u001a\u00020\u001c2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020!0(2\u0006\u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020+H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006."}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/ErrorBarGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/WithWidth;", "()V", "legendKeyElementFactory", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "widthUnit", "Lorg/jetbrains/letsPlot/core/plot/base/geom/DimensionUnit;", "getWidthUnit", "()Lorg/jetbrains/letsPlot/core/plot/base/geom/DimensionUnit;", "setWidthUnit", "(Lorg/jetbrains/letsPlot/core/plot/base/geom/DimensionUnit;)V", "buildIntern", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "rectByDataPoint", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "geomHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;", "widthOrNull", "", "p", "helper", "(Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;)Ljava/lang/Double;", "widthSpan", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "coordAes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "resolution", "isDiscrete", "", "Companion", "ErrorBarLegendKeyElementFactory", "plot-base"})
public final class ErrorBarGeom
extends GeomBase
implements WithWidth {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private DimensionUnit widthUnit = DEF_WIDTH_UNIT;
    @NotNull
    private static final DimensionUnit DEF_WIDTH_UNIT = DimensionUnit.RESOLUTION;
    public static final boolean HANDLES_GROUPS = false;

    @NotNull
    public final DimensionUnit getWidthUnit() {
        return this.widthUnit;
    }

    public final void setWidthUnit(@NotNull DimensionUnit dimensionUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)dimensionUnit), (String)"<set-?>");
        this.widthUnit = dimensionUnit;
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return new ErrorBarLegendKeyElementFactory();
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        GeomHelper geomHelper = new GeomHelper(pos, coord, ctx2);
        Function1<DataPointAesthetics, List<Color>> colorsByDataPoint = HintColorUtil.INSTANCE.createColorMarkerMapper(GeomKind.ERROR_BAR, ctx2);
        Aes[] aesArray = new Aes[]{Aes.Companion.getYMIN(), Aes.Companion.getYMAX()};
        RectangleTooltipHelper tooltipHelper2 = new RectangleTooltipHelper(pos, coord, ctx2, CollectionsKt.listOf((Object[])aesArray), null, null, colorsByDataPoint, 48, null);
        for (DataPointAesthetics p : aesthetics2.dataPoints()) {
            Double d = p.finiteOrNull(Aes.Companion.getX());
            if (d == null) {
                continue;
            }
            double x2 = d;
            Double d2 = p.finiteOrNull(Aes.Companion.getYMIN());
            if (d2 == null) {
                continue;
            }
            double ymin = d2;
            Double d3 = p.finiteOrNull(Aes.Companion.getYMAX());
            if (d3 == null) {
                continue;
            }
            double ymax = d3;
            Double d4 = this.widthOrNull(p, geomHelper);
            if (d4 == null) {
                continue;
            }
            double width2 = d4;
            double height = ymax - ymin;
            DoubleRectangle rect2 = new DoubleRectangle(x2 - width2 / (double)2, ymin, width2, height);
            List segments = ErrorBarGeom.Companion.errorBarShapeSegments(rect2);
            SvgGElement g = ErrorBarGeom.Companion.errorBarShape(segments, p, geomHelper);
            root.add(g);
        }
        RectanglesHelper hintHelper = new RectanglesHelper(aesthetics2, pos, coord, ctx2, this.rectByDataPoint(geomHelper));
        hintHelper.createRectangles((Function3<? super DataPointAesthetics, ? super SvgNode, ? super DoubleRectangle, Unit>)((Function3)new Function3<DataPointAesthetics, SvgNode, DoubleRectangle, Unit>(tooltipHelper2){
            final /* synthetic */ RectangleTooltipHelper $tooltipHelper;
            {
                this.$tooltipHelper = $tooltipHelper;
                super(3);
            }

            public final void invoke(@NotNull DataPointAesthetics aes2, @NotNull SvgNode svgNode, @NotNull DoubleRectangle rect2) {
                Intrinsics.checkNotNullParameter((Object)aes2, (String)"aes");
                Intrinsics.checkNotNullParameter((Object)svgNode, (String)"<anonymous parameter 1>");
                Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
                this.$tooltipHelper.addTarget(aes2, rect2);
            }
        }));
    }

    private final Function1<DataPointAesthetics, DoubleRectangle> rectByDataPoint(GeomHelper geomHelper) {
        return (Function1)new Function1<DataPointAesthetics, DoubleRectangle>(this, geomHelper){
            final /* synthetic */ ErrorBarGeom this$0;
            final /* synthetic */ GeomHelper $geomHelper;
            {
                this.this$0 = $receiver;
                this.$geomHelper = $geomHelper;
                super(1, Intrinsics.Kotlin.class, "factory", "rectByDataPoint$factory(Lorg/jetbrains/letsPlot/core/plot/base/geom/ErrorBarGeom;Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;)Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", 0);
            }

            @Nullable
            public final DoubleRectangle invoke(@NotNull DataPointAesthetics p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ErrorBarGeom.access$rectByDataPoint$factory(this.this$0, this.$geomHelper, p0);
            }
        };
    }

    private final Double widthOrNull(DataPointAesthetics p, GeomHelper helper2) {
        Double d = p.finiteOrNull(Aes.Companion.getWIDTH());
        if (d == null) {
            return null;
        }
        double width2 = d;
        return width2 * helper2.getUnitResolution(this.widthUnit, Aes.Companion.getX());
    }

    @Override
    @Nullable
    public DoubleSpan widthSpan(@NotNull DataPointAesthetics p, @NotNull Aes<Double> coordAes, double resolution, boolean isDiscrete) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter(coordAes, (String)"coordAes");
        return DimensionsUtil.INSTANCE.dimensionSpan(p, coordAes, Aes.Companion.getWIDTH(), resolution, this.widthUnit);
    }

    private static final DoubleRectangle rectByDataPoint$factory(ErrorBarGeom this$0, GeomHelper $geomHelper, DataPointAesthetics p) {
        Double d = p.finiteOrNull(Aes.Companion.getX());
        if (d == null) {
            return null;
        }
        double x2 = d;
        Double d2 = p.finiteOrNull(Aes.Companion.getYMIN());
        if (d2 == null) {
            return null;
        }
        double ymin = d2;
        Double d3 = p.finiteOrNull(Aes.Companion.getYMAX());
        if (d3 == null) {
            return null;
        }
        double ymax = d3;
        Double d4 = this$0.widthOrNull(p, $geomHelper);
        if (d4 == null) {
            return null;
        }
        double width2 = d4;
        double height = ymax - ymin;
        return new DoubleRectangle(x2 - width2 / 2.0, ymax - height / 2.0, width2, 0.0);
    }

    public static final /* synthetic */ DoubleRectangle access$rectByDataPoint$factory(ErrorBarGeom this$0, GeomHelper $geomHelper, DataPointAesthetics p) {
        return ErrorBarGeom.rectByDataPoint$factory(this$0, $geomHelper, p);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0002J&\u0010\u000e\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/ErrorBarGeom$Companion;", "", "()V", "DEF_WIDTH_UNIT", "Lorg/jetbrains/letsPlot/core/plot/base/geom/DimensionUnit;", "HANDLES_GROUPS", "", "errorBarLegendShape", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgGElement;", "segments", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleSegment;", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "errorBarShape", "geomHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;", "errorBarShapeSegments", "r", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "plot-base"})
    @SourceDebugExtension(value={"SMAP\nErrorBarGeom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ErrorBarGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/ErrorBarGeom$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,153:1\n1855#2,2:154\n1855#2,2:156\n*S KotlinDebug\n*F\n+ 1 ErrorBarGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/ErrorBarGeom$Companion\n*L\n115#1:154,2\n142#1:156,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final SvgGElement errorBarLegendShape(List<DoubleSegment> segments, DataPointAesthetics p) {
            SvgGElement g = new SvgGElement();
            Iterable $this$forEach$iv = segments;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DoubleSegment segment2 = (DoubleSegment)element$iv;
                boolean bl = false;
                SvgLineElement shapeLine = new SvgLineElement(segment2.getStart().getX(), segment2.getStart().getY(), segment2.getEnd().getX(), segment2.getEnd().getY());
                GeomHelper.Companion.decorate$default(GeomHelper.Companion, shapeLine, p, false, null, false, 28, null);
                g.children().add(shapeLine);
            }
            return g;
        }

        private final List<DoubleSegment> errorBarShapeSegments(DoubleRectangle r) {
            double center = r.getLeft() + r.getWidth() / (double)2;
            DoubleRectangle $this$errorBarShapeSegments_u24lambda_u241 = r;
            boolean bl = false;
            Object[] objectArray = new DoubleSegment[]{new DoubleSegment(new DoubleVector($this$errorBarShapeSegments_u24lambda_u241.getLeft(), $this$errorBarShapeSegments_u24lambda_u241.getTop()), new DoubleVector($this$errorBarShapeSegments_u24lambda_u241.getRight(), $this$errorBarShapeSegments_u24lambda_u241.getTop())), new DoubleSegment(new DoubleVector($this$errorBarShapeSegments_u24lambda_u241.getLeft(), $this$errorBarShapeSegments_u24lambda_u241.getBottom()), new DoubleVector($this$errorBarShapeSegments_u24lambda_u241.getRight(), $this$errorBarShapeSegments_u24lambda_u241.getBottom())), new DoubleSegment(new DoubleVector(center, $this$errorBarShapeSegments_u24lambda_u241.getTop()), new DoubleVector(center, $this$errorBarShapeSegments_u24lambda_u241.getBottom()))};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        private final SvgGElement errorBarShape(List<DoubleSegment> segments, DataPointAesthetics p, GeomHelper geomHelper) {
            SvgGElement g = new SvgGElement();
            GeomHelper.SvgElementHelper elementHelper = geomHelper.createSvgElementHelper();
            elementHelper.setStrokeAlphaEnabled(true);
            Iterable $this$forEach$iv = segments;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DoubleSegment segment2 = (DoubleSegment)element$iv;
                boolean bl = false;
                ObservableList<SvgNode> observableList = g.children();
                Pair pair2 = GeomHelper.SvgElementHelper.createLine$default(elementHelper, segment2.getStart(), segment2.getEnd(), p, null, 8, null);
                Intrinsics.checkNotNull((Object)pair2);
                observableList.add(pair2.getFirst());
            }
            return g;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/ErrorBarGeom$ErrorBarLegendKeyElementFactory;", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "()V", "createKeyElement", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgGElement;", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "size", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "plot-base"})
    public static final class ErrorBarLegendKeyElementFactory
    implements LegendKeyElementFactory {
        @Override
        @NotNull
        public SvgGElement createKeyElement(@NotNull DataPointAesthetics p, @NotNull DoubleVector size2) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
            double strokeWidth = AesScaling.INSTANCE.strokeWidth(p);
            Double d = p.width();
            Intrinsics.checkNotNull((Object)d);
            double width2 = d * (size2.getX() - strokeWidth);
            double height = size2.getY() - strokeWidth;
            double x2 = (size2.getX() - width2) / (double)2;
            double y2 = strokeWidth / (double)2;
            return Companion.errorBarLegendShape(Companion.errorBarShapeSegments(new DoubleRectangle(x2, y2, width2, height)), p);
        }

        @Override
        @NotNull
        public DoubleVector minimumKeySize(@NotNull DataPointAesthetics p) {
            return LegendKeyElementFactory.DefaultImpls.minimumKeySize(this, p);
        }
    }
}

