/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.util;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.AttributeInputStream;
import com.intellij.openapi.vfs.newvfs.AttributeOutputStream;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.plugins.watcher.BackgroundTaskBundle;
import com.intellij.plugins.watcher.config.FileDependencyFinder;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TaskUtils {
    private static final FileAttribute CREATED_BY_ATTRIBUTE = new FileAttribute("file.watcher", 1, false);
    private static final Key<Pair<String, String>> CREATED_BY_CACHE = Key.create((String)"CREATED_BY_CACHE");
    public static final FileType FAKE_ANY_FILE_TYPE = new FileType(){

        @NotNull
        public String getName() {
            return "Any";
        }

        @NotNull
        public String getDescription() {
            String string = BackgroundTaskBundle.message("filetype.file.watcher.dialog.any.description", new Object[0]);
            if (string == null) {
                1.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getDefaultExtension() {
            return "*";
        }

        public Icon getIcon() {
            return AllIcons.FileTypes.Any_type;
        }

        public boolean isBinary() {
            return false;
        }

        public boolean isReadOnly() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/watcher/util/TaskUtils$1", "getDescription"));
        }
    };

    public static boolean isGenerated(@Nullable VirtualFile file) {
        return !StringUtil.isEmpty((String)TaskUtils.extractCreatedTaskName(file));
    }

    @Nullable
    public static String extractCreatedTaskName(@Nullable VirtualFile file) {
        Pair<String, String> taskInfo = TaskUtils.extractTaskInfo(file);
        return (String)Pair.getFirst(taskInfo);
    }

    @Nullable
    public static Pair<String, String> extractTaskInfo(@Nullable VirtualFile file) {
        if (!(file instanceof NewVirtualFile) || !file.isValid()) {
            return null;
        }
        Pair<String, String> result = (Pair<String, String>)file.getUserData(CREATED_BY_CACHE);
        if (result == null) {
            result = TaskUtils.readTaskInfo(file);
            file.putUserData(CREATED_BY_CACHE, result);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static Pair<String, String> readTaskInfo(@NotNull VirtualFile file) {
        if (file == null) {
            TaskUtils.$$$reportNull$$$0(0);
        }
        try (AttributeInputStream inputStream = CREATED_BY_ATTRIBUTE.readFileAttribute(file);){
            if (inputStream == null) {
                Pair<String, String> pair2 = null;
                return pair2;
            }
            String watcherName = inputStream.readUTF();
            String originalFileName = inputStream.readUTF();
            Pair pair = StringUtil.isEmpty((String)watcherName) ? null : Pair.create((Object)watcherName, (Object)originalFileName);
            return pair;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void saveOutputFileInfo(@NotNull VirtualFile outputFile, @Nullable String watcherName, @NotNull VirtualFile sourceFile) {
        if (outputFile == null) {
            TaskUtils.$$$reportNull$$$0(1);
        }
        if (sourceFile == null) {
            TaskUtils.$$$reportNull$$$0(2);
        }
        if (!(outputFile instanceof NewVirtualFile)) {
            return;
        }
        if (sourceFile.equals(outputFile)) {
            return;
        }
        boolean sameParent = sourceFile.getParent() != null && sourceFile.getParent().equals(outputFile.getParent());
        String sourceFileName = sameParent ? sourceFile.getName() : null;
        try (AttributeOutputStream outputStream = CREATED_BY_ATTRIBUTE.writeFileAttribute(outputFile);){
            outputStream.writeUTF(StringUtil.notNullize((String)watcherName));
            outputStream.writeUTF(StringUtil.notNullize((String)sourceFileName));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        outputFile.putUserData(CREATED_BY_CACHE, (Object)Pair.create((Object)watcherName, (Object)sourceFileName));
    }

    @NotNull
    public static DataContext getContext(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            TaskUtils.$$$reportNull$$$0(3);
        }
        DataContext dataContext = SimpleDataContext.builder().add(CommonDataKeys.PROJECT, (Object)project).add(PlatformCoreDataKeys.PROJECT_FILE_DIRECTORY, (Object)project.getBaseDir()).add(CommonDataKeys.VIRTUAL_FILE, (Object)file).build();
        if (dataContext == null) {
            TaskUtils.$$$reportNull$$$0(4);
        }
        return dataContext;
    }

    public static String getPathByRelativePath(String basePath, String relativePath, String separator) {
        ArrayList<String> path = new ArrayList<String>(Arrays.asList(basePath.split(separator)));
        for (String step : relativePath.split(separator)) {
            if ("..".equals(step)) {
                if (path.isEmpty()) {
                    return null;
                }
                path.remove(path.size() - 1);
                continue;
            }
            path.add(step);
        }
        return String.join((CharSequence)separator, path);
    }

    public static String getPresentableNames(List<? extends TaskOptions> tasks) {
        return Arrays.toString(ContainerUtil.map(tasks, TaskOptions::getName).toArray());
    }

    @NotNull
    public static List<VirtualFile> findRoots(VirtualFile file, @NotNull Project project, TaskOptions option) {
        if (project == null) {
            TaskUtils.$$$reportNull$$$0(5);
        }
        ArrayList result = new ArrayList();
        ApplicationManager.getApplication().runReadAction(() -> {
            GlobalSearchScope scope = option.getFileScope(project);
            String extension = file.getExtension();
            boolean trackOnlyRoots = option.isTrackOnlyRoot();
            for (FileDependencyFinder dependencyFinder : (FileDependencyFinder[])FileDependencyFinder.EP_NAME.getExtensions()) {
                if (!dependencyFinder.accept(extension) || !trackOnlyRoots && !dependencyFinder.trackAllDependentFiles()) continue;
                List<VirtualFile> files = TaskUtils.findDependentFiles(project, file, dependencyFinder, scope, trackOnlyRoots);
                result.addAll(files);
            }
        });
        List<Object> list = result.isEmpty() ? Collections.singletonList(file) : result;
        if (list == null) {
            TaskUtils.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    public static FileDependencyFinder findDependencyFinderForExtension(@Nullable String extension) {
        for (FileDependencyFinder dependencyFinder : (FileDependencyFinder[])FileDependencyFinder.EP_NAME.getExtensions()) {
            if (!dependencyFinder.accept(extension)) continue;
            return dependencyFinder;
        }
        return null;
    }

    @NotNull
    private static List<VirtualFile> findDependentFiles(@NotNull Project project, @NotNull VirtualFile file, @NotNull FileDependencyFinder finder, @NotNull GlobalSearchScope scope, boolean trackOnlyRoots) {
        if (project == null) {
            TaskUtils.$$$reportNull$$$0(7);
        }
        if (file == null) {
            TaskUtils.$$$reportNull$$$0(8);
        }
        if (finder == null) {
            TaskUtils.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            TaskUtils.$$$reportNull$$$0(10);
        }
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
        HashSet<VirtualFile> visited = new HashSet<VirtualFile>();
        LinkedList<VirtualFile> queue = new LinkedList<VirtualFile>();
        queue.add(file);
        while (!queue.isEmpty()) {
            VirtualFile currentFile = (VirtualFile)queue.removeFirst();
            if (!visited.add(currentFile)) continue;
            Set<VirtualFile> dependentFiles = finder.findDependentFiles(project, currentFile, scope);
            if (dependentFiles.isEmpty()) {
                roots.add(currentFile);
                continue;
            }
            queue.addAll(dependentFiles);
        }
        return trackOnlyRoots ? roots : new ArrayList<VirtualFile>(visited);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/plugins/watcher/util/TaskUtils";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finder";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/plugins/watcher/util/TaskUtils";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readTaskInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "saveOutputFileInfo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getContext";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findRoots";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findDependentFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6 -> new IllegalStateException(string);
        };
    }
}

