/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysql.plan;

import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dialects.base.plan.RawPlanData;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.openapi.util.text.StringUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MysqlTreeRawPlanData
extends RawPlanData {
    public final List<String> rows = new ArrayList<String>();
    public final IntList indents = new IntArrayList();

    public void load(@NotNull DatabaseConnectionCore connection, final @NotNull String statement, final boolean run) {
        if (connection == null) {
            MysqlTreeRawPlanData.$$$reportNull$$$0(0);
        }
        if (statement == null) {
            MysqlTreeRawPlanData.$$$reportNull$$$0(1);
        }
        MysqlTreeRawPlanData.useStatementWithPreserved((DatabaseConnectionCore)connection, (RawPlanData.ResourceUser)new RawPlanData.ResourceUser<ReusableSmartStatement<String>>(){

            public void use(ReusableSmartStatement<String> s) throws PlanRetrievalException, SQLException {
                String tree = (String)s.noisy().execute((Object)("EXPLAIN " + (run ? "ANALYZE " : "FORMAT=TREE ") + statement), StandardResultsProcessors.firstString((int)1));
                MysqlTreeRawPlanData.this.load(tree);
            }
        }, (RawPlanData.StateSaver[])new RawPlanData.StateSaver[0]);
    }

    public void load(@NotNull String dump) {
        if (dump == null) {
            MysqlTreeRawPlanData.$$$reportNull$$$0(2);
        }
        this.rows.clear();
        this.rows.addAll(StringUtil.split((String)dump, (String)"\n"));
        this.indents.clear();
        for (String row : this.rows) {
            this.indents.add(row.indexOf(45));
        }
    }

    public String dump() {
        return StringUtil.join(this.rows, (String)"\n");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "connection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "statement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "dump";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dialects/mysql/plan/MysqlTreeRawPlanData";
        objectArray[2] = "load";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

