/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ChangeListScheduler;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateCallback;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.util.concurrency.Semaphore;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class UpdateRequestsQueue {
    private static final Logger LOG = Logger.getInstance(UpdateRequestsQueue.class);
    private final Project myProject;
    private final ChangeListScheduler myScheduler;
    private final BooleanSupplier myRefreshDelegate;
    private final BooleanSupplier myFastTrackDelegate;
    private final Object myLock;
    private volatile boolean myStarted;
    private volatile boolean myStopped;
    private volatile boolean myIgnoreBackgroundOperation;
    private boolean myRequestSubmitted;
    private boolean myRequestRunning;
    private final List<Runnable> myWaitingUpdateCompletionQueue;
    private final List<Semaphore> myWaitingUpdateCompletionSemaphores;

    public UpdateRequestsQueue(@NotNull Project project, @NotNull ChangeListScheduler scheduler, @NotNull BooleanSupplier refreshDelegate, @NotNull BooleanSupplier fastTrackDelegate) {
        if (project == null) {
            UpdateRequestsQueue.$$$reportNull$$$0(0);
        }
        if (scheduler == null) {
            UpdateRequestsQueue.$$$reportNull$$$0(1);
        }
        if (refreshDelegate == null) {
            UpdateRequestsQueue.$$$reportNull$$$0(2);
        }
        if (fastTrackDelegate == null) {
            UpdateRequestsQueue.$$$reportNull$$$0(3);
        }
        this.myLock = new Object();
        this.myWaitingUpdateCompletionQueue = new ArrayList<Runnable>();
        this.myWaitingUpdateCompletionSemaphores = new ArrayList<Semaphore>();
        this.myProject = project;
        this.myScheduler = scheduler;
        this.myRefreshDelegate = refreshDelegate;
        this.myFastTrackDelegate = fastTrackDelegate;
        this.myStarted = false;
        this.myStopped = false;
    }

    public void initialized() {
        this.debug("Initialized");
        this.myStarted = true;
    }

    public boolean isStopped() {
        return this.myStopped;
    }

    public void schedule() {
        this.schedule(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(boolean withFastTrack) {
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myStarted && ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error("Update was scheduled, but queue wasn't initialized", new Throwable());
            }
            if (this.myStopped) {
                return;
            }
            if (this.myRequestSubmitted) {
                return;
            }
            this.myRequestSubmitted = true;
            if (withFastTrack) {
                FastTrackRunnable fastRunnable = new FastTrackRunnable();
                this.myScheduler.submit(fastRunnable);
                this.debug("Scheduled fast-track", fastRunnable);
            }
            RefreshRunnable runnable = new RefreshRunnable();
            this.myScheduler.schedule(runnable, 300L, TimeUnit.MILLISECONDS);
            this.debug("Scheduled", runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.myLock;
        synchronized (object) {
            this.myStopped = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public void forceGo() {
        Object object = this.myLock;
        synchronized (object) {
            this.myStopped = false;
            this.myRequestSubmitted = false;
            this.myRequestRunning = false;
        }
        this.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void go() {
        Object object = this.myLock;
        synchronized (object) {
            this.myStopped = false;
        }
        this.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        ArrayList<Runnable> waiters;
        this.debug("Stop called");
        Object object = this.myLock;
        synchronized (object) {
            this.myStopped = true;
            waiters = new ArrayList<Runnable>(this.myWaitingUpdateCompletionQueue);
            this.myWaitingUpdateCompletionQueue.clear();
        }
        this.debug("Stop - calling runnables");
        UpdateRequestsQueue.runWaiters(waiters);
        this.debug("Stop - finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public void waitUntilRefreshed() {
        Semaphore semaphore;
        do {
            semaphore = new Semaphore();
            Object object = this.myLock;
            synchronized (object) {
                if (!this.myRequestSubmitted && !this.myRequestRunning) {
                    return;
                }
                if (!this.myRequestRunning) {
                    this.myScheduler.submit(new RefreshRunnable());
                }
                semaphore.down();
                this.myWaitingUpdateCompletionSemaphores.add(semaphore);
            }
        } while (semaphore.waitFor(100000L));
        LOG.error("Too long VCS update\n" + ThreadDumper.dumpThreadsToString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeSemaphores() {
        Object object = this.myLock;
        synchronized (object) {
            for (Semaphore semaphore : this.myWaitingUpdateCompletionSemaphores) {
                semaphore.up();
            }
            this.myWaitingUpdateCompletionSemaphores.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAfterUpdate(@NotNull Runnable afterUpdate, @NotNull InvokeAfterUpdateMode mode, @Nullable @Nls String title) {
        boolean stopped;
        if (afterUpdate == null) {
            UpdateRequestsQueue.$$$reportNull$$$0(4);
        }
        if (mode == null) {
            UpdateRequestsQueue.$$$reportNull$$$0(5);
        }
        this.debug("invokeAfterUpdate called");
        InvokeAfterUpdateCallback.Callback callback = InvokeAfterUpdateCallback.create(this.myProject, mode, afterUpdate, title);
        Object object = this.myLock;
        synchronized (object) {
            stopped = this.myStopped;
            if (!stopped) {
                this.myWaitingUpdateCompletionQueue.add(callback::endProgress);
                this.schedule(true);
            }
        }
        if (stopped) {
            this.debug("invokeAfterUpdate: stopped, invoke right now");
            callback.handleStoppedQueue();
        } else {
            callback.startProgress();
            this.debug("invokeAfterUpdate: start progress");
        }
    }

    private boolean checkHeavyOperations() {
        return !this.myIgnoreBackgroundOperation && ProjectLevelVcsManager.getInstance((Project)this.myProject).isBackgroundVcsOperationRunning();
    }

    private boolean checkLifeCycle() {
        return !this.myStarted || !StartupManagerEx.getInstanceEx((Project)this.myProject).startupActivityPassed();
    }

    public void setIgnoreBackgroundOperation(boolean ignoreBackgroundOperation) {
        this.myIgnoreBackgroundOperation = ignoreBackgroundOperation;
        this.debug("Ignore background operations: " + ignoreBackgroundOperation);
    }

    private void debug(@NotNull String text, @NotNull Runnable runnable) {
        if (text == null) {
            UpdateRequestsQueue.$$$reportNull$$$0(6);
        }
        if (runnable == null) {
            UpdateRequestsQueue.$$$reportNull$$$0(7);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("%s. Runnable: %s, Project: %s", text, runnable, this.myProject));
        }
    }

    private void debug(@NotNull String text) {
        if (text == null) {
            UpdateRequestsQueue.$$$reportNull$$$0(8);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("%s. Project: %s", text, this.myProject));
        }
    }

    private static void runWaiters(List<? extends Runnable> copy) {
        for (Runnable runnable : copy) {
            try {
                runnable.run();
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheduler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refreshDelegate";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fastTrackDelegate";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterUpdate";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/UpdateRequestsQueue";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeAfterUpdate";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "debug";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class FastTrackRunnable
    implements Runnable {
        private FastTrackRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<Runnable> copy;
            Object object = UpdateRequestsQueue.this.myLock;
            synchronized (object) {
                if (!UpdateRequestsQueue.this.myRequestSubmitted) {
                    return;
                }
                UpdateRequestsQueue.this.myRequestSubmitted = false;
                LOG.assertTrue(!UpdateRequestsQueue.this.myRequestRunning);
                if (UpdateRequestsQueue.this.myStopped) {
                    UpdateRequestsQueue.this.debug("Stopped", this);
                    return;
                }
                copy = new ArrayList<Runnable>(UpdateRequestsQueue.this.myWaitingUpdateCompletionQueue);
                UpdateRequestsQueue.this.myWaitingUpdateCompletionQueue.clear();
            }
            UpdateRequestsQueue.this.debug("Before callback", this);
            boolean nothingToUpdate = false;
            try {
                nothingToUpdate = UpdateRequestsQueue.this.myFastTrackDelegate.getAsBoolean();
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Throwable e) {
                LOG.error(e);
            }
            UpdateRequestsQueue.this.debug("After callback", this);
            if (nothingToUpdate) {
                UpdateRequestsQueue.runWaiters(copy);
                UpdateRequestsQueue.this.debug("Runnables executed", this);
            } else {
                UpdateRequestsQueue.this.debug("Restoring runnables", this);
                Object object2 = UpdateRequestsQueue.this.myLock;
                synchronized (object2) {
                    UpdateRequestsQueue.this.myRequestSubmitted = true;
                    UpdateRequestsQueue.this.myWaitingUpdateCompletionQueue.addAll(0, copy);
                }
            }
        }

        public String toString() {
            return "CLM Refresh Fast-Track runnable@" + this.hashCode();
        }
    }

    private final class RefreshRunnable
    implements Runnable {
        private RefreshRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            ArrayList<Runnable> copy;
            block26: {
                copy = new ArrayList<Runnable>();
                Object object = UpdateRequestsQueue.this.myLock;
                // MONITORENTER : object
                if (UpdateRequestsQueue.this.myRequestSubmitted) break block26;
                // MONITOREXIT : object
                Object object2 = UpdateRequestsQueue.this.myLock;
                UpdateRequestsQueue.this.debug("Finally", this);
                UpdateRequestsQueue.this.myRequestRunning = false;
                if (!(UpdateRequestsQueue.this.myWaitingUpdateCompletionQueue.isEmpty() || UpdateRequestsQueue.this.myRequestSubmitted || UpdateRequestsQueue.this.myStopped)) {
                    LOG.error("No update task to handle request(s)");
                }
                // MONITOREXIT : object2
                UpdateRequestsQueue.runWaiters(copy);
                UpdateRequestsQueue.this.freeSemaphores();
                UpdateRequestsQueue.this.debug("Runnables executed", this);
                return;
            }
            UpdateRequestsQueue.this.myRequestSubmitted = false;
            LOG.assertTrue(!UpdateRequestsQueue.this.myRequestRunning);
            UpdateRequestsQueue.this.myRequestRunning = true;
            if (UpdateRequestsQueue.this.myStopped) {
                UpdateRequestsQueue.this.debug("Stopped", this);
                // MONITOREXIT : object
                Object object = UpdateRequestsQueue.this.myLock;
                // MONITORENTER : object
                UpdateRequestsQueue.this.debug("Finally", this);
                UpdateRequestsQueue.this.myRequestRunning = false;
                if (!(UpdateRequestsQueue.this.myWaitingUpdateCompletionQueue.isEmpty() || UpdateRequestsQueue.this.myRequestSubmitted || UpdateRequestsQueue.this.myStopped)) {
                    LOG.error("No update task to handle request(s)");
                }
                // MONITOREXIT : object
                UpdateRequestsQueue.runWaiters(copy);
                UpdateRequestsQueue.this.freeSemaphores();
                UpdateRequestsQueue.this.debug("Runnables executed", this);
                return;
            }
            if (UpdateRequestsQueue.this.checkLifeCycle() || UpdateRequestsQueue.this.checkHeavyOperations()) {
                UpdateRequestsQueue.this.debug("Reschedule", this);
                UpdateRequestsQueue.this.schedule();
                // MONITOREXIT : object
                Object object = UpdateRequestsQueue.this.myLock;
                // MONITORENTER : object
                UpdateRequestsQueue.this.debug("Finally", this);
                UpdateRequestsQueue.this.myRequestRunning = false;
                if (!(UpdateRequestsQueue.this.myWaitingUpdateCompletionQueue.isEmpty() || UpdateRequestsQueue.this.myRequestSubmitted || UpdateRequestsQueue.this.myStopped)) {
                    LOG.error("No update task to handle request(s)");
                }
                // MONITOREXIT : object
                UpdateRequestsQueue.runWaiters(copy);
                UpdateRequestsQueue.this.freeSemaphores();
                UpdateRequestsQueue.this.debug("Runnables executed", this);
                return;
            }
            try {
                copy.addAll(UpdateRequestsQueue.this.myWaitingUpdateCompletionQueue);
                UpdateRequestsQueue.this.myWaitingUpdateCompletionQueue.clear();
                // MONITOREXIT : object
                UpdateRequestsQueue.this.debug("Before callback", this);
                boolean success = UpdateRequestsQueue.this.myRefreshDelegate.getAsBoolean();
                UpdateRequestsQueue.this.debug("After callback, was success: " + success, this);
                if (success) return;
                UpdateRequestsQueue.this.debug("Restoring runnables", this);
                Object object = UpdateRequestsQueue.this.myLock;
                // MONITORENTER : object
                UpdateRequestsQueue.this.myWaitingUpdateCompletionQueue.addAll(0, copy);
                copy.clear();
                // MONITOREXIT : object
                return;
            }
            finally {
                Object object = UpdateRequestsQueue.this.myLock;
            }
        }

        public String toString() {
            return "CLM Refresh runnable@" + this.hashCode();
        }
    }
}

