/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.containerview;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.toolbarLayout.ToolbarLayoutStrategy;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.TwoSideComponent;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyFrameListener;
import com.jetbrains.python.debugger.array.AbstractDataViewTable;
import com.jetbrains.python.debugger.array.AsyncArrayTableModel;
import com.jetbrains.python.debugger.array.JBTableWithRowHeaders;
import com.jetbrains.python.debugger.containerview.ColoredCellRenderer;
import com.jetbrains.python.debugger.containerview.DataViewStrategy;
import com.jetbrains.python.debugger.containerview.DataViewerCommandSource;
import com.jetbrains.python.debugger.containerview.PyDataView;
import com.jetbrains.python.debugger.containerview.PyDataViewerAbstractPanel;
import com.jetbrains.python.debugger.containerview.PyDataViewerCommunityPanel;
import com.jetbrains.python.debugger.containerview.PyDataViewerCompletionProvider;
import com.jetbrains.python.debugger.containerview.PyDataViewerModel;
import com.jetbrains.python.debugger.containerview.PyDataViewerPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 C2\u00020\u0001:\u0001CB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020+H\u0014J\b\u0010-\u001a\u00020\tH\u0002J\b\u0010.\u001a\u00020\u001eH\u0002J\b\u0010/\u001a\u00020+H\u0002J\b\u00100\u001a\u00020+H\u0002J\u0010\u00101\u001a\u00020+2\u0006\u0010#\u001a\u00020$H\u0002J\u001c\u00102\u001a\u00020\u00072\b\u00103\u001a\u0004\u0018\u0001042\b\u00105\u001a\u0004\u0018\u000106H\u0016J\u0010\u00107\u001a\u00020\u000b2\u0006\u00108\u001a\u000209H\u0002J(\u0010:\u001a\u00020+2\u0006\u00105\u001a\u0002062\u0006\u00103\u001a\u0002042\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u001eH\u0014J\u000e\u0010>\u001a\u00020+2\u0006\u0010?\u001a\u00020\u001eJ\u001d\u0010@\u001a\u00020+2\u000b\u0010A\u001a\u00070\u0015\u00a2\u0006\u0002\bB2\u0006\u0010=\u001a\u00020\u001eH\u0014R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R&\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00158V@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR&\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00158T@TX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0018\"\u0004\b\u001d\u0010\u001aR$\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u001e8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0016\u0010#\u001a\u0004\u0018\u00010$8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/jetbrains/python/debugger/containerview/PyDataViewerCommunityPanel;", "Lcom/jetbrains/python/debugger/containerview/PyDataViewerAbstractPanel;", "dataViewerModel", "Lcom/jetbrains/python/debugger/containerview/PyDataViewerModel;", "<init>", "(Lcom/jetbrains/python/debugger/containerview/PyDataViewerModel;)V", "table", "Lcom/jetbrains/python/debugger/array/AbstractDataViewTable;", "panelWithTable", "Ljavax/swing/JPanel;", "formatTextField", "Lcom/intellij/ui/EditorTextField;", "slicingTextField", "getSlicingTextField", "()Lcom/intellij/ui/EditorTextField;", "topToolbar", "getTopToolbar", "()Ljavax/swing/JPanel;", "setTopToolbar", "(Ljavax/swing/JPanel;)V", "value", "", "formatValueFromUI", "getFormatValueFromUI", "()Ljava/lang/String;", "setFormatValueFromUI", "(Ljava/lang/String;)V", "slicingValueFromUI", "getSlicingValueFromUI", "setSlicingValueFromUI", "", "isColoredValueFromUI", "()Z", "setColoredValueFromUI", "(Z)V", "model", "Lcom/jetbrains/python/debugger/array/AsyncArrayTableModel;", "getModel", "()Lcom/jetbrains/python/debugger/array/AsyncArrayTableModel;", "errorLabel", "Lcom/intellij/ui/dsl/builder/Cell;", "Ljavax/swing/JEditorPane;", "recreateTable", "", "setupDataProvider", "createAndSetupTopToolbar", "isVariablePresentInStack", "setupChangeListener", "updateModel", "updateDebugValue", "createTable", "originalDebugValue", "Lcom/jetbrains/python/debugger/PyDebugValue;", "chunk", "Lcom/jetbrains/python/debugger/ArrayChunk;", "createEditorField", "commandSource", "Lcom/jetbrains/python/debugger/containerview/DataViewerCommandSource;", "updateUI", "strategy", "Lcom/jetbrains/python/debugger/containerview/DataViewStrategy;", "modifier", "resize", "autoResize", "setError", "text", "Lcom/intellij/openapi/util/NlsContexts$Label;", "Companion", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPyDataViewerCommunityPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyDataViewerCommunityPanel.kt\ncom/jetbrains/python/debugger/containerview/PyDataViewerCommunityPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,285:1\n1#2:286\n1869#3,2:287\n*S KotlinDebug\n*F\n+ 1 PyDataViewerCommunityPanel.kt\ncom/jetbrains/python/debugger/containerview/PyDataViewerCommunityPanel\n*L\n139#1:287,2\n*E\n"})
public final class PyDataViewerCommunityPanel
extends PyDataViewerAbstractPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private AbstractDataViewTable table;
    @NotNull
    private final JPanel panelWithTable;
    @NotNull
    private EditorTextField formatTextField;
    @NotNull
    private final EditorTextField slicingTextField;
    @Nullable
    private JPanel topToolbar;
    @NotNull
    private String formatValueFromUI;
    @NotNull
    private String slicingValueFromUI;
    private Cell<? extends JEditorPane> errorLabel;
    @NotNull
    private static final DataKey<AbstractDataViewTable> PY_DATA_VIEWER_COMMUNITY_PANEL_KEY = DataKey.Companion.create("PY_DATA_VIEWER_COMMUNITY_PANEL_KEY");

    public PyDataViewerCommunityPanel(@NotNull PyDataViewerModel dataViewerModel) {
        Intrinsics.checkNotNullParameter((Object)dataViewerModel, (String)"dataViewerModel");
        super(dataViewerModel, false);
        this.panelWithTable = new JPanel(new BorderLayout());
        this.formatTextField = this.createEditorField(DataViewerCommandSource.FORMATTING);
        this.slicingTextField = this.createEditorField(DataViewerCommandSource.SLICING);
        this.formatValueFromUI = "";
        this.slicingValueFromUI = "";
        new PyDataViewerCompletionProvider(dataViewerModel.getFrameAccessor()).apply(this.getSlicingTextField());
        this.formatTextField.setText(dataViewerModel.getFormat());
        this.add((Component)this.panelWithTable, "Center");
        this.add((Component)BuilderKt.panel(arg_0 -> PyDataViewerCommunityPanel._init_$lambda$0(this, arg_0)), "South");
        this.setupChangeListener();
        this.setTopToolbar(this.createAndSetupTopToolbar());
    }

    @Override
    @NotNull
    public EditorTextField getSlicingTextField() {
        return this.slicingTextField;
    }

    @Override
    @Nullable
    public JPanel getTopToolbar() {
        return this.topToolbar;
    }

    @Override
    public void setTopToolbar(@Nullable JPanel jPanel) {
        this.topToolbar = jPanel;
    }

    @Override
    @NotNull
    public String getFormatValueFromUI() {
        CharSequence charSequence;
        String string = this.formatTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String format = string;
        CharSequence charSequence2 = format;
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = "%s";
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    @Override
    public void setFormatValueFromUI(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.formatValueFromUI = value;
        this.formatTextField.setText(value);
    }

    @Override
    @NotNull
    protected String getSlicingValueFromUI() {
        CharSequence charSequence;
        String string = this.getSlicingTextField().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String slicing = string;
        CharSequence charSequence2 = slicing;
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = "None";
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    @Override
    protected void setSlicingValueFromUI(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.slicingValueFromUI = value;
        this.getSlicingTextField().setText(value);
    }

    @Override
    public boolean isColoredValueFromUI() {
        return this.getDataViewerModel().getProtectedColored();
    }

    @Override
    public void setColoredValueFromUI(boolean value) {
        this.getDataViewerModel().setProtectedColored(value);
        AbstractDataViewTable table = this.table;
        if (table != null && !table.isEmpty()) {
            TableCellRenderer tableCellRenderer = table.getDefaultRenderer(table.getColumnClass(0));
            Intrinsics.checkNotNull((Object)tableCellRenderer, (String)"null cannot be cast to non-null type com.jetbrains.python.debugger.containerview.ColoredCellRenderer");
            ((ColoredCellRenderer)tableCellRenderer).setColored(value);
            table.repaint();
        }
    }

    private final AsyncArrayTableModel getModel() {
        AbstractDataViewTable abstractDataViewTable = this.table;
        TableModel tableModel = abstractDataViewTable != null ? abstractDataViewTable.getModel() : null;
        return tableModel instanceof AsyncArrayTableModel ? (AsyncArrayTableModel)tableModel : null;
    }

    @Override
    public void recreateTable() {
        this.panelWithTable.removeAll();
        this.panelWithTable.add((Component)((AbstractDataViewTable)((Object)PyDataViewerAbstractPanel.createTable$default(this, null, null, 3, null))).getScrollPane(), "Center");
    }

    @Override
    protected void setupDataProvider() {
        DataProvider toolbarDataProvider = arg_0 -> PyDataViewerCommunityPanel.setupDataProvider$lambda$0(this, arg_0);
        PyDataViewerPanel.Companion.addDataProvider(this, toolbarDataProvider);
    }

    /*
     * WARNING - void declaration
     */
    private final JPanel createAndSetupTopToolbar() {
        ActionToolbar actionToolbar;
        void $this$forEach$iv;
        DefaultActionGroup defaultActionGroup;
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup $this$createAndSetupTopToolbar_u24lambda_u240 = defaultActionGroup = new DefaultActionGroup();
        boolean bl = false;
        AnAction anAction = actionManager.getAction("ToggleDataViewColoring");
        if (anAction != null) {
            AnAction it = anAction;
            boolean bl2 = false;
            $this$createAndSetupTopToolbar_u24lambda_u240.add(it);
        }
        DefaultActionGroup leftActionGroup = defaultActionGroup;
        ActionToolbar $this$createAndSetupTopToolbar_u24lambda_u241 = bl = actionManager.createActionToolbar("PyDataView", (ActionGroup)leftActionGroup, true);
        boolean bl3 = false;
        $this$createAndSetupTopToolbar_u24lambda_u241.setTargetComponent((JComponent)this.panelWithTable);
        ActionToolbar actionToolbar2 = bl;
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar2, (String)"apply(...)");
        ActionToolbar leftActionToolbar = actionToolbar2;
        ActionToolbar $this$createAndSetupTopToolbar_u24lambda_u242 = bl = new DefaultActionGroup();
        boolean bl4 = false;
        Object object = new String[]{"OpenInEditorAction", "ExportTableAction", "SwitchBetweenTableModesAction"};
        object = CollectionsKt.listOf((Object[])object);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AnAction it;
            String actionId = (String)element$iv;
            boolean bl5 = false;
            if (actionManager.getAction(actionId) == null) continue;
            boolean bl6 = false;
            $this$createAndSetupTopToolbar_u24lambda_u242.add(it);
        }
        ActionToolbar rightActionGroup = bl;
        ActionToolbar $this$createAndSetupTopToolbar_u24lambda_u243 = actionToolbar = actionManager.createActionToolbar("PyDataView", (ActionGroup)rightActionGroup, true);
        boolean bl7 = false;
        $this$createAndSetupTopToolbar_u24lambda_u243.setLayoutStrategy(ToolbarLayoutStrategy.NOWRAP_STRATEGY);
        $this$createAndSetupTopToolbar_u24lambda_u243.setTargetComponent((JComponent)this.panelWithTable);
        ActionToolbar actionToolbar3 = actionToolbar;
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar3, (String)"apply(...)");
        ActionToolbar rightActionToolbar = actionToolbar3;
        TwoSideComponent twoSideComponent = new TwoSideComponent(leftActionToolbar.getComponent(), rightActionToolbar.getComponent());
        this.add((Component)twoSideComponent, "First");
        this.setTopToolbar((JPanel)twoSideComponent);
        return (JPanel)twoSideComponent;
    }

    private final boolean isVariablePresentInStack() {
        XValueChildrenList xValueChildrenList = this.getDataViewerModel().getFrameAccessor().loadFrame(null);
        if (xValueChildrenList == null) {
            return true;
        }
        XValueChildrenList values = xValueChildrenList;
        int n = values.size();
        for (int i = 0; i < n; ++i) {
            if (!Intrinsics.areEqual((Object)values.getValue(i), (Object)this.getDataViewerModel().getDebugValue())) continue;
            return true;
        }
        return false;
    }

    private final void setupChangeListener() {
        this.getDataViewerModel().getFrameAccessor().addFrameListener(new PyFrameListener(this){
            final /* synthetic */ PyDataViewerCommunityPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void frameChanged() {
                if (this.this$0.getDataViewerModel().getDebugValue() == null) {
                    return;
                }
                ApplicationManager.getApplication().executeOnPooledThread(() -> setupChangeListener.1.frameChanged$lambda$0(this.this$0));
            }

            private static final void frameChanged$lambda$0(PyDataViewerCommunityPanel this$0) {
                if (PyDataViewerCommunityPanel.access$isVariablePresentInStack(this$0)) {
                    PyDataViewerCommunityPanel.access$updateModel(this$0);
                }
            }
        });
    }

    private final void updateModel() {
        AsyncArrayTableModel asyncArrayTableModel = this.getModel();
        if (asyncArrayTableModel == null) {
            return;
        }
        AsyncArrayTableModel model2 = asyncArrayTableModel;
        model2.invalidateCache();
        if (this.getDataViewerModel().isModified()) {
            PyDataViewerAbstractPanel.apply$default((PyDataViewerAbstractPanel)this, this.getDataViewerModel().getModifiedVarName(), true, null, 4, null);
        } else {
            this.updateDebugValue(model2);
            ApplicationManager.getApplication().invokeLater(() -> PyDataViewerCommunityPanel.updateModel$lambda$0(this, model2));
        }
    }

    private final void updateDebugValue(AsyncArrayTableModel model2) {
        PyDebugValue oldValue = model2.getDebugValue();
        if (oldValue != null && !oldValue.isTemporary() || ((CharSequence)this.getSlicingValueFromUI()).length() == 0) {
            return;
        }
        PyDebugValue newValue = this.getDebugValue(this.getSlicingValueFromUI(), false);
        if (newValue != null) {
            model2.setDebugValue(newValue);
        }
    }

    @NotNull
    public AbstractDataViewTable createTable(@Nullable PyDebugValue originalDebugValue, @Nullable ArrayChunk chunk) {
        JPanel jPanel;
        JBTableWithRowHeaders mainTable = new JBTableWithRowHeaders(PyDataView.Companion.isAutoResizeEnabled(this.getDataViewerModel().getProject()));
        mainTable.getScrollPane().setBorder(BorderFactory.createEmptyBorder());
        JPanel $this$createTable_u24lambda_u240 = jPanel = this.panelWithTable;
        boolean bl = false;
        $this$createTable_u24lambda_u240.add((Component)mainTable.getScrollPane(), "Center");
        $this$createTable_u24lambda_u240.revalidate();
        $this$createTable_u24lambda_u240.repaint();
        this.table = mainTable;
        return mainTable;
    }

    private final EditorTextField createEditorField(DataViewerCommandSource commandSource) {
        Document document = EditorFactory.getInstance().createDocument((CharSequence)"");
        Project project = this.getDataViewerModel().getProject();
        PythonFileType pythonFileType = PythonFileType.INSTANCE;
        return new EditorTextField(this, commandSource, document, project, pythonFileType){
            final /* synthetic */ PyDataViewerCommunityPanel this$0;
            final /* synthetic */ DataViewerCommandSource $commandSource;
            {
                this.this$0 = $receiver;
                this.$commandSource = $commandSource;
                super($super_call_param$1, $super_call_param$2, (FileType)$super_call_param$3, false, true);
            }

            protected EditorEx createEditor() {
                EditorEx editorEx = super.createEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"createEditor(...)");
                EditorEx editor2 = editorEx;
                editor2.getSettings().setAdditionalColumnsCount(5);
                editor2.getContentComponent().addKeyListener(new KeyAdapter(this.this$0, this.$commandSource){
                    final /* synthetic */ PyDataViewerCommunityPanel this$0;
                    final /* synthetic */ DataViewerCommandSource $commandSource;
                    {
                        this.this$0 = $receiver;
                        this.$commandSource = $commandSource;
                    }

                    public void keyPressed(KeyEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        if (e.getKeyCode() == 10) {
                            this.this$0.onEnterPressed(this.$commandSource);
                        }
                    }
                });
                return editor2;
            }
        };
    }

    @Override
    protected void updateUI(@NotNull ArrayChunk chunk, @NotNull PyDebugValue originalDebugValue, @NotNull DataViewStrategy strategy, boolean modifier) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)originalDebugValue, (String)"originalDebugValue");
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        Cell<? extends JEditorPane> cell = this.errorLabel;
        if (cell == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"errorLabel");
            cell = null;
        }
        cell.visible(false);
        PyDebugValue debugValue = chunk.getValue();
        AsyncArrayTableModel model2 = strategy.createTableModel(chunk.getRows(), chunk.getColumns(), this, debugValue);
        model2.addToCache(chunk);
        UIUtil.invokeLaterIfNeeded(() -> PyDataViewerCommunityPanel.updateUI$lambda$0(this, model2, modifier, chunk, originalDebugValue, strategy));
    }

    public final void resize(boolean autoResize) {
        AbstractDataViewTable abstractDataViewTable = this.table;
        if (abstractDataViewTable != null) {
            abstractDataViewTable.setAutoResize(autoResize);
        }
        PyDataViewerAbstractPanel.apply$default((PyDataViewerAbstractPanel)this, this.getSlicingValueFromUI(), false, null, 4, null);
    }

    @Override
    protected void setError(@NotNull String text, boolean modifier) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Cell<? extends JEditorPane> cell = this.errorLabel;
        if (cell == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"errorLabel");
            cell = null;
        }
        cell.visible(true);
        Cell<? extends JEditorPane> cell2 = this.errorLabel;
        if (cell2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"errorLabel");
            cell2 = null;
        }
        TextFieldKt.text(cell2, (String)this.composeErrorMessage(text, modifier));
        if (!modifier) {
            AbstractDataViewTable abstractDataViewTable = this.table;
            if (abstractDataViewTable != null) {
                abstractDataViewTable.setEmpty();
            }
            Iterator<PyDataViewerAbstractPanel.OnNameChangedListener> iterator = this.getListeners().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<PyDataViewerAbstractPanel.OnNameChangedListener> iterator2 = iterator;
            while (iterator2.hasNext()) {
                PyDataViewerAbstractPanel.OnNameChangedListener listener2 = iterator2.next();
                String string = PyBundle.message("debugger.data.view.empty.tab", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                listener2.onNameChanged(string);
            }
        }
    }

    private static final Unit _init_$lambda$0(PyDataViewerCommunityPanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PyDataViewerCommunityPanel.lambda$0$0(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PyDataViewerCommunityPanel.lambda$0$1(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0(PyDataViewerCommunityPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.getSlicingTextField()).align((Align)AlignX.FILL.INSTANCE).resizableColumn();
        String string = PyBundle.message("form.data.viewer.format", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string);
        $this$row.cell((JComponent)this$0.formatTextField);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit lambda$0$1(PyDataViewerCommunityPanel this$0, Row $this$row) {
        void $this$lambda_u240_u241_u240;
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell cell2 = cell = Row.text$default((Row)$this$row, (String)"", (int)0, null, (int)6, null);
        PyDataViewerCommunityPanel pyDataViewerCommunityPanel = this$0;
        boolean bl = false;
        ((JEditorPane)$this$lambda_u240_u241_u240.getComponent()).setForeground((Color)JBColor.RED);
        pyDataViewerCommunityPanel.errorLabel = cell;
        return Unit.INSTANCE;
    }

    private static final Object setupDataProvider$lambda$0(PyDataViewerCommunityPanel this$0, String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return PY_DATA_VIEWER_COMMUNITY_PANEL_KEY.is(dataId) ? this$0.table : null;
    }

    private static final void updateModel$lambda$0(PyDataViewerCommunityPanel this$0, AsyncArrayTableModel $model) {
        if (this$0.isShowing()) {
            $model.fireTableDataChanged();
        }
    }

    private static final void updateUI$lambda$0(PyDataViewerCommunityPanel this$0, AsyncArrayTableModel $model, boolean $modifier, ArrayChunk $chunk, PyDebugValue $originalDebugValue, DataViewStrategy $strategy) {
        AbstractDataViewTable abstractDataViewTable = this$0.table;
        if (abstractDataViewTable == null) {
            abstractDataViewTable = (AbstractDataViewTable)((Object)PyDataViewerAbstractPanel.createTable$default(this$0, null, null, 3, null));
        }
        AbstractDataViewTable table = abstractDataViewTable;
        table.setModel($model, $modifier);
        this$0.updateTabNameSlicingFieldAndFormatField($chunk, $originalDebugValue, $modifier);
        ColoredCellRenderer cellRenderer = $strategy.createCellRenderer(Double.MIN_VALUE, Double.MAX_VALUE, $chunk);
        cellRenderer.setColored(this$0.getDataViewerModel().getProtectedColored());
        $model.fireTableDataChanged();
        $model.fireTableCellUpdated(0, 0);
        if (table.getColumnCount() > 0) {
            table.setDefaultRenderer(table.getColumnClass(0), cellRenderer);
        }
        table.setShowColumns($strategy.showColumnHeader());
    }

    public static final /* synthetic */ boolean access$isVariablePresentInStack(PyDataViewerCommunityPanel $this) {
        return $this.isVariablePresentInStack();
    }

    public static final /* synthetic */ void access$updateModel(PyDataViewerCommunityPanel $this) {
        $this.updateModel();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/python/debugger/containerview/PyDataViewerCommunityPanel$Companion;", "", "<init>", "()V", "PY_DATA_VIEWER_COMMUNITY_PANEL_KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/jetbrains/python/debugger/array/AbstractDataViewTable;", "getPY_DATA_VIEWER_COMMUNITY_PANEL_KEY", "()Lcom/intellij/openapi/actionSystem/DataKey;", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<AbstractDataViewTable> getPY_DATA_VIEWER_COMMUNITY_PANEL_KEY() {
            return PY_DATA_VIEWER_COMMUNITY_PANEL_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

