/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.jupyterConsole.actions;

import com.intellij.codeWithMe.ClientId;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.executor.JupyterExecutionManager;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.helper.JupyterAnActionEventExtensionsKt;
import com.intellij.jupyter.py.jupyterConsole.JupyterConsoleService;
import com.intellij.jupyter.py.jupyterConsole.JupyterConsoleView;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/jupyter/py/jupyterConsole/actions/JupyterConsoleShowAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "service", "Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsoleService;", "update", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterConsoleShowAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterConsoleShowAction.kt\ncom/intellij/jupyter/py/jupyterConsole/actions/JupyterConsoleShowAction\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,37:1\n42#2,3:38\n*S KotlinDebug\n*F\n+ 1 JupyterConsoleShowAction.kt\ncom/intellij/jupyter/py/jupyterConsole/actions/JupyterConsoleShowAction\n*L\n13#1:38,3\n*E\n"})
public final class JupyterConsoleShowAction
extends DumbAwareAction {
    @NotNull
    private final JupyterConsoleService service;

    private JupyterConsoleShowAction() {
        super(JupyterBundle.message((String)"action.open.JupyterConsole.text", (Object[])new Object[0]));
        boolean $i$f$service = false;
        Class<JupyterConsoleService> serviceClass$iv = JupyterConsoleService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        this.service = (JupyterConsoleService)object;
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        JupyterConsoleView consoleView = this.service.getConsoleViewForNotebook(JupyterAnActionEventExtensionsKt.getNotebookFile((AnActionEvent)event));
        Project project = event.getProject();
        if (project == null) {
            event.getPresentation().setEnabled(false);
            return;
        }
        BackedNotebookVirtualFile virtualFile = JupyterAnActionEventExtensionsKt.getNotebookFile((AnActionEvent)event);
        event.getPresentation().setEnabledAndVisible(virtualFile != null && consoleView == null && JupyterExecutionManager.Companion.getInstance(project, virtualFile).hasSession());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        BackedNotebookVirtualFile notebookVirtualFile = JupyterAnActionEventExtensionsKt.getNotebookFile((AnActionEvent)event);
        if (notebookVirtualFile == null) {
            return;
        }
        this.service.showConsoleViewContent(project2, notebookVirtualFile);
    }
}

